/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignmentPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;

public class IdwidthAdjuster
extends Panel
implements MouseListener,
MouseMotionListener {
    boolean active = false;
    int oldX = 0;
    Image image;
    AlignmentPanel ap;

    public IdwidthAdjuster(AlignmentPanel ap) {
        this.setLayout(null);
        this.ap = ap;
        URL url = this.getClass().getResource("/images/idwidth.gif");
        if (url != null) {
            this.image = Toolkit.getDefaultToolkit().getImage(url);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent evt) {
        this.oldX = evt.getX();
    }

    public void mouseReleased(MouseEvent evt) {
        this.active = false;
        this.repaint();
    }

    public void mouseEntered(MouseEvent evt) {
        this.active = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent evt) {
        this.active = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent evt) {
        this.active = true;
        Dimension d = this.ap.idPanel.idCanvas.getSize();
        int dif = evt.getX() - this.oldX;
        if (d.width + dif > 20 || dif > 0) {
            this.ap.setIdWidth(d.width + dif, d.height);
            this.setSize(d.width + dif, this.getSize().height);
        }
        this.oldX = evt.getX();
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.active && this.image != null) {
            g.drawImage(this.image, this.getSize().width - 20, 2, this);
        }
    }
}

