#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import time

from fenrirscreenreader.core import debug
from fenrirscreenreader.core.inputDriver import InputDriver as inputDriver


class driver(inputDriver):
    """PTY (Pseudo-terminal) input driver for Fenrir screen reader.
    
    This driver provides input handling for terminal emulation environments
    where direct device access (evdev) is not available or appropriate.
    It uses byte-based input processing instead of key event processing.
    
    This is primarily used when running Fenrir in terminal emulators,
    desktop environments, or other contexts where traditional TTY device
    access is not available.
    
    Features:
    - Byte-based input processing
    - Terminal emulation compatibility
    - Simplified input handling for non-TTY environments
    """
    def __init__(self):
        self._is_initialized = False
        inputDriver.__init__(self)

    def initialize(self, environment):
        """Initialize the PTY input driver.
        
        Sets the input manager to use byte-based shortcuts instead of
        key-based shortcuts, enabling proper operation in terminal
        emulation environments.
        
        Args:
            environment: Fenrir environment dictionary
        """
        self.env = environment
        self.env["runtime"]["InputManager"].set_shortcut_type("BYTE")
        self._is_initialized = True
