/*
 * fhist - file history and comparison tools
 * Copyright (C) 1991-1994, 1998-2000, 2002, 2008, 2010, 2012 Peter Miller
 *
 * Derived from a work
 * Copyright (C) 1990 David I. Bell.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * Definitions for local file handling routines.
 */

#ifndef FILEIO_H
#define FILEIO_H

#include <common/ac/stdio.h>

#include <common/main.h>


/*
 * Function Prototypes
 */
void seekf(FILE *, long);
int skipf(FILE *, long);
char *readlinef(FILE *, long *, int, const char *, int *);
long readf(FILE *, char *, long, int *);
void writefx(FILE *, const char *, long);

/**
 * The copyfx function is used to copy the input file to the output file.
 *
 * @param ifp
 *     The input file.
 * @param ofp
 *     The output file.
 * @param count
 *     The number of bytes to transfer, or -1 for "infinity"
 */
void copyfx(FILE *ifp, FILE *ofp, long count);

/**
 * The typefx function is used to copy the input file to the standard output.
 * All of the input will be copied.
 *
 * @param ifp
 *     The input file.
 */
void typefx(FILE *ifp);

#endif /* FILEIO_H */
/* vim: set ts=8 sw=4 et : */
