/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#define _C_DATA_IMPORT_
#include <data_import.h>

int data_import_init()
{
  if ( ! sharedfile )
    mpav_fmsg( stderr, "ERROR: You should provide a filename with -f option\n" );

  fd = open( sharedfile, O_RDONLY );
  if ( fd < 0 )
    {
      mpav_fmsg( stderr, "ERROR: Could not open file '%s': %s\n", 
		 sharedfile, strerror( errno ) );
      return -1;
    }

  mmap_area = mmap( 0, sizeof( data_t ),
		    PROT_READ, MAP_SHARED, 
		    fd, 0 );

  if ( ! mmap_area )
    {
      mpav_fmsg( stderr, "ERROR: Could not mmap area: %s\n", strerror( errno ) );
      return -2;
    }

  data_mutex = SDL_CreateMutex();

  if ( ( data_import_thread = SDL_CreateThread( (void*)__data_import_thread_func, NULL ) ) == NULL )
    return( -1 );
  mpav_debug( "Data importer thread started...\n" );

  return( 0 );
}

void data_import_quit()
{
  SDL_WaitThread( data_import_thread, NULL );
  SDL_DestroyMutex( data_mutex );

  mpav_debug( "Data importer thread finished!\n" );
}

void __data_import_thread_func()
{
  // we have the expected export?
  while ( ( ( mmap_area->nch != 2 ) || ( mmap_area->bs != 2048 ) ) && ( ! the_end ) )
    {
      usleep( 1000 ); // wait export
    }

  // now we know the size, so map the whole thing
  mmap_area = mremap( mmap_area, sizeof( data_t ), 
		      sizeof( data_t ) + mmap_area->bs,
		      0 );
  if ( ! mmap_area )
    {
      mpav_fmsg( stderr, "ERROR: Could not mmap area: %s\n", strerror( errno ) );
      the_end = 1;
      return;
    }
  
  while ( ! the_end )
    {
      mpav_debug( "Data import loop...\n" );
      if ( mmap_area->count > data_counter )
	{
	  mpav_debug( "Data import processing %lli...\n", mmap_area->count );
	  SDL_mutexP( data_mutex );
	  data_counter = mmap_area->count;
	  // we deal with 2 streams with 512 sambes of 16bits (2bytes) so, 1024	  
	  memcpy( sound_data,  ((void *)mmap_area) + sizeof( data_t ), 2048 );
	  SDL_mutexV( data_mutex );
	}
      else if ( mmap_area->count < data_counter )
	data_counter = mmap_area->count; // fix cases when mplayer brakes and user restart it.

      usleep( 1000 );
    }
}





