#  Autorelease values

## JERRYX_AR_VALUE_T

**Summary**

Macro for `const jerry_value_t` for which jerry_release_value() is
automatically called when the variable goes out of scope.

*Note*: The macro depends on compiler support. For GCC and LLVM/clang, the macro is implemented
using the `__cleanup__` variable attribute. For other compilers, no support has been added yet.

**Example**

```c
#include "jerryscript.h"
#include "jerryscript-ext/autorelease.h"

static void foo (bool enable)
{
  JERRYX_AR_VALUE_T bar = jerry_create_string (...);

  if (enable)
  {
    JERRYX_AR_VALUE_T baz = jerry_get_global_object ();

    ...

    /*
     * jerry_release_value (baz) and jerry_release_value (bar) is called automatically before
     * returning, because `baz` and `bar` go out of scope.
     */
    return;
  }

  /*
   * jerry_release_value (bar) is called automatically when the function returns,
   * because `bar` goes out of scope.
   */
}
```

**See also**

- [jerry_value_t](../docs/02.API-REFERENCE.md#jerry_value_t)
- [jerry_acquire_value](../docs/02.API-REFERENCE.md#jerry_acquire_value)
- [jerry_release_value](../docs/02.API-REFERENCE.md#jerry_release_value)
