%{
/*
  config.l - functions parsing the configuration file
  
  (c) 1999-2002 Robert Cheramy <robert@cheramy.net>
  (c) 2000      Samuel Hocevar <sam@via.ecp.fr>
 
  Thanks to Etienne BERNARD <eb@via.ecp.fr> for his
  * little manual for Lex and Yacc
    http://www.via.ecp.fr/~eb/textes/minimanlexyacc-english.html
  * sample code in ippl (http://www.via.ecp.fr/~hugo/ippl)
  which helped me to understand Lex and Yacc

  200010 : sam & tibob : various config options
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/* #include <db.h> */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <string.h>

#include "utils.h"
#include "filter.h"
#include "y.tab.h"
#include "data.h"

int line;
void parseerror(char *s, int line);
%}

white     [ \t]+

integer   [0-9]+

ippart    [0-9]{1,3}

ip        ({ippart}"."){3}{ippart}

%%

{white}               { /* Ignore */ }
"#".*$                { /* Ignore */ }
"\n"                  { line++;  return EOL; }
"/"                     return SLASH;

[Aa][Ff][Tt][Ee][Rr]             return AFTER;
[Aa][Ll][Ww][Aa][Yy][Ss]         return ALWAYS;
[Aa][Pp][Pp][Ee][Nn][Dd]         return APPEND;
[Bb][Oo][Tt][Hh]                 return BOTH;
[Cc][Ll][Ee][Aa][Rr]             return CLEAR;
[Dd][Ee][Vv][Ii][Cc][Ee]         return DEVICE;
[Dd][Uu][Mm][Pp]                 return DUMP;
[Ee][Vv][Ee][Rr][Yy]             return EVERY;
[Ff][Rr][Oo][Mm]                 return FROM;
[Ff][Ii][Ll][Ee][Nn][Aa][Mm][Ee] return FILENAME;
[Ll][Oo][Cc][Aa][Ll][Tt][Ii][Mm][Ee]  return LOCALTIME;
[Ll][Oo][Gg]                     return LOG;
[Nn][Ee][Ww][Ll][Oo][Gg]         return NEWLOG; 
[Nn][Ee][Vv][Ee][Rr]             return NEVER;
[Nn][Oo][Tt]                     return NOT;
[Nn][Oo][Nn][Ee]                 return NONE;
[Rr][Ee][Pp][Ll][Aa][Cc][Ee]     return REPLACE;
[Ss][Oo][Rr][Tt]                 return SORT;
[Tt][Oo]                         return TO;
[Uu][Tt][Cc]                     return UNIVERSALTIME;
[Ww][Ii][Tt][Hh]                 return WITH;

[Pp][Rr][Oo][Mm][Ii][Ss][Cc]         { yylval.longval = 1; return PROMISC; }
[Nn][Oo][Pp][Rr][Oo][Mm][Ii][Ss][Cc] { yylval.longval = 0; return PROMISC; }
[Rr][Ee][Ss][Oo][Ll][Vv][Ee]         { yylval.longval = 1; return DNS; }
[Nn][Oo][Rr][Ee][Ss][Oo][Ll][Vv][Ee] { yylval.longval = 0; return DNS; }
[Ii][Nn]              { yylval.SortFunc = DataCompareIn; return SORTFUNC; }
[Oo][Uu][Tt]          { yylval.SortFunc = DataCompareOut; return SORTFUNC; }
[Tt][Oo][Tt][Aa][Ll]  { yylval.SortFunc = DataCompareTotal; return SORTFUNC; }

\"([^\"]|(\"\"))+\"   {
                        yylval.stringval = (char*) xmalloc(strlen(yytext) - 1);
			strncpy(yylval.stringval, yytext + 1,
                                strlen(yytext) - 2);
                        yylval.stringval[strlen(yytext) - 2] = 0;
			return STRING;
	              }

{ip}                  {
                        yylval.stringval = strdup(yytext);
                        return IP;
                      }

{integer}             {
                        yylval.longval = atol(yytext);
			return NUMBER;
                      }

days?                 { yylval.longval = 24*60*60; return DATETYPE; }
hours?                { yylval.longval = 60*60;    return DATETYPE; }
minutes?              { yylval.longval = 60;       return DATETYPE; }
seconds?              { yylval.longval = 1;        return DATETYPE; }

[0-9A-Za-z]+          {
                        yylval.stringval = xstrdup(yytext);
                        return STRING;
                      }

.                     { parseerror("unexpected token.", line + 1); }
%%

int yywrap() {
  return 1;
}

