/*
 * debug.c - generic debug routines.
 *
 * Copyright (c) 1993-2004 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 *
 * void debug(int level,char *format, ...);	* the function to call, at
 *						* most 10 arguments to it
 * int setdlevel(int level); 		* set the debug level to level.
 *					* returns old level
 * int getdlevel();			* returns the debug level..
 * int debuglevel;			* the current level of debugging
 */

#include "irc.h"		/* This is where DEBUG is defined or not */
IRCII_RCSID("@(#)$eterna: debug.c,v 1.20 2004/01/06 08:14:09 mrg Exp $");

#ifdef DEBUG
# include <stdio.h>
# include "debug.h"

int	debuglevel = 0;

int
setdlevel(level)
	int	level;
{
	int	oldlevel = debuglevel;

	debuglevel = level;
	return oldlevel;
}

int	getdlevel()
{
	return debuglevel;
}

void
debug(int level, char *format, ...)
{
	va_list vlist;

	if (!debuglevel || level > debuglevel)
		return;

	va_start(vlist, format);
	vfprintf(stderr, format, vlist);
	fputc('\n', stderr);
	fflush(stderr);
}
#endif /* DEBUG */
