package com.prolixtech.jaminid;

import java.util.Iterator;
import java.util.Map;

/**
 * The content oracle is a very special class. It completely allows us to
 * delegate the computation of
 * 
 * @author Constantinos Michael
 * 
 * 
 * 
 * TODO
 */
public class ContentOracle {

    protected static ContentOracle theInstance;
    
    

    /**
     * pertains to the singleton DESIGN PATTERN
     * 
     * @return ContentOracle
     */
    public static ContentOracle Instance() {
        if (theInstance == null)
            theInstance = new ContentOracle();
        return theInstance;
    }

    /**
     * the main function of the oracle, is to demux the request and produce an
     * output that is relative to the request.
     * 
     * in this example, it is a static HTML, that is all we care about for now.
     * 
     * @param connRequest
     * @param connResponse
     * @return the output
     */
    public String demultiplex(Request connRequest, Response connResponse) {

        StringBuffer HTML = new StringBuffer();

        HTML.append("<HTML><BODY>");
        HTML.append("<H1>Testing Handler Page</H1>");
        HTML.append("<H2>What is this?</H2>");
        HTML.append("This is a hard-coded test page produced by the "
                + this.getClass().toString() + " handler class.");

        HTML.append("<H2>Why is this?</H2>");
        HTML
                .append("Either you are testing a new mserve based applet, or something has gone terribly wrong. This class is supposed to be extended and overriden by content specific classes.");

        HTML.append("<H2>Here is some information:</H2>");

        HTML
                .append("<TABLE BORDER=1>"
                        +

                        "<TR><TD>URI</TD><TD>&nbsp;"
                        + connRequest.getURI()
                        + "</TD></TR>"
                        +

                        "<TR><TD>Message</TD><TD>&nbsp;<XMP>"
                        + connRequest.getMessage()
                        + "</XMP></TD></TR>"
                        +

                        "<TR><TD>Body</TD><TD>&nbsp;"
                        + connRequest.getBody()
                        + "</TD></TR>"
                        +

                        "<TR><TD>POST Form:</TD><TD>&nbsp;"
                        + "<FORM METHOD='POST'> <BR>First: <INPUT NAME=FIRST> <BR>Last: <INPUT NAME=LAST> <BR> <INPUT TYPE='submit'></FORM>"
                        + "</TD></TR>");

        Map params = connRequest.getParamMap();

        HTML.append("<TR><TD>Parameters:</TD><TD>&nbsp;");

        if (params.size() > 0) {

            HTML.append("<TABLE BORDER=1>");
            Iterator iter = params.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();

                HTML.append("<TR><TD>" + key + "</TD><TD>&nbsp;"
                        + params.get(key) + "</TD></TR>");

            }
            HTML.append("</TABLE>");
        } else {
            HTML.append("<I>No parameters.</I>");
        }

        HTML.append("</TD></TR>");

        HTML.append("</TABLE>");

        HTML.append("<BR><BR>" + connRequest.getDaemon());

        return HTML.toString();
    }

    /**
     * @return the oracle that will handle the request
     */
    public ContentOracle getDelegatedOracle(Request serviceRequest) {
        // TODO Auto-generated method stub
        return this;
    }

}