/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.mock;

import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.mock.MockRequestDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletRequest
implements HttpServletRequest {
    private String authType;
    private Cookie[] cookies;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private String method = "POST";
    private HttpSession session;
    private String characterEncoding = "UTF-8";
    private List<Locale> locales = new ArrayList<Locale>();
    private Principal userPrincipal;
    private Set<String> roles = new HashSet<String>();
    private String forwardUrl;
    private List<String> includedUrls = new ArrayList<String>();
    private String protocol = "https";
    private String serverName = "localhost";
    private int serverPort = 8080;
    private String contextPath = "";
    private String servletPath = "";
    private String pathInfo = "";
    private String queryString = "";

    public MockHttpServletRequest(String contextPath, String servletPath) {
        this.contextPath = contextPath;
        this.servletPath = servletPath;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void addHeader(String name, Object value) {
        this.headers.put(name.toLowerCase(), value);
    }

    public long getDateHeader(String name) {
        return (Long)this.headers.get(name);
    }

    public String getHeader(String name) {
        Object header;
        if (name != null) {
            name = name.toLowerCase();
        }
        if ((header = this.headers.get(name)) != null) {
            return header.toString();
        }
        return null;
    }

    public Enumeration<String> getHeaders(String name) {
        String header = this.getHeader(name);
        ArrayList<String> values = new ArrayList<String>();
        if (header != null) {
            values.add(header);
        }
        return Collections.enumeration(values);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        return (Integer)this.headers.get(name);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.getPathInfo();
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        return p == null ? null : p.getName();
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        if (this.session == null) {
            return null;
        }
        return this.session.getId();
    }

    public String getRequestURI() {
        return this.contextPath + this.servletPath + this.pathInfo;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer().append(this.protocol).append("://").append(this.serverName).append(":").append(this.serverPort).append(this.contextPath).append(this.servletPath).append(this.pathInfo);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean b) {
        return this.session;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.getProtocol();
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public Locale getLocale() {
        return this.getLocales().nextElement();
    }

    public Enumeration<Locale> getLocales() {
        if (this.locales.size() == 0) {
            this.locales.add(Locale.getDefault());
        }
        return Collections.enumeration(this.locales);
    }

    public boolean isSecure() {
        return this.protocol.equalsIgnoreCase("https");
    }

    public MockRequestDispatcher getRequestDispatcher(String url) {
        return new MockRequestDispatcher(url);
    }

    public String getRealPath(String path) {
        return path;
    }

    public int getRemotePort() {
        return 1088;
    }

    public String getLocalName() {
        return this.getServerName();
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    void setForwardUrl(String url) {
        this.forwardUrl = url;
    }

    public String getForwardUrl() {
        return this.forwardUrl;
    }

    void addIncludedUrl(String url) {
        this.includedUrls.add(url);
    }

    public List<String> getIncludedUrls() {
        return this.includedUrls;
    }
}

