
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSplashScreen.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSplashScreen>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QColor>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSplashScreen

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSplashScreen::staticMetaObject);
}


// void QSplashScreen::clearMessage()


static void _init_f_clearMessage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearMessage_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen *)cls)->clearMessage ();
}


// void QSplashScreen::finish(QWidget *w)


static void _init_f_finish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_finish_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen *)cls)->finish (arg1);
}


// QString QSplashScreen::message()


static void _init_f_message_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_message_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSplashScreen *)cls)->message ());
}


// const QPixmap QSplashScreen::pixmap()


static void _init_f_pixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPixmap > ();
}

static void _call_f_pixmap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QPixmap > ((const QPixmap)((QSplashScreen *)cls)->pixmap ());
}


// void QSplashScreen::repaint()


static void _init_f_repaint_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_repaint_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen *)cls)->repaint ();
}


// void QSplashScreen::setPixmap(const QPixmap &pixmap)


static void _init_f_setPixmap_2017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPixmap_2017 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPixmap &arg1 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen *)cls)->setPixmap (arg1);
}


// void QSplashScreen::showMessage(const QString &message, int alignment, const QColor &color)


static void _init_f_showMessage_4481 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("message");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment", true, "Qt::AlignLeft");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("color", true, "Qt::black");
  decl->add_arg<const QColor & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_showMessage_4481 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::AlignLeft, heap);
  const QColor &arg3 = args ? gsi::arg_reader<const QColor & >() (args, heap) : gsi::arg_maker<const QColor & >() (Qt::black, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen *)cls)->showMessage (arg1, arg2, arg3);
}


// static QString QSplashScreen::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSplashScreen::tr (arg1, arg2, arg3));
}


// static QString QSplashScreen::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSplashScreen::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSplashScreen () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("clearMessage", "@brief Method void QSplashScreen::clearMessage()\n", false, &_init_f_clearMessage_0, &_call_f_clearMessage_0);
  methods += new qt_gsi::GenericMethod ("finish", "@brief Method void QSplashScreen::finish(QWidget *w)\n", false, &_init_f_finish_1315, &_call_f_finish_1315);
  methods += new qt_gsi::GenericMethod ("message", "@brief Method QString QSplashScreen::message()\n", true, &_init_f_message_c0, &_call_f_message_c0);
  methods += new qt_gsi::GenericMethod (":pixmap", "@brief Method const QPixmap QSplashScreen::pixmap()\n", true, &_init_f_pixmap_c0, &_call_f_pixmap_c0);
  methods += new qt_gsi::GenericMethod ("repaint", "@brief Method void QSplashScreen::repaint()\n", false, &_init_f_repaint_0, &_call_f_repaint_0);
  methods += new qt_gsi::GenericMethod ("setPixmap|pixmap=", "@brief Method void QSplashScreen::setPixmap(const QPixmap &pixmap)\n", false, &_init_f_setPixmap_2017, &_call_f_setPixmap_2017);
  methods += new qt_gsi::GenericMethod ("showMessage", "@brief Method void QSplashScreen::showMessage(const QString &message, int alignment, const QColor &color)\n", false, &_init_f_showMessage_4481, &_call_f_showMessage_4481);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QSplashScreen::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSplashScreen::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("messageChanged(const QString &)", "messageChanged", gsi::arg("message"), "@brief Signal declaration for QSplashScreen::messageChanged(const QString &message)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QSplashScreen::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QSplashScreen::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QSplashScreen::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QSplashScreen::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSplashScreen::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSplashScreen::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QWidget> &qtdecl_QWidget ();

qt_gsi::QtNativeClass<QSplashScreen> decl_QSplashScreen (qtdecl_QWidget (), "QtWidgets", "QSplashScreen_Native",
  methods_QSplashScreen (),
  "@hide\n@alias QSplashScreen");

GSI_QTWIDGETS_PUBLIC gsi::Class<QSplashScreen> &qtdecl_QSplashScreen () { return decl_QSplashScreen; }

}


class QSplashScreen_Adaptor : public QSplashScreen, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSplashScreen_Adaptor();

  //  [adaptor ctor] QSplashScreen::QSplashScreen(const QPixmap &pixmap, QFlags<Qt::WindowType> f)
  QSplashScreen_Adaptor() : QSplashScreen()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSplashScreen::QSplashScreen(const QPixmap &pixmap, QFlags<Qt::WindowType> f)
  QSplashScreen_Adaptor(const QPixmap &pixmap) : QSplashScreen(pixmap)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSplashScreen::QSplashScreen(const QPixmap &pixmap, QFlags<Qt::WindowType> f)
  QSplashScreen_Adaptor(const QPixmap &pixmap, QFlags<Qt::WindowType> f) : QSplashScreen(pixmap, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSplashScreen::QSplashScreen(QWidget *parent, const QPixmap &pixmap, QFlags<Qt::WindowType> f)
  QSplashScreen_Adaptor(QWidget *parent) : QSplashScreen(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSplashScreen::QSplashScreen(QWidget *parent, const QPixmap &pixmap, QFlags<Qt::WindowType> f)
  QSplashScreen_Adaptor(QWidget *parent, const QPixmap &pixmap) : QSplashScreen(parent, pixmap)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSplashScreen::QSplashScreen(QWidget *parent, const QPixmap &pixmap, QFlags<Qt::WindowType> f)
  QSplashScreen_Adaptor(QWidget *parent, const QPixmap &pixmap, QFlags<Qt::WindowType> f) : QSplashScreen(parent, pixmap, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QSplashScreen::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QSplashScreen_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QSplashScreen::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QSplashScreen::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QSplashScreen_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QSplashScreen::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QSplashScreen::focusNextChild()
  bool fp_QSplashScreen_focusNextChild_0 () {
    return QSplashScreen::focusNextChild();
  }

  //  [expose] bool QSplashScreen::focusPreviousChild()
  bool fp_QSplashScreen_focusPreviousChild_0 () {
    return QSplashScreen::focusPreviousChild();
  }

  //  [expose] bool QSplashScreen::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSplashScreen_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSplashScreen::isSignalConnected(signal);
  }

  //  [expose] int QSplashScreen::receivers(const char *signal)
  int fp_QSplashScreen_receivers_c1731 (const char *signal) const {
    return QSplashScreen::receivers(signal);
  }

  //  [expose] QObject *QSplashScreen::sender()
  QObject * fp_QSplashScreen_sender_c0 () const {
    return QSplashScreen::sender();
  }

  //  [expose] int QSplashScreen::senderSignalIndex()
  int fp_QSplashScreen_senderSignalIndex_c0 () const {
    return QSplashScreen::senderSignalIndex();
  }

  //  [expose] void QSplashScreen::updateMicroFocus()
  void fp_QSplashScreen_updateMicroFocus_0 () {
    QSplashScreen::updateMicroFocus();
  }

  //  [emitter impl] void QSplashScreen::customContextMenuRequested(const QPoint &pos)
  void emitter_QSplashScreen_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QSplashScreen::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QSplashScreen::destroyed(QObject *)
  void emitter_QSplashScreen_destroyed_1302(QObject *arg1)
  {
    emit QSplashScreen::destroyed(arg1);
  }

  //  [adaptor impl] bool QSplashScreen::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QSplashScreen::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSplashScreen_Adaptor, bool, QObject *, QEvent *>(&QSplashScreen_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QSplashScreen::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QSplashScreen::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QSplashScreen::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QSplashScreen_Adaptor, bool>(&QSplashScreen_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QSplashScreen::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QSplashScreen::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QSplashScreen::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QSplashScreen_Adaptor, int, int>(&QSplashScreen_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QSplashScreen::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QSplashScreen::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QSplashScreen::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QSplashScreen_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QSplashScreen_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QSplashScreen::inputMethodQuery(arg1);
    }
  }

  //  [emitter impl] void QSplashScreen::messageChanged(const QString &message)
  void emitter_QSplashScreen_messageChanged_2025(const QString &message)
  {
    emit QSplashScreen::messageChanged(message);
  }

  //  [adaptor impl] QSize QSplashScreen::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QSplashScreen::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QSplashScreen_Adaptor, QSize>(&QSplashScreen_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QSplashScreen::minimumSizeHint();
    }
  }

  //  [emitter impl] void QSplashScreen::objectNameChanged(const QString &objectName)
  void emitter_QSplashScreen_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QSplashScreen::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QSplashScreen::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QSplashScreen::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QSplashScreen_Adaptor, QPaintEngine *>(&QSplashScreen_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QSplashScreen::paintEngine();
    }
  }

  //  [adaptor impl] void QSplashScreen::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QSplashScreen::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QSplashScreen_Adaptor, bool>(&QSplashScreen_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QSplashScreen::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QSplashScreen::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QSplashScreen::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QSplashScreen_Adaptor, QSize>(&QSplashScreen_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QSplashScreen::sizeHint();
    }
  }

  //  [emitter impl] void QSplashScreen::windowIconChanged(const QIcon &icon)
  void emitter_QSplashScreen_windowIconChanged_1787(const QIcon &icon)
  {
    emit QSplashScreen::windowIconChanged(icon);
  }

  //  [emitter impl] void QSplashScreen::windowIconTextChanged(const QString &iconText)
  void emitter_QSplashScreen_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QSplashScreen::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QSplashScreen::windowTitleChanged(const QString &title)
  void emitter_QSplashScreen_windowTitleChanged_2025(const QString &title)
  {
    emit QSplashScreen::windowTitleChanged(title);
  }

  //  [adaptor impl] void QSplashScreen::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QSplashScreen::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QSplashScreen_Adaptor, QActionEvent *>(&QSplashScreen_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QSplashScreen::actionEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QSplashScreen::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QSplashScreen_Adaptor, QEvent *>(&QSplashScreen_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QSplashScreen::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QSplashScreen::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QSplashScreen::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSplashScreen_Adaptor, QChildEvent *>(&QSplashScreen_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QSplashScreen::childEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QSplashScreen::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QSplashScreen_Adaptor, QCloseEvent *>(&QSplashScreen_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QSplashScreen::closeEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QSplashScreen::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QSplashScreen_Adaptor, QContextMenuEvent *>(&QSplashScreen_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QSplashScreen::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QSplashScreen::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSplashScreen_Adaptor, QEvent *>(&QSplashScreen_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QSplashScreen::customEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSplashScreen::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSplashScreen_Adaptor, const QMetaMethod &>(&QSplashScreen_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSplashScreen::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QSplashScreen::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QSplashScreen::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QSplashScreen_Adaptor, QDragEnterEvent *>(&QSplashScreen_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QSplashScreen::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QSplashScreen::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QSplashScreen_Adaptor, QDragLeaveEvent *>(&QSplashScreen_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QSplashScreen::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QSplashScreen::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QSplashScreen_Adaptor, QDragMoveEvent *>(&QSplashScreen_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QSplashScreen::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::drawContents(QPainter *painter)
  void cbs_drawContents_1426_0(QPainter *painter)
  {
    QSplashScreen::drawContents(painter);
  }

  virtual void drawContents(QPainter *painter)
  {
    if (cb_drawContents_1426_0.can_issue()) {
      cb_drawContents_1426_0.issue<QSplashScreen_Adaptor, QPainter *>(&QSplashScreen_Adaptor::cbs_drawContents_1426_0, painter);
    } else {
      QSplashScreen::drawContents(painter);
    }
  }

  //  [adaptor impl] void QSplashScreen::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QSplashScreen::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QSplashScreen_Adaptor, QDropEvent *>(&QSplashScreen_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QSplashScreen::dropEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::enterEvent(QEvent *event)
  void cbs_enterEvent_1217_0(QEvent *event)
  {
    QSplashScreen::enterEvent(event);
  }

  virtual void enterEvent(QEvent *event)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QSplashScreen_Adaptor, QEvent *>(&QSplashScreen_Adaptor::cbs_enterEvent_1217_0, event);
    } else {
      QSplashScreen::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QSplashScreen::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QSplashScreen::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSplashScreen_Adaptor, bool, QEvent *>(&QSplashScreen_Adaptor::cbs_event_1217_0, e);
    } else {
      return QSplashScreen::event(e);
    }
  }

  //  [adaptor impl] void QSplashScreen::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QSplashScreen::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QSplashScreen_Adaptor, QFocusEvent *>(&QSplashScreen_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QSplashScreen::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QSplashScreen::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QSplashScreen::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QSplashScreen_Adaptor, bool, bool>(&QSplashScreen_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QSplashScreen::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QSplashScreen::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QSplashScreen::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QSplashScreen_Adaptor, QFocusEvent *>(&QSplashScreen_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QSplashScreen::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QSplashScreen::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QSplashScreen_Adaptor, QHideEvent *>(&QSplashScreen_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QSplashScreen::hideEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QSplashScreen::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QSplashScreen_Adaptor, QPainter *>(&QSplashScreen_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QSplashScreen::initPainter(painter);
    }
  }

  //  [adaptor impl] void QSplashScreen::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QSplashScreen::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QSplashScreen_Adaptor, QInputMethodEvent *>(&QSplashScreen_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QSplashScreen::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QSplashScreen::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QSplashScreen::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QSplashScreen_Adaptor, QKeyEvent *>(&QSplashScreen_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QSplashScreen::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QSplashScreen::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QSplashScreen_Adaptor, QKeyEvent *>(&QSplashScreen_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QSplashScreen::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QSplashScreen::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QSplashScreen_Adaptor, QEvent *>(&QSplashScreen_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QSplashScreen::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QSplashScreen::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QSplashScreen::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QSplashScreen_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QSplashScreen_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QSplashScreen::metric(arg1);
    }
  }

  //  [adaptor impl] void QSplashScreen::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QSplashScreen::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QSplashScreen_Adaptor, QMouseEvent *>(&QSplashScreen_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QSplashScreen::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QSplashScreen::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QSplashScreen_Adaptor, QMouseEvent *>(&QSplashScreen_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QSplashScreen::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QSplashScreen::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QSplashScreen_Adaptor, QMouseEvent *>(&QSplashScreen_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QSplashScreen::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QSplashScreen::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QSplashScreen::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QSplashScreen_Adaptor, QMouseEvent *>(&QSplashScreen_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QSplashScreen::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QSplashScreen::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QSplashScreen_Adaptor, QMoveEvent *>(&QSplashScreen_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QSplashScreen::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QSplashScreen::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QSplashScreen::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QSplashScreen_Adaptor, bool, const QByteArray &, void *, long int *>(&QSplashScreen_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QSplashScreen::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QSplashScreen::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QSplashScreen::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QSplashScreen_Adaptor, QPaintEvent *>(&QSplashScreen_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QSplashScreen::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QSplashScreen::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QSplashScreen::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QSplashScreen_Adaptor, QPaintDevice *, QPoint *>(&QSplashScreen_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QSplashScreen::redirected(offset);
    }
  }

  //  [adaptor impl] void QSplashScreen::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QSplashScreen::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QSplashScreen_Adaptor, QResizeEvent *>(&QSplashScreen_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QSplashScreen::resizeEvent(event);
    }
  }

  //  [adaptor impl] QPainter *QSplashScreen::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QSplashScreen::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QSplashScreen_Adaptor, QPainter *>(&QSplashScreen_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QSplashScreen::sharedPainter();
    }
  }

  //  [adaptor impl] void QSplashScreen::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QSplashScreen::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QSplashScreen_Adaptor, QShowEvent *>(&QSplashScreen_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QSplashScreen::showEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QSplashScreen::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QSplashScreen_Adaptor, QTabletEvent *>(&QSplashScreen_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QSplashScreen::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QSplashScreen::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSplashScreen_Adaptor, QTimerEvent *>(&QSplashScreen_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QSplashScreen::timerEvent(event);
    }
  }

  //  [adaptor impl] void QSplashScreen::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QSplashScreen::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QSplashScreen_Adaptor, QWheelEvent *>(&QSplashScreen_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QSplashScreen::wheelEvent(event);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_drawContents_1426_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QSplashScreen_Adaptor::~QSplashScreen_Adaptor() { }

//  Constructor QSplashScreen::QSplashScreen(const QPixmap &pixmap, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QSplashScreen_Adaptor_4404 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap", true, "QPixmap()");
  decl->add_arg<const QPixmap & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "Qt::WindowFlags()");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QSplashScreen_Adaptor> ();
}

static void _call_ctor_QSplashScreen_Adaptor_4404 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPixmap &arg1 = args ? gsi::arg_reader<const QPixmap & >() (args, heap) : gsi::arg_maker<const QPixmap & >() (QPixmap(), heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::WindowFlags(), heap);
  ret.write<QSplashScreen_Adaptor *> (new QSplashScreen_Adaptor (arg1, arg2));
}


//  Constructor QSplashScreen::QSplashScreen(QWidget *parent, const QPixmap &pixmap, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QSplashScreen_Adaptor_5611 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap", true, "QPixmap()");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("f", true, "Qt::WindowFlags()");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_2);
  decl->set_return_new<QSplashScreen_Adaptor> ();
}

static void _call_ctor_QSplashScreen_Adaptor_5611 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QPixmap &arg2 = args ? gsi::arg_reader<const QPixmap & >() (args, heap) : gsi::arg_maker<const QPixmap & >() (QPixmap(), heap);
  QFlags<Qt::WindowType> arg3 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::WindowFlags(), heap);
  ret.write<QSplashScreen_Adaptor *> (new QSplashScreen_Adaptor (arg1, arg2, arg3));
}


// void QSplashScreen::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QSplashScreen::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QSplashScreen::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSplashScreen::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QSplashScreen::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QSplashScreen::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_create_2208 (arg1, arg2, arg3);
}


// emitter void QSplashScreen::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QSplashScreen_Adaptor *)cls)->emitter_QSplashScreen_customContextMenuRequested_1916 (arg1);
}


// void QSplashScreen::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QSplashScreen::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_destroy_1620 (arg1, arg2);
}


// emitter void QSplashScreen::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QSplashScreen_Adaptor *)cls)->emitter_QSplashScreen_destroyed_1302 (arg1);
}


// void QSplashScreen::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QSplashScreen::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QSplashScreen::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QSplashScreen::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QSplashScreen::drawContents(QPainter *painter)

static void _init_cbs_drawContents_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_drawContents_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_drawContents_1426_0 (arg1);
}

static void _set_callback_cbs_drawContents_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_drawContents_1426_0 = cb;
}


// void QSplashScreen::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QSplashScreen::enterEvent(QEvent *event)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QSplashScreen::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSplashScreen_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSplashScreen::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSplashScreen_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QSplashScreen::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QSplashScreen::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_focusNextChild_0 ());
}


// bool QSplashScreen::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QSplashScreen_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QSplashScreen::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QSplashScreen::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_focusPreviousChild_0 ());
}


// bool QSplashScreen::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSplashScreen_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QSplashScreen::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QSplashScreen_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QSplashScreen::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QSplashScreen::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QSplashScreen::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QSplashScreen::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QSplashScreen_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QSplashScreen::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_isSignalConnected_c2394 (arg1));
}


// void QSplashScreen::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QSplashScreen::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QSplashScreen::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// emitter void QSplashScreen::messageChanged(const QString &message)

static void _init_emitter_messageChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("message");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_messageChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSplashScreen_Adaptor *)cls)->emitter_QSplashScreen_messageChanged_2025 (arg1);
}


// int QSplashScreen::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QSplashScreen_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QSplashScreen::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QSplashScreen_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QSplashScreen::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QSplashScreen::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QSplashScreen::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QSplashScreen::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QSplashScreen::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QSplashScreen::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QSplashScreen_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QSplashScreen::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSplashScreen_Adaptor *)cls)->emitter_QSplashScreen_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QSplashScreen::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QSplashScreen_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QSplashScreen::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QSplashScreen::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_receivers_c1731 (arg1));
}


// QPaintDevice *QSplashScreen::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QSplashScreen_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QSplashScreen::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QSplashScreen::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_sender_c0 ());
}


// exposed int QSplashScreen::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_senderSignalIndex_c0 ());
}


// void QSplashScreen::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QSplashScreen::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QSplashScreen_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QSplashScreen::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QSplashScreen::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QSplashScreen_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QSplashScreen::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QSplashScreen::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QSplashScreen::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->fp_QSplashScreen_updateMicroFocus_0 ();
}


// void QSplashScreen::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSplashScreen_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QSplashScreen_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QSplashScreen::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QSplashScreen_Adaptor *)cls)->emitter_QSplashScreen_windowIconChanged_1787 (arg1);
}


// emitter void QSplashScreen::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSplashScreen_Adaptor *)cls)->emitter_QSplashScreen_windowIconTextChanged_2025 (arg1);
}


// emitter void QSplashScreen::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSplashScreen_Adaptor *)cls)->emitter_QSplashScreen_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QSplashScreen> &qtdecl_QSplashScreen ();

static gsi::Methods methods_QSplashScreen_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSplashScreen::QSplashScreen(const QPixmap &pixmap, QFlags<Qt::WindowType> f)\nThis method creates an object of class QSplashScreen.", &_init_ctor_QSplashScreen_Adaptor_4404, &_call_ctor_QSplashScreen_Adaptor_4404);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSplashScreen::QSplashScreen(QWidget *parent, const QPixmap &pixmap, QFlags<Qt::WindowType> f)\nThis method creates an object of class QSplashScreen.", &_init_ctor_QSplashScreen_Adaptor_5611, &_call_ctor_QSplashScreen_Adaptor_5611);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QSplashScreen::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QSplashScreen::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSplashScreen::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QSplashScreen::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QSplashScreen::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QSplashScreen::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QSplashScreen::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSplashScreen::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QSplashScreen::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSplashScreen::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSplashScreen::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QSplashScreen::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QSplashScreen::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QSplashScreen::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawContents", "@brief Virtual method void QSplashScreen::drawContents(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawContents_1426_0, &_call_cbs_drawContents_1426_0);
  methods += new qt_gsi::GenericMethod ("*drawContents", "@hide", false, &_init_cbs_drawContents_1426_0, &_call_cbs_drawContents_1426_0, &_set_callback_cbs_drawContents_1426_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QSplashScreen::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QSplashScreen::enterEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QSplashScreen::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSplashScreen::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QSplashScreen::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QSplashScreen::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QSplashScreen::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QSplashScreen::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QSplashScreen::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QSplashScreen::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QSplashScreen::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QSplashScreen::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QSplashScreen::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QSplashScreen::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QSplashScreen::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSplashScreen::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QSplashScreen::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QSplashScreen::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QSplashScreen::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_messageChanged", "@brief Emitter for signal void QSplashScreen::messageChanged(const QString &message)\nCall this method to emit this signal.", false, &_init_emitter_messageChanged_2025, &_call_emitter_messageChanged_2025);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QSplashScreen::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QSplashScreen::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QSplashScreen::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QSplashScreen::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QSplashScreen::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QSplashScreen::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QSplashScreen::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QSplashScreen::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QSplashScreen::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QSplashScreen::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QSplashScreen::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSplashScreen::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QSplashScreen::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QSplashScreen::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSplashScreen::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSplashScreen::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QSplashScreen::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QSplashScreen::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QSplashScreen::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QSplashScreen::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QSplashScreen::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSplashScreen::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QSplashScreen::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QSplashScreen::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QSplashScreen::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QSplashScreen::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QSplashScreen::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QSplashScreen_Adaptor> decl_QSplashScreen_Adaptor (qtdecl_QSplashScreen (), "QtWidgets", "QSplashScreen",
  methods_QSplashScreen_Adaptor (),
  "@qt\n@brief Binding of QSplashScreen");

}

