/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "fieldfactory.h"

#include "accounttypefield.h"
#include "aclselectionfield.h"
#include "aliasfield.h"
#include "booleanfield.h"
#include "delegatefield.h"
#include "hostsfield.h"
#include "integerfield.h"
#include "invitationpolicyfield.h"
#include "mailfilterfield.h"
#include "memberselectionfield.h"
#include "networksfield.h"
#include "passwordfield.h"
#include "servicesfield.h"
#include "smtphostfield.h"
#include "stringfield.h"

using namespace Form;

FieldFactory *FieldFactory::mSelf = 0;

FieldFactory::FieldFactory()
{
}

FieldFactory::~FieldFactory()
{
}

FieldFactory *FieldFactory::self()
{
  if ( !mSelf )
    mSelf = new FieldFactory;

  return mSelf;
}

Field *FieldFactory::createField( const QString &type, const QString &name, QWidget *parent ) const
{
  if ( type == "accounttype" )
    return new AccountTypeField( name, parent );

  if ( type == "aclselection" )
    return new AclSelectionField( name, parent );

  if ( type == "alias" )
    return new AliasField( name, parent );

  if ( type == "boolean" )
    return new BooleanField( name, parent );

  if ( type == "delegate" )
    return new DelegateField( name, parent );

  if ( type == "hosts" )
    return new HostsField( name, parent );

  if ( type == "integer" )
    return new IntegerField( name, parent );

  if ( type == "invitationpolicy" )
    return new InvitationPolicyField( name, parent );

  if ( type == "mailfilter" )
    return new MailFilterField( name, parent );

  if ( type == "memberselection" )
    return new MemberSelectionField( name, parent );

  if ( type == "networks" )
    return new NetworksField( name, parent );

  if ( type == "non-empty-string" )
    return new StringField( name, StringField::InvalidateEmpty, parent );

  if ( type == "password" )
    return new PasswordField( name, parent );

  if ( type == "smtphost" )
    return new SmtpHostField( name, parent );

  if ( type == "string" )
    return new StringField( name, StringField::ValidateEmpty, parent );

  if ( type == "services" )
    return new ServicesField( name, parent );

  qDebug( "FieldFactory: Unknown field type '%s'", qPrintable( type ) );

  return 0;
}

