/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "service_description.h"

using namespace Form;

Description::Entry::List ServiceDescription::entries() const
{
  Entry::List entries;

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "Administrative email addresses" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "distributionlists" );
    entry.setType( "string" );
    entry.setHeader( QObject::tr( "You have not yet set up a receiving account for the administrative email addresses hostmaster@yourdomain.tld, postmaster@yourdomain.tld, MAILER-DAEMON@yourdomain.tld, abuse@yourdomain.tld and virusalert@yourdomain.tld. Enter the email address of a kolab account below and press the button to create a distribution list for each of those addresses. Later you can add or remove people from the lists like any other distribution list" ) );
    entry.setLabel( QObject::tr( "Email address:" ) );
    entries.append( entry );
  }

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "Enable or Disable individual Services" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "services" );
    entry.setType( "services" );
    entry.setLabel( QObject::tr( "Services" ) );
    entries.append( entry );
  }

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "Quota Settings" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "cyrus-quotawarn" );
    entry.setType( "integer" );
    entry.setDefaultValue( "80" );
    entry.setLabel( QObject::tr( "Limit:" ) );
    entry.setHeader( QObject::tr( "Warn user when quota has reached given limit" ) );
    entries.append( entry );
  }

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "Free/Busy Settings" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "apache-allow-unauthenticated-fb" );
    entry.setType( "boolean" );
    entry.setLabel( QObject::tr( "Allow download:" ) );
    entry.setHeader( QObject::tr( "Allow unauthenticated downloading of Free/Busy information" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "kolabFreeBusyPast" );
    entry.setType( "integer" );
    entry.setDefaultValue( "10" );
    entry.setLabel( QObject::tr( "Days:" ) );
    entry.setHeader( QObject::tr( "When creating Free/Busy lists, include data from the last given days" ) );
    entries.append( entry );
  }

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "Privileged Networks" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "postfix-mynetworks" );
    entry.setType( "networks" );
    entry.setLabel( QObject::tr( "Networks:" ) );
    entry.setHeader( QObject::tr( "Networks allowed to relay and send mail through unauthenticated SMTP connections to the Kolab server (networks in x.x.x.x/y format)" ) );
    entries.append( entry );
  }

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "SMTP \"smarthost/relayhost\"" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "postfix-relayhost" );
    entry.setType( "smtphost" );
    entry.setLabel( QObject::tr( "Host:" ) );
    entry.setHeader( QObject::tr( "Smarthost (and optional port) to use to send outgoing mail (host.domain.tld). Leave empty for no relayhost." ) );
    entries.append( entry );
  }

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "Accept Internet Mail" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "postfix-allow-unauthenticated" );
    entry.setType( "boolean" );
    entry.setLabel( QObject::tr( "Accept mails:" ) );
    entry.setHeader( QObject::tr( "Accept mail from other domains over non-authenticated SMTP. This must be enabled if you want to use the Kolab server to receive mail from other internet domains." ) );
    entries.append( entry );
  }

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "Mail Filter Settings" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "kolabfilter-verify-from-header" );
    entry.setType( "boolean" );
    entry.setLabel( QObject::tr( "Check:" ) );
    entry.setHeader( QObject::tr( "Check messages for mismatching From header and envelope from." ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "kolabfilter-allow-sender-header" );
    entry.setType( "boolean" );
    entry.setLabel( QObject::tr( "Use:" ) );
    entry.setHeader( QObject::tr( "Use the Sender header instead of From for the above checks if Sender is present." ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "kolabfilter-reject-forged-from-header" );
    entry.setType( "mailfilter" );
    entry.setHeader( QObject::tr( "Action to take for messages that fail the check:" ) );
    entries.append( entry );
  }

  {
    Entry entry( Entry::GroupType );
    entry.setLabel( QObject::tr( "Kolab Hosts" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "kolabHost" );
    entry.setType( "hosts" );
    entry.setLabel( "Hosts:" );
    entries.append( entry );
  }

  return entries;
}
