/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
**************************************************************************/

#include "xml_parser_client.h"

XmlParserClient::XmlParserClient(QObject *parent)
    : QObject(parent)
{
}

OsCharacteristic* XmlParserClient::getClientParametersFromXml(QString buffer)
{
    OsCharacteristic *osCharacteristic = new OsCharacteristic(this);
    QStringList *folderList = new QStringList;
    QStringList *fileList = new QStringList;
    QStringList *ipList = new QStringList;
    QDomDocument doc;
    doc.setContent(buffer);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == HOSTNAME)
        {
            osCharacteristic->hostname = child.text();
        }
        else if (child.tagName() == SYSTEM)
        {
            osCharacteristic->system = child.text();
        }
        if (child.tagName() == PATH)
        {
            QString pathName = child.text();
            osCharacteristic->home_path = pathName;
        }
        else if (child.tagName() == FOLDER_LIST)
        {
            QDomElement folderChild = child.firstChild().toElement();
            while(!folderChild.isNull())
            {
                if (folderChild.tagName() == FOLDER) {
                    QString folderName = folderChild.text();
                    folderList->append(folderName);
                }
                folderChild = folderChild.nextSibling().toElement();
            }

        } else if (child.tagName() == FILE_LIST)
        {
            QDomElement fileChild = child.firstChild().toElement();
            while(!fileChild.isNull())
            {
                if (fileChild.tagName() == FILE_XML) {
                    QString fileName = fileChild.text();
                    fileList->append(fileName);
                }
                fileChild = fileChild.nextSibling().toElement();
            }
        } else if (child.tagName() == IP_LIST)
        {
            QDomElement ipChild = child.firstChild().toElement();
            while(!ipChild.isNull())
            {
                if (ipChild.tagName() == IP)
                {
                    ipList->append(ipChild.text());
                }
                ipChild = ipChild.nextSibling().toElement();
            }
        }
        child = child.nextSibling().toElement();
    }
    osCharacteristic->folder_list = folderList;
    osCharacteristic->file_list = fileList;
    osCharacteristic->ip_list = ipList;
    return osCharacteristic;
}

Folder* XmlParserClient::getDirectoryContent(QString buffer)
{
    Folder *folder = new Folder(this);
    QStringList *folderList = new QStringList;
    QStringList *fileList = new QStringList;
    QStringList *driveList = new QStringList;
    QDomDocument doc;
    doc.setContent(buffer);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == PATH) {
            QString pathName = child.text();
            folder->path = pathName;
        }
        else if (child.tagName() == FOLDER_LIST) {
            QDomElement folderChild = child.firstChild().toElement();
            while(!folderChild.isNull()) {
                if (folderChild.tagName() == FOLDER) {
                    QString folderName = folderChild.text();
                    folderList->append(folderName);
                }
                folderChild = folderChild.nextSibling().toElement();
            }
        } else if (child.tagName() == FILE_LIST) {
            QDomElement fileChild = child.firstChild().toElement();
            while(!fileChild.isNull()) {
                if (fileChild.tagName() == FILE_XML) {
                    QString fileName = fileChild.text();
                    fileList->append(fileName);
                }
                fileChild = fileChild.nextSibling().toElement();
            }
        } else if (child.tagName() == DRIVES) {
            QDomElement driveChild = child.firstChild().toElement();
            while(!driveChild.isNull())
            {
                if (driveChild.tagName() == DRIVE)
                {
                    driveList->append(driveChild.text());
                }
                driveChild = driveChild.nextSibling().toElement();
            }
        }
        child = child.nextSibling().toElement();
    }
    folder->folder_list = folderList;
    folder->file_list = fileList;
    folder->drive_list = driveList;
    return folder;
}

File* XmlParserClient::getFileInfo(QString buffer)
{
    File *file = new File(this);

    QDomDocument doc;
    doc.setContent(buffer);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == FILE_NAME) {
            QString name = child.text();
            file->name = name;
        } else if (child.tagName() == FILE_SIZE) {
            QString size = child.text();
            file->size = size;
        } else if (child.tagName() == FILE_EXECECUTABLE) {
            QString exec = child.text();
            file->executable = exec;
        } else if (child.tagName() == FILE_READABLE) {
            QString readable = child.text();
            file->readable = readable;
        } else if (child.tagName() == FILE_OWNER) {
            QString owner = child.text();
            file->owner = owner;
        } else if (child.tagName() == FILE_EXTENSION) {
            QString extension = child.text();
            file->extension = extension;
        } else if (child.tagName() == FILE_DIRECTORY) {
            QString directory = child.text();
            file->directory = directory;
        } else if (child.tagName() == FILE_CREATION_DATE) {
            QString date = child.text();
            file->creationDate = date;
        } else if (child.tagName() == FILE_MODIFIED_DATE) {
            QString date = child.text();
            file->modifiedDate = date;
        }
        child = child.nextSibling().toElement();
    }
    return file;
}
