/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.actions;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/navigation/gotoTestOrCode")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class GotoTestOrCodeActionTestGenerated extends AbstractGotoTestOrCodeActionTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInGotoTestOrCode() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/navigation/gotoTestOrCode"), Pattern.compile("^(.+)\\.main\\..+$"), TargetBackend.ANY, true);
    }

    @TestMetadata("fromJavaClassToTest.main.java")
    public void testFromJavaClassToTest() throws Exception {
        runTest("idea/testData/navigation/gotoTestOrCode/fromJavaClassToTest.main.java");
    }

    @TestMetadata("fromJavaTestToKotlinClass.main.java")
    public void testFromJavaTestToKotlinClass() throws Exception {
        runTest("idea/testData/navigation/gotoTestOrCode/fromJavaTestToKotlinClass.main.java");
    }

    @TestMetadata("fromJavaTestToKotlinFile.main.java")
    public void testFromJavaTestToKotlinFile() throws Exception {
        runTest("idea/testData/navigation/gotoTestOrCode/fromJavaTestToKotlinFile.main.java");
    }

    @TestMetadata("fromKotlinClassToTest.main.kt")
    public void testFromKotlinClassToTest() throws Exception {
        runTest("idea/testData/navigation/gotoTestOrCode/fromKotlinClassToTest.main.kt");
    }

    @TestMetadata("fromKotlinFileToTest.main.kt")
    public void testFromKotlinFileToTest() throws Exception {
        runTest("idea/testData/navigation/gotoTestOrCode/fromKotlinFileToTest.main.kt");
    }

    @TestMetadata("fromKotlinTestToJavaClass.main.kt")
    public void testFromKotlinTestToJavaClass() throws Exception {
        runTest("idea/testData/navigation/gotoTestOrCode/fromKotlinTestToJavaClass.main.kt");
    }

    @TestMetadata("fromKotlinTestToKotlinClass.main.kt")
    public void testFromKotlinTestToKotlinClass() throws Exception {
        runTest("idea/testData/navigation/gotoTestOrCode/fromKotlinTestToKotlinClass.main.kt");
    }

    @TestMetadata("fromKotlinTestToKotlinFile.main.kt")
    public void testFromKotlinTestToKotlinFile() throws Exception {
        runTest("idea/testData/navigation/gotoTestOrCode/fromKotlinTestToKotlinFile.main.kt");
    }
}
