(* X64.thy - generated by L3 - 24/09/2015 *)
theory X64
imports "$ISABELLE_HOME/src/HOL/Word/Word" "L3_Theory"
begin

ML_file "$ISABELLE_HOME/src/HOL/Word/Tools/word_lib.ML"
ML_file "L3.ML"

datatype Zreg = RAX | RCX | RDX | RBX | RSP | RBP | RSI | RDI | zR8 | zR9 | zR10 | zR11 | zR12 |
  zR13 | zR14 | zR15

datatype Zeflags = Z_CF | Z_PF | Z_AF | Z_ZF | Z_SF | Z_OF

datatype Zsize = Z16 | Z32 | Z64 | Z8 bool

datatype Zbase = ZnoBase | ZregBase Zreg | ZripBase

datatype Zrm = Zm "((2 word \<times> Zreg) option) \<times> Zbase \<times> 64 word" | Zr Zreg

datatype Zdest_src =
    Zr_rm "Zreg \<times> Zrm"
  | Zrm_i "Zrm \<times> 64 word"
  | Zrm_r "Zrm \<times> Zreg"

datatype Zimm_rm = Zimm "64 word" | Zrm Zrm

datatype Zmonop_name = Zdec | Zinc | Znot | Zneg

datatype Zbinop_name = Zadd | Zor | Zadc | Zsbb | Zand | Zsub | Zxor | Zcmp | Zrol | Zror | Zrcl |
  Zrcr | Zshl | Zshr | Ztest | Zsar

datatype Zcond = Z_O | Z_NO | Z_B | Z_NB | Z_E | Z_NE | Z_NA | Z_A | Z_S | Z_NS | Z_P | Z_NP | Z_L |
  Z_NL | Z_NG | Z_G | Z_ALWAYS

datatype Zea =
    Zea_i "Zsize \<times> 64 word"
  | Zea_m "Zsize \<times> 64 word"
  | Zea_r "Zsize \<times> Zreg"

datatype instruction =
    Zbinop "Zbinop_name \<times> Zsize \<times> Zdest_src"
  | Zcall Zimm_rm
  | Zcmpxchg "Zsize \<times> Zrm \<times> Zreg"
  | Zdiv "Zsize \<times> Zrm"
  | Zjcc "Zcond \<times> 64 word"
  | Zjmp Zrm
  | Zlea "Zsize \<times> Zdest_src"
  | Zleave
  | Zloop "Zcond \<times> 64 word"
  | Zmonop "Zmonop_name \<times> Zsize \<times> Zrm"
  | Zmov "Zcond \<times> Zsize \<times> Zdest_src"
  | Zmovsx "Zsize \<times> Zdest_src \<times> Zsize"
  | Zmovzx "Zsize \<times> Zdest_src \<times> Zsize"
  | Zmul "Zsize \<times> Zrm"
  | Znop
  | Zpop Zrm
  | Zpush Zimm_rm
  | Zret "64 word"
  | Zxadd "Zsize \<times> Zrm \<times> Zreg"
  | Zxchg "Zsize \<times> Zrm \<times> Zreg"

datatype Zinst =
    Zdec_fail string
  | Zfull_inst "(8 word list) \<times> instruction \<times> 8 word list"

record REX = B :: bool R :: bool W :: bool X :: bool

datatype exception = BadFlagAccess string | BadMemAccess "64 word" | FAILURE string | NoException

record X64_state =
  EFLAGS :: "Zeflags \<Rightarrow> (bool option)"
  MEM :: "64 word \<Rightarrow> 8 word"
  REG :: "Zreg \<Rightarrow> 64 word"
  RIP :: "64 word"
  exception :: exception

fun nat_to_Zreg :: "nat \<Rightarrow> Zreg" where
  "nat_to_Zreg x =
   (if x = 0 then RAX
    else if x = 1 then RCX
    else if x = 2 then RDX
    else if x = 3 then RBX
    else if x = 4 then RSP
    else if x = 5 then RBP
    else if x = 6 then RSI
    else if x = 7 then RDI
    else if x = 8 then zR8
    else if x = 9 then zR9
    else if x = 10 then zR10
    else if x = 11 then zR11
    else if x = 12 then zR12
    else if x = 13 then zR13
    else if x = 14 then zR14
    else if x = 15 then zR15
    else undefined)"

fun nat_to_Zeflags :: "nat \<Rightarrow> Zeflags" where
  "nat_to_Zeflags x =
   (if x = 0 then Z_CF
    else if x = 1 then Z_PF
    else if x = 2 then Z_AF
    else if x = 3 then Z_ZF
    else if x = 4 then Z_SF
    else if x = 5 then Z_OF
    else undefined)"

fun nat_to_Zmonop_name :: "nat \<Rightarrow> Zmonop_name" where
  "nat_to_Zmonop_name x =
   (if x = 0 then Zdec else if x = 1 then Zinc else if x = 2 then Znot else if x = 3 then Zneg
    else undefined)"

fun nat_to_Zbinop_name :: "nat \<Rightarrow> Zbinop_name" where
  "nat_to_Zbinop_name x =
   (if x = 0 then Zadd
    else if x = 1 then Zor
    else if x = 2 then Zadc
    else if x = 3 then Zsbb
    else if x = 4 then Zand
    else if x = 5 then Zsub
    else if x = 6 then Zxor
    else if x = 7 then Zcmp
    else if x = 8 then Zrol
    else if x = 9 then Zror
    else if x = 10 then Zrcl
    else if x = 11 then Zrcr
    else if x = 12 then Zshl
    else if x = 13 then Zshr
    else if x = 14 then Ztest
    else if x = 15 then Zsar
    else undefined)"

fun nat_to_Zcond :: "nat \<Rightarrow> Zcond" where
  "nat_to_Zcond x =
   (if x = 0 then Z_O
    else if x = 1 then Z_NO
    else if x = 2 then Z_B
    else if x = 3 then Z_NB
    else if x = 4 then Z_E
    else if x = 5 then Z_NE
    else if x = 6 then Z_NA
    else if x = 7 then Z_A
    else if x = 8 then Z_S
    else if x = 9 then Z_NS
    else if x = 10 then Z_P
    else if x = 11 then Z_NP
    else if x = 12 then Z_L
    else if x = 13 then Z_NL
    else if x = 14 then Z_NG
    else if x = 15 then Z_G
    else if x = 16 then Z_ALWAYS
    else undefined)"

fun Zreg_to_nat :: "Zreg \<Rightarrow> nat" where
  "Zreg_to_nat x =
   (case x of
       RAX => 0
     | RCX => 1
     | RDX => 2
     | RBX => 3
     | RSP => 4
     | RBP => 5
     | RSI => 6
     | RDI => 7
     | zR8 => 8
     | zR9 => 9
     | zR10 => 10
     | zR11 => 11
     | zR12 => 12
     | zR13 => 13
     | zR14 => 14
     | zR15 => 15)"

fun Zeflags_to_nat :: "Zeflags \<Rightarrow> nat" where
  "Zeflags_to_nat x =
   (case x of
       Z_CF => 0 | Z_PF => 1 | Z_AF => 2 | Z_ZF => 3 | Z_SF => 4 | Z_OF => 5)"

fun Zmonop_name_to_nat :: "Zmonop_name \<Rightarrow> nat" where
  "Zmonop_name_to_nat x =
   (case x of
       Zdec => 0 | Zinc => 1 | Znot => 2 | Zneg => 3)"

fun Zbinop_name_to_nat :: "Zbinop_name \<Rightarrow> nat" where
  "Zbinop_name_to_nat x =
   (case x of
       Zadd => 0
     | Zor => 1
     | Zadc => 2
     | Zsbb => 3
     | Zand => 4
     | Zsub => 5
     | Zxor => 6
     | Zcmp => 7
     | Zrol => 8
     | Zror => 9
     | Zrcl => 10
     | Zrcr => 11
     | Zshl => 12
     | Zshr => 13
     | Ztest => 14
     | Zsar => 15)"

fun Zcond_to_nat :: "Zcond \<Rightarrow> nat" where
  "Zcond_to_nat x =
   (case x of
       Z_O => 0
     | Z_NO => 1
     | Z_B => 2
     | Z_NB => 3
     | Z_E => 4
     | Z_NE => 5
     | Z_NA => 6
     | Z_A => 7
     | Z_S => 8
     | Z_NS => 9
     | Z_P => 10
     | Z_NP => 11
     | Z_L => 12
     | Z_NL => 13
     | Z_NG => 14
     | Z_G => 15
     | Z_ALWAYS => 16)"

fun Zreg_to_string :: "Zreg \<Rightarrow> string" where
  "Zreg_to_string x =
   (case x of
       RAX => ''RAX''
     | RCX => ''RCX''
     | RDX => ''RDX''
     | RBX => ''RBX''
     | RSP => ''RSP''
     | RBP => ''RBP''
     | RSI => ''RSI''
     | RDI => ''RDI''
     | zR8 => ''zR8''
     | zR9 => ''zR9''
     | zR10 => ''zR10''
     | zR11 => ''zR11''
     | zR12 => ''zR12''
     | zR13 => ''zR13''
     | zR14 => ''zR14''
     | zR15 => ''zR15'')"

fun Zeflags_to_string :: "Zeflags \<Rightarrow> string" where
  "Zeflags_to_string x =
   (case x of
       Z_CF => ''Z_CF''
     | Z_PF => ''Z_PF''
     | Z_AF => ''Z_AF''
     | Z_ZF => ''Z_ZF''
     | Z_SF => ''Z_SF''
     | Z_OF => ''Z_OF'')"

fun Zmonop_name_to_string :: "Zmonop_name \<Rightarrow> string" where
  "Zmonop_name_to_string x =
   (case x of
       Zdec => ''Zdec'' | Zinc => ''Zinc'' | Znot => ''Znot'' | Zneg => ''Zneg'')"

fun Zbinop_name_to_string :: "Zbinop_name \<Rightarrow> string" where
  "Zbinop_name_to_string x =
   (case x of
       Zadd => ''Zadd''
     | Zor => ''Zor''
     | Zadc => ''Zadc''
     | Zsbb => ''Zsbb''
     | Zand => ''Zand''
     | Zsub => ''Zsub''
     | Zxor => ''Zxor''
     | Zcmp => ''Zcmp''
     | Zrol => ''Zrol''
     | Zror => ''Zror''
     | Zrcl => ''Zrcl''
     | Zrcr => ''Zrcr''
     | Zshl => ''Zshl''
     | Zshr => ''Zshr''
     | Ztest => ''Ztest''
     | Zsar => ''Zsar'')"

fun Zcond_to_string :: "Zcond \<Rightarrow> string" where
  "Zcond_to_string x =
   (case x of
       Z_O => ''Z_O''
     | Z_NO => ''Z_NO''
     | Z_B => ''Z_B''
     | Z_NB => ''Z_NB''
     | Z_E => ''Z_E''
     | Z_NE => ''Z_NE''
     | Z_NA => ''Z_NA''
     | Z_A => ''Z_A''
     | Z_S => ''Z_S''
     | Z_NS => ''Z_NS''
     | Z_P => ''Z_P''
     | Z_NP => ''Z_NP''
     | Z_L => ''Z_L''
     | Z_NL => ''Z_NL''
     | Z_NG => ''Z_NG''
     | Z_G => ''Z_G''
     | Z_ALWAYS => ''Z_ALWAYS'')"

fun string_to_Zreg :: "string \<Rightarrow> Zreg" where
  "string_to_Zreg x =
   (if x = ''RAX'' then RAX
    else if x = ''RCX'' then RCX
    else if x = ''RDX'' then RDX
    else if x = ''RBX'' then RBX
    else if x = ''RSP'' then RSP
    else if x = ''RBP'' then RBP
    else if x = ''RSI'' then RSI
    else if x = ''RDI'' then RDI
    else if x = ''zR8'' then zR8
    else if x = ''zR9'' then zR9
    else if x = ''zR10'' then zR10
    else if x = ''zR11'' then zR11
    else if x = ''zR12'' then zR12
    else if x = ''zR13'' then zR13
    else if x = ''zR14'' then zR14
    else if x = ''zR15'' then zR15
    else undefined)"

fun string_to_Zeflags :: "string \<Rightarrow> Zeflags" where
  "string_to_Zeflags x =
   (if x = ''Z_CF'' then Z_CF
    else if x = ''Z_PF'' then Z_PF
    else if x = ''Z_AF'' then Z_AF
    else if x = ''Z_ZF'' then Z_ZF
    else if x = ''Z_SF'' then Z_SF
    else if x = ''Z_OF'' then Z_OF
    else undefined)"

fun string_to_Zmonop_name :: "string \<Rightarrow> Zmonop_name" where
  "string_to_Zmonop_name x =
   (if x = ''Zdec'' then Zdec
    else if x = ''Zinc'' then Zinc
    else if x = ''Znot'' then Znot
    else if x = ''Zneg'' then Zneg
    else undefined)"

fun string_to_Zbinop_name :: "string \<Rightarrow> Zbinop_name" where
  "string_to_Zbinop_name x =
   (if x = ''Zadd'' then Zadd
    else if x = ''Zor'' then Zor
    else if x = ''Zadc'' then Zadc
    else if x = ''Zsbb'' then Zsbb
    else if x = ''Zand'' then Zand
    else if x = ''Zsub'' then Zsub
    else if x = ''Zxor'' then Zxor
    else if x = ''Zcmp'' then Zcmp
    else if x = ''Zrol'' then Zrol
    else if x = ''Zror'' then Zror
    else if x = ''Zrcl'' then Zrcl
    else if x = ''Zrcr'' then Zrcr
    else if x = ''Zshl'' then Zshl
    else if x = ''Zshr'' then Zshr
    else if x = ''Ztest'' then Ztest
    else if x = ''Zsar'' then Zsar
    else undefined)"

fun string_to_Zcond :: "string \<Rightarrow> Zcond" where
  "string_to_Zcond x =
   (if x = ''Z_O'' then Z_O
    else if x = ''Z_NO'' then Z_NO
    else if x = ''Z_B'' then Z_B
    else if x = ''Z_NB'' then Z_NB
    else if x = ''Z_E'' then Z_E
    else if x = ''Z_NE'' then Z_NE
    else if x = ''Z_NA'' then Z_NA
    else if x = ''Z_A'' then Z_A
    else if x = ''Z_S'' then Z_S
    else if x = ''Z_NS'' then Z_NS
    else if x = ''Z_P'' then Z_P
    else if x = ''Z_NP'' then Z_NP
    else if x = ''Z_L'' then Z_L
    else if x = ''Z_NL'' then Z_NL
    else if x = ''Z_NG'' then Z_NG
    else if x = ''Z_G'' then Z_G
    else if x = ''Z_ALWAYS'' then Z_ALWAYS
    else undefined)"

fun boolify'8 :: "8 word \<Rightarrow>
  (bool \<times>
   bool \<times> bool \<times> bool \<times> bool \<times> bool \<times> bool \<times> bool)" where
  "boolify'8 w =
   (case to_bl w of
     [b0,b1,b2,b3,b4,b5,b6,b7] \<Rightarrow>
     (b0,b1,b2,b3,b4,b5,b6,b7))"

ML \<open>
local open L3 in
val () = function
  ("raise'exception",var("e",@{typ exception}),
   close
     (var("state",@{typ X64_state}),
      tp[lx(@{typ 'a}),
         ite(eq(call("X64_state.exception",@{typ exception},var("state",@{typ X64_state}),@{theory}),
                Term.Const(@{const_name "NoException"},@{typ exception})),
             rupd
               ("X64_state.exception",tp[var("state",@{typ X64_state}),var("e",@{typ exception})],
                @{theory}),var("state",@{typ X64_state}))]))

val () = function
  ("mem8",var("addr",@{typ "64 word"}),
   close
     (var("state",@{typ X64_state}),
      tp[apply
           (call
              ("X64_state.MEM",@{typ "64 word \<Rightarrow> 8 word"},var("state",@{typ X64_state}),
               @{theory}),var("addr",@{typ "64 word"})),var("state",@{typ X64_state})]))

val () = function
  ("write'mem8",tp[var("b",@{typ "8 word"}),var("addr",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      tp[lu,
         rupd
           ("X64_state.MEM",
            tp[var("state",@{typ X64_state}),
               fupd
                 (call
                    ("X64_state.MEM",@{typ "64 word \<Rightarrow> 8 word"},
                     var("state",@{typ X64_state}),@{theory}),var("addr",@{typ "64 word"}),
                  var("b",@{typ "8 word"}))],@{theory})]))

val () = function
  ("mem16",var("addr",@{typ "64 word"}),
   close
     (var("state",@{typ X64_state}),
      tp[cc[mop(Fst,
                apply
                  (call
                     ("mem8",@{typ "X64_state \<Rightarrow> (8 word \<times> X64_state)"},
                      bop(Add,var("addr",@{typ "64 word"}),lw(1,64)),@{theory}),
                   var("state",@{typ X64_state}))),
            mop(Fst,
                apply
                  (call
                     ("mem8",@{typ "X64_state \<Rightarrow> (8 word \<times> X64_state)"},
                      var("addr",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state})))],
         var("state",@{typ X64_state})]))

val () = function
  ("write'mem16",tp[var("w",@{typ "16 word"}),var("addr",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'mem8",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[ex(var("w",@{typ "16 word"}),ln 15,ln 8,@{typ "8 word"}),
               bop(Add,var("addr",@{typ "64 word"}),lw(1,64))],@{theory}),
         mop(Snd,
             apply
               (call
                  ("write'mem8",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[ex(var("w",@{typ "16 word"}),ln 7,ln 0,@{typ "8 word"}),
                      var("addr",@{typ "64 word"})],@{theory}),var("state",@{typ X64_state}))))))

val () = function
  ("mem32",var("addr",@{typ "64 word"}),
   close
     (var("state",@{typ X64_state}),
      tp[cc[mop(Fst,
                apply
                  (call
                     ("mem16",@{typ "X64_state \<Rightarrow> (16 word \<times> X64_state)"},
                      bop(Add,var("addr",@{typ "64 word"}),lw(2,64)),@{theory}),
                   var("state",@{typ X64_state}))),
            mop(Fst,
                apply
                  (call
                     ("mem16",@{typ "X64_state \<Rightarrow> (16 word \<times> X64_state)"},
                      var("addr",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state})))],
         var("state",@{typ X64_state})]))

val () = function
  ("write'mem32",tp[var("w",@{typ "32 word"}),var("addr",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'mem16",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[ex(var("w",@{typ "32 word"}),ln 31,ln 16,@{typ "16 word"}),
               bop(Add,var("addr",@{typ "64 word"}),lw(2,64))],@{theory}),
         mop(Snd,
             apply
               (call
                  ("write'mem16",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[ex(var("w",@{typ "32 word"}),ln 15,ln 0,@{typ "16 word"}),
                      var("addr",@{typ "64 word"})],@{theory}),var("state",@{typ X64_state}))))))

val () = function
  ("mem64",var("addr",@{typ "64 word"}),
   close
     (var("state",@{typ X64_state}),
      tp[cc[mop(Fst,
                apply
                  (call
                     ("mem32",@{typ "X64_state \<Rightarrow> (32 word \<times> X64_state)"},
                      bop(Add,var("addr",@{typ "64 word"}),lw(4,64)),@{theory}),
                   var("state",@{typ X64_state}))),
            mop(Fst,
                apply
                  (call
                     ("mem32",@{typ "X64_state \<Rightarrow> (32 word \<times> X64_state)"},
                      var("addr",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state})))],
         var("state",@{typ X64_state})]))

val () = function
  ("write'mem64",tp[var("w",@{typ "64 word"}),var("addr",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'mem32",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[ex(var("w",@{typ "64 word"}),ln 63,ln 32,@{typ "32 word"}),
               bop(Add,var("addr",@{typ "64 word"}),lw(4,64))],@{theory}),
         mop(Snd,
             apply
               (call
                  ("write'mem32",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[ex(var("w",@{typ "64 word"}),ln 31,ln 0,@{typ "32 word"}),
                      var("addr",@{typ "64 word"})],@{theory}),var("state",@{typ X64_state}))))))

val () = function
  ("Eflag",var("flag",@{typ Zeflags}),
   close
     (var("state",@{typ X64_state}),
      cs(apply
           (call
              ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
               var("state",@{typ X64_state}),@{theory}),var("flag",@{typ Zeflags})),
         [(mop(Some,var_b"b"),tp[var_b"b",var("state",@{typ X64_state})]),
          (lo(@{typ bool}),
           apply
             (call
                ("raise'exception",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
                 call
                   ("exception.BadFlagAccess",@{typ exception},
                    mop(Cast(@{typ string}),var("flag",@{typ Zeflags})),@{theory}),@{theory}),
              var("state",@{typ X64_state})))],@{context})))

val () = function
  ("write'Eflag",tp[var_b"b",var("flag",@{typ Zeflags})],
   close
     (var("state",@{typ X64_state}),
      tp[lu,
         rupd
           ("X64_state.EFLAGS",
            tp[var("state",@{typ X64_state}),
               fupd
                 (call
                    ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                     var("state",@{typ X64_state}),@{theory}),var("flag",@{typ Zeflags}),
                  mop(Some,var_b"b"))],@{theory})]))

val () = function
  ("FlagUnspecified",var("flag",@{typ Zeflags}),
   close
     (var("state",@{typ X64_state}),
      tp[lu,
         rupd
           ("X64_state.EFLAGS",
            tp[var("state",@{typ X64_state}),
               fupd
                 (call
                    ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                     var("state",@{typ X64_state}),@{theory}),var("flag",@{typ Zeflags}),
                  lo(@{typ bool}))],@{theory})]))

val () = function
  ("CF",var("state",@{typ X64_state}),
   apply
     (call
        ("Eflag",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
         lc("Z_CF","Zeflags",@{theory}),@{theory}),var("state",@{typ X64_state})))

val () = function
  ("write'CF",var_b"b",
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'Eflag",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var_b"b",lc("Z_CF","Zeflags",@{theory})],@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("PF",var("state",@{typ X64_state}),
   apply
     (call
        ("Eflag",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
         lc("Z_PF","Zeflags",@{theory}),@{theory}),var("state",@{typ X64_state})))

val () = function
  ("write'PF",var_b"b",
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'Eflag",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var_b"b",lc("Z_PF","Zeflags",@{theory})],@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("AF",var("state",@{typ X64_state}),
   apply
     (call
        ("Eflag",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
         lc("Z_AF","Zeflags",@{theory}),@{theory}),var("state",@{typ X64_state})))

val () = function
  ("write'AF",var_b"b",
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'Eflag",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var_b"b",lc("Z_AF","Zeflags",@{theory})],@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("ZF",var("state",@{typ X64_state}),
   apply
     (call
        ("Eflag",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
         lc("Z_ZF","Zeflags",@{theory}),@{theory}),var("state",@{typ X64_state})))

val () = function
  ("write'ZF",var_b"b",
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'Eflag",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var_b"b",lc("Z_ZF","Zeflags",@{theory})],@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("SF",var("state",@{typ X64_state}),
   apply
     (call
        ("Eflag",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
         lc("Z_SF","Zeflags",@{theory}),@{theory}),var("state",@{typ X64_state})))

val () = function
  ("write'SF",var_b"b",
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'Eflag",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var_b"b",lc("Z_SF","Zeflags",@{theory})],@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("OF",var("state",@{typ X64_state}),
   apply
     (call
        ("Eflag",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
         lc("Z_OF","Zeflags",@{theory}),@{theory}),var("state",@{typ X64_state})))

val () = function
  ("write'OF",var_b"b",
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'Eflag",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var_b"b",lc("Z_OF","Zeflags",@{theory})],@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("ea_index",var("index",@{typ "(2 word \<times> Zreg) option"}),
   close
     (var("state",@{typ X64_state}),
      cs(var("index",@{typ "(2 word \<times> Zreg) option"}),
         [(lo(@{typ "2 word \<times> Zreg"}),tp[lw(0,64),var("state",@{typ X64_state})]),
          (mop(Some,tp[var("scale",@{typ "2 word"}),var("idx",@{typ Zreg})]),
           tp[bop(Mul,bop(Lsl,lw(1,64),mop(Cast(@{typ nat}),var("scale",@{typ "2 word"}))),
                  apply
                    (call
                       ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                        var("state",@{typ X64_state}),@{theory}),var("idx",@{typ Zreg}))),
              var("state",@{typ X64_state})])],@{context})))

val () = function
  ("ea_base",var("base",@{typ Zbase}),
   close
     (var("state",@{typ X64_state}),
      cs(var("base",@{typ Zbase}),
         [(Term.Const(@{const_name "ZnoBase"},@{typ Zbase}),
           tp[lw(0,64),var("state",@{typ X64_state})]),
          (Term.Const(@{const_name "ZripBase"},@{typ Zbase}),
           tp[call("X64_state.RIP",@{typ "64 word"},var("state",@{typ X64_state}),@{theory}),
              var("state",@{typ X64_state})]),
          (call("Zbase.ZregBase",@{typ Zbase},var("b",@{typ Zreg}),@{theory}),
           tp[apply
                (call
                   ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                    var("state",@{typ X64_state}),@{theory}),var("b",@{typ Zreg})),
              var("state",@{typ X64_state})])],@{context})))

val () = function
  ("ea_Zrm",tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
   close
     (var("state",@{typ X64_state}),
      cs(var("rm",@{typ Zrm}),
         [(call("Zrm.Zr",@{typ Zrm},var("r",@{typ Zreg}),@{theory}),
           tp[call
                ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
              var("state",@{typ X64_state})]),
          (call
             ("Zrm.Zm",@{typ Zrm},
              tp[var("index",@{typ "(2 word \<times> Zreg) option"}),var("base",@{typ Zbase}),
                 var("displacement",@{typ "64 word"})],@{theory}),
           tp[call
                ("Zea.Zea_m",@{typ Zea},
                 tp[var("size",@{typ Zsize}),
                    bop(Add,
                        bop(Add,
                            mop(Fst,
                                apply
                                  (call
                                     ("ea_index",
                                      @{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                      var("index",@{typ "(2 word \<times> Zreg) option"}),@{theory}),
                                   var("state",@{typ X64_state}))),
                            mop(Fst,
                                apply
                                  (call
                                     ("ea_base",
                                      @{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                      var("base",@{typ Zbase}),@{theory}),
                                   var("state",@{typ X64_state})))),
                        var("displacement",@{typ "64 word"}))],@{theory}),
              var("state",@{typ X64_state})])],@{context})))

val () = function
  ("ea_Zdest",tp[var("size",@{typ Zsize}),var("ds",@{typ Zdest_src})],
   close
     (var("state",@{typ X64_state}),
      cs(var("ds",@{typ Zdest_src}),
         [(call
             ("Zdest_src.Zrm_i",@{typ Zdest_src},tp[var("rm",@{typ Zrm}),var_a(@{typ "64 word"})],
              @{theory}),
           tp[mop(Fst,
                  apply
                    (call
                       ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                        tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                     var("state",@{typ X64_state}))),var("state",@{typ X64_state})]),
          (call
             ("Zdest_src.Zrm_r",@{typ Zdest_src},tp[var("rm",@{typ Zrm}),var_a(@{typ Zreg})],
              @{theory}),
           tp[mop(Fst,
                  apply
                    (call
                       ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                        tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                     var("state",@{typ X64_state}))),var("state",@{typ X64_state})]),
          (call
             ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var("r",@{typ Zreg}),var_a(@{typ Zrm})],
              @{theory}),
           tp[call
                ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
              var("state",@{typ X64_state})])],@{context})))

val () = function
  ("ea_Zsrc",tp[var("size",@{typ Zsize}),var("ds",@{typ Zdest_src})],
   close
     (var("state",@{typ X64_state}),
      cs(var("ds",@{typ Zdest_src}),
         [(call
             ("Zdest_src.Zrm_i",@{typ Zdest_src},tp[var_a(@{typ Zrm}),var("i",@{typ "64 word"})],
              @{theory}),
           tp[call
                ("Zea.Zea_i",@{typ Zea},tp[var("size",@{typ Zsize}),var("i",@{typ "64 word"})],
                 @{theory}),var("state",@{typ X64_state})]),
          (call
             ("Zdest_src.Zrm_r",@{typ Zdest_src},tp[var_a(@{typ Zrm}),var("r",@{typ Zreg})],
              @{theory}),
           tp[call
                ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
              var("state",@{typ X64_state})]),
          (call
             ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var_a(@{typ Zreg}),var("rm",@{typ Zrm})],
              @{theory}),
           tp[mop(Fst,
                  apply
                    (call
                       ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                        tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                     var("state",@{typ X64_state}))),var("state",@{typ X64_state})])],@{context})))

val () = function
  ("ea_Zimm_rm",tp[var("size",@{typ Zsize}),var("imm_rm",@{typ Zimm_rm})],
   close
     (var("state",@{typ X64_state}),
      cs(var("imm_rm",@{typ Zimm_rm}),
         [(call("Zimm_rm.Zrm",@{typ Zimm_rm},var("rm",@{typ Zrm}),@{theory}),
           tp[mop(Fst,
                  apply
                    (call
                       ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                        tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                     var("state",@{typ X64_state}))),var("state",@{typ X64_state})]),
          (call("Zimm_rm.Zimm",@{typ Zimm_rm},var("imm",@{typ "64 word"}),@{theory}),
           tp[call
                ("Zea.Zea_i",@{typ Zea},tp[var("size",@{typ Zsize}),var("imm",@{typ "64 word"})],
                 @{theory}),var("state",@{typ X64_state})])],@{context})))

val () = function
  ("restrictSize",tp[var("size",@{typ Zsize}),var("imm",@{typ "64 word"})],
   cs(var("size",@{typ Zsize}),
      [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
        bop(BAnd,var("imm",@{typ "64 word"}),lw(255,64))),
       (Term.Const(@{const_name "Z16"},@{typ Zsize}),
        bop(BAnd,var("imm",@{typ "64 word"}),lw(65535,64))),
       (Term.Const(@{const_name "Z32"},@{typ Zsize}),
        bop(BAnd,var("imm",@{typ "64 word"}),lw(4294967295,64))),
       (Term.Const(@{const_name "Z64"},@{typ Zsize}),var("imm",@{typ "64 word"}))],@{context}))

val () = function
  ("EA",var("ea",@{typ Zea}),
   close
     (var("state",@{typ X64_state}),
      cs(var("ea",@{typ Zea}),
         [(call("Zea.Zea_i",@{typ Zea},var("i",@{typ "Zsize \<times> 64 word"}),@{theory}),
           tp[call
                ("restrictSize",@{typ "64 word"},var("i",@{typ "Zsize \<times> 64 word"}),@{theory}),
              var("state",@{typ X64_state})]),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[call("Zsize.Z8",@{typ Zsize},var_b"have_rex",@{theory}),var("r",@{typ Zreg})],
              @{theory}),
           tp[bop(BAnd,
                  ite(bop(Or,var_b"have_rex",
                          mop(Not,
                              bop(In,var("r",@{typ Zreg}),
                                  sl[lc("RSP","Zreg",@{theory}),lc("RBP","Zreg",@{theory}),
                                     lc("RSI","Zreg",@{theory}),lc("RDI","Zreg",@{theory})]))),
                      apply
                        (call
                           ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                            var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg})),
                      bop(Lsr,
                          apply
                            (call
                               ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                var("state",@{typ X64_state}),@{theory}),
                             mop(Cast(@{typ Zreg}),
                                 bop(Sub,mop(Cast(@{typ nat}),var("r",@{typ Zreg})),ln 4))),ln 8)),
                  lw(255,64)),var("state",@{typ X64_state})]),
          (call("Zea.Zea_r",@{typ Zea},tp[var("s",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           tp[call
                ("restrictSize",@{typ "64 word"},
                 tp[var("s",@{typ Zsize}),
                    apply
                      (call
                         ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                          var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg}))],@{theory}),
              var("state",@{typ X64_state})]),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
                 var("a",@{typ "64 word"})],@{theory}),
           tp[mop(Cast(@{typ "64 word"}),
                  mop(Fst,
                      apply
                        (call
                           ("mem8",@{typ "X64_state \<Rightarrow> (8 word \<times> X64_state)"},
                            var("a",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state})))),
              var("state",@{typ X64_state})]),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),var("a",@{typ "64 word"})],@{theory}),
           tp[mop(Cast(@{typ "64 word"}),
                  mop(Fst,
                      apply
                        (call
                           ("mem16",@{typ "X64_state \<Rightarrow> (16 word \<times> X64_state)"},
                            var("a",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state})))),
              var("state",@{typ X64_state})]),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),var("a",@{typ "64 word"})],@{theory}),
           tp[mop(Cast(@{typ "64 word"}),
                  mop(Fst,
                      apply
                        (call
                           ("mem32",@{typ "X64_state \<Rightarrow> (32 word \<times> X64_state)"},
                            var("a",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state})))),
              var("state",@{typ X64_state})]),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("a",@{typ "64 word"})],@{theory}),
           tp[mop(Fst,
                  apply
                    (call
                       ("mem64",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                        var("a",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state}))),
              var("state",@{typ X64_state})])],@{context})))

val () = function
  ("write'EA",tp[var("w",@{typ "64 word"}),var("ea",@{typ Zea})],
   close
     (var("state",@{typ X64_state}),
      cs(var("ea",@{typ Zea}),
         [(call("Zea.Zea_i",@{typ Zea},var("i",@{typ "Zsize \<times> 64 word"}),@{theory}),
           apply
             (call
                ("raise'exception",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 call("exception.FAILURE",@{typ exception},ls"write to constant",@{theory}),
                 @{theory}),var("state",@{typ X64_state}))),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[call("Zsize.Z8",@{typ Zsize},var_b"have_rex",@{theory}),var("r",@{typ Zreg})],
              @{theory}),
           ite(bop(Or,var_b"have_rex",
                   mop(Not,
                       bop(In,var("r",@{typ Zreg}),
                           sl[lc("RSP","Zreg",@{theory}),lc("RBP","Zreg",@{theory}),
                              lc("RSI","Zreg",@{theory}),lc("RDI","Zreg",@{theory})]))),
               tp[lu,
                  rupd
                    ("X64_state.REG",
                     tp[var("state",@{typ X64_state}),
                        fupd
                          (call
                             ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                              var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg}),
                           bfi(ln 7,ln 0,ex(var("w",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
                               apply
                                 (call
                                    ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                     var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg}))))],
                     @{theory})],
               let'
                 (var("x",@{typ Zreg}),
                  mop(Cast(@{typ Zreg}),bop(Sub,mop(Cast(@{typ nat}),var("r",@{typ Zreg})),ln 4)),
                  tp[lu,
                     rupd
                       ("X64_state.REG",
                        tp[var("state",@{typ X64_state}),
                           fupd
                             (call
                                ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                 var("state",@{typ X64_state}),@{theory}),var("x",@{typ Zreg}),
                              bfi(ln 15,ln 8,
                                  ex(var("w",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
                                  apply
                                    (call
                                       ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                        var("state",@{typ X64_state}),@{theory}),
                                     var("x",@{typ Zreg}))))],@{theory})]))),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           tp[lu,
              rupd
                ("X64_state.REG",
                 tp[var("state",@{typ X64_state}),
                    fupd
                      (call
                         ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                          var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg}),
                       bfi(ln 15,ln 0,ex(var("w",@{typ "64 word"}),ln 15,ln 0,@{typ "16 word"}),
                           apply
                             (call
                                ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                 var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg}))))],
                 @{theory})]),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           tp[lu,
              rupd
                ("X64_state.REG",
                 tp[var("state",@{typ X64_state}),
                    fupd
                      (call
                         ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                          var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg}),
                       mop(Cast(@{typ "64 word"}),
                           ex(var("w",@{typ "64 word"}),ln 31,ln 0,@{typ "32 word"})))],@{theory})]),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           tp[lu,
              rupd
                ("X64_state.REG",
                 tp[var("state",@{typ X64_state}),
                    fupd
                      (call
                         ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                          var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg}),
                       var("w",@{typ "64 word"}))],@{theory})]),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
                 var("a",@{typ "64 word"})],@{theory}),
           apply
             (call
                ("write'mem8",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[ex(var("w",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
                    var("a",@{typ "64 word"})],@{theory}),var("state",@{typ X64_state}))),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),var("a",@{typ "64 word"})],@{theory}),
           apply
             (call
                ("write'mem16",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[ex(var("w",@{typ "64 word"}),ln 15,ln 0,@{typ "16 word"}),
                    var("a",@{typ "64 word"})],@{theory}),var("state",@{typ X64_state}))),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),var("a",@{typ "64 word"})],@{theory}),
           apply
             (call
                ("write'mem32",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[ex(var("w",@{typ "64 word"}),ln 31,ln 0,@{typ "32 word"}),
                    var("a",@{typ "64 word"})],@{theory}),var("state",@{typ X64_state}))),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("a",@{typ "64 word"})],@{theory}),
           apply
             (call
                ("write'mem64",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("w",@{typ "64 word"}),var("a",@{typ "64 word"})],@{theory}),
              var("state",@{typ X64_state})))],@{context})))

val () = function
  ("read_dest_src_ea",var("sd",@{typ "Zsize \<times> Zdest_src"}),
   close
     (var("state",@{typ X64_state}),
      let'
        (var("v",@{typ Zea}),
         mop(Fst,
             apply
               (call
                  ("ea_Zdest",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                   var("sd",@{typ "Zsize \<times> Zdest_src"}),@{theory}),
                var("state",@{typ X64_state}))),
         tp[tp[var("v",@{typ Zea}),
               mop(Fst,
                   apply
                     (call
                        ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                         var("v",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
               mop(Fst,
                   apply
                     (call
                        ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                         mop(Fst,
                             apply
                               (call
                                  ("ea_Zsrc",
                                   @{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                   var("sd",@{typ "Zsize \<times> Zdest_src"}),@{theory}),
                                var("state",@{typ X64_state}))),@{theory}),
                      var("state",@{typ X64_state})))],var("state",@{typ X64_state})])))

val () = function
  ("call_dest_from_ea",var("ea",@{typ Zea}),
   close
     (var("state",@{typ X64_state}),
      cs(var("ea",@{typ Zea}),
         [(call("Zea.Zea_i",@{typ Zea},tp[var_a(@{typ Zsize}),var("i",@{typ "64 word"})],@{theory}),
           tp[bop(Add,
                  call("X64_state.RIP",@{typ "64 word"},var("state",@{typ X64_state}),@{theory}),
                  var("i",@{typ "64 word"})),var("state",@{typ X64_state})]),
          (call("Zea.Zea_r",@{typ Zea},tp[var_a(@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           tp[apply
                (call
                   ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                    var("state",@{typ X64_state}),@{theory}),var("r",@{typ Zreg})),
              var("state",@{typ X64_state})]),
          (call("Zea.Zea_m",@{typ Zea},tp[var_a(@{typ Zsize}),var("a",@{typ "64 word"})],@{theory}),
           tp[mop(Fst,
                  apply
                    (call
                       ("mem64",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                        var("a",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state}))),
              var("state",@{typ X64_state})])],@{context})))

val () = function
  ("get_ea_address",var("ea",@{typ Zea}),
   cs(var("ea",@{typ Zea}),
      [(call("Zea.Zea_i",@{typ Zea},tp[var_a(@{typ Zsize}),var("i",@{typ "64 word"})],@{theory}),
        lw(0,64)),
       (call("Zea.Zea_r",@{typ Zea},tp[var_a(@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),lw(0,64)),
       (call("Zea.Zea_m",@{typ Zea},tp[var_a(@{typ Zsize}),var("a",@{typ "64 word"})],@{theory}),
        var("a",@{typ "64 word"}))],@{context}))

val () = function
  ("jump_to_ea",var("ea",@{typ Zea}),
   close
     (var("state",@{typ X64_state}),
      tp[lu,
         rupd
           ("X64_state.RIP",
            tp[var("state",@{typ X64_state}),
               mop(Fst,
                   apply
                     (call
                        ("call_dest_from_ea",
                         @{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                         var("ea",@{typ Zea}),@{theory}),var("state",@{typ X64_state})))],@{theory})]))

val () = function
  ("ByteParity",var("b",@{typ "8 word"}),
   eq(bop(Mod,
          bop(Add,
              bop(Add,
                  bop(Add,
                      bop(Add,
                          bop(Add,
                              bop(Add,
                                  bop(Add,
                                      mop(Cast(@{typ nat}),bop(Bit,var("b",@{typ "8 word"}),ln 7)),
                                      mop(Cast(@{typ nat}),bop(Bit,var("b",@{typ "8 word"}),ln 6))),
                                  mop(Cast(@{typ nat}),bop(Bit,var("b",@{typ "8 word"}),ln 5))),
                              mop(Cast(@{typ nat}),bop(Bit,var("b",@{typ "8 word"}),ln 4))),
                          mop(Cast(@{typ nat}),bop(Bit,var("b",@{typ "8 word"}),ln 3))),
                      mop(Cast(@{typ nat}),bop(Bit,var("b",@{typ "8 word"}),ln 2))),
                  mop(Cast(@{typ nat}),bop(Bit,var("b",@{typ "8 word"}),ln 1))),
              mop(Cast(@{typ nat}),bop(Bit,var("b",@{typ "8 word"}),ln 0))),ln 2),ln 0))

val () = function
  ("Zsize_width",var("size",@{typ Zsize}),
   cs(var("size",@{typ Zsize}),
      [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),ln 8),
       (Term.Const(@{const_name "Z16"},@{typ Zsize}),ln 16),
       (Term.Const(@{const_name "Z32"},@{typ Zsize}),ln 32),
       (Term.Const(@{const_name "Z64"},@{typ Zsize}),ln 64)],@{context}))

val () = function
  ("word_size_msb",tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],
   bop(Bit,var("w",@{typ "64 word"}),
       bop(Sub,call("Zsize_width",@{typ nat},var("size",@{typ Zsize}),@{theory}),ln 1)))

val () = function
  ("write_PF",var("w",@{typ "64 word"}),
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'PF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            call
              ("ByteParity",@{typ bool},ex(var("w",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
               @{theory}),@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("write_SF",var("s_w",@{typ "Zsize \<times> 64 word"}),
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'SF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            call("word_size_msb",@{typ bool},var("s_w",@{typ "Zsize \<times> 64 word"}),@{theory}),
            @{theory}),var("state",@{typ X64_state}))))

val () = function
  ("write_ZF",tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'ZF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            cs(var("size",@{typ Zsize}),
               [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
                 eq(mop(Cast(@{typ "8 word"}),var("w",@{typ "64 word"})),lw(0,8))),
                (Term.Const(@{const_name "Z16"},@{typ Zsize}),
                 eq(mop(Cast(@{typ "16 word"}),var("w",@{typ "64 word"})),lw(0,16))),
                (Term.Const(@{const_name "Z32"},@{typ Zsize}),
                 eq(mop(Cast(@{typ "32 word"}),var("w",@{typ "64 word"})),lw(0,32))),
                (Term.Const(@{const_name "Z64"},@{typ Zsize}),eq(var("w",@{typ "64 word"}),lw(0,64)))],
               @{context}),@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("write_logical_eflags",tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("FlagUnspecified",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            lc("Z_AF","Zeflags",@{theory}),@{theory}),
         mop(Snd,
             apply
               (call
                  ("write_ZF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],@{theory}),
                mop(Snd,
                    apply
                      (call
                         ("write_SF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                          tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],@{theory}),
                       mop(Snd,
                           apply
                             (call
                                ("write_PF",
                                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                 var("w",@{typ "64 word"}),@{theory}),
                              mop(Snd,
                                  apply
                                    (call
                                       ("write'OF",
                                        @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                        lf,@{theory}),
                                     mop(Snd,
                                         apply
                                           (call
                                              ("write'CF",
                                               @{typ
                                               "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                               lf,@{theory}),var("state",@{typ X64_state}))))))))))))))

val () = function
  ("write_arith_eflags_except_CF_OF",tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("FlagUnspecified",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            lc("Z_AF","Zeflags",@{theory}),@{theory}),
         mop(Snd,
             apply
               (call
                  ("write_ZF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],@{theory}),
                mop(Snd,
                    apply
                      (call
                         ("write_SF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                          tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],@{theory}),
                       mop(Snd,
                           apply
                             (call
                                ("write_PF",
                                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                 var("w",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state}))))))))))

val () = function
  ("write_arith_eflags",
   tp[var("size",@{typ Zsize}),var("r",@{typ "64 word \<times> bool \<times> bool"})],
   close
     (var("state",@{typ X64_state}),
      let'
        (tp[var("w",@{typ "64 word"}),var_b"c",var_b"x"],
         var("r",@{typ "64 word \<times> bool \<times> bool"}),
         apply
           (call
              ("write_arith_eflags_except_CF_OF",
               @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
               tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],@{theory}),
            mop(Snd,
                apply
                  (call
                     ("write'OF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                      var_b"x",@{theory}),
                   mop(Snd,
                       apply
                         (call
                            ("write'CF",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                             var_b"c",@{theory}),var("state",@{typ X64_state})))))))))

val () = function
  ("erase_eflags",var("state",@{typ X64_state}),
   tp[lu,
      rupd
        ("X64_state.EFLAGS",
         tp[var("state",@{typ X64_state}),mop(K1(@{typ Zeflags}),lo(@{typ bool}))],@{theory})])

val () = function
  ("value_width",var("s",@{typ Zsize}),
   bop(Exp,ln 2,call("Zsize_width",@{typ nat},var("s",@{typ Zsize}),@{theory})))

val () = function
  ("word_signed_overflow_add",
   tp[var("size",@{typ Zsize}),var("a",@{typ "64 word"}),var("b",@{typ "64 word"})],
   bop(And,
       eq(call
            ("word_size_msb",@{typ bool},tp[var("size",@{typ Zsize}),var("a",@{typ "64 word"})],
             @{theory}),
          call
            ("word_size_msb",@{typ bool},tp[var("size",@{typ Zsize}),var("b",@{typ "64 word"})],
             @{theory})),
       mop(Not,
           eq(call
                ("word_size_msb",@{typ bool},
                 tp[var("size",@{typ Zsize}),
                    bop(Add,var("a",@{typ "64 word"}),var("b",@{typ "64 word"}))],@{theory}),
              call
                ("word_size_msb",@{typ bool},tp[var("size",@{typ Zsize}),var("a",@{typ "64 word"})],
                 @{theory})))))

val () = function
  ("word_signed_overflow_sub",
   tp[var("size",@{typ Zsize}),var("a",@{typ "64 word"}),var("b",@{typ "64 word"})],
   bop(And,
       mop(Not,
           eq(call
                ("word_size_msb",@{typ bool},tp[var("size",@{typ Zsize}),var("a",@{typ "64 word"})],
                 @{theory}),
              call
                ("word_size_msb",@{typ bool},tp[var("size",@{typ Zsize}),var("b",@{typ "64 word"})],
                 @{theory}))),
       mop(Not,
           eq(call
                ("word_size_msb",@{typ bool},
                 tp[var("size",@{typ Zsize}),
                    bop(Sub,var("a",@{typ "64 word"}),var("b",@{typ "64 word"}))],@{theory}),
              call
                ("word_size_msb",@{typ bool},tp[var("size",@{typ Zsize}),var("a",@{typ "64 word"})],
                 @{theory})))))

val () = function
  ("add_with_carry_out",
   tp[var("size",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
   tp[bop(Add,var("x",@{typ "64 word"}),var("y",@{typ "64 word"})),
      bop(Le,call("value_width",@{typ nat},var("size",@{typ Zsize}),@{theory}),
          bop(Add,mop(Cast(@{typ nat}),var("x",@{typ "64 word"})),
              mop(Cast(@{typ nat}),var("y",@{typ "64 word"})))),
      call
        ("word_signed_overflow_add",@{typ bool},
         tp[var("size",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],@{theory})])

val () = function
  ("sub_with_borrow",
   tp[var("size",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
   tp[bop(Sub,var("x",@{typ "64 word"}),var("y",@{typ "64 word"})),
      bop(Ult,var("x",@{typ "64 word"}),var("y",@{typ "64 word"})),
      call
        ("word_signed_overflow_sub",@{typ bool},
         tp[var("size",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],@{theory})])

val () = function
  ("write_arith_result",
   tp[var("size",@{typ Zsize}),var("r",@{typ "64 word \<times> bool \<times> bool"}),
      var("ea",@{typ Zea})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[mop(Fst,var("r",@{typ "64 word \<times> bool \<times> bool"})),var("ea",@{typ Zea})],
            @{theory}),
         mop(Snd,
             apply
               (call
                  ("write_arith_eflags",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[var("size",@{typ Zsize}),var("r",@{typ "64 word \<times> bool \<times> bool"})],
                   @{theory}),var("state",@{typ X64_state}))))))

val () = function
  ("write_arith_result_no_CF_OF",
   tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"}),var("ea",@{typ Zea})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var("w",@{typ "64 word"}),var("ea",@{typ Zea})],@{theory}),
         mop(Snd,
             apply
               (call
                  ("write_arith_eflags_except_CF_OF",
                   @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],@{theory}),
                var("state",@{typ X64_state}))))))

val () = function
  ("write_logical_result",
   tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"}),var("ea",@{typ Zea})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var("w",@{typ "64 word"}),var("ea",@{typ Zea})],@{theory}),
         mop(Snd,
             apply
               (call
                  ("write_logical_eflags",
                   @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],@{theory}),
                var("state",@{typ X64_state}))))))

val () = function
  ("write_result_erase_eflags",tp[var("w",@{typ "64 word"}),var("ea",@{typ Zea})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[var("w",@{typ "64 word"}),var("ea",@{typ Zea})],@{theory}),
         mop(Snd,
             apply
               (const
                  ("erase_eflags",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   @{theory}),var("state",@{typ X64_state}))))))

val () = function
  ("SignExtension",
   tp[var("w",@{typ "64 word"}),var("size1",@{typ Zsize}),var("size2",@{typ Zsize})],
   close
     (var("state",@{typ X64_state}),
      let'
        (tp[var("r",@{typ "64 word"}),var("s1",@{typ "64 word \<times> X64_state"})],
         let'
           (var("s",@{typ "64 word \<times> X64_state"}),
            cs(tp[var("size1",@{typ Zsize}),var("size2",@{typ Zsize})],
               [(tp[call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
                    Term.Const(@{const_name "Z16"},@{typ Zsize})],
                 tp[bfi(ln 15,ln 0,
                        mop(SE(@{typ "16 word"}),
                            ex(var("w",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"})),
                        var("w",@{typ "64 word"})),var("state",@{typ X64_state})]),
                (tp[call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
                    Term.Const(@{const_name "Z32"},@{typ Zsize})],
                 tp[bfi(ln 31,ln 0,
                        mop(SE(@{typ "32 word"}),
                            ex(var("w",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"})),
                        var("w",@{typ "64 word"})),var("state",@{typ X64_state})]),
                (tp[call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
                    Term.Const(@{const_name "Z64"},@{typ Zsize})],
                 tp[mop(SE(@{typ "64 word"}),ex(var("w",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"})),
                    var("state",@{typ X64_state})]),
                (tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),
                    Term.Const(@{const_name "Z32"},@{typ Zsize})],
                 tp[bfi(ln 31,ln 0,
                        mop(SE(@{typ "32 word"}),
                            ex(var("w",@{typ "64 word"}),ln 15,ln 0,@{typ "16 word"})),
                        var("w",@{typ "64 word"})),var("state",@{typ X64_state})]),
                (tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),
                    Term.Const(@{const_name "Z64"},@{typ Zsize})],
                 tp[mop(SE(@{typ "64 word"}),
                        ex(var("w",@{typ "64 word"}),ln 15,ln 0,@{typ "16 word"})),
                    var("state",@{typ X64_state})]),
                (tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),
                    Term.Const(@{const_name "Z64"},@{typ Zsize})],
                 tp[mop(SE(@{typ "64 word"}),
                        ex(var("w",@{typ "64 word"}),ln 31,ln 0,@{typ "32 word"})),
                    var("state",@{typ X64_state})]),
                (var_a(@{typ "Zsize \<times> Zsize"}),
                 tp[var("w",@{typ "64 word"}),
                    mop(Snd,
                        apply
                          (call
                             ("raise'exception",
                              @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                              call("exception.FAILURE",@{typ exception},ls"SignExtension",@{theory}),
                              @{theory}),var("state",@{typ X64_state})))])],@{context}),
            tp[mop(Fst,var("s",@{typ "64 word \<times> X64_state"})),
               var("s",@{typ "64 word \<times> X64_state"})]),
         tp[var("r",@{typ "64 word"}),mop(Snd,var("s1",@{typ "64 word \<times> X64_state"}))])))

val () = function
  ("maskShift",tp[var("size",@{typ Zsize}),var("w",@{typ "64 word"})],
   ite(eq(var("size",@{typ Zsize}),Term.Const(@{const_name "Z64"},@{typ Zsize})),
       mop(Cast(@{typ nat}),ex(var("w",@{typ "64 word"}),ln 5,ln 0,@{typ "6 word"})),
       mop(Cast(@{typ nat}),ex(var("w",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))

val () = function
  ("ROL",tp[var("size",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
   cs(var("size",@{typ Zsize}),
      [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
        mop(Cast(@{typ "64 word"}),
            bop(Rol,ex(var("x",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z16"},@{typ Zsize}),
        mop(Cast(@{typ "64 word"}),
            bop(Rol,ex(var("x",@{typ "64 word"}),ln 15,ln 0,@{typ "16 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z32"},@{typ Zsize}),
        mop(Cast(@{typ "64 word"}),
            bop(Rol,ex(var("x",@{typ "64 word"}),ln 31,ln 0,@{typ "32 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z64"},@{typ Zsize}),
        bop(Rol,var("x",@{typ "64 word"}),
            mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 5,ln 0,@{typ "6 word"}))))],
      @{context}))

val () = function
  ("ROR",tp[var("size",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
   cs(var("size",@{typ Zsize}),
      [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
        mop(Cast(@{typ "64 word"}),
            bop(Ror,ex(var("x",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z16"},@{typ Zsize}),
        mop(Cast(@{typ "64 word"}),
            bop(Ror,ex(var("x",@{typ "64 word"}),ln 15,ln 0,@{typ "16 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z32"},@{typ Zsize}),
        mop(Cast(@{typ "64 word"}),
            bop(Ror,ex(var("x",@{typ "64 word"}),ln 31,ln 0,@{typ "32 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z64"},@{typ Zsize}),
        bop(Ror,var("x",@{typ "64 word"}),
            mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 5,ln 0,@{typ "6 word"}))))],
      @{context}))

val () = function
  ("SAR",tp[var("size",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
   cs(var("size",@{typ Zsize}),
      [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
        mop(Cast(@{typ "64 word"}),
            bop(Asr,ex(var("x",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z16"},@{typ Zsize}),
        mop(Cast(@{typ "64 word"}),
            bop(Asr,ex(var("x",@{typ "64 word"}),ln 15,ln 0,@{typ "16 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z32"},@{typ Zsize}),
        mop(Cast(@{typ "64 word"}),
            bop(Asr,ex(var("x",@{typ "64 word"}),ln 31,ln 0,@{typ "32 word"}),
                mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 4,ln 0,@{typ "5 word"}))))),
       (Term.Const(@{const_name "Z64"},@{typ Zsize}),
        bop(Asr,var("x",@{typ "64 word"}),
            mop(Cast(@{typ nat}),ex(var("y",@{typ "64 word"}),ln 5,ln 0,@{typ "6 word"}))))],
      @{context}))

val () = function
  ("write_binop",
   tp[var("s",@{typ Zsize}),var("bop",@{typ Zbinop_name}),var("x",@{typ "64 word"}),
      var("y",@{typ "64 word"}),var("ea",@{typ Zea})],
   close
     (var("state",@{typ X64_state}),
      cs(var("bop",@{typ Zbinop_name}),
         [(lc("Zadd","Zbinop_name",@{theory}),
           apply
             (call
                ("write_arith_result",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),
                    call
                      ("add_with_carry_out",@{typ "64 word \<times> bool \<times> bool"},
                       tp[var("s",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
                       @{theory}),var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zsub","Zbinop_name",@{theory}),
           apply
             (call
                ("write_arith_result",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),
                    call
                      ("sub_with_borrow",@{typ "64 word \<times> bool \<times> bool"},
                       tp[var("s",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
                       @{theory}),var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zcmp","Zbinop_name",@{theory}),
           apply
             (call
                ("write_arith_eflags",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),
                    call
                      ("sub_with_borrow",@{typ "64 word \<times> bool \<times> bool"},
                       tp[var("s",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
                       @{theory})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Ztest","Zbinop_name",@{theory}),
           apply
             (call
                ("write_logical_eflags",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),
                    bop(BAnd,var("x",@{typ "64 word"}),var("y",@{typ "64 word"}))],@{theory}),
              var("state",@{typ X64_state}))),
          (lc("Zand","Zbinop_name",@{theory}),
           apply
             (call
                ("write_logical_result",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),
                    bop(BAnd,var("x",@{typ "64 word"}),var("y",@{typ "64 word"})),
                    var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zxor","Zbinop_name",@{theory}),
           apply
             (call
                ("write_logical_result",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),
                    bop(BXor,var("x",@{typ "64 word"}),var("y",@{typ "64 word"})),
                    var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zor","Zbinop_name",@{theory}),
           apply
             (call
                ("write_logical_result",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),
                    bop(BOr,var("x",@{typ "64 word"}),var("y",@{typ "64 word"})),
                    var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zrol","Zbinop_name",@{theory}),
           apply
             (call
                ("write_result_erase_eflags",
                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[call
                      ("ROL",@{typ "64 word"},
                       tp[var("s",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
                       @{theory}),var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zror","Zbinop_name",@{theory}),
           apply
             (call
                ("write_result_erase_eflags",
                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[call
                      ("ROR",@{typ "64 word"},
                       tp[var("s",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
                       @{theory}),var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zsar","Zbinop_name",@{theory}),
           apply
             (call
                ("write_result_erase_eflags",
                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[call
                      ("SAR",@{typ "64 word"},
                       tp[var("s",@{typ Zsize}),var("x",@{typ "64 word"}),var("y",@{typ "64 word"})],
                       @{theory}),var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zshl","Zbinop_name",@{theory}),
           apply
             (call
                ("write_result_erase_eflags",
                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[bop(Lsl,var("x",@{typ "64 word"}),
                        call
                          ("maskShift",@{typ nat},
                           tp[var("s",@{typ Zsize}),var("y",@{typ "64 word"})],@{theory})),
                    var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zshr","Zbinop_name",@{theory}),
           apply
             (call
                ("write_result_erase_eflags",
                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[bop(Lsr,var("x",@{typ "64 word"}),
                        call
                          ("maskShift",@{typ nat},
                           tp[var("s",@{typ Zsize}),var("y",@{typ "64 word"})],@{theory})),
                    var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zadc","Zbinop_name",@{theory}),
           let'
             (tp[var_b"v",var("s0",@{typ X64_state})],
              apply
                (const("CF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),
              apply
                (call
                   ("write_arith_result_no_CF_OF",
                    @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                    tp[var("s",@{typ Zsize}),
                       bop(Add,bop(Add,var("x",@{typ "64 word"}),var("y",@{typ "64 word"})),
                           mop(Cast(@{typ "64 word"}),var_b"v")),var("ea",@{typ Zea})],@{theory}),
                 mop(Snd,
                     apply
                       (call
                          ("FlagUnspecified",
                           @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                           lc("Z_OF","Zeflags",@{theory}),@{theory}),
                        mop(Snd,
                            apply
                              (call
                                 ("write'CF",
                                  @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                  bop(Le,
                                      call("value_width",@{typ nat},var("s",@{typ Zsize}),@{theory}),
                                      bop(Add,
                                          bop(Add,mop(Cast(@{typ nat}),var("x",@{typ "64 word"})),
                                              mop(Cast(@{typ nat}),var("y",@{typ "64 word"}))),
                                          mop(Cast(@{typ nat}),var_b"v"))),@{theory}),
                               var("s0",@{typ X64_state})))))))),
          (lc("Zsbb","Zbinop_name",@{theory}),
           let'
             (tp[var_b"v",var("s0",@{typ X64_state})],
              apply
                (const("CF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),
              apply
                (call
                   ("write_arith_result_no_CF_OF",
                    @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                    tp[var("s",@{typ Zsize}),
                       bop(Sub,var("x",@{typ "64 word"}),
                           bop(Add,var("y",@{typ "64 word"}),mop(Cast(@{typ "64 word"}),var_b"v"))),
                       var("ea",@{typ Zea})],@{theory}),
                 mop(Snd,
                     apply
                       (call
                          ("FlagUnspecified",
                           @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                           lc("Z_OF","Zeflags",@{theory}),@{theory}),
                        mop(Snd,
                            apply
                              (call
                                 ("write'CF",
                                  @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                  bop(Lt,mop(Cast(@{typ nat}),var("x",@{typ "64 word"})),
                                      bop(Add,mop(Cast(@{typ nat}),var("y",@{typ "64 word"})),
                                          mop(Cast(@{typ nat}),var_b"v"))),@{theory}),
                               var("s0",@{typ X64_state})))))))),
          (var_a(@{typ Zbinop_name}),
           apply
             (call
                ("raise'exception",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 call
                   ("exception.FAILURE",@{typ exception},
                    cc[ls"Binary op not implemented: ",
                       mop(Cast(@{typ string}),var("bop",@{typ Zbinop_name}))],@{theory}),@{theory}),
              var("state",@{typ X64_state})))],@{context})))

val () = function
  ("write_monop",
   tp[var("s",@{typ Zsize}),var("mop",@{typ Zmonop_name}),var("x",@{typ "64 word"}),
      var("ea",@{typ Zea})],
   close
     (var("state",@{typ X64_state}),
      cs(var("mop",@{typ Zmonop_name}),
         [(lc("Znot","Zmonop_name",@{theory}),
           apply
             (call
                ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[mop(BNot,var("x",@{typ "64 word"})),var("ea",@{typ Zea})],@{theory}),
              var("state",@{typ X64_state}))),
          (lc("Zdec","Zmonop_name",@{theory}),
           apply
             (call
                ("write_arith_result_no_CF_OF",
                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),bop(Sub,var("x",@{typ "64 word"}),lw(1,64)),
                    var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zinc","Zmonop_name",@{theory}),
           apply
             (call
                ("write_arith_result_no_CF_OF",
                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 tp[var("s",@{typ Zsize}),bop(Add,var("x",@{typ "64 word"}),lw(1,64)),
                    var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
          (lc("Zneg","Zmonop_name",@{theory}),
           apply
             (call
                ("FlagUnspecified",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 lc("Z_CF","Zeflags",@{theory}),@{theory}),
              mop(Snd,
                  apply
                    (call
                       ("write_arith_result_no_CF_OF",
                        @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                        tp[var("s",@{typ Zsize}),mop(Neg,var("x",@{typ "64 word"})),
                           var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state})))))],
         @{context})))

val () = function
  ("read_cond",var("c",@{typ Zcond}),
   close
     (var("state",@{typ X64_state}),
      cs(var("c",@{typ Zcond}),
         [(lc("Z_O","Zcond",@{theory}),
           apply
             (const("OF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
              var("state",@{typ X64_state}))),
          (lc("Z_NO","Zcond",@{theory}),
           let'
             (tp[var_b"v",var("s",@{typ X64_state})],
              apply
                (const("OF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),tp[mop(Not,var_b"v"),var("s",@{typ X64_state})])),
          (lc("Z_B","Zcond",@{theory}),
           apply
             (const("CF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
              var("state",@{typ X64_state}))),
          (lc("Z_NB","Zcond",@{theory}),
           let'
             (tp[var_b"v",var("s",@{typ X64_state})],
              apply
                (const("CF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),tp[mop(Not,var_b"v"),var("s",@{typ X64_state})])),
          (lc("Z_E","Zcond",@{theory}),
           apply
             (const("ZF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
              var("state",@{typ X64_state}))),
          (lc("Z_NE","Zcond",@{theory}),
           let'
             (tp[var_b"v",var("s",@{typ X64_state})],
              apply
                (const("ZF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),tp[mop(Not,var_b"v"),var("s",@{typ X64_state})])),
          (lc("Z_A","Zcond",@{theory}),
           cs(tp[apply
                   (call
                      ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("state",@{typ X64_state}),@{theory}),lc("Z_CF","Zeflags",@{theory})),
                 apply
                   (call
                      ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("state",@{typ X64_state}),@{theory}),lc("Z_ZF","Zeflags",@{theory}))],
              [(tp[mop(Some,lf),mop(Some,lf)],tp[lt,var("state",@{typ X64_state})]),
               (tp[mop(Some,lt),var_a(@{typ "bool option"})],tp[lf,var("state",@{typ X64_state})]),
               (tp[var_a(@{typ "bool option"}),mop(Some,lt)],tp[lf,var("state",@{typ X64_state})]),
               (var_a(@{typ "(bool option) \<times> bool option"}),
                apply
                  (call
                     ("raise'exception",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
                      call
                        ("exception.BadFlagAccess",@{typ exception},
                         cc[ls"read_cond: ",mop(Cast(@{typ string}),var("c",@{typ Zcond}))],
                         @{theory}),@{theory}),var("state",@{typ X64_state})))],@{context})),
          (lc("Z_NA","Zcond",@{theory}),
           cs(tp[apply
                   (call
                      ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("state",@{typ X64_state}),@{theory}),lc("Z_CF","Zeflags",@{theory})),
                 apply
                   (call
                      ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("state",@{typ X64_state}),@{theory}),lc("Z_ZF","Zeflags",@{theory}))],
              [(tp[mop(Some,lt),var_a(@{typ "bool option"})],tp[lt,var("state",@{typ X64_state})]),
               (tp[var_a(@{typ "bool option"}),mop(Some,lt)],tp[lt,var("state",@{typ X64_state})]),
               (tp[mop(Some,lf),mop(Some,lf)],tp[lf,var("state",@{typ X64_state})]),
               (var_a(@{typ "(bool option) \<times> bool option"}),
                apply
                  (call
                     ("raise'exception",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
                      call
                        ("exception.BadFlagAccess",@{typ exception},
                         cc[ls"read_cond: ",mop(Cast(@{typ string}),var("c",@{typ Zcond}))],
                         @{theory}),@{theory}),var("state",@{typ X64_state})))],@{context})),
          (lc("Z_S","Zcond",@{theory}),
           apply
             (const("SF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
              var("state",@{typ X64_state}))),
          (lc("Z_NS","Zcond",@{theory}),
           let'
             (tp[var_b"v",var("s",@{typ X64_state})],
              apply
                (const("SF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),tp[mop(Not,var_b"v"),var("s",@{typ X64_state})])),
          (lc("Z_P","Zcond",@{theory}),
           apply
             (const("PF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
              var("state",@{typ X64_state}))),
          (lc("Z_NP","Zcond",@{theory}),
           let'
             (tp[var_b"v",var("s",@{typ X64_state})],
              apply
                (const("PF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),tp[mop(Not,var_b"v"),var("s",@{typ X64_state})])),
          (lc("Z_L","Zcond",@{theory}),
           let'
             (tp[var_b"v",var("s",@{typ X64_state})],
              apply
                (const("SF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),
              let'
                (tp[var_b"v",var("s",@{typ X64_state})],
                 let'
                   (tp[var_b"v0",var("s",@{typ X64_state})],
                    apply
                      (const
                         ("OF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                       var("s",@{typ X64_state})),
                    tp[eq(var_b"v",var_b"v0"),var("s",@{typ X64_state})]),
                 tp[mop(Not,var_b"v"),var("s",@{typ X64_state})]))),
          (lc("Z_NL","Zcond",@{theory}),
           let'
             (tp[var_b"v",var("s",@{typ X64_state})],
              apply
                (const("SF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                 var("state",@{typ X64_state})),
              let'
                (tp[var_b"v0",var("s",@{typ X64_state})],
                 apply
                   (const("OF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                    var("s",@{typ X64_state})),tp[eq(var_b"v",var_b"v0"),var("s",@{typ X64_state})]))),
          (lc("Z_G","Zcond",@{theory}),
           cs(tp[apply
                   (call
                      ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("state",@{typ X64_state}),@{theory}),lc("Z_SF","Zeflags",@{theory})),
                 apply
                   (call
                      ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("state",@{typ X64_state}),@{theory}),lc("Z_OF","Zeflags",@{theory}))],
              [(tp[mop(Some,var_b"a"),mop(Some,var_b"b")],
                let'
                  (tp[var_b"v",var("s",@{typ X64_state})],
                   apply
                     (const
                        ("ZF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                      var("state",@{typ X64_state})),
                   tp[bop(And,eq(var_b"a",var_b"b"),mop(Not,var_b"v")),var("s",@{typ X64_state})])),
               (var_a(@{typ "(bool option) \<times> bool option"}),
                cs(apply
                     (call
                        ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                         var("state",@{typ X64_state}),@{theory}),lc("Z_ZF","Zeflags",@{theory})),
                   [(mop(Some,lt),tp[lf,var("state",@{typ X64_state})]),
                    (var_a(@{typ "bool option"}),
                     apply
                       (call
                          ("raise'exception",
                           @{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
                           call
                             ("exception.BadFlagAccess",@{typ exception},
                              cc[ls"read_cond: ",mop(Cast(@{typ string}),var("c",@{typ Zcond}))],
                              @{theory}),@{theory}),var("state",@{typ X64_state})))],@{context}))],
              @{context})),
          (lc("Z_NG","Zcond",@{theory}),
           cs(tp[apply
                   (call
                      ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("state",@{typ X64_state}),@{theory}),lc("Z_SF","Zeflags",@{theory})),
                 apply
                   (call
                      ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("state",@{typ X64_state}),@{theory}),lc("Z_OF","Zeflags",@{theory}))],
              [(tp[mop(Some,var_b"a"),mop(Some,var_b"b")],
                let'
                  (tp[var_b"v",var("s",@{typ X64_state})],
                   apply
                     (const
                        ("ZF",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},@{theory}),
                      var("state",@{typ X64_state})),
                   tp[bop(Or,mop(Not,eq(var_b"a",var_b"b")),var_b"v"),var("s",@{typ X64_state})])),
               (var_a(@{typ "(bool option) \<times> bool option"}),
                cs(apply
                     (call
                        ("X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                         var("state",@{typ X64_state}),@{theory}),lc("Z_ZF","Zeflags",@{theory})),
                   [(mop(Some,lt),tp[lt,var("state",@{typ X64_state})]),
                    (var_a(@{typ "bool option"}),
                     apply
                       (call
                          ("raise'exception",
                           @{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
                           call
                             ("exception.BadFlagAccess",@{typ exception},
                              cc[ls"read_cond: ",mop(Cast(@{typ string}),var("c",@{typ Zcond}))],
                              @{theory}),@{theory}),var("state",@{typ X64_state})))],@{context}))],
              @{context})),(lc("Z_ALWAYS","Zcond",@{theory}),tp[lt,var("state",@{typ X64_state})])],
         @{context})))

val () = function
  ("x64_pop_aux",var("state",@{typ X64_state}),
   let'
     (var("v",@{typ "64 word"}),
      apply
        (call
           ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("state",@{typ X64_state}),
            @{theory}),lc("RSP","Zreg",@{theory})),
      tp[mop(Fst,
             apply
               (call
                  ("mem64",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                   var("v",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state}))),
         rupd
           ("X64_state.REG",
            tp[var("state",@{typ X64_state}),
               fupd
                 (call
                    ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                     var("state",@{typ X64_state}),@{theory}),lc("RSP","Zreg",@{theory}),
                  bop(Add,var("v",@{typ "64 word"}),lw(8,64)))],@{theory})]))

val () = function
  ("x64_pop",var("rm",@{typ Zrm}),
   close
     (var("state",@{typ X64_state}),
      let'
        (tp[var("v0",@{typ "64 word"}),var("s",@{typ X64_state})],
         apply
           (const
              ("x64_pop_aux",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},@{theory}),
            var("state",@{typ X64_state})),
         apply
           (call
              ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
               tp[var("v0",@{typ "64 word"}),
                  mop(Fst,
                      apply
                        (call
                           ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                            tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("rm",@{typ Zrm})],
                            @{theory}),var("state",@{typ X64_state})))],@{theory}),
            var("s",@{typ X64_state})))))

val () = function
  ("x64_pop_rip",var("state",@{typ X64_state}),
   let'
     (tp[var("v",@{typ "64 word"}),var("s",@{typ X64_state})],
      apply
        (const
           ("x64_pop_aux",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},@{theory}),
         var("state",@{typ X64_state})),
      tp[lu,rupd("X64_state.RIP",tp[var("s",@{typ X64_state}),var("v",@{typ "64 word"})],@{theory})]))

val () = function
  ("x64_push_aux",var("w",@{typ "64 word"}),
   close
     (var("state",@{typ X64_state}),
      let'
        (var("v",@{typ "64 word"}),
         bop(Sub,
             apply
               (call
                  ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                   var("state",@{typ X64_state}),@{theory}),lc("RSP","Zreg",@{theory})),lw(8,64)),
         apply
           (call
              ("write'mem64",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
               tp[var("w",@{typ "64 word"}),var("v",@{typ "64 word"})],@{theory}),
            rupd
              ("X64_state.REG",
               tp[var("state",@{typ X64_state}),
                  fupd
                    (call
                       ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                        var("state",@{typ X64_state}),@{theory}),lc("RSP","Zreg",@{theory}),
                     var("v",@{typ "64 word"}))],@{theory})))))

val () = function
  ("x64_push",var("imm_rm",@{typ Zimm_rm}),
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("x64_push_aux",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            mop(Fst,
                apply
                  (call
                     ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                      mop(Fst,
                          apply
                            (call
                               ("ea_Zimm_rm",
                                @{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),
                                   var("imm_rm",@{typ Zimm_rm})],@{theory}),
                             var("state",@{typ X64_state}))),@{theory}),
                   var("state",@{typ X64_state}))),@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("x64_push_rip",var("state",@{typ X64_state}),
   apply
     (call
        ("x64_push_aux",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
         call("X64_state.RIP",@{typ "64 word"},var("state",@{typ X64_state}),@{theory}),@{theory}),
      var("state",@{typ X64_state})))

val () = function
  ("x64_drop",var("imm",@{typ "64 word"}),
   close
     (var("state",@{typ X64_state}),
      let'
        (var("s",@{typ X64_state}),
         ite(mop(Not,eq(ex(var("imm",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),lw(0,8))),
             mop(Snd,
                 apply
                   (call
                      ("raise'exception",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                       call("exception.FAILURE",@{typ exception},ls"x64_drop",@{theory}),@{theory}),
                    var("state",@{typ X64_state}))),var("state",@{typ X64_state})),
         tp[lu,
            rupd
              ("X64_state.REG",
               tp[var("s",@{typ X64_state}),
                  fupd
                    (call
                       ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                        var("s",@{typ X64_state}),@{theory}),lc("RSP","Zreg",@{theory}),
                     bop(Add,
                         apply
                           (call
                              ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                               var("s",@{typ X64_state}),@{theory}),lc("RSP","Zreg",@{theory})),
                         var("imm",@{typ "64 word"})))],@{theory})])))

val () = function
  ("dfn'Zbinop",
   tp[var("bop",@{typ Zbinop_name}),var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],
   close
     (var("state",@{typ X64_state}),
      let'
        (tp[var("ea",@{typ Zea}),var("val_dst",@{typ "64 word"}),var("val_src",@{typ "64 word"})],
         mop(Fst,
             apply
               (call
                  ("read_dest_src_ea",
                   @{typ
                   "X64_state \<Rightarrow>
                    ((Zea \<times> 64 word \<times> 64 word) \<times> X64_state)"},
                   tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
                var("state",@{typ X64_state}))),
         apply
           (call
              ("write_binop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
               tp[var("size",@{typ Zsize}),var("bop",@{typ Zbinop_name}),
                  var("val_dst",@{typ "64 word"}),var("val_src",@{typ "64 word"}),
                  var("ea",@{typ Zea})],@{theory}),var("state",@{typ X64_state})))))

val () = function
  ("dfn'Zcall",var("imm_rm",@{typ Zimm_rm}),
   close
     (var("state",@{typ X64_state}),
      let'
        (var("s",@{typ X64_state}),
         mop(Snd,
             apply
               (const
                  ("x64_push_rip",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   @{theory}),var("state",@{typ X64_state}))),
         apply
           (call
              ("jump_to_ea",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
               mop(Fst,
                   apply
                     (call
                        ("ea_Zimm_rm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                         tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),
                            var("imm_rm",@{typ Zimm_rm})],@{theory}),var("s",@{typ X64_state}))),
               @{theory}),var("s",@{typ X64_state})))))

val () = function
  ("dfn'Zcmpxchg",tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
   close
     (var("state",@{typ X64_state}),
      let'
        (var("ea_src",@{typ Zea}),
         call("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
         let'
           (var("v",@{typ Zea}),
            mop(Fst,
                apply
                  (call
                     ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                      tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                   var("state",@{typ X64_state}))),
            let'
              (var("v0",@{typ "64 word"}),
               mop(Fst,
                   apply
                     (call
                        ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                         var("v",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
               let'
                 (var("v1",@{typ "64 word"}),
                  mop(Fst,
                      apply
                        (call
                           ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                            var("ea_src",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
                  let'
                    (var("s",@{typ X64_state}),
                     mop(Snd,
                         apply
                           (call
                              ("write_binop",
                               @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                               tp[var("size",@{typ Zsize}),lc("Zcmp","Zbinop_name",@{theory}),
                                  var("v1",@{typ "64 word"}),var("v0",@{typ "64 word"}),
                                  var("ea_src",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))),
                     ite(eq(var("v1",@{typ "64 word"}),var("v0",@{typ "64 word"})),
                         apply
                           (call
                              ("write'EA",
                               @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                               tp[mop(Fst,
                                      apply
                                        (call
                                           ("EA",
                                            @{typ
                                            "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                            var("ea_src",@{typ Zea}),@{theory}),
                                         var("s",@{typ X64_state}))),var("v",@{typ Zea})],@{theory}),
                            var("s",@{typ X64_state})),
                         apply
                           (call
                              ("write'EA",
                               @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                               tp[var("v0",@{typ "64 word"}),
                                  call
                                    ("Zea.Zea_r",@{typ Zea},
                                     tp[var("size",@{typ Zsize}),lc("RAX","Zreg",@{theory})],
                                     @{theory})],@{theory}),var("s",@{typ X64_state}))))))))))

val () = function
  ("dfn'Zdiv",tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
   close
     (var("state",@{typ X64_state}),
      let'
        (var_n"w",call("value_width",@{typ nat},var("size",@{typ Zsize}),@{theory}),
         let'
           (var("ea_eax",@{typ Zea}),
            call
              ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),lc("RAX","Zreg",@{theory})],
               @{theory}),
            let'
              (var("ea_edx",@{typ Zea}),
               call
                 ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),lc("RAX","Zreg",@{theory})],
                  @{theory}),
               let'
                 (var_n"v",
                  bop(Add,
                      bop(Mul,
                          mop(Cast(@{typ nat}),
                              mop(Fst,
                                  apply
                                    (call
                                       ("EA",
                                        @{typ
                                        "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                        var("ea_eax",@{typ Zea}),@{theory}),
                                     var("state",@{typ X64_state})))),var_n"w"),
                      mop(Cast(@{typ nat}),
                          mop(Fst,
                              apply
                                (call
                                   ("EA",
                                    @{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                    var("ea_edx",@{typ Zea}),@{theory}),
                                 var("state",@{typ X64_state}))))),
                  let'
                    (var_n"v0",
                     mop(Cast(@{typ nat}),
                         mop(Fst,
                             apply
                               (call
                                  ("EA",
                                   @{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                   mop(Fst,
                                       apply
                                         (call
                                            ("ea_Zrm",
                                             @{typ
                                             "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                             tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
                                             @{theory}),var("state",@{typ X64_state}))),@{theory}),
                                var("state",@{typ X64_state})))),
                     let'
                       (var_n"q",bop(Div,var_n"v",var_n"v0"),
                        apply
                          (const
                             ("erase_eflags",
                              @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},@{theory}),
                           mop(Snd,
                               apply
                                 (call
                                    ("write'EA",
                                     @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                     tp[mop(Cast(@{typ "64 word"}),bop(Mod,var_n"v",var_n"v0")),
                                        var("ea_edx",@{typ Zea})],@{theory}),
                                  mop(Snd,
                                      apply
                                        (call
                                           ("write'EA",
                                            @{typ
                                            "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                            tp[mop(Cast(@{typ "64 word"}),var_n"q"),
                                               var("ea_eax",@{typ Zea})],@{theory}),
                                         ite(bop(Or,eq(var_n"v0",ln 0),bop(Le,var_n"w",var_n"q")),
                                             mop(Snd,
                                                 apply
                                                   (call
                                                      ("raise'exception",
                                                       @{typ
                                                       "X64_state \<Rightarrow>
                                                        (unit \<times> X64_state)"},
                                                       call
                                                         ("exception.FAILURE",@{typ exception},
                                                          ls"division",@{theory}),@{theory}),
                                                    var("state",@{typ X64_state}))),
                                             var("state",@{typ X64_state})))))))))))))))

val () = function
  ("dfn'Zjcc",tp[var("cond",@{typ Zcond}),var("imm",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      let'
        (tp[var_b"v",var("s",@{typ X64_state})],
         apply
           (call
              ("read_cond",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
               var("cond",@{typ Zcond}),@{theory}),var("state",@{typ X64_state})),
         tp[lu,
            ite(var_b"v",
                rupd
                  ("X64_state.RIP",
                   tp[var("s",@{typ X64_state}),
                      bop(Add,
                          call("X64_state.RIP",@{typ "64 word"},var("s",@{typ X64_state}),@{theory}),
                          var("imm",@{typ "64 word"}))],@{theory}),var("s",@{typ X64_state}))])))

val () = function
  ("dfn'Zjmp",var("rm",@{typ Zrm}),
   close
     (var("state",@{typ X64_state}),
      tp[lu,
         rupd
           ("X64_state.RIP",
            tp[var("state",@{typ X64_state}),
               mop(Fst,
                   apply
                     (call
                        ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                         mop(Fst,
                             apply
                               (call
                                  ("ea_Zrm",
                                   @{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                   tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),
                                      var("rm",@{typ Zrm})],@{theory}),var("state",@{typ X64_state}))),
                         @{theory}),var("state",@{typ X64_state})))],@{theory})]))

val () = function
  ("dfn'Zlea",tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[call
                 ("get_ea_address",@{typ "64 word"},
                  mop(Fst,
                      apply
                        (call
                           ("ea_Zsrc",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                            tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
                         var("state",@{typ X64_state}))),@{theory}),
               mop(Fst,
                   apply
                     (call
                        ("ea_Zdest",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                         tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
                      var("state",@{typ X64_state})))],@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("dfn'Zleave",var("state",@{typ X64_state}),
   apply
     (call
        ("x64_pop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
         call("Zrm.Zr",@{typ Zrm},lc("RBP","Zreg",@{theory}),@{theory}),@{theory}),
      rupd
        ("X64_state.REG",
         tp[var("state",@{typ X64_state}),
            fupd
              (call
                 ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("state",@{typ X64_state}),
                  @{theory}),lc("RSP","Zreg",@{theory}),
               apply
                 (call
                    ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                     var("state",@{typ X64_state}),@{theory}),lc("RBP","Zreg",@{theory})))],
         @{theory})))

val () = function
  ("dfn'Zloop",tp[var("cond",@{typ Zcond}),var("imm",@{typ "64 word"})],
   close
     (var("state",@{typ X64_state}),
      let'
        (var("v",@{typ "64 word"}),
         bop(Sub,
             apply
               (call
                  ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                   var("state",@{typ X64_state}),@{theory}),lc("RCX","Zreg",@{theory})),lw(1,64)),
         let'
           (tp[var_b"v0",var("s",@{typ X64_state})],
            apply
              (call
                 ("read_cond",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
                  var("cond",@{typ Zcond}),@{theory}),
               rupd
                 ("X64_state.REG",
                  tp[var("state",@{typ X64_state}),
                     fupd
                       (call
                          ("X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                           var("state",@{typ X64_state}),@{theory}),lc("RCX","Zreg",@{theory}),
                        var("v",@{typ "64 word"}))],@{theory})),
            tp[lu,
               ite(bop(And,mop(Not,eq(var("v",@{typ "64 word"}),lw(0,64))),var_b"v0"),
                   rupd
                     ("X64_state.RIP",
                      tp[var("s",@{typ X64_state}),
                         bop(Add,
                             call
                               ("X64_state.RIP",@{typ "64 word"},var("s",@{typ X64_state}),@{theory}),
                             var("imm",@{typ "64 word"}))],@{theory}),var("s",@{typ X64_state}))]))))

val () = function
  ("dfn'Zmonop",tp[var("mop",@{typ Zmonop_name}),var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
   close
     (var("state",@{typ X64_state}),
      let'
        (var("v",@{typ Zea}),
         mop(Fst,
             apply
               (call
                  ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                   tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                var("state",@{typ X64_state}))),
         apply
           (call
              ("write_monop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
               tp[var("size",@{typ Zsize}),var("mop",@{typ Zmonop_name}),
                  mop(Fst,
                      apply
                        (call
                           ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                            var("v",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
                  var("v",@{typ Zea})],@{theory}),var("state",@{typ X64_state})))))

val () = function
  ("dfn'Zmov",tp[var("cond",@{typ Zcond}),var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],
   close
     (var("state",@{typ X64_state}),
      let'
        (tp[var_b"v",var("s",@{typ X64_state})],
         apply
           (call
              ("read_cond",@{typ "X64_state \<Rightarrow> (bool \<times> X64_state)"},
               var("cond",@{typ Zcond}),@{theory}),var("state",@{typ X64_state})),
         ite(var_b"v",
             apply
               (call
                  ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   tp[mop(Fst,
                          apply
                            (call
                               ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                mop(Fst,
                                    apply
                                      (call
                                         ("ea_Zsrc",
                                          @{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                          tp[var("size",@{typ Zsize}),
                                             var("dst_src",@{typ Zdest_src})],@{theory}),
                                       var("s",@{typ X64_state}))),@{theory}),
                             var("s",@{typ X64_state}))),
                      mop(Fst,
                          apply
                            (call
                               ("ea_Zdest",
                                @{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],
                                @{theory}),var("s",@{typ X64_state})))],@{theory}),
                var("s",@{typ X64_state})),tp[lu,var("s",@{typ X64_state})]))))

val () = function
  ("dfn'Zmovsx",
   tp[var("size1",@{typ Zsize}),var("dst_src",@{typ Zdest_src}),var("size2",@{typ Zsize})],
   close
     (var("state",@{typ X64_state}),
      let'
        (tp[var("v",@{typ "64 word \<times> Zea"}),var("s",@{typ X64_state})],
         let'
           (tp[var("v0",@{typ "64 word"}),var("s",@{typ X64_state})],
            apply
              (call
                 ("SignExtension",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                  tp[mop(Fst,
                         apply
                           (call
                              ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                               mop(Fst,
                                   apply
                                     (call
                                        ("ea_Zsrc",
                                         @{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                         tp[var("size1",@{typ Zsize}),
                                            var("dst_src",@{typ Zdest_src})],@{theory}),
                                      var("state",@{typ X64_state}))),@{theory}),
                            var("state",@{typ X64_state}))),var("size1",@{typ Zsize}),
                     var("size2",@{typ Zsize})],@{theory}),var("state",@{typ X64_state})),
            tp[tp[var("v0",@{typ "64 word"}),
                  mop(Fst,
                      apply
                        (call
                           ("ea_Zdest",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                            tp[var("size2",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
                         var("state",@{typ X64_state})))],var("s",@{typ X64_state})]),
         apply
           (call
              ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
               var("v",@{typ "64 word \<times> Zea"}),@{theory}),var("s",@{typ X64_state})))))

val () = function
  ("dfn'Zmovzx",
   tp[var("size1",@{typ Zsize}),var("dst_src",@{typ Zdest_src}),var("size2",@{typ Zsize})],
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            tp[mop(Fst,
                   apply
                     (call
                        ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                         mop(Fst,
                             apply
                               (call
                                  ("ea_Zsrc",
                                   @{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                   tp[var("size1",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],
                                   @{theory}),var("state",@{typ X64_state}))),@{theory}),
                      var("state",@{typ X64_state}))),
               mop(Fst,
                   apply
                     (call
                        ("ea_Zdest",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                         tp[var("size2",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
                      var("state",@{typ X64_state})))],@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("dfn'Zmul",tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
   close
     (var("state",@{typ X64_state}),
      let'
        (var("ea_eax",@{typ Zea}),
         call
           ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),lc("RAX","Zreg",@{theory})],@{theory}),
         let'
           (var("v",@{typ "64 word"}),
            mop(Fst,
                apply
                  (call
                     ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                      var("ea_eax",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
            let'
              (var("v0",@{typ "64 word"}),
               mop(Fst,
                   apply
                     (call
                        ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                         mop(Fst,
                             apply
                               (call
                                  ("ea_Zrm",
                                   @{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                                   tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                                var("state",@{typ X64_state}))),@{theory}),
                      var("state",@{typ X64_state}))),
               apply
                 (const
                    ("erase_eflags",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                     @{theory}),
                  cs(var("size",@{typ Zsize}),
                     [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
                       mop(Snd,
                           apply
                             (call
                                ("write'EA",
                                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                 tp[bop(Mul,var("v",@{typ "64 word"}),var("v0",@{typ "64 word"})),
                                    call
                                      ("Zea.Zea_r",@{typ Zea},
                                       tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),
                                          lc("RAX","Zreg",@{theory})],@{theory})],@{theory}),
                              var("state",@{typ X64_state})))),
                      (var_a(@{typ Zsize}),
                       mop(Snd,
                           apply
                             (call
                                ("write'EA",
                                 @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                 tp[mop(Cast(@{typ "64 word"}),
                                        bop(Div,
                                            bop(Mul,mop(Cast(@{typ nat}),var("v",@{typ "64 word"})),
                                                mop(Cast(@{typ nat}),var("v0",@{typ "64 word"}))),
                                            call
                                              ("value_width",@{typ nat},var("size",@{typ Zsize}),
                                               @{theory}))),
                                    call
                                      ("Zea.Zea_r",@{typ Zea},
                                       tp[var("size",@{typ Zsize}),lc("RDX","Zreg",@{theory})],
                                       @{theory})],@{theory}),
                              mop(Snd,
                                  apply
                                    (call
                                       ("write'EA",
                                        @{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                                        tp[bop(Mul,var("v",@{typ "64 word"}),
                                               var("v0",@{typ "64 word"})),var("ea_eax",@{typ Zea})],
                                        @{theory}),var("state",@{typ X64_state}))))))],@{context})))))))

val () = def ("dfn'Znop",lu)

val () = function
  ("dfn'Zpop",var("rm",@{typ Zrm}),
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("x64_pop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            var("rm",@{typ Zrm}),@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("dfn'Zpush",var("imm_rm",@{typ Zimm_rm}),
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("x64_push",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            var("imm_rm",@{typ Zimm_rm}),@{theory}),var("state",@{typ X64_state}))))

val () = function
  ("dfn'Zret",var("imm",@{typ "64 word"}),
   close
     (var("state",@{typ X64_state}),
      apply
        (call
           ("x64_drop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
            var("imm",@{typ "64 word"}),@{theory}),
         mop(Snd,
             apply
               (const
                  ("x64_pop_rip",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                   @{theory}),var("state",@{typ X64_state}))))))

val () = function
  ("dfn'Zxadd",tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
   close
     (var("state",@{typ X64_state}),
      let'
        (var("ea_src",@{typ Zea}),
         call("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
         let'
           (var("v",@{typ Zea}),
            mop(Fst,
                apply
                  (call
                     ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                      tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                   var("state",@{typ X64_state}))),
            let'
              (var("v0",@{typ "64 word"}),
               mop(Fst,
                   apply
                     (call
                        ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                         var("v",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
               apply
                 (call
                    ("write_binop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                     tp[var("size",@{typ Zsize}),lc("Zadd","Zbinop_name",@{theory}),
                        mop(Fst,
                            apply
                              (call
                                 ("EA",
                                  @{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                  var("ea_src",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
                        var("v0",@{typ "64 word"}),var("v",@{typ Zea})],@{theory}),
                  mop(Snd,
                      apply
                        (call
                           ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                            tp[var("v0",@{typ "64 word"}),var("ea_src",@{typ Zea})],@{theory}),
                         var("state",@{typ X64_state})))))))))

val () = function
  ("dfn'Zxchg",tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
   close
     (var("state",@{typ X64_state}),
      let'
        (var("ea_src",@{typ Zea}),
         call("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
         let'
           (var("v",@{typ Zea}),
            mop(Fst,
                apply
                  (call
                     ("ea_Zrm",@{typ "X64_state \<Rightarrow> (Zea \<times> X64_state)"},
                      tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                   var("state",@{typ X64_state}))),
            apply
              (call
                 ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                  tp[mop(Fst,
                         apply
                           (call
                              ("EA",@{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                               var("ea_src",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
                     var("v",@{typ Zea})],@{theory}),
               mop(Snd,
                   apply
                     (call
                        ("write'EA",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                         tp[mop(Fst,
                                apply
                                  (call
                                     ("EA",
                                      @{typ "X64_state \<Rightarrow> (64 word \<times> X64_state)"},
                                      var("v",@{typ Zea}),@{theory}),var("state",@{typ X64_state}))),
                            var("ea_src",@{typ Zea})],@{theory}),var("state",@{typ X64_state}))))))))

val () = function
  ("Run",var("v0",@{typ instruction}),
   close
     (var("state",@{typ X64_state}),
      cs(var("v0",@{typ instruction}),
         [(Term.Const(@{const_name "Zleave"},@{typ instruction}),
           apply
             (const
                ("dfn'Zleave",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},@{theory}),
              var("state",@{typ X64_state}))),
          (Term.Const(@{const_name "Znop"},@{typ instruction}),
           tp[const("dfn'Znop",@{typ unit},@{theory}),var("state",@{typ X64_state})]),
          (call
             ("instruction.Zbinop",@{typ instruction},
              var("v1",@{typ "Zbinop_name \<times> Zsize \<times> Zdest_src"}),@{theory}),
           apply
             (call
                ("dfn'Zbinop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v1",@{typ "Zbinop_name \<times> Zsize \<times> Zdest_src"}),@{theory}),
              var("state",@{typ X64_state}))),
          (call("instruction.Zcall",@{typ instruction},var("v2",@{typ Zimm_rm}),@{theory}),
           apply
             (call
                ("dfn'Zcall",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v2",@{typ Zimm_rm}),@{theory}),var("state",@{typ X64_state}))),
          (call
             ("instruction.Zcmpxchg",@{typ instruction},
              var("v3",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
           apply
             (call
                ("dfn'Zcmpxchg",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v3",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
              var("state",@{typ X64_state}))),
          (call
             ("instruction.Zdiv",@{typ instruction},var("v4",@{typ "Zsize \<times> Zrm"}),@{theory}),
           apply
             (call
                ("dfn'Zdiv",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v4",@{typ "Zsize \<times> Zrm"}),@{theory}),var("state",@{typ X64_state}))),
          (call
             ("instruction.Zjcc",@{typ instruction},var("v5",@{typ "Zcond \<times> 64 word"}),
              @{theory}),
           apply
             (call
                ("dfn'Zjcc",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v5",@{typ "Zcond \<times> 64 word"}),@{theory}),var("state",@{typ X64_state}))),
          (call("instruction.Zjmp",@{typ instruction},var("v6",@{typ Zrm}),@{theory}),
           apply
             (call
                ("dfn'Zjmp",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v6",@{typ Zrm}),@{theory}),var("state",@{typ X64_state}))),
          (call
             ("instruction.Zlea",@{typ instruction},var("v7",@{typ "Zsize \<times> Zdest_src"}),
              @{theory}),
           apply
             (call
                ("dfn'Zlea",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v7",@{typ "Zsize \<times> Zdest_src"}),@{theory}),
              var("state",@{typ X64_state}))),
          (call
             ("instruction.Zloop",@{typ instruction},var("v8",@{typ "Zcond \<times> 64 word"}),
              @{theory}),
           apply
             (call
                ("dfn'Zloop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v8",@{typ "Zcond \<times> 64 word"}),@{theory}),var("state",@{typ X64_state}))),
          (call
             ("instruction.Zmonop",@{typ instruction},
              var("v9",@{typ "Zmonop_name \<times> Zsize \<times> Zrm"}),@{theory}),
           apply
             (call
                ("dfn'Zmonop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v9",@{typ "Zmonop_name \<times> Zsize \<times> Zrm"}),@{theory}),
              var("state",@{typ X64_state}))),
          (call
             ("instruction.Zmov",@{typ instruction},
              var("v10",@{typ "Zcond \<times> Zsize \<times> Zdest_src"}),@{theory}),
           apply
             (call
                ("dfn'Zmov",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v10",@{typ "Zcond \<times> Zsize \<times> Zdest_src"}),@{theory}),
              var("state",@{typ X64_state}))),
          (call
             ("instruction.Zmovsx",@{typ instruction},
              var("v11",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory}),
           apply
             (call
                ("dfn'Zmovsx",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v11",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory}),
              var("state",@{typ X64_state}))),
          (call
             ("instruction.Zmovzx",@{typ instruction},
              var("v12",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory}),
           apply
             (call
                ("dfn'Zmovzx",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v12",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory}),
              var("state",@{typ X64_state}))),
          (call
             ("instruction.Zmul",@{typ instruction},var("v13",@{typ "Zsize \<times> Zrm"}),@{theory}),
           apply
             (call
                ("dfn'Zmul",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v13",@{typ "Zsize \<times> Zrm"}),@{theory}),var("state",@{typ X64_state}))),
          (call("instruction.Zpop",@{typ instruction},var("v14",@{typ Zrm}),@{theory}),
           apply
             (call
                ("dfn'Zpop",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v14",@{typ Zrm}),@{theory}),var("state",@{typ X64_state}))),
          (call("instruction.Zpush",@{typ instruction},var("v15",@{typ Zimm_rm}),@{theory}),
           apply
             (call
                ("dfn'Zpush",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v15",@{typ Zimm_rm}),@{theory}),var("state",@{typ X64_state}))),
          (call("instruction.Zret",@{typ instruction},var("v16",@{typ "64 word"}),@{theory}),
           apply
             (call
                ("dfn'Zret",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v16",@{typ "64 word"}),@{theory}),var("state",@{typ X64_state}))),
          (call
             ("instruction.Zxadd",@{typ instruction},
              var("v17",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
           apply
             (call
                ("dfn'Zxadd",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v17",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
              var("state",@{typ X64_state}))),
          (call
             ("instruction.Zxchg",@{typ instruction},
              var("v18",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
           apply
             (call
                ("dfn'Zxchg",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
                 var("v18",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
              var("state",@{typ X64_state})))],@{context})))

val () = function
  ("immediate8",var("strm",@{typ "8 word list"}),
   cs(var("strm",@{typ "8 word list"}),
      [(llc([var("b",@{typ "8 word"})],var("t",@{typ "8 word list"})),
        tp[mop(SE(@{typ "64 word"}),var("b",@{typ "8 word"})),var("t",@{typ "8 word list"})]),
       (var_a(@{typ "8 word list"}),lx(@{typ "64 word \<times> 8 word list"}))],@{context}))

val () = function
  ("immediate16",var("strm",@{typ "8 word list"}),
   cs(var("strm",@{typ "8 word list"}),
      [(llc([var("b1",@{typ "8 word"}),var("b2",@{typ "8 word"})],var("t",@{typ "8 word list"})),
        tp[mop(SE(@{typ "64 word"}),cc[var("b2",@{typ "8 word"}),var("b1",@{typ "8 word"})]),
           var("t",@{typ "8 word list"})]),
       (var_a(@{typ "8 word list"}),lx(@{typ "64 word \<times> 8 word list"}))],@{context}))

val () = function
  ("immediate32",var("strm",@{typ "8 word list"}),
   cs(var("strm",@{typ "8 word list"}),
      [(llc([var("b1",@{typ "8 word"}),var("b2",@{typ "8 word"}),var("b3",@{typ "8 word"}),
             var("b4",@{typ "8 word"})],var("t",@{typ "8 word list"})),
        tp[mop(SE(@{typ "64 word"}),
               cc[var("b4",@{typ "8 word"}),var("b3",@{typ "8 word"}),var("b2",@{typ "8 word"}),
                  var("b1",@{typ "8 word"})]),var("t",@{typ "8 word list"})]),
       (var_a(@{typ "8 word list"}),lx(@{typ "64 word \<times> 8 word list"}))],@{context}))

val () = function
  ("immediate64",var("strm",@{typ "8 word list"}),
   cs(var("strm",@{typ "8 word list"}),
      [(llc([var("b1",@{typ "8 word"}),var("b2",@{typ "8 word"}),var("b3",@{typ "8 word"}),
             var("b4",@{typ "8 word"}),var("b5",@{typ "8 word"}),var("b6",@{typ "8 word"}),
             var("b7",@{typ "8 word"}),var("b8",@{typ "8 word"})],var("t",@{typ "8 word list"})),
        tp[cc[var("b8",@{typ "8 word"}),var("b7",@{typ "8 word"}),var("b6",@{typ "8 word"}),
              var("b5",@{typ "8 word"}),var("b4",@{typ "8 word"}),var("b3",@{typ "8 word"}),
              var("b2",@{typ "8 word"}),var("b1",@{typ "8 word"})],var("t",@{typ "8 word list"})]),
       (var_a(@{typ "8 word list"}),lx(@{typ "64 word \<times> 8 word list"}))],@{context}))

val () = function
  ("immediate",tp[var("size",@{typ Zsize}),var("strm",@{typ "8 word list"})],
   cs(var("size",@{typ Zsize}),
      [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
        call
          ("immediate8",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
           @{theory})),
       (Term.Const(@{const_name "Z16"},@{typ Zsize}),
        call
          ("immediate16",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
           @{theory})),
       (var_a(@{typ Zsize}),
        call
          ("immediate32",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
           @{theory}))],@{context}))

val () = function
  ("full_immediate",tp[var("size",@{typ Zsize}),var("strm",@{typ "8 word list"})],
   ite(eq(var("size",@{typ Zsize}),Term.Const(@{const_name "Z64"},@{typ Zsize})),
       call
         ("immediate64",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
          @{theory}),
       call
         ("immediate",@{typ "64 word \<times> 8 word list"},
          tp[var("size",@{typ Zsize}),var("strm",@{typ "8 word list"})],@{theory})))

val () = function
  ("rec'REX",var("x",@{typ "4 word"}),
   record
     ("REX",
      [bop(Bit,var("x",@{typ "4 word"}),ln 0),bop(Bit,var("x",@{typ "4 word"}),ln 2),
       bop(Bit,var("x",@{typ "4 word"}),ln 3),bop(Bit,var("x",@{typ "4 word"}),ln 1)],@{theory}))

val () = function
  ("reg'REX",var("x",@{typ REX}),
   bop(Mdfy,
       close
         (tp[var_n"i",var_a(@{typ bool})],
          itb([(eq(var_n"i",ln 3),call("REX.W",@{typ bool},var("x",@{typ REX}),@{theory})),
               (eq(var_n"i",ln 2),call("REX.R",@{typ bool},var("x",@{typ REX}),@{theory})),
               (eq(var_n"i",ln 1),call("REX.X",@{typ bool},var("x",@{typ REX}),@{theory}))],
              call("REX.B",@{typ bool},var("x",@{typ REX}),@{theory}))),lw(0,4)))

val () = function
  ("write'rec'REX",tp[var_a(@{typ "4 word"}),var("x",@{typ REX})],
   call("reg'REX",@{typ "4 word"},var("x",@{typ REX}),@{theory}))

val () = function
  ("write'reg'REX",tp[var_a(@{typ REX}),var("x",@{typ "4 word"})],
   call("rec'REX",@{typ REX},var("x",@{typ "4 word"}),@{theory}))

val () = function
  ("RexReg",tp[var_b"b",var("r",@{typ "3 word"})],
   mop(Cast(@{typ Zreg}),cc[mop(Cast(@{typ "1 word"}),var_b"b"),var("r",@{typ "3 word"})]))

val () = function
  ("readDisplacement",tp[var("Mod",@{typ "2 word"}),var("strm",@{typ "8 word list"})],
   itb([(eq(var("Mod",@{typ "2 word"}),lw(1,2)),
         call
           ("immediate8",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
            @{theory})),
        (eq(var("Mod",@{typ "2 word"}),lw(2,2)),
         call
           ("immediate32",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
            @{theory}))],tp[lw(0,64),var("strm",@{typ "8 word list"})]))

val () = function
  ("readSibDisplacement",tp[var_b"w",var("Mod",@{typ "2 word"}),var("strm",@{typ "8 word list"})],
   itb([(bop(And,eq(var("Mod",@{typ "2 word"}),lw(0,2)),mop(Not,var_b"w")),
         tp[lw(0,64),var("strm",@{typ "8 word list"})]),
        (eq(var("Mod",@{typ "2 word"}),lw(1,2)),
         call
           ("immediate8",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
            @{theory}))],
       call
         ("immediate32",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
          @{theory})))

val () = function
  ("readSIB",tp[var("REX",@{typ REX}),var("Mod",@{typ "2 word"}),var("strm",@{typ "8 word list"})],
   cs(var("strm",@{typ "8 word list"}),
      [(llc([var("v#0",@{typ "8 word"})],var("v#1",@{typ "8 word list"})),
        cs(tp[call
                ("boolify'8",
                 @{typ
                 "bool \<times>
                  bool \<times>
                  bool \<times> bool \<times> bool \<times> bool \<times> bool \<times> bool"},
                 var("v#0",@{typ "8 word"}),@{theory}),var("v#1",@{typ "8 word list"})],
           [(tp[tp[var_b"SS'1",var_b"SS'0",var_b"Index'2",var_b"Index'1",var_b"Index'0",
                   var_b"Base'2",var_b"Base'1",var_b"Base'0"],var("strm1",@{typ "8 word list"})],
             let'
               (var("base",@{typ Zreg}),
                call
                  ("RexReg",@{typ Zreg},
                   tp[call("REX.B",@{typ bool},var("REX",@{typ REX}),@{theory}),
                      mop(Cast(@{typ "3 word"}),ll[var_b"Base'2",var_b"Base'1",var_b"Base'0"])],
                   @{theory}),
                let'
                  (var("index",@{typ Zreg}),
                   call
                     ("RexReg",@{typ Zreg},
                      tp[call("REX.X",@{typ bool},var("REX",@{typ REX}),@{theory}),
                         mop(Cast(@{typ "3 word"}),ll[var_b"Index'2",var_b"Index'1",var_b"Index'0"])],
                      @{theory}),
                   let'
                     (var("scaled_index",@{typ "(2 word \<times> Zreg) option"}),
                      ite(eq(var("index",@{typ Zreg}),lc("RSP","Zreg",@{theory})),
                          lo(@{typ "2 word \<times> Zreg"}),
                          mop(Some,
                              tp[mop(Cast(@{typ "2 word"}),ll[var_b"SS'1",var_b"SS'0"]),
                                 var("index",@{typ Zreg})])),
                      ite(eq(var("base",@{typ Zreg}),lc("RBP","Zreg",@{theory})),
                          let'
                            (tp[var("displacement",@{typ "64 word"}),
                                var("strm2",@{typ "8 word list"})],
                             call
                               ("readSibDisplacement",@{typ "64 word \<times> 8 word list"},
                                tp[call("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                   var("Mod",@{typ "2 word"}),var("strm1",@{typ "8 word list"})],
                                @{theory}),
                             tp[call
                                  ("Zrm.Zm",@{typ Zrm},
                                   tp[var("scaled_index",@{typ "(2 word \<times> Zreg) option"}),
                                      ite(eq(var("Mod",@{typ "2 word"}),lw(0,2)),
                                          Term.Const(@{const_name "ZnoBase"},@{typ Zbase}),
                                          call
                                            ("Zbase.ZregBase",@{typ Zbase},var("base",@{typ Zreg}),
                                             @{theory})),var("displacement",@{typ "64 word"})],
                                   @{theory}),var("strm2",@{typ "8 word list"})]),
                          let'
                            (tp[var("displacement",@{typ "64 word"}),
                                var("strm2",@{typ "8 word list"})],
                             call
                               ("readDisplacement",@{typ "64 word \<times> 8 word list"},
                                tp[var("Mod",@{typ "2 word"}),var("strm1",@{typ "8 word list"})],
                                @{theory}),
                             tp[call
                                  ("Zrm.Zm",@{typ Zrm},
                                   tp[var("scaled_index",@{typ "(2 word \<times> Zreg) option"}),
                                      call
                                        ("Zbase.ZregBase",@{typ Zbase},var("base",@{typ Zreg}),
                                         @{theory}),var("displacement",@{typ "64 word"})],@{theory}),
                                var("strm2",@{typ "8 word list"})]))))))],@{context})),
       (var_a(@{typ "8 word list"}),tp[lx(@{typ Zrm}),var("strm",@{typ "8 word list"})])],@{context}))

val () = function
  ("readModRM",tp[var("REX",@{typ REX}),var("strm",@{typ "8 word list"})],
   cs(var("strm",@{typ "8 word list"}),
      [(llc([var("v#0",@{typ "8 word"})],var("v#1",@{typ "8 word list"})),
        cs(tp[call
                ("boolify'8",
                 @{typ
                 "bool \<times>
                  bool \<times>
                  bool \<times> bool \<times> bool \<times> bool \<times> bool \<times> bool"},
                 var("v#0",@{typ "8 word"}),@{theory}),var("v#1",@{typ "8 word list"})],
           [(tp[tp[lf,lf,var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0",lt,lf,lt],
                var("strm1",@{typ "8 word list"})],
             let'
               (tp[var("displacement",@{typ "64 word"}),var("strm2",@{typ "8 word list"})],
                call
                  ("immediate32",@{typ "64 word \<times> 8 word list"},
                   var("strm1",@{typ "8 word list"}),@{theory}),
                tp[call
                     ("RexReg",@{typ Zreg},
                      tp[call("REX.R",@{typ bool},var("REX",@{typ REX}),@{theory}),
                         mop(Cast(@{typ "3 word"}),
                             ll[var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0"])],@{theory}),
                   call
                     ("Zrm.Zm",@{typ Zrm},
                      tp[lo(@{typ "2 word \<times> Zreg"}),
                         Term.Const(@{const_name "ZripBase"},@{typ Zbase}),
                         var("displacement",@{typ "64 word"})],@{theory}),
                   var("strm2",@{typ "8 word list"})])),
            (tp[tp[lt,lt,var_b"REG'2",var_b"REG'1",var_b"REG'0",var_b"RM'2",var_b"RM'1",var_b"RM'0"],
                var("strm1",@{typ "8 word list"})],
             tp[call
                  ("RexReg",@{typ Zreg},
                   tp[call("REX.R",@{typ bool},var("REX",@{typ REX}),@{theory}),
                      mop(Cast(@{typ "3 word"}),ll[var_b"REG'2",var_b"REG'1",var_b"REG'0"])],
                   @{theory}),
                call
                  ("Zrm.Zr",@{typ Zrm},
                   call
                     ("RexReg",@{typ Zreg},
                      tp[call("REX.B",@{typ bool},var("REX",@{typ REX}),@{theory}),
                         mop(Cast(@{typ "3 word"}),ll[var_b"RM'2",var_b"RM'1",var_b"RM'0"])],
                      @{theory}),@{theory}),var("strm1",@{typ "8 word list"})]),
            (tp[tp[var_b"Mod'1",var_b"Mod'0",var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0",lt,lf,
                   lf],var("strm1",@{typ "8 word list"})],
             let'
               (tp[var("sib",@{typ Zrm}),var("strm2",@{typ "8 word list"})],
                call
                  ("readSIB",@{typ "Zrm \<times> 8 word list"},
                   tp[var("REX",@{typ REX}),
                      mop(Cast(@{typ "2 word"}),ll[var_b"Mod'1",var_b"Mod'0"]),
                      var("strm1",@{typ "8 word list"})],@{theory}),
                tp[call
                     ("RexReg",@{typ Zreg},
                      tp[call("REX.R",@{typ bool},var("REX",@{typ REX}),@{theory}),
                         mop(Cast(@{typ "3 word"}),
                             ll[var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0"])],@{theory}),
                   var("sib",@{typ Zrm}),var("strm2",@{typ "8 word list"})])),
            (tp[tp[var_b"Mod'1",var_b"Mod'0",var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0",
                   var_b"RM'2",var_b"RM'1",var_b"RM'0"],var("strm1",@{typ "8 word list"})],
             let'
               (tp[var("displacement",@{typ "64 word"}),var("strm2",@{typ "8 word list"})],
                call
                  ("readDisplacement",@{typ "64 word \<times> 8 word list"},
                   tp[mop(Cast(@{typ "2 word"}),ll[var_b"Mod'1",var_b"Mod'0"]),
                      var("strm1",@{typ "8 word list"})],@{theory}),
                tp[call
                     ("RexReg",@{typ Zreg},
                      tp[call("REX.R",@{typ bool},var("REX",@{typ REX}),@{theory}),
                         mop(Cast(@{typ "3 word"}),
                             ll[var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0"])],@{theory}),
                   call
                     ("Zrm.Zm",@{typ Zrm},
                      tp[lo(@{typ "2 word \<times> Zreg"}),
                         call
                           ("Zbase.ZregBase",@{typ Zbase},
                            call
                              ("RexReg",@{typ Zreg},
                               tp[call("REX.B",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                  mop(Cast(@{typ "3 word"}),ll[var_b"RM'2",var_b"RM'1",var_b"RM'0"])],
                               @{theory}),@{theory}),var("displacement",@{typ "64 word"})],@{theory}),
                   var("strm2",@{typ "8 word list"})]))],@{context})),
       (var_a(@{typ "8 word list"}),
        tp[lx(@{typ Zreg}),lx(@{typ Zrm}),var("strm",@{typ "8 word list"})])],@{context}))

val () = function
  ("readOpcodeModRM",tp[var("REX",@{typ REX}),var("strm",@{typ "8 word list"})],
   let'
     (tp[var("opcode",@{typ Zreg}),var("rm",@{typ Zrm}),var("strm1",@{typ "8 word list"})],
      call
        ("readModRM",@{typ "Zreg \<times> Zrm \<times> 8 word list"},
         tp[var("REX",@{typ REX}),var("strm",@{typ "8 word list"})],@{theory}),
      tp[mop(Cast(@{typ "3 word"}),bop(Mod,mop(Cast(@{typ nat}),var("opcode",@{typ Zreg})),ln 8)),
         var("rm",@{typ Zrm}),var("strm1",@{typ "8 word list"})]))

val () = function
  ("prefixGroup",var("b",@{typ "8 word"}),
   cs(var("b",@{typ "8 word"}),
      [(var("v",@{typ "8 word"}),
        itb([(eq(var("v",@{typ "8 word"}),lw(240,8)),ln 1),
             (eq(var("v",@{typ "8 word"}),lw(242,8)),ln 1),
             (eq(var("v",@{typ "8 word"}),lw(243,8)),ln 1),
             (eq(var("v",@{typ "8 word"}),lw(38,8)),ln 2),
             (eq(var("v",@{typ "8 word"}),lw(46,8)),ln 2),
             (eq(var("v",@{typ "8 word"}),lw(54,8)),ln 2),
             (eq(var("v",@{typ "8 word"}),lw(62,8)),ln 2),
             (eq(var("v",@{typ "8 word"}),lw(100,8)),ln 2),
             (eq(var("v",@{typ "8 word"}),lw(101,8)),ln 2),
             (eq(var("v",@{typ "8 word"}),lw(102,8)),ln 3),
             (eq(var("v",@{typ "8 word"}),lw(103,8)),ln 4),
             (eq(ex(var("b",@{typ "8 word"}),ln 7,ln 4,@{typ "4 word"}),lw(4,4)),ln 5)],ln 0))],
      @{context}))

val () = function
  ("readPrefix",
   tp[var("s",@{typ "nat set"}),var("p",@{typ "8 word list"}),var("strm",@{typ "8 word list"})],
   cs(var("strm",@{typ "8 word list"}),
      [(llc([var("h",@{typ "8 word"})],var("strm1",@{typ "8 word list"})),
        let'
          (var_n"group",call("prefixGroup",@{typ nat},var("h",@{typ "8 word"}),@{theory}),
           itb([(eq(var_n"group",ln 0),
                 mop(Some,
                     tp[var("p",@{typ "8 word list"}),lf,
                        call("rec'REX",@{typ REX},lw(0,4),@{theory}),
                        var("strm",@{typ "8 word list"})])),
                (eq(var_n"group",ln 5),
                 mop(Some,
                     tp[var("p",@{typ "8 word list"}),lt,
                        call
                          ("rec'REX",@{typ REX},
                           ex(var("h",@{typ "8 word"}),ln 3,ln 0,@{typ "4 word"}),@{theory}),
                        var("strm1",@{typ "8 word list"})])),
                (bop(In,var_n"group",var("s",@{typ "nat set"})),
                 lo(@{typ "(8 word list) \<times> bool \<times> REX \<times> 8 word list"}))],
               apply
                 (var("readPrefix",
                      @{typ
                      "((nat set) \<times> (8 word list) \<times> 8 word list) \<Rightarrow>
                       (((8 word list) \<times> bool \<times> REX \<times> 8 word list) option)"}),
                  tp[bop(Insert,var_n"group",var("s",@{typ "nat set"})),
                     llc([var("h",@{typ "8 word"})],var("p",@{typ "8 word list"})),
                     var("strm1",@{typ "8 word list"})])))),
       (lnl(@{typ "8 word"}),
        mop(Some,
            tp[var("p",@{typ "8 word list"}),lf,lx(@{typ REX}),var("strm",@{typ "8 word list"})]))],
      @{context}))

val () = function
  ("readPrefixes",var("strm",@{typ "8 word list"}),
   call
     ("readPrefix",@{typ "((8 word list) \<times> bool \<times> REX \<times> 8 word list) option"},
      tp[le(@{typ nat}),lnl(@{typ "8 word"}),var("strm",@{typ "8 word list"})],@{theory}))

val () = function
  ("OpSize",tp[var_b"have_rex",var_b"w",var("v",@{typ "1 word"}),var_b"override"],
   itb([(eq(var("v",@{typ "1 word"}),lw(0,1)),
         call("Zsize.Z8",@{typ Zsize},var_b"have_rex",@{theory})),
        (var_b"w",Term.Const(@{const_name "Z64"},@{typ Zsize})),
        (var_b"override",Term.Const(@{const_name "Z16"},@{typ Zsize}))],
       Term.Const(@{const_name "Z32"},@{typ Zsize})))

val () = function
  ("isZm",var("rm",@{typ Zrm}),
   cs(var("rm",@{typ Zrm}),
      [(call
          ("Zrm.Zm",@{typ Zrm},
           var_a(@{typ "((2 word \<times> Zreg) option) \<times> Zbase \<times> 64 word"}),@{theory}),
        lt),(var_a(@{typ Zrm}),lf)],@{context}))

val () = function
  ("x64_decode",var("strm",@{typ "8 word list"}),
   cs(call
        ("readPrefixes",
         @{typ "((8 word list) \<times> bool \<times> REX \<times> 8 word list) option"},
         var("strm",@{typ "8 word list"}),@{theory}),
      [(lo(@{typ "(8 word list) \<times> bool \<times> REX \<times> 8 word list"}),
        call("Zinst.Zdec_fail",@{typ Zinst},ls"Bad prefix",@{theory})),
       (mop(Some,
            tp[var("p",@{typ "8 word list"}),var_b"have_rex",var("REX",@{typ REX}),
               var("strm1",@{typ "8 word list"})]),
        let'
          (var("prefixes",@{typ "8 word set"}),mop(SofL,var("p",@{typ "8 word list"})),
           let'
             (var_b"op_size_override",bop(In,lw(102,8),var("prefixes",@{typ "8 word set"})),
              itb([(bop(And,call("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                        var_b"op_size_override"),
                    call
                      ("Zinst.Zdec_fail",@{typ Zinst},ls"REX.W together with override prefix",
                       @{theory})),
                   (bop(In,lw(103,8),var("prefixes",@{typ "8 word set"})),
                    call
                      ("Zinst.Zdec_fail",@{typ Zinst},ls"address override prefix not supported",
                       @{theory}))],
                  cs(var("strm1",@{typ "8 word list"}),
                     [(llc([var("v#0",@{typ "8 word"})],var("v#1",@{typ "8 word list"})),
                       let'
                         (tp[tp[var_b"v#0",var_b"v#1",var_b"v#2",var_b"v#3",var_b"v#4",var_b"v#5",
                                var_b"v#6",var_b"v#7"],var("v#8",@{typ "8 word list"})],
                          tp[call
                               ("boolify'8",
                                @{typ
                                "bool \<times>
                                 bool \<times>
                                 bool \<times>
                                 bool \<times> bool \<times> bool \<times> bool \<times> bool"},
                                var("v#0",@{typ "8 word"}),@{theory}),
                             var("v#1",@{typ "8 word list"})],
                          cs(var("v#8",@{typ "8 word list"}),
                             [(llc([var("v#9",@{typ "8 word"})],var("v#10",@{typ "8 word list"})),
                               cs(tp[tp[var("v#9",@{typ "8 word"}),var("v#10",@{typ "8 word list"})],
                                     var_b"v#0",var_b"v#1",var_b"v#2",var_b"v#3",var_b"v#4",
                                     var_b"v#5",var_b"v#6",var_b"v#7"],
                                  [(tp[tp[var("v#69",@{typ "8 word"}),
                                          var("v#70",@{typ "8 word list"})],lt,lf,lt,lt,var_b"v'0",
                                       var_b"r'2",var_b"r'1",var_b"r'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("full_immediate",@{typ "64 word \<times> 8 word list"},
                                             tp[var("size",@{typ Zsize}),
                                                llc([var("v#69",@{typ "8 word"})],
                                                    var("v#70",@{typ "8 word list"}))],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zmov",@{typ instruction},
                                                   tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                      var("size",@{typ Zsize}),
                                                      call
                                                        ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                         tp[call
                                                              ("Zrm.Zr",@{typ Zrm},
                                                               mop(Cast(@{typ Zreg}),
                                                                   cc[mop(Cast(@{typ "1 word"}),
                                                                          call
                                                                            ("REX.B",@{typ bool},
                                                                             var("REX",@{typ REX}),
                                                                             @{theory})),
                                                                      mop(Cast(@{typ "3 word"}),
                                                                          ll[var_b"r'2",var_b"r'1",
                                                                             var_b"r'0"])]),
                                                               @{theory}),
                                                            var("imm",@{typ "64 word"})],@{theory})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[tp[var("v#53",@{typ "8 word"}),
                                          var("v#54",@{typ "8 word list"})],lt,lf,lf,lf,lf,lf,lt,lt],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#53",@{typ "8 word"})],
                                                 var("v#54",@{typ "8 word list"}))],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm4",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             var("strm3",@{typ "8 word list"}),@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[mop(Cast(@{typ Zbinop_name}),
                                                          var("opcode",@{typ "3 word"})),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[lf,
                                                            call
                                                              ("REX.W",@{typ bool},
                                                               var("REX",@{typ REX}),@{theory}),
                                                            lw(1,1),var_b"op_size_override"],
                                                         @{theory}),
                                                      call
                                                        ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                         tp[var("rm",@{typ Zrm}),
                                                            var("imm",@{typ "64 word"})],@{theory})],
                                                   @{theory}),var("strm4",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[tp[var("v#85",@{typ "8 word"}),
                                          var("v#86",@{typ "8 word list"})],lt,lt,lt,lf,lt,lf,lf,lf],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("immediate32",@{typ "64 word \<times> 8 word list"},
                                          llc([var("v#85",@{typ "8 word"})],
                                              var("v#86",@{typ "8 word list"})),@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zcall",@{typ instruction},
                                                call
                                                  ("Zimm_rm.Zimm",@{typ Zimm_rm},
                                                   var("imm",@{typ "64 word"}),@{theory}),@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[tp[var("v#45",@{typ "8 word"}),
                                          var("v#46",@{typ "8 word list"})],lf,lt,lt,lf,lf,lf,lt,lt],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#45",@{typ "8 word"})],
                                                 var("v#46",@{typ "8 word list"}))],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zmovsx",@{typ instruction},
                                                tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),
                                                   call
                                                     ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                      tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm})],
                                                      @{theory}),
                                                   Term.Const(@{const_name "Z64"},@{typ Zsize})],
                                                @{theory}),var("strm3",@{typ "8 word list"})],
                                          @{theory}))),
                                   (tp[tp[var("v#77",@{typ "8 word"}),
                                          var("v#78",@{typ "8 word list"})],lt,lt,lf,lf,lt,lf,lf,lt],
                                    call
                                      ("Zinst.Zfull_inst",@{typ Zinst},
                                       tp[var("p",@{typ "8 word list"}),
                                          Term.Const(@{const_name "Zleave"},@{typ instruction}),
                                          llc([var("v#77",@{typ "8 word"})],
                                              var("v#78",@{typ "8 word list"}))],@{theory})),
                                   (tp[tp[var("v#61",@{typ "8 word"}),
                                          var("v#62",@{typ "8 word list"})],lt,lf,lf,lf,lt,lt,lf,lt],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#61",@{typ "8 word"})],
                                                 var("v#62",@{typ "8 word list"}))],@{theory}),
                                       ite(call("isZm",@{typ bool},var("rm",@{typ Zrm}),@{theory}),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zlea",@{typ instruction},
                                                    tp[call
                                                         ("OpSize",@{typ Zsize},
                                                          tp[lt,
                                                             call
                                                               ("REX.W",@{typ bool},
                                                                var("REX",@{typ REX}),@{theory}),
                                                             lw(1,1),var_b"op_size_override"],
                                                          @{theory}),
                                                       call
                                                         ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                          tp[var("reg",@{typ Zreg}),
                                                             var("rm",@{typ Zrm})],@{theory})],
                                                    @{theory}),var("strm3",@{typ "8 word list"})],
                                              @{theory}),
                                           call
                                             ("Zinst.Zdec_fail",@{typ Zinst},
                                              ls"LEA with register argument",@{theory})))),
                                   (tp[tp[var("v#93",@{typ "8 word"}),
                                          var("v#94",@{typ "8 word list"})],lt,lt,lt,lt,lt,lt,lt,lt],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             lw(1,1),var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var("v#93",@{typ "8 word"})],
                                                    var("v#94",@{typ "8 word list"}))],@{theory}),
                                          cs(var("opcode",@{typ "3 word"}),
                                             [(var("v",@{typ "3 word"}),
                                               itb([(eq(var("v",@{typ "3 word"}),lw(0,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmonop",
                                                              @{typ instruction},
                                                              tp[lc("Zinc","Zmonop_name",@{theory}),
                                                                 var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(1,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmonop",
                                                              @{typ instruction},
                                                              tp[lc("Zdec","Zmonop_name",@{theory}),
                                                                 var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(2,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zcall",
                                                              @{typ instruction},
                                                              call
                                                                ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                                 var("rm",@{typ Zrm}),@{theory}),
                                                              @{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(4,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zjmp",@{typ instruction},
                                                              var("rm",@{typ Zrm}),@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(6,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zpush",
                                                              @{typ instruction},
                                                              call
                                                                ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                                 var("rm",@{typ Zrm}),@{theory}),
                                                              @{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory}))],
                                                   call
                                                     ("Zinst.Zdec_fail",@{typ Zinst},
                                                      ls"Unsupported opcode: INC/DEC Group 5",
                                                      @{theory})))],@{context})))),
                                   (tp[tp[var("v#41",@{typ "8 word"}),
                                          var("v#42",@{typ "8 word list"})],lf,lf,var_b"opc'2",
                                       var_b"opc'1",var_b"opc'0",lt,lf,var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate",@{typ "64 word \<times> 8 word list"},
                                             tp[var("size",@{typ Zsize}),
                                                llc([var("v#41",@{typ "8 word"})],
                                                    var("v#42",@{typ "8 word list"}))],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[mop(Cast(@{typ Zbinop_name}),
                                                          mop(Cast(@{typ "3 word"}),
                                                              ll[var_b"opc'2",var_b"opc'1",
                                                                 var_b"opc'0"])),
                                                      var("size",@{typ Zsize}),
                                                      call
                                                        ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                         tp[call
                                                              ("Zrm.Zr",@{typ Zrm},
                                                               lc("RAX","Zreg",@{theory}),@{theory}),
                                                            var("imm",@{typ "64 word"})],@{theory})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[tp[var("v#73",@{typ "8 word"}),
                                          var("v#74",@{typ "8 word list"})],lt,lt,lf,lf,lf,lf,lt,
                                       var_b"v'0"],
                                    let'
                                      (var("v#28",@{typ "8 word \<times> 8 word list"}),
                                       tp[var("v#73",@{typ "8 word"}),
                                          var("v#74",@{typ "8 word list"})],
                                       ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),lw(0,1)),
                                           let'
                                             (tp[var("imm",@{typ "64 word"}),
                                                 var("strm3",@{typ "8 word list"})],
                                              call
                                                ("immediate16",
                                                 @{typ "64 word \<times> 8 word list"},
                                                 llc([],
                                                     var("v#28",@{typ "8 word \<times> 8 word list"})),
                                                 @{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zret",@{typ instruction},
                                                       var("imm",@{typ "64 word"}),@{theory}),
                                                    var("strm3",@{typ "8 word list"})],@{theory})),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zret",@{typ instruction},lw(0,64),
                                                    @{theory}),
                                                 llc([],
                                                     var("v#28",@{typ "8 word \<times> 8 word list"}))],
                                              @{theory})))),
                                   (tp[tp[var("v#57",@{typ "8 word"}),
                                          var("v#58",@{typ "8 word list"})],lt,lf,lf,lf,lf,lt,lt,
                                       var_b"v'0"],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#57",@{typ "8 word"})],
                                                 var("v#58",@{typ "8 word list"}))],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zxchg",@{typ instruction},
                                                tp[call
                                                     ("OpSize",@{typ Zsize},
                                                      tp[var_b"have_rex",
                                                         call
                                                           ("REX.W",@{typ bool},
                                                            var("REX",@{typ REX}),@{theory}),
                                                         mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         var_b"op_size_override"],@{theory}),
                                                   var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
                                                @{theory}),var("strm3",@{typ "8 word list"})],
                                          @{theory}))),
                                   (tp[tp[var("v#89",@{typ "8 word"}),
                                          var("v#90",@{typ "8 word list"})],lt,lt,lt,lt,lf,lt,lt,
                                       var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var("v#89",@{typ "8 word"})],
                                                    var("v#90",@{typ "8 word list"}))],@{theory}),
                                          cs(var("opcode",@{typ "3 word"}),
                                             [(var("v",@{typ "3 word"}),
                                               itb([(eq(var("v",@{typ "3 word"}),lw(0,3)),
                                                     let'
                                                       (tp[var("imm",@{typ "64 word"}),
                                                           var("strm4",@{typ "8 word list"})],
                                                        call
                                                          ("immediate",
                                                           @{typ "64 word \<times> 8 word list"},
                                                           tp[var("size",@{typ Zsize}),
                                                              var("strm3",@{typ "8 word list"})],
                                                           @{theory}),
                                                        call
                                                          ("Zinst.Zfull_inst",@{typ Zinst},
                                                           tp[var("p",@{typ "8 word list"}),
                                                              call
                                                                ("instruction.Zbinop",
                                                                 @{typ instruction},
                                                                 tp[lc("Ztest","Zbinop_name",
                                                                       @{theory}),
                                                                    var("size",@{typ Zsize}),
                                                                    call
                                                                      ("Zdest_src.Zrm_i",
                                                                       @{typ Zdest_src},
                                                                       tp[var("rm",@{typ Zrm}),
                                                                          var("imm",@{typ "64 word"})],
                                                                       @{theory})],@{theory}),
                                                              var("strm4",@{typ "8 word list"})],
                                                           @{theory}))),
                                                    (eq(var("v",@{typ "3 word"}),lw(2,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmonop",
                                                              @{typ instruction},
                                                              tp[lc("Znot","Zmonop_name",@{theory}),
                                                                 var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(3,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmonop",
                                                              @{typ instruction},
                                                              tp[lc("Zneg","Zmonop_name",@{theory}),
                                                                 var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(4,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmul",@{typ instruction},
                                                              tp[var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(6,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zdiv",@{typ instruction},
                                                              tp[var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory}))],
                                                   call
                                                     ("Zinst.Zdec_fail",@{typ Zinst},
                                                      ls"Unsupported opcode: Unary Group 3",
                                                      @{theory})))],@{context})))),
                                   (tp[tp[var("v#49",@{typ "8 word"}),
                                          var("v#50",@{typ "8 word list"})],lf,lt,lt,lt,var_b"c'3",
                                       var_b"c'2",var_b"c'1",var_b"c'0"],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("immediate8",@{typ "64 word \<times> 8 word list"},
                                          llc([var("v#49",@{typ "8 word"})],
                                              var("v#50",@{typ "8 word list"})),@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zjcc",@{typ instruction},
                                                tp[mop(Cast(@{typ Zcond}),
                                                       mop(Cast(@{typ "4 word"}),
                                                           ll[var_b"c'3",var_b"c'2",var_b"c'1",
                                                              var_b"c'0"])),
                                                   var("imm",@{typ "64 word"})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[tp[var("v#81",@{typ "8 word"}),
                                          var("v#82",@{typ "8 word list"})],lt,lt,lt,lf,lf,lf,lf,
                                       var_b"b'0"],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("immediate8",@{typ "64 word \<times> 8 word list"},
                                          llc([var("v#81",@{typ "8 word"})],
                                              var("v#82",@{typ "8 word list"})),@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zloop",@{typ instruction},
                                                tp[ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"b'0"]),
                                                          lw(0,1)),lc("Z_NE","Zcond",@{theory}),
                                                       lc("Z_E","Zcond",@{theory})),
                                                   var("imm",@{typ "64 word"})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[tp[var("v#65",@{typ "8 word"}),
                                          var("v#66",@{typ "8 word list"})],lt,lf,lf,lt,lf,
                                       var_b"r'2",var_b"r'1",var_b"r'0"],
                                    let'
                                      (var("v#24",@{typ "8 word \<times> 8 word list"}),
                                       tp[var("v#65",@{typ "8 word"}),
                                          var("v#66",@{typ "8 word list"})],
                                       let'
                                         (var("reg",@{typ Zreg}),
                                          call
                                            ("RexReg",@{typ Zreg},
                                             tp[call
                                                  ("REX.B",@{typ bool},var("REX",@{typ REX}),
                                                   @{theory}),
                                                mop(Cast(@{typ "3 word"}),
                                                    ll[var_b"r'2",var_b"r'1",var_b"r'0"])],@{theory}),
                                          ite(eq(var("reg",@{typ Zreg}),lc("RAX","Zreg",@{theory})),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    Term.Const
                                                      (@{const_name "Znop"},@{typ instruction}),
                                                    llc([],
                                                        var("v#24",
                                                            @{typ "8 word \<times> 8 word list"}))],
                                                 @{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zxchg",@{typ instruction},
                                                       tp[call
                                                            ("OpSize",@{typ Zsize},
                                                             tp[lt,
                                                                call
                                                                  ("REX.W",@{typ bool},
                                                                   var("REX",@{typ REX}),@{theory}),
                                                                lw(1,1),var_b"op_size_override"],
                                                             @{theory}),
                                                          call
                                                            ("Zrm.Zr",@{typ Zrm},
                                                             lc("RAX","Zreg",@{theory}),@{theory}),
                                                          var("reg",@{typ Zreg})],@{theory}),
                                                    llc([],
                                                        var("v#24",
                                                            @{typ "8 word \<times> 8 word list"}))],
                                                 @{theory}))))),
                                   (tp[tp[var("opc",@{typ "8 word"}),
                                          var("strm2",@{typ "8 word list"})],lf,lf,lf,lf,lt,lt,lt,lt],
                                    cs(call
                                         ("boolify'8",
                                          @{typ
                                          "bool \<times>
                                           bool \<times>
                                           bool \<times>
                                           bool \<times>
                                           bool \<times> bool \<times> bool \<times> bool"},
                                          var("opc",@{typ "8 word"}),@{theory}),
                                       [(tp[lf,lt,lf,lf,var_b"c'3",var_b"c'2",var_b"c'1",var_b"c'0"],
                                         let'
                                           (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                               var("strm3",@{typ "8 word list"})],
                                            call
                                              ("readModRM",
                                               @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                               tp[var("REX",@{typ REX}),
                                                  var("strm2",@{typ "8 word list"})],@{theory}),
                                            call
                                              ("Zinst.Zfull_inst",@{typ Zinst},
                                               tp[var("p",@{typ "8 word list"}),
                                                  call
                                                    ("instruction.Zmov",@{typ instruction},
                                                     tp[mop(Cast(@{typ Zcond}),
                                                            mop(Cast(@{typ "4 word"}),
                                                                ll[var_b"c'3",var_b"c'2",var_b"c'1",
                                                                   var_b"c'0"])),
                                                        call
                                                          ("OpSize",@{typ Zsize},
                                                           tp[lt,
                                                              call
                                                                ("REX.W",@{typ bool},
                                                                 var("REX",@{typ REX}),@{theory}),
                                                              lw(1,1),var_b"op_size_override"],
                                                           @{theory}),
                                                        call
                                                          ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                           tp[var("reg",@{typ Zreg}),
                                                              var("rm",@{typ Zrm})],@{theory})],
                                                     @{theory}),var("strm3",@{typ "8 word list"})],
                                               @{theory}))),
                                        (tp[lt,lf,lf,lf,var_b"c'3",var_b"c'2",var_b"c'1",var_b"c'0"],
                                         let'
                                           (tp[var("imm",@{typ "64 word"}),
                                               var("strm3",@{typ "8 word list"})],
                                            call
                                              ("immediate32",@{typ "64 word \<times> 8 word list"},
                                               var("strm2",@{typ "8 word list"}),@{theory}),
                                            call
                                              ("Zinst.Zfull_inst",@{typ Zinst},
                                               tp[var("p",@{typ "8 word list"}),
                                                  call
                                                    ("instruction.Zjcc",@{typ instruction},
                                                     tp[mop(Cast(@{typ Zcond}),
                                                            mop(Cast(@{typ "4 word"}),
                                                                ll[var_b"c'3",var_b"c'2",var_b"c'1",
                                                                   var_b"c'0"])),
                                                        var("imm",@{typ "64 word"})],@{theory}),
                                                  var("strm3",@{typ "8 word list"})],@{theory}))),
                                        (tp[lt,lf,lt,lt,lf,lf,lf,var_b"v'0"],
                                         let'
                                           (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                               var("strm3",@{typ "8 word list"})],
                                            call
                                              ("readModRM",
                                               @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                               tp[var("REX",@{typ REX}),
                                                  var("strm2",@{typ "8 word list"})],@{theory}),
                                            call
                                              ("Zinst.Zfull_inst",@{typ Zinst},
                                               tp[var("p",@{typ "8 word list"}),
                                                  call
                                                    ("instruction.Zcmpxchg",@{typ instruction},
                                                     tp[call
                                                          ("OpSize",@{typ Zsize},
                                                           tp[var_b"have_rex",
                                                              call
                                                                ("REX.W",@{typ bool},
                                                                 var("REX",@{typ REX}),@{theory}),
                                                              mop(Cast(@{typ "1 word"}),
                                                                  ll[var_b"v'0"]),
                                                              var_b"op_size_override"],@{theory}),
                                                        var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
                                                     @{theory}),var("strm3",@{typ "8 word list"})],
                                               @{theory}))),
                                        (tp[lt,lt,lf,lf,lf,lf,lf,var_b"v'0"],
                                         let'
                                           (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                               var("strm3",@{typ "8 word list"})],
                                            call
                                              ("readModRM",
                                               @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                               tp[var("REX",@{typ REX}),
                                                  var("strm2",@{typ "8 word list"})],@{theory}),
                                            call
                                              ("Zinst.Zfull_inst",@{typ Zinst},
                                               tp[var("p",@{typ "8 word list"}),
                                                  call
                                                    ("instruction.Zxadd",@{typ instruction},
                                                     tp[call
                                                          ("OpSize",@{typ Zsize},
                                                           tp[var_b"have_rex",
                                                              call
                                                                ("REX.W",@{typ bool},
                                                                 var("REX",@{typ REX}),@{theory}),
                                                              mop(Cast(@{typ "1 word"}),
                                                                  ll[var_b"v'0"]),
                                                              var_b"op_size_override"],@{theory}),
                                                        var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
                                                     @{theory}),var("strm3",@{typ "8 word list"})],
                                               @{theory}))),
                                        (tp[lt,lf,lt,lt,var_b"s'0",lt,lt,var_b"v'0"],
                                         let'
                                           (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                               var("strm3",@{typ "8 word list"})],
                                            call
                                              ("readModRM",
                                               @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                               tp[var("REX",@{typ REX}),
                                                  var("strm2",@{typ "8 word list"})],@{theory}),
                                            let'
                                              (var("arg",
                                                   @{typ "Zsize \<times> Zdest_src \<times> Zsize"}),
                                               tp[ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         lw(1,1)),
                                                      Term.Const(@{const_name "Z16"},@{typ Zsize}),
                                                      call
                                                        ("Zsize.Z8",@{typ Zsize},var_b"have_rex",
                                                         @{theory})),
                                                  call
                                                    ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                     tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm})],
                                                     @{theory}),
                                                  call
                                                    ("OpSize",@{typ Zsize},
                                                     tp[var_b"have_rex",
                                                        call
                                                          ("REX.W",@{typ bool},
                                                           var("REX",@{typ REX}),@{theory}),lw(1,1),
                                                        var_b"op_size_override"],@{theory})],
                                               call
                                                 ("Zinst.Zfull_inst",@{typ Zinst},
                                                  tp[var("p",@{typ "8 word list"}),
                                                     ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"s'0"]),
                                                            lw(1,1)),
                                                         call
                                                           ("instruction.Zmovsx",@{typ instruction},
                                                            var("arg",
                                                                @{typ
                                                                "Zsize \<times>
                                                                 Zdest_src \<times> Zsize"}),
                                                            @{theory}),
                                                         call
                                                           ("instruction.Zmovzx",@{typ instruction},
                                                            var("arg",
                                                                @{typ
                                                                "Zsize \<times>
                                                                 Zdest_src \<times> Zsize"}),
                                                            @{theory})),
                                                     var("strm3",@{typ "8 word list"})],@{theory})))),
                                        (tp[var_a(@{typ bool}),var_a(@{typ bool}),
                                            var_a(@{typ bool}),var_a(@{typ bool}),
                                            var_a(@{typ bool}),var_a(@{typ bool}),
                                            var_a(@{typ bool}),var_a(@{typ bool})],
                                         call
                                           ("Zinst.Zdec_fail",@{typ Zinst},
                                            cc[ls"Unsupported opcode: 0F ",
                                               mop(Cast(@{typ string}),var("opc",@{typ "8 word"}))],
                                            @{theory}))],@{context})),
                                   (tp[tp[var("v#39",@{typ "8 word"}),
                                          var("v#40",@{typ "8 word list"})],lf,lf,var_b"opc'2",
                                       var_b"opc'1",var_b"opc'0",lf,var_b"x'0",var_b"v'0"],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#39",@{typ "8 word"})],
                                                 var("v#40",@{typ "8 word list"}))],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zbinop",@{typ instruction},
                                                tp[mop(Cast(@{typ Zbinop_name}),
                                                       mop(Cast(@{typ "3 word"}),
                                                           ll[var_b"opc'2",var_b"opc'1",var_b"opc'0"])),
                                                   call
                                                     ("OpSize",@{typ Zsize},
                                                      tp[var_b"have_rex",
                                                         call
                                                           ("REX.W",@{typ bool},
                                                            var("REX",@{typ REX}),@{theory}),
                                                         mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         var_b"op_size_override"],@{theory}),
                                                   ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"x'0"]),
                                                          lw(0,1)),
                                                       call
                                                         ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                          tp[var("rm",@{typ Zrm}),
                                                             var("reg",@{typ Zreg})],@{theory}),
                                                       call
                                                         ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                          tp[var("reg",@{typ Zreg}),
                                                             var("rm",@{typ Zrm})],@{theory}))],
                                                @{theory}),var("strm3",@{typ "8 word list"})],
                                          @{theory}))),
                                   (tp[tp[var("v#71",@{typ "8 word"}),
                                          var("v#72",@{typ "8 word list"})],lt,lt,lf,lf,lf,lf,lf,
                                       var_b"v'0"],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#71",@{typ "8 word"})],
                                                 var("v#72",@{typ "8 word list"}))],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm4",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             var("strm3",@{typ "8 word list"}),@{theory}),
                                          ite(eq(var("opcode",@{typ "3 word"}),lw(6,3)),
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"Unsupported opcode: Shift Group 2",@{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zbinop",@{typ instruction},
                                                       tp[mop(Cast(@{typ Zbinop_name}),
                                                              bop(Add,
                                                                  mop(Cast(@{typ nat}),
                                                                      var("opcode",@{typ "3 word"})),
                                                                  ln 8)),
                                                          call
                                                            ("OpSize",@{typ Zsize},
                                                             tp[var_b"have_rex",
                                                                call
                                                                  ("REX.W",@{typ bool},
                                                                   var("REX",@{typ REX}),@{theory}),
                                                                mop(Cast(@{typ "1 word"}),
                                                                    ll[var_b"v'0"]),
                                                                var_b"op_size_override"],@{theory}),
                                                          call
                                                            ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                             tp[var("rm",@{typ Zrm}),
                                                                var("imm",@{typ "64 word"})],
                                                             @{theory})],@{theory}),
                                                    var("strm4",@{typ "8 word list"})],@{theory}))))),
                                   (tp[tp[var("v#55",@{typ "8 word"}),
                                          var("v#56",@{typ "8 word list"})],lt,lf,lf,lf,lf,lt,lf,
                                       var_b"v'0"],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#55",@{typ "8 word"})],
                                                 var("v#56",@{typ "8 word list"}))],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zbinop",@{typ instruction},
                                                tp[lc("Ztest","Zbinop_name",@{theory}),
                                                   call
                                                     ("OpSize",@{typ Zsize},
                                                      tp[var_b"have_rex",
                                                         call
                                                           ("REX.W",@{typ bool},
                                                            var("REX",@{typ REX}),@{theory}),
                                                         mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         var_b"op_size_override"],@{theory}),
                                                   call
                                                     ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                      tp[var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
                                                      @{theory})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[tp[var("v#87",@{typ "8 word"}),
                                          var("v#88",@{typ "8 word list"})],lt,lt,lt,lf,lt,lf,
                                       var_b"b'0",lt],
                                    let'
                                      (var("v#35",@{typ "8 word \<times> 8 word list"}),
                                       tp[var("v#87",@{typ "8 word"}),
                                          var("v#88",@{typ "8 word list"})],
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm3",@{typ "8 word list"})],
                                          ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"b'0"]),lw(0,1)),
                                              call
                                                ("immediate32",
                                                 @{typ "64 word \<times> 8 word list"},
                                                 llc([],
                                                     var("v#35",@{typ "8 word \<times> 8 word list"})),
                                                 @{theory}),
                                              call
                                                ("immediate8",@{typ "64 word \<times> 8 word list"},
                                                 llc([],
                                                     var("v#35",@{typ "8 word \<times> 8 word list"})),
                                                 @{theory})),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zjcc",@{typ instruction},
                                                   tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                      var("imm",@{typ "64 word"})],@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory})))),
                                   (tp[tp[var("v#47",@{typ "8 word"}),
                                          var("v#48",@{typ "8 word list"})],lf,lt,lt,lf,lt,lf,
                                       var_b"b'0",lf],
                                    let'
                                      (var("v#15",@{typ "8 word \<times> 8 word list"}),
                                       tp[var("v#47",@{typ "8 word"}),
                                          var("v#48",@{typ "8 word list"})],
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm3",@{typ "8 word list"})],
                                          ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"b'0"]),lw(1,1)),
                                              call
                                                ("immediate8",@{typ "64 word \<times> 8 word list"},
                                                 llc([],
                                                     var("v#15",@{typ "8 word \<times> 8 word list"})),
                                                 @{theory}),
                                              call
                                                ("immediate32",
                                                 @{typ "64 word \<times> 8 word list"},
                                                 llc([],
                                                     var("v#15",@{typ "8 word \<times> 8 word list"})),
                                                 @{theory})),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zpush",@{typ instruction},
                                                   call
                                                     ("Zimm_rm.Zimm",@{typ Zimm_rm},
                                                      var("imm",@{typ "64 word"}),@{theory}),
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[tp[var("v#79",@{typ "8 word"}),
                                          var("v#80",@{typ "8 word list"})],lt,lt,lf,lt,lf,lf,
                                       var_b"b'0",var_b"v'0"],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#79",@{typ "8 word"})],
                                                 var("v#80",@{typ "8 word list"}))],@{theory}),
                                       ite(eq(var("opcode",@{typ "3 word"}),lw(6,3)),
                                           call
                                             ("Zinst.Zdec_fail",@{typ Zinst},
                                              ls"Unsupported opcode: Shift Group 2",@{theory}),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zbinop",@{typ instruction},
                                                    tp[mop(Cast(@{typ Zbinop_name}),
                                                           bop(Add,
                                                               mop(Cast(@{typ nat}),
                                                                   var("opcode",@{typ "3 word"})),
                                                               ln 8)),
                                                       call
                                                         ("OpSize",@{typ Zsize},
                                                          tp[var_b"have_rex",
                                                             call
                                                               ("REX.W",@{typ bool},
                                                                var("REX",@{typ REX}),@{theory}),
                                                             mop(Cast(@{typ "1 word"}),
                                                                 ll[var_b"v'0"]),
                                                             var_b"op_size_override"],@{theory}),
                                                       ite(eq(mop(Cast(@{typ "1 word"}),
                                                                  ll[var_b"b'0"]),lw(0,1)),
                                                           call
                                                             ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                              tp[var("rm",@{typ Zrm}),lw(1,64)],
                                                              @{theory}),
                                                           call
                                                             ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                              tp[var("rm",@{typ Zrm}),
                                                                 lc("RCX","Zreg",@{theory})],
                                                              @{theory}))],@{theory}),
                                                 var("strm3",@{typ "8 word list"})],@{theory})))),
                                   (tp[tp[var("v#63",@{typ "8 word"}),
                                          var("v#64",@{typ "8 word list"})],lt,lf,lf,lf,lt,lt,lt,lt],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#63",@{typ "8 word"})],
                                                 var("v#64",@{typ "8 word list"}))],@{theory}),
                                       ite(eq(var("opcode",@{typ "3 word"}),lw(0,3)),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zpop",@{typ instruction},
                                                    var("rm",@{typ Zrm}),@{theory}),
                                                 var("strm3",@{typ "8 word list"})],@{theory}),
                                           call
                                             ("Zinst.Zdec_fail",@{typ Zinst},
                                              ls"Unsupported opcode: Group 1a",@{theory})))),
                                   (tp[tp[var("v",@{typ "8 word"}),
                                          llc([var("opc",@{typ "8 word"})],
                                              var("v0",@{typ "8 word list"}))],lf,lf,lf,lf,lt,lt,lt,
                                       lt],
                                    itb([(eq(var("v",@{typ "8 word"}),lw(56,8)),
                                          call
                                            ("Zinst.Zdec_fail",@{typ Zinst},
                                             cc[ls"Unsupported opcode: 0F 38 ",
                                                mop(Cast(@{typ string}),var("opc",@{typ "8 word"}))],
                                             @{theory})),
                                         (eq(var("v",@{typ "8 word"}),lw(58,8)),
                                          call
                                            ("Zinst.Zdec_fail",@{typ Zinst},
                                             cc[ls"Unsupported opcode: 0F 3A ",
                                                mop(Cast(@{typ string}),var("opc",@{typ "8 word"}))],
                                             @{theory}))],
                                        cs(call
                                             ("boolify'8",
                                              @{typ
                                              "bool \<times>
                                               bool \<times>
                                               bool \<times>
                                               bool \<times>
                                               bool \<times> bool \<times> bool \<times> bool"},
                                              var("opc",@{typ "8 word"}),@{theory}),
                                           [(tp[lf,lt,lf,lf,var_b"c'3",var_b"c'2",var_b"c'1",
                                                var_b"c'0"],
                                             let'
                                               (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                                   var("strm3",@{typ "8 word list"})],
                                                call
                                                  ("readModRM",
                                                   @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                                   tp[var("REX",@{typ REX}),
                                                      var("strm2",@{typ "8 word list"})],@{theory}),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zmov",@{typ instruction},
                                                         tp[mop(Cast(@{typ Zcond}),
                                                                mop(Cast(@{typ "4 word"}),
                                                                    ll[var_b"c'3",var_b"c'2",
                                                                       var_b"c'1",var_b"c'0"])),
                                                            call
                                                              ("OpSize",@{typ Zsize},
                                                               tp[lt,
                                                                  call
                                                                    ("REX.W",@{typ bool},
                                                                     var("REX",@{typ REX}),@{theory}),
                                                                  lw(1,1),var_b"op_size_override"],
                                                               @{theory}),
                                                            call
                                                              ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                               tp[var("reg",@{typ Zreg}),
                                                                  var("rm",@{typ Zrm})],@{theory})],
                                                         @{theory}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}))),
                                            (tp[lt,lf,lf,lf,var_b"c'3",var_b"c'2",var_b"c'1",
                                                var_b"c'0"],
                                             let'
                                               (tp[var("imm",@{typ "64 word"}),
                                                   var("strm3",@{typ "8 word list"})],
                                                call
                                                  ("immediate32",
                                                   @{typ "64 word \<times> 8 word list"},
                                                   var("strm2",@{typ "8 word list"}),@{theory}),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zjcc",@{typ instruction},
                                                         tp[mop(Cast(@{typ Zcond}),
                                                                mop(Cast(@{typ "4 word"}),
                                                                    ll[var_b"c'3",var_b"c'2",
                                                                       var_b"c'1",var_b"c'0"])),
                                                            var("imm",@{typ "64 word"})],@{theory}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}))),
                                            (tp[lt,lf,lt,lt,lf,lf,lf,var_b"v'0"],
                                             let'
                                               (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                                   var("strm3",@{typ "8 word list"})],
                                                call
                                                  ("readModRM",
                                                   @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                                   tp[var("REX",@{typ REX}),
                                                      var("strm2",@{typ "8 word list"})],@{theory}),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zcmpxchg",@{typ instruction},
                                                         tp[call
                                                              ("OpSize",@{typ Zsize},
                                                               tp[var_b"have_rex",
                                                                  call
                                                                    ("REX.W",@{typ bool},
                                                                     var("REX",@{typ REX}),@{theory}),
                                                                  mop(Cast(@{typ "1 word"}),
                                                                      ll[var_b"v'0"]),
                                                                  var_b"op_size_override"],@{theory}),
                                                            var("rm",@{typ Zrm}),
                                                            var("reg",@{typ Zreg})],@{theory}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}))),
                                            (tp[lt,lt,lf,lf,lf,lf,lf,var_b"v'0"],
                                             let'
                                               (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                                   var("strm3",@{typ "8 word list"})],
                                                call
                                                  ("readModRM",
                                                   @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                                   tp[var("REX",@{typ REX}),
                                                      var("strm2",@{typ "8 word list"})],@{theory}),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zxadd",@{typ instruction},
                                                         tp[call
                                                              ("OpSize",@{typ Zsize},
                                                               tp[var_b"have_rex",
                                                                  call
                                                                    ("REX.W",@{typ bool},
                                                                     var("REX",@{typ REX}),@{theory}),
                                                                  mop(Cast(@{typ "1 word"}),
                                                                      ll[var_b"v'0"]),
                                                                  var_b"op_size_override"],@{theory}),
                                                            var("rm",@{typ Zrm}),
                                                            var("reg",@{typ Zreg})],@{theory}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}))),
                                            (tp[lt,lf,lt,lt,var_b"s'0",lt,lt,var_b"v'0"],
                                             let'
                                               (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                                   var("strm3",@{typ "8 word list"})],
                                                call
                                                  ("readModRM",
                                                   @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                                   tp[var("REX",@{typ REX}),
                                                      var("strm2",@{typ "8 word list"})],@{theory}),
                                                let'
                                                  (var("arg",
                                                       @{typ
                                                       "Zsize \<times> Zdest_src \<times> Zsize"}),
                                                   tp[ite(eq(mop(Cast(@{typ "1 word"}),
                                                                 ll[var_b"v'0"]),lw(1,1)),
                                                          Term.Const
                                                            (@{const_name "Z16"},@{typ Zsize}),
                                                          call
                                                            ("Zsize.Z8",@{typ Zsize},
                                                             var_b"have_rex",@{theory})),
                                                      call
                                                        ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                         tp[var("reg",@{typ Zreg}),
                                                            var("rm",@{typ Zrm})],@{theory}),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",@{typ bool},
                                                               var("REX",@{typ REX}),@{theory}),
                                                            lw(1,1),var_b"op_size_override"],
                                                         @{theory})],
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         ite(eq(mop(Cast(@{typ "1 word"}),
                                                                    ll[var_b"s'0"]),lw(1,1)),
                                                             call
                                                               ("instruction.Zmovsx",
                                                                @{typ instruction},
                                                                var("arg",
                                                                    @{typ
                                                                    "Zsize \<times>
                                                                     Zdest_src \<times> Zsize"}),
                                                                @{theory}),
                                                             call
                                                               ("instruction.Zmovzx",
                                                                @{typ instruction},
                                                                var("arg",
                                                                    @{typ
                                                                    "Zsize \<times>
                                                                     Zdest_src \<times> Zsize"}),
                                                                @{theory})),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})))),
                                            (tp[var_a(@{typ bool}),var_a(@{typ bool}),
                                                var_a(@{typ bool}),var_a(@{typ bool}),
                                                var_a(@{typ bool}),var_a(@{typ bool}),
                                                var_a(@{typ bool}),var_a(@{typ bool})],
                                             call
                                               ("Zinst.Zdec_fail",@{typ Zinst},
                                                cc[ls"Unsupported opcode: 0F ",
                                                   mop(Cast(@{typ string}),
                                                       var("opc",@{typ "8 word"}))],@{theory}))],
                                           @{context}))),
                                   (tp[tp[var("v#43",@{typ "8 word"}),
                                          var("v#44",@{typ "8 word list"})],lf,lt,lf,lt,var_b"b'0",
                                       var_b"r'2",var_b"r'1",var_b"r'0"],
                                    let'
                                      (var("reg",@{typ Zrm}),
                                       call
                                         ("Zrm.Zr",@{typ Zrm},
                                          mop(Cast(@{typ Zreg}),
                                              cc[mop(Cast(@{typ "1 word"}),
                                                     call
                                                       ("REX.B",@{typ bool},var("REX",@{typ REX}),
                                                        @{theory})),
                                                 mop(Cast(@{typ "3 word"}),
                                                     ll[var_b"r'2",var_b"r'1",var_b"r'0"])]),
                                          @{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"b'0"]),
                                                    lw(0,1)),
                                                 call
                                                   ("instruction.Zpush",@{typ instruction},
                                                    call
                                                      ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                       var("reg",@{typ Zrm}),@{theory}),@{theory}),
                                                 call
                                                   ("instruction.Zpop",@{typ instruction},
                                                    var("reg",@{typ Zrm}),@{theory})),
                                             llc([var("v#43",@{typ "8 word"})],
                                                 var("v#44",@{typ "8 word list"}))],@{theory}))),
                                   (tp[tp[var("v#75",@{typ "8 word"}),
                                          var("v#76",@{typ "8 word list"})],lt,lt,lf,lf,lf,lt,lt,
                                       var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var("v#75",@{typ "8 word"})],
                                                    var("v#76",@{typ "8 word list"}))],@{theory}),
                                          let'
                                            (tp[var("imm",@{typ "64 word"}),
                                                var("strm4",@{typ "8 word list"})],
                                             call
                                               ("immediate",@{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),
                                                   var("strm3",@{typ "8 word list"})],@{theory}),
                                             ite(eq(var("opcode",@{typ "3 word"}),lw(0,3)),
                                                 call
                                                   ("Zinst.Zfull_inst",@{typ Zinst},
                                                    tp[var("p",@{typ "8 word list"}),
                                                       call
                                                         ("instruction.Zmov",@{typ instruction},
                                                          tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                             var("size",@{typ Zsize}),
                                                             call
                                                               ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                                tp[var("rm",@{typ Zrm}),
                                                                   var("imm",@{typ "64 word"})],
                                                                @{theory})],@{theory}),
                                                       var("strm4",@{typ "8 word list"})],@{theory}),
                                                 call
                                                   ("Zinst.Zdec_fail",@{typ Zinst},
                                                    ls"Unsupported opcode: Group 11",@{theory})))))),
                                   (tp[tp[var("v#59",@{typ "8 word"}),
                                          var("v#60",@{typ "8 word list"})],lt,lf,lf,lf,lt,lf,
                                       var_b"x'0",var_b"v'0"],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#59",@{typ "8 word"})],
                                                 var("v#60",@{typ "8 word list"}))],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zmov",@{typ instruction},
                                                tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                   call
                                                     ("OpSize",@{typ Zsize},
                                                      tp[var_b"have_rex",
                                                         call
                                                           ("REX.W",@{typ bool},
                                                            var("REX",@{typ REX}),@{theory}),
                                                         mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         var_b"op_size_override"],@{theory}),
                                                   ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"x'0"]),
                                                          lw(0,1)),
                                                       call
                                                         ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                          tp[var("rm",@{typ Zrm}),
                                                             var("reg",@{typ Zreg})],@{theory}),
                                                       call
                                                         ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                          tp[var("reg",@{typ Zreg}),
                                                             var("rm",@{typ Zrm})],@{theory}))],
                                                @{theory}),var("strm3",@{typ "8 word list"})],
                                          @{theory}))),
                                   (tp[tp[var("v#91",@{typ "8 word"}),
                                          var("v#92",@{typ "8 word list"})],lt,lt,lt,lt,lt,lt,lt,lf],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),
                                             llc([var("v#91",@{typ "8 word"})],
                                                 var("v#92",@{typ "8 word list"}))],@{theory}),
                                       itb([(eq(var("opcode",@{typ "3 word"}),lw(0,3)),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zmonop",@{typ instruction},
                                                      tp[lc("Zinc","Zmonop_name",@{theory}),
                                                         call
                                                           ("Zsize.Z8",@{typ Zsize},var_b"have_rex",
                                                            @{theory}),var("rm",@{typ Zrm})],
                                                      @{theory}),var("strm3",@{typ "8 word list"})],
                                                @{theory})),
                                            (eq(var("opcode",@{typ "3 word"}),lw(1,3)),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zmonop",@{typ instruction},
                                                      tp[lc("Zdec","Zmonop_name",@{theory}),
                                                         call
                                                           ("Zsize.Z8",@{typ Zsize},var_b"have_rex",
                                                            @{theory}),var("rm",@{typ Zrm})],
                                                      @{theory}),var("strm3",@{typ "8 word list"})],
                                                @{theory}))],
                                           call
                                             ("Zinst.Zdec_fail",@{typ Zinst},
                                              ls"Unsupported opcode: INC/DEC Group 4",@{theory})))),
                                   (tp[tp[var("v#51",@{typ "8 word"}),
                                          var("v#52",@{typ "8 word list"})],lt,lf,lf,lf,lf,lf,lf,
                                       var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var("v#51",@{typ "8 word"})],
                                                    var("v#52",@{typ "8 word list"}))],@{theory}),
                                          let'
                                            (tp[var("imm",@{typ "64 word"}),
                                                var("strm4",@{typ "8 word list"})],
                                             call
                                               ("immediate",@{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),
                                                   var("strm3",@{typ "8 word list"})],@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zbinop",@{typ instruction},
                                                      tp[mop(Cast(@{typ Zbinop_name}),
                                                             var("opcode",@{typ "3 word"})),
                                                         var("size",@{typ Zsize}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[var("rm",@{typ Zrm}),
                                                               var("imm",@{typ "64 word"})],
                                                            @{theory})],@{theory}),
                                                   var("strm4",@{typ "8 word list"})],@{theory}))))),
                                   (tp[tp[var("v#83",@{typ "8 word"}),
                                          var("v#84",@{typ "8 word list"})],lt,lt,lt,lf,lf,lf,lt,lf],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("immediate8",@{typ "64 word \<times> 8 word list"},
                                          llc([var("v#83",@{typ "8 word"})],
                                              var("v#84",@{typ "8 word list"})),@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zloop",@{typ instruction},
                                                tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                   var("imm",@{typ "64 word"})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[tp[var("v#67",@{typ "8 word"}),
                                          var("v#68",@{typ "8 word list"})],lt,lf,lt,lf,lt,lf,lf,
                                       var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[lt,
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate",@{typ "64 word \<times> 8 word list"},
                                             tp[var("size",@{typ Zsize}),
                                                llc([var("v#67",@{typ "8 word"})],
                                                    var("v#68",@{typ "8 word list"}))],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[lc("Ztest","Zbinop_name",@{theory}),
                                                      var("size",@{typ Zsize}),
                                                      call
                                                        ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                         tp[call
                                                              ("Zrm.Zr",@{typ Zrm},
                                                               lc("RAX","Zreg",@{theory}),@{theory}),
                                                            var("imm",@{typ "64 word"})],@{theory})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[tp[var("v",@{typ "8 word"}),var("v0",@{typ "8 word list"})],
                                       var_b"opc'7",var_b"opc'6",var_b"opc'5",var_b"opc'4",
                                       var_b"opc'3",var_b"opc'2",var_b"opc'1",var_b"opc'0"],
                                    call
                                      ("Zinst.Zdec_fail",@{typ Zinst},
                                       cc[ls"Unsupported opcode: ",
                                          mop(Cast(@{typ string}),
                                              mop(Cast(@{typ "8 word"}),
                                                  ll[var_b"opc'7",var_b"opc'6",var_b"opc'5",
                                                     var_b"opc'4",var_b"opc'3",var_b"opc'2",
                                                     var_b"opc'1",var_b"opc'0"]))],@{theory}))],
                                  @{context})),
                              (lnl(@{typ "8 word"}),
                               cs(tp[var_b"v#0",var_b"v#1",var_b"v#2",var_b"v#3",var_b"v#4",
                                     var_b"v#5",var_b"v#6",var_b"v#7"],
                                  [(tp[lf,lf,var_b"opc'2",var_b"opc'1",var_b"opc'0",lf,var_b"x'0",
                                       var_b"v'0"],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zbinop",@{typ instruction},
                                                tp[mop(Cast(@{typ Zbinop_name}),
                                                       mop(Cast(@{typ "3 word"}),
                                                           ll[var_b"opc'2",var_b"opc'1",var_b"opc'0"])),
                                                   call
                                                     ("OpSize",@{typ Zsize},
                                                      tp[var_b"have_rex",
                                                         call
                                                           ("REX.W",@{typ bool},
                                                            var("REX",@{typ REX}),@{theory}),
                                                         mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         var_b"op_size_override"],@{theory}),
                                                   ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"x'0"]),
                                                          lw(0,1)),
                                                       call
                                                         ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                          tp[var("rm",@{typ Zrm}),
                                                             var("reg",@{typ Zreg})],@{theory}),
                                                       call
                                                         ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                          tp[var("reg",@{typ Zreg}),
                                                             var("rm",@{typ Zrm})],@{theory}))],
                                                @{theory}),var("strm3",@{typ "8 word list"})],
                                          @{theory}))),
                                   (tp[lf,lf,var_b"opc'2",var_b"opc'1",var_b"opc'0",lt,lf,var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate",@{typ "64 word \<times> 8 word list"},
                                             tp[var("size",@{typ Zsize}),lnl(@{typ "8 word"})],
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[mop(Cast(@{typ Zbinop_name}),
                                                          mop(Cast(@{typ "3 word"}),
                                                              ll[var_b"opc'2",var_b"opc'1",
                                                                 var_b"opc'0"])),
                                                      var("size",@{typ Zsize}),
                                                      call
                                                        ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                         tp[call
                                                              ("Zrm.Zr",@{typ Zrm},
                                                               lc("RAX","Zreg",@{theory}),@{theory}),
                                                            var("imm",@{typ "64 word"})],@{theory})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[lf,lt,lf,lt,var_b"b'0",var_b"r'2",var_b"r'1",var_b"r'0"],
                                    let'
                                      (var("reg",@{typ Zrm}),
                                       call
                                         ("Zrm.Zr",@{typ Zrm},
                                          mop(Cast(@{typ Zreg}),
                                              cc[mop(Cast(@{typ "1 word"}),
                                                     call
                                                       ("REX.B",@{typ bool},var("REX",@{typ REX}),
                                                        @{theory})),
                                                 mop(Cast(@{typ "3 word"}),
                                                     ll[var_b"r'2",var_b"r'1",var_b"r'0"])]),
                                          @{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"b'0"]),
                                                    lw(0,1)),
                                                 call
                                                   ("instruction.Zpush",@{typ instruction},
                                                    call
                                                      ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                       var("reg",@{typ Zrm}),@{theory}),@{theory}),
                                                 call
                                                   ("instruction.Zpop",@{typ instruction},
                                                    var("reg",@{typ Zrm}),@{theory})),
                                             lnl(@{typ "8 word"})],@{theory}))),
                                   (tp[lf,lt,lt,lf,lf,lf,lt,lt],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zmovsx",@{typ instruction},
                                                tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),
                                                   call
                                                     ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                      tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm})],
                                                      @{theory}),
                                                   Term.Const(@{const_name "Z64"},@{typ Zsize})],
                                                @{theory}),var("strm3",@{typ "8 word list"})],
                                          @{theory}))),
                                   (tp[lf,lt,lt,lf,lt,lf,var_b"b'0",lf],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"b'0"]),lw(1,1)),
                                           call
                                             ("immediate8",@{typ "64 word \<times> 8 word list"},
                                              lnl(@{typ "8 word"}),@{theory}),
                                           call
                                             ("immediate32",@{typ "64 word \<times> 8 word list"},
                                              lnl(@{typ "8 word"}),@{theory})),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zpush",@{typ instruction},
                                                call
                                                  ("Zimm_rm.Zimm",@{typ Zimm_rm},
                                                   var("imm",@{typ "64 word"}),@{theory}),@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[lf,lt,lt,lt,var_b"c'3",var_b"c'2",var_b"c'1",var_b"c'0"],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("immediate8",@{typ "64 word \<times> 8 word list"},
                                          lnl(@{typ "8 word"}),@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zjcc",@{typ instruction},
                                                tp[mop(Cast(@{typ Zcond}),
                                                       mop(Cast(@{typ "4 word"}),
                                                           ll[var_b"c'3",var_b"c'2",var_b"c'1",
                                                              var_b"c'0"])),
                                                   var("imm",@{typ "64 word"})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[lt,lf,lf,lf,lf,lf,lf,var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],
                                             @{theory}),
                                          let'
                                            (tp[var("imm",@{typ "64 word"}),
                                                var("strm4",@{typ "8 word list"})],
                                             call
                                               ("immediate",@{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),
                                                   var("strm3",@{typ "8 word list"})],@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zbinop",@{typ instruction},
                                                      tp[mop(Cast(@{typ Zbinop_name}),
                                                             var("opcode",@{typ "3 word"})),
                                                         var("size",@{typ Zsize}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[var("rm",@{typ Zrm}),
                                                               var("imm",@{typ "64 word"})],
                                                            @{theory})],@{theory}),
                                                   var("strm4",@{typ "8 word list"})],@{theory}))))),
                                   (tp[lt,lf,lf,lf,lf,lf,lt,lt],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm4",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             var("strm3",@{typ "8 word list"}),@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[mop(Cast(@{typ Zbinop_name}),
                                                          var("opcode",@{typ "3 word"})),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[lf,
                                                            call
                                                              ("REX.W",@{typ bool},
                                                               var("REX",@{typ REX}),@{theory}),
                                                            lw(1,1),var_b"op_size_override"],
                                                         @{theory}),
                                                      call
                                                        ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                         tp[var("rm",@{typ Zrm}),
                                                            var("imm",@{typ "64 word"})],@{theory})],
                                                   @{theory}),var("strm4",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[lt,lf,lf,lf,lf,lt,lf,var_b"v'0"],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zbinop",@{typ instruction},
                                                tp[lc("Ztest","Zbinop_name",@{theory}),
                                                   call
                                                     ("OpSize",@{typ Zsize},
                                                      tp[var_b"have_rex",
                                                         call
                                                           ("REX.W",@{typ bool},
                                                            var("REX",@{typ REX}),@{theory}),
                                                         mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         var_b"op_size_override"],@{theory}),
                                                   call
                                                     ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                      tp[var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
                                                      @{theory})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[lt,lf,lf,lf,lf,lt,lt,var_b"v'0"],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zxchg",@{typ instruction},
                                                tp[call
                                                     ("OpSize",@{typ Zsize},
                                                      tp[var_b"have_rex",
                                                         call
                                                           ("REX.W",@{typ bool},
                                                            var("REX",@{typ REX}),@{theory}),
                                                         mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         var_b"op_size_override"],@{theory}),
                                                   var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
                                                @{theory}),var("strm3",@{typ "8 word list"})],
                                          @{theory}))),
                                   (tp[lt,lf,lf,lf,lt,lf,var_b"x'0",var_b"v'0"],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zmov",@{typ instruction},
                                                tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                   call
                                                     ("OpSize",@{typ Zsize},
                                                      tp[var_b"have_rex",
                                                         call
                                                           ("REX.W",@{typ bool},
                                                            var("REX",@{typ REX}),@{theory}),
                                                         mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                                         var_b"op_size_override"],@{theory}),
                                                   ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"x'0"]),
                                                          lw(0,1)),
                                                       call
                                                         ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                          tp[var("rm",@{typ Zrm}),
                                                             var("reg",@{typ Zreg})],@{theory}),
                                                       call
                                                         ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                          tp[var("reg",@{typ Zreg}),
                                                             var("rm",@{typ Zrm})],@{theory}))],
                                                @{theory}),var("strm3",@{typ "8 word list"})],
                                          @{theory}))),
                                   (tp[lt,lf,lf,lf,lt,lt,lf,lt],
                                    let'
                                      (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readModRM",
                                          @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       ite(call("isZm",@{typ bool},var("rm",@{typ Zrm}),@{theory}),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zlea",@{typ instruction},
                                                    tp[call
                                                         ("OpSize",@{typ Zsize},
                                                          tp[lt,
                                                             call
                                                               ("REX.W",@{typ bool},
                                                                var("REX",@{typ REX}),@{theory}),
                                                             lw(1,1),var_b"op_size_override"],
                                                          @{theory}),
                                                       call
                                                         ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                          tp[var("reg",@{typ Zreg}),
                                                             var("rm",@{typ Zrm})],@{theory})],
                                                    @{theory}),var("strm3",@{typ "8 word list"})],
                                              @{theory}),
                                           call
                                             ("Zinst.Zdec_fail",@{typ Zinst},
                                              ls"LEA with register argument",@{theory})))),
                                   (tp[lt,lf,lf,lf,lt,lt,lt,lt],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       ite(eq(var("opcode",@{typ "3 word"}),lw(0,3)),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zpop",@{typ instruction},
                                                    var("rm",@{typ Zrm}),@{theory}),
                                                 var("strm3",@{typ "8 word list"})],@{theory}),
                                           call
                                             ("Zinst.Zdec_fail",@{typ Zinst},
                                              ls"Unsupported opcode: Group 1a",@{theory})))),
                                   (tp[lt,lf,lf,lt,lf,var_b"r'2",var_b"r'1",var_b"r'0"],
                                    let'
                                      (var("reg",@{typ Zreg}),
                                       call
                                         ("RexReg",@{typ Zreg},
                                          tp[call
                                               ("REX.B",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "3 word"}),
                                                 ll[var_b"r'2",var_b"r'1",var_b"r'0"])],@{theory}),
                                       ite(eq(var("reg",@{typ Zreg}),lc("RAX","Zreg",@{theory})),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 Term.Const(@{const_name "Znop"},@{typ instruction}),
                                                 lnl(@{typ "8 word"})],@{theory}),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zxchg",@{typ instruction},
                                                    tp[call
                                                         ("OpSize",@{typ Zsize},
                                                          tp[lt,
                                                             call
                                                               ("REX.W",@{typ bool},
                                                                var("REX",@{typ REX}),@{theory}),
                                                             lw(1,1),var_b"op_size_override"],
                                                          @{theory}),
                                                       call
                                                         ("Zrm.Zr",@{typ Zrm},
                                                          lc("RAX","Zreg",@{theory}),@{theory}),
                                                       var("reg",@{typ Zreg})],@{theory}),
                                                 lnl(@{typ "8 word"})],@{theory})))),
                                   (tp[lt,lf,lt,lf,lt,lf,lf,var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[lt,
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate",@{typ "64 word \<times> 8 word list"},
                                             tp[var("size",@{typ Zsize}),lnl(@{typ "8 word"})],
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[lc("Ztest","Zbinop_name",@{theory}),
                                                      var("size",@{typ Zsize}),
                                                      call
                                                        ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                         tp[call
                                                              ("Zrm.Zr",@{typ Zrm},
                                                               lc("RAX","Zreg",@{theory}),@{theory}),
                                                            var("imm",@{typ "64 word"})],@{theory})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[lt,lf,lt,lt,var_b"v'0",var_b"r'2",var_b"r'1",var_b"r'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("full_immediate",@{typ "64 word \<times> 8 word list"},
                                             tp[var("size",@{typ Zsize}),lnl(@{typ "8 word"})],
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zmov",@{typ instruction},
                                                   tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                      var("size",@{typ Zsize}),
                                                      call
                                                        ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                         tp[call
                                                              ("Zrm.Zr",@{typ Zrm},
                                                               mop(Cast(@{typ Zreg}),
                                                                   cc[mop(Cast(@{typ "1 word"}),
                                                                          call
                                                                            ("REX.B",@{typ bool},
                                                                             var("REX",@{typ REX}),
                                                                             @{theory})),
                                                                      mop(Cast(@{typ "3 word"}),
                                                                          ll[var_b"r'2",var_b"r'1",
                                                                             var_b"r'0"])]),
                                                               @{theory}),
                                                            var("imm",@{typ "64 word"})],@{theory})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory})))),
                                   (tp[lt,lt,lf,lf,lf,lf,lf,var_b"v'0"],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       let'
                                         (tp[var("imm",@{typ "64 word"}),
                                             var("strm4",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             var("strm3",@{typ "8 word list"}),@{theory}),
                                          ite(eq(var("opcode",@{typ "3 word"}),lw(6,3)),
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"Unsupported opcode: Shift Group 2",@{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zbinop",@{typ instruction},
                                                       tp[mop(Cast(@{typ Zbinop_name}),
                                                              bop(Add,
                                                                  mop(Cast(@{typ nat}),
                                                                      var("opcode",@{typ "3 word"})),
                                                                  ln 8)),
                                                          call
                                                            ("OpSize",@{typ Zsize},
                                                             tp[var_b"have_rex",
                                                                call
                                                                  ("REX.W",@{typ bool},
                                                                   var("REX",@{typ REX}),@{theory}),
                                                                mop(Cast(@{typ "1 word"}),
                                                                    ll[var_b"v'0"]),
                                                                var_b"op_size_override"],@{theory}),
                                                          call
                                                            ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                             tp[var("rm",@{typ Zrm}),
                                                                var("imm",@{typ "64 word"})],
                                                             @{theory})],@{theory}),
                                                    var("strm4",@{typ "8 word list"})],@{theory}))))),
                                   (tp[lt,lt,lf,lf,lf,lf,lt,var_b"v'0"],
                                    ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),lw(0,1)),
                                        let'
                                          (tp[var("imm",@{typ "64 word"}),
                                              var("strm3",@{typ "8 word list"})],
                                           call
                                             ("immediate16",@{typ "64 word \<times> 8 word list"},
                                              lnl(@{typ "8 word"}),@{theory}),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zret",@{typ instruction},
                                                    var("imm",@{typ "64 word"}),@{theory}),
                                                 var("strm3",@{typ "8 word list"})],@{theory})),
                                        call
                                          ("Zinst.Zfull_inst",@{typ Zinst},
                                           tp[var("p",@{typ "8 word list"}),
                                              call
                                                ("instruction.Zret",@{typ instruction},lw(0,64),
                                                 @{theory}),lnl(@{typ "8 word"})],@{theory}))),
                                   (tp[lt,lt,lf,lf,lf,lt,lt,var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],
                                             @{theory}),
                                          let'
                                            (tp[var("imm",@{typ "64 word"}),
                                                var("strm4",@{typ "8 word list"})],
                                             call
                                               ("immediate",@{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),
                                                   var("strm3",@{typ "8 word list"})],@{theory}),
                                             ite(eq(var("opcode",@{typ "3 word"}),lw(0,3)),
                                                 call
                                                   ("Zinst.Zfull_inst",@{typ Zinst},
                                                    tp[var("p",@{typ "8 word list"}),
                                                       call
                                                         ("instruction.Zmov",@{typ instruction},
                                                          tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                             var("size",@{typ Zsize}),
                                                             call
                                                               ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                                tp[var("rm",@{typ Zrm}),
                                                                   var("imm",@{typ "64 word"})],
                                                                @{theory})],@{theory}),
                                                       var("strm4",@{typ "8 word list"})],@{theory}),
                                                 call
                                                   ("Zinst.Zdec_fail",@{typ Zinst},
                                                    ls"Unsupported opcode: Group 11",@{theory})))))),
                                   (tp[lt,lt,lf,lf,lt,lf,lf,lt],
                                    call
                                      ("Zinst.Zfull_inst",@{typ Zinst},
                                       tp[var("p",@{typ "8 word list"}),
                                          Term.Const(@{const_name "Zleave"},@{typ instruction}),
                                          lnl(@{typ "8 word"})],@{theory})),
                                   (tp[lt,lt,lf,lt,lf,lf,var_b"b'0",var_b"v'0"],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       ite(eq(var("opcode",@{typ "3 word"}),lw(6,3)),
                                           call
                                             ("Zinst.Zdec_fail",@{typ Zinst},
                                              ls"Unsupported opcode: Shift Group 2",@{theory}),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zbinop",@{typ instruction},
                                                    tp[mop(Cast(@{typ Zbinop_name}),
                                                           bop(Add,
                                                               mop(Cast(@{typ nat}),
                                                                   var("opcode",@{typ "3 word"})),
                                                               ln 8)),
                                                       call
                                                         ("OpSize",@{typ Zsize},
                                                          tp[var_b"have_rex",
                                                             call
                                                               ("REX.W",@{typ bool},
                                                                var("REX",@{typ REX}),@{theory}),
                                                             mop(Cast(@{typ "1 word"}),
                                                                 ll[var_b"v'0"]),
                                                             var_b"op_size_override"],@{theory}),
                                                       ite(eq(mop(Cast(@{typ "1 word"}),
                                                                  ll[var_b"b'0"]),lw(0,1)),
                                                           call
                                                             ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                              tp[var("rm",@{typ Zrm}),lw(1,64)],
                                                              @{theory}),
                                                           call
                                                             ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                              tp[var("rm",@{typ Zrm}),
                                                                 lc("RCX","Zreg",@{theory})],
                                                              @{theory}))],@{theory}),
                                                 var("strm3",@{typ "8 word list"})],@{theory})))),
                                   (tp[lt,lt,lt,lf,lf,lf,lf,var_b"b'0"],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("immediate8",@{typ "64 word \<times> 8 word list"},
                                          lnl(@{typ "8 word"}),@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zloop",@{typ instruction},
                                                tp[ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"b'0"]),
                                                          lw(0,1)),lc("Z_NE","Zcond",@{theory}),
                                                       lc("Z_E","Zcond",@{theory})),
                                                   var("imm",@{typ "64 word"})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[lt,lt,lt,lf,lf,lf,lt,lf],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("immediate8",@{typ "64 word \<times> 8 word list"},
                                          lnl(@{typ "8 word"}),@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zloop",@{typ instruction},
                                                tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                   var("imm",@{typ "64 word"})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[lt,lt,lt,lf,lt,lf,lf,lf],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("immediate32",@{typ "64 word \<times> 8 word list"},
                                          lnl(@{typ "8 word"}),@{theory}),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zcall",@{typ instruction},
                                                call
                                                  ("Zimm_rm.Zimm",@{typ Zimm_rm},
                                                   var("imm",@{typ "64 word"}),@{theory}),@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[lt,lt,lt,lf,lt,lf,var_b"b'0",lt],
                                    let'
                                      (tp[var("imm",@{typ "64 word"}),
                                          var("strm3",@{typ "8 word list"})],
                                       ite(eq(mop(Cast(@{typ "1 word"}),ll[var_b"b'0"]),lw(0,1)),
                                           call
                                             ("immediate32",@{typ "64 word \<times> 8 word list"},
                                              lnl(@{typ "8 word"}),@{theory}),
                                           call
                                             ("immediate8",@{typ "64 word \<times> 8 word list"},
                                              lnl(@{typ "8 word"}),@{theory})),
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             call
                                               ("instruction.Zjcc",@{typ instruction},
                                                tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                   var("imm",@{typ "64 word"})],@{theory}),
                                             var("strm3",@{typ "8 word list"})],@{theory}))),
                                   (tp[lt,lt,lt,lt,lf,lt,lt,var_b"v'0"],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             mop(Cast(@{typ "1 word"}),ll[var_b"v'0"]),
                                             var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],
                                             @{theory}),
                                          cs(var("opcode",@{typ "3 word"}),
                                             [(var("v",@{typ "3 word"}),
                                               itb([(eq(var("v",@{typ "3 word"}),lw(0,3)),
                                                     let'
                                                       (tp[var("imm",@{typ "64 word"}),
                                                           var("strm4",@{typ "8 word list"})],
                                                        call
                                                          ("immediate",
                                                           @{typ "64 word \<times> 8 word list"},
                                                           tp[var("size",@{typ Zsize}),
                                                              var("strm3",@{typ "8 word list"})],
                                                           @{theory}),
                                                        call
                                                          ("Zinst.Zfull_inst",@{typ Zinst},
                                                           tp[var("p",@{typ "8 word list"}),
                                                              call
                                                                ("instruction.Zbinop",
                                                                 @{typ instruction},
                                                                 tp[lc("Ztest","Zbinop_name",
                                                                       @{theory}),
                                                                    var("size",@{typ Zsize}),
                                                                    call
                                                                      ("Zdest_src.Zrm_i",
                                                                       @{typ Zdest_src},
                                                                       tp[var("rm",@{typ Zrm}),
                                                                          var("imm",@{typ "64 word"})],
                                                                       @{theory})],@{theory}),
                                                              var("strm4",@{typ "8 word list"})],
                                                           @{theory}))),
                                                    (eq(var("v",@{typ "3 word"}),lw(2,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmonop",
                                                              @{typ instruction},
                                                              tp[lc("Znot","Zmonop_name",@{theory}),
                                                                 var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(3,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmonop",
                                                              @{typ instruction},
                                                              tp[lc("Zneg","Zmonop_name",@{theory}),
                                                                 var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(4,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmul",@{typ instruction},
                                                              tp[var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(6,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zdiv",@{typ instruction},
                                                              tp[var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory}))],
                                                   call
                                                     ("Zinst.Zdec_fail",@{typ Zinst},
                                                      ls"Unsupported opcode: Unary Group 3",
                                                      @{theory})))],@{context})))),
                                   (tp[lt,lt,lt,lt,lt,lt,lt,lf],
                                    let'
                                      (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                          var("strm3",@{typ "8 word list"})],
                                       call
                                         ("readOpcodeModRM",
                                          @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                          tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],@{theory}),
                                       itb([(eq(var("opcode",@{typ "3 word"}),lw(0,3)),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zmonop",@{typ instruction},
                                                      tp[lc("Zinc","Zmonop_name",@{theory}),
                                                         call
                                                           ("Zsize.Z8",@{typ Zsize},var_b"have_rex",
                                                            @{theory}),var("rm",@{typ Zrm})],
                                                      @{theory}),var("strm3",@{typ "8 word list"})],
                                                @{theory})),
                                            (eq(var("opcode",@{typ "3 word"}),lw(1,3)),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zmonop",@{typ instruction},
                                                      tp[lc("Zdec","Zmonop_name",@{theory}),
                                                         call
                                                           ("Zsize.Z8",@{typ Zsize},var_b"have_rex",
                                                            @{theory}),var("rm",@{typ Zrm})],
                                                      @{theory}),var("strm3",@{typ "8 word list"})],
                                                @{theory}))],
                                           call
                                             ("Zinst.Zdec_fail",@{typ Zinst},
                                              ls"Unsupported opcode: INC/DEC Group 4",@{theory})))),
                                   (tp[lt,lt,lt,lt,lt,lt,lt,lt],
                                    let'
                                      (var("size",@{typ Zsize}),
                                       call
                                         ("OpSize",@{typ Zsize},
                                          tp[var_b"have_rex",
                                             call
                                               ("REX.W",@{typ bool},var("REX",@{typ REX}),@{theory}),
                                             lw(1,1),var_b"op_size_override"],@{theory}),
                                       let'
                                         (tp[var("opcode",@{typ "3 word"}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl(@{typ "8 word"})],
                                             @{theory}),
                                          cs(var("opcode",@{typ "3 word"}),
                                             [(var("v",@{typ "3 word"}),
                                               itb([(eq(var("v",@{typ "3 word"}),lw(0,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmonop",
                                                              @{typ instruction},
                                                              tp[lc("Zinc","Zmonop_name",@{theory}),
                                                                 var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(1,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zmonop",
                                                              @{typ instruction},
                                                              tp[lc("Zdec","Zmonop_name",@{theory}),
                                                                 var("size",@{typ Zsize}),
                                                                 var("rm",@{typ Zrm})],@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(2,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zcall",
                                                              @{typ instruction},
                                                              call
                                                                ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                                 var("rm",@{typ Zrm}),@{theory}),
                                                              @{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(4,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zjmp",@{typ instruction},
                                                              var("rm",@{typ Zrm}),@{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory})),
                                                    (eq(var("v",@{typ "3 word"}),lw(6,3)),
                                                     call
                                                       ("Zinst.Zfull_inst",@{typ Zinst},
                                                        tp[var("p",@{typ "8 word list"}),
                                                           call
                                                             ("instruction.Zpush",
                                                              @{typ instruction},
                                                              call
                                                                ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                                 var("rm",@{typ Zrm}),@{theory}),
                                                              @{theory}),
                                                           var("strm3",@{typ "8 word list"})],
                                                        @{theory}))],
                                                   call
                                                     ("Zinst.Zdec_fail",@{typ Zinst},
                                                      ls"Unsupported opcode: INC/DEC Group 5",
                                                      @{theory})))],@{context})))),
                                   (tp[var_b"opc'7",var_b"opc'6",var_b"opc'5",var_b"opc'4",
                                       var_b"opc'3",var_b"opc'2",var_b"opc'1",var_b"opc'0"],
                                    call
                                      ("Zinst.Zdec_fail",@{typ Zinst},
                                       cc[ls"Unsupported opcode: ",
                                          mop(Cast(@{typ string}),
                                              mop(Cast(@{typ "8 word"}),
                                                  ll[var_b"opc'7",var_b"opc'6",var_b"opc'5",
                                                     var_b"opc'4",var_b"opc'3",var_b"opc'2",
                                                     var_b"opc'1",var_b"opc'0"]))],@{theory}))],
                                  @{context}))],@{context}))),
                      (lnl(@{typ "8 word"}),
                       call("Zinst.Zdec_fail",@{typ Zinst},ls"No opcode",@{theory}))],@{context})))))],
      @{context}))

val () = function
  ("x64_fetch",var("state",@{typ X64_state}),
   let'
     (tp[var("r",@{typ "8 word list"}),var("s1",@{typ "(8 word list) \<times> X64_state"})],
      let'
        (var("s",@{typ "(8 word list) \<times> X64_state"}),
         mop(Snd,
             apply
               (forloop
                  (tp[ln 19,ln 0,
                      close
                        (var_n"i",
                         close
                           (var("state",@{typ "(8 word list) \<times> X64_state"}),
                            tp[lu,
                               llc([apply
                                      (call
                                         ("X64_state.MEM",@{typ "64 word \<Rightarrow> 8 word"},
                                          mop(Snd,
                                              var("state",@{typ "(8 word list) \<times> X64_state"})),
                                          @{theory}),
                                       bop(Add,
                                           call
                                             ("X64_state.RIP",@{typ "64 word"},
                                              mop(Snd,
                                                  var("state",
                                                      @{typ "(8 word list) \<times> X64_state"})),
                                              @{theory}),mop(Cast(@{typ "64 word"}),var_n"i")))],
                                   mop(Fst,var("state",@{typ "(8 word list) \<times> X64_state"}))),
                               mop(Snd,var("state",@{typ "(8 word list) \<times> X64_state"}))]))]),
                tp[lnl(@{typ "8 word"}),var("state",@{typ X64_state})])),
         tp[mop(Fst,var("s",@{typ "(8 word list) \<times> X64_state"})),
            var("s",@{typ "(8 word list) \<times> X64_state"})]),
      tp[var("r",@{typ "8 word list"}),mop(Snd,var("s1",@{typ "(8 word list) \<times> X64_state"}))]))

val () = function
  ("x64_next",var("state",@{typ X64_state}),
   cs(call
        ("x64_decode",@{typ Zinst},
         mop(Fst,
             apply
               (const
                  ("x64_fetch",@{typ "X64_state \<Rightarrow> ((8 word list) \<times> X64_state)"},
                   @{theory}),var("state",@{typ X64_state}))),@{theory}),
      [(call
          ("Zinst.Zfull_inst",@{typ Zinst},
           tp[var_a(@{typ "8 word list"}),var("i",@{typ instruction}),
              var("strm1",@{typ "8 word list"})],@{theory}),
        apply
          (call
             ("Run",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
              var("i",@{typ instruction}),@{theory}),
           rupd
             ("X64_state.RIP",
              tp[var("state",@{typ X64_state}),
                 bop(Add,
                     call("X64_state.RIP",@{typ "64 word"},var("state",@{typ X64_state}),@{theory}),
                     mop(Cast(@{typ "64 word"}),
                         bop(Sub,ln 20,mop(Length,var("strm1",@{typ "8 word list"})))))],@{theory}))),
       (call("Zinst.Zdec_fail",@{typ Zinst},var_s"s0",@{theory}),
        apply
          (call
             ("raise'exception",@{typ "X64_state \<Rightarrow> (unit \<times> X64_state)"},
              call("exception.FAILURE",@{typ exception},var_s"s0",@{theory}),@{theory}),
           var("state",@{typ X64_state})))],@{context}))

val () = function
  ("e_imm8",var("imm",@{typ "64 word"}),
   ite(bop(And,bop(Le,lw(18446744073709551488,64),var("imm",@{typ "64 word"})),
           bop(Le,var("imm",@{typ "64 word"}),lw(127,64))),
       ll[ex(var("imm",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"})],lnl(@{typ "8 word"})))

val () = function
  ("e_imm16",var("imm",@{typ "64 word"}),
   ite(bop(And,bop(Le,lw(18446744073709518848,64),var("imm",@{typ "64 word"})),
           bop(Le,var("imm",@{typ "64 word"}),lw(32767,64))),
       ll[ex(var("imm",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
          ex(var("imm",@{typ "64 word"}),ln 15,ln 8,@{typ "8 word"})],lnl(@{typ "8 word"})))

val () = function
  ("e_imm32",var("imm",@{typ "64 word"}),
   ite(bop(And,bop(Le,lw(18446744071562067968,64),var("imm",@{typ "64 word"})),
           bop(Le,var("imm",@{typ "64 word"}),lw(2147483647,64))),
       ll[ex(var("imm",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
          ex(var("imm",@{typ "64 word"}),ln 15,ln 8,@{typ "8 word"}),
          ex(var("imm",@{typ "64 word"}),ln 23,ln 16,@{typ "8 word"}),
          ex(var("imm",@{typ "64 word"}),ln 31,ln 24,@{typ "8 word"})],lnl(@{typ "8 word"})))

val () = function
  ("e_imm64",var("imm",@{typ "64 word"}),
   ll[ex(var("imm",@{typ "64 word"}),ln 7,ln 0,@{typ "8 word"}),
      ex(var("imm",@{typ "64 word"}),ln 15,ln 8,@{typ "8 word"}),
      ex(var("imm",@{typ "64 word"}),ln 23,ln 16,@{typ "8 word"}),
      ex(var("imm",@{typ "64 word"}),ln 31,ln 24,@{typ "8 word"}),
      ex(var("imm",@{typ "64 word"}),ln 39,ln 32,@{typ "8 word"}),
      ex(var("imm",@{typ "64 word"}),ln 47,ln 40,@{typ "8 word"}),
      ex(var("imm",@{typ "64 word"}),ln 55,ln 48,@{typ "8 word"}),
      ex(var("imm",@{typ "64 word"}),ln 63,ln 56,@{typ "8 word"})])

val () = function
  ("e_imm",var("imm",@{typ "64 word"}),
   cs(call("e_imm8",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
      [(lnl(@{typ "8 word"}),
        cs(call("e_imm16",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
           [(lnl(@{typ "8 word"}),
             cs(call("e_imm32",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
                [(lnl(@{typ "8 word"}),
                  call("e_imm64",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory})),
                 (var("l",@{typ "8 word list"}),var("l",@{typ "8 word list"}))],@{context})),
            (var("l",@{typ "8 word list"}),var("l",@{typ "8 word list"}))],@{context})),
       (var("l",@{typ "8 word list"}),var("l",@{typ "8 word list"}))],@{context}))

val () = function
  ("e_imm_8_32",var("imm",@{typ "64 word"}),
   cs(call("e_imm8",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
      [(lnl(@{typ "8 word"}),
        cs(call("e_imm32",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
           [(lnl(@{typ "8 word"}),tp[ln 8,lnl(@{typ "8 word"})]),
            (var("l",@{typ "8 word list"}),tp[ln 4,var("l",@{typ "8 word list"})])],@{context})),
       (var("l",@{typ "8 word list"}),tp[ln 1,var("l",@{typ "8 word list"})])],@{context}))

val () = function
  ("e_ModRM",tp[var("r",@{typ "4 word"}),var("rm",@{typ Zrm})],
   cs(var("rm",@{typ Zrm}),
      [(call
          ("Zrm.Zm",@{typ Zrm},
           tp[lo(@{typ "2 word \<times> Zreg"}),Term.Const(@{const_name "ZripBase"},@{typ Zbase}),
              var("displacement",@{typ "64 word"})],@{theory}),
        tp[cc[lw(0,1),ex(var("r",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"}),lw(0,2)],
           llc([cc[lw(0,2),ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),lw(5,3)]],
               call("e_imm32",@{typ "8 word list"},var("displacement",@{typ "64 word"}),@{theory}))]),
       (call("Zrm.Zr",@{typ Zrm},var("rm",@{typ Zreg}),@{theory}),
        let'
          (var("rm",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("rm",@{typ Zreg})),
           tp[cc[lw(0,1),ex(var("r",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"}),lw(0,1),
                 ex(var("rm",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"})],
              ll[cc[lw(3,2),ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),
                    ex(var("rm",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"})]]])),
       (call
          ("Zrm.Zm",@{typ Zrm},
           tp[lo(@{typ "2 word \<times> Zreg"}),Term.Const(@{const_name "ZnoBase"},@{typ Zbase}),
              var("imm",@{typ "64 word"})],@{theory}),
        cs(call("e_imm32",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
           [(lnl(@{typ "8 word"}),tp[lx(@{typ "4 word"}),lnl(@{typ "8 word"})]),
            (var("l",@{typ "8 word list"}),
             tp[cc[lw(0,1),ex(var("r",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"}),lw(0,2)],
                cc[ll[cc[lw(0,2),ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),lw(4,3)],
                      lw(37,8)],var("l",@{typ "8 word list"})]])],@{context})),
       (call
          ("Zrm.Zm",@{typ Zrm},
           tp[mop(Some,tp[var("ss",@{typ "2 word"}),var("index",@{typ Zreg})]),
              Term.Const(@{const_name "ZnoBase"},@{typ Zbase}),var("imm",@{typ "64 word"})],
           @{theory}),
        let'
          (var("i",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("index",@{typ Zreg})),
           cs(call("e_imm32",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
              [(lnl(@{typ "8 word"}),tp[lx(@{typ "4 word"}),lnl(@{typ "8 word"})]),
               (var("l",@{typ "8 word list"}),
                tp[cc[lw(0,1),ex(var("r",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"}),
                      ex(var("i",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"}),lw(0,1)],
                   cc[ll[cc[lw(0,2),ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),lw(4,3)],
                         cc[var("ss",@{typ "2 word"}),
                            ex(var("i",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),lw(5,3)]],
                      var("l",@{typ "8 word list"})]])],@{context}))),
       (call
          ("Zrm.Zm",@{typ Zrm},
           tp[mop(Some,tp[var("ss",@{typ "2 word"}),var("index",@{typ Zreg})]),
              call("Zbase.ZregBase",@{typ Zbase},var("base",@{typ Zreg}),@{theory}),
              var("imm",@{typ "64 word"})],@{theory}),
        let'
          (var("b",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("base",@{typ Zreg})),
           let'
             (var("i",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("index",@{typ Zreg})),
              let'
                (var("b20",@{typ "3 word"}),ex(var("b",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),
                 let'
                   (tp[var_n"s",var("l",@{typ "8 word list"})],
                    ite(bop(And,eq(var("imm",@{typ "64 word"}),lw(0,64)),
                            mop(Not,eq(var("b20",@{typ "3 word"}),lw(5,3)))),
                        tp[ln 0,lnl(@{typ "8 word"})],
                        call
                          ("e_imm_8_32",@{typ "nat \<times> 8 word list"},
                           var("imm",@{typ "64 word"}),@{theory})),
                    ite(bop(In,var_n"s",sl[ln 0,ln 1,ln 4]),
                        tp[cc[lw(0,1),ex(var("r",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"}),
                              ex(var("i",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"}),
                              ex(var("b",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"})],
                           cc[ll[cc[cs(var_n"s",
                                       [(var_n"v",
                                         itb([(eq(var_n"v",ln 0),lw(0,2)),
                                              (eq(var_n"v",ln 1),lw(1,2))],lw(2,2)))],@{context}),
                                    ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),lw(4,3)],
                                 cc[var("ss",@{typ "2 word"}),
                                    ex(var("i",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),
                                    var("b20",@{typ "3 word"})]],var("l",@{typ "8 word list"})]],
                        tp[lx(@{typ "4 word"}),lnl(@{typ "8 word"})])))))),
       (call
          ("Zrm.Zm",@{typ Zrm},
           tp[lo(@{typ "2 word \<times> Zreg"}),
              call("Zbase.ZregBase",@{typ Zbase},var("base",@{typ Zreg}),@{theory}),
              var("imm",@{typ "64 word"})],@{theory}),
        let'
          (var("base",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("base",@{typ Zreg})),
           let'
             (var("base20",@{typ "3 word"}),
              ex(var("base",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),
              let'
                (tp[var_n"s",var("l",@{typ "8 word list"})],
                 ite(bop(And,eq(var("imm",@{typ "64 word"}),lw(0,64)),
                         mop(Not,eq(var("base20",@{typ "3 word"}),lw(5,3)))),
                     tp[ln 0,lnl(@{typ "8 word"})],
                     call
                       ("e_imm_8_32",@{typ "nat \<times> 8 word list"},var("imm",@{typ "64 word"}),
                        @{theory})),
                 ite(bop(In,var_n"s",sl[ln 0,ln 1,ln 4]),
                     tp[cc[lw(0,1),ex(var("r",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"}),lw(0,1),
                           ex(var("base",@{typ "4 word"}),ln 3,ln 3,@{typ "1 word"})],
                        cc[llc([cc[cs(var_n"s",
                                      [(var_n"v",
                                        itb([(eq(var_n"v",ln 0),lw(0,2)),(eq(var_n"v",ln 1),lw(1,2))],
                                            lw(2,2)))],@{context}),
                                   ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),
                                   var("base20",@{typ "3 word"})]],
                               ite(eq(var("base20",@{typ "3 word"}),lw(4,3)),
                                   ll[cc[lw(4,5),var("base20",@{typ "3 word"})]],
                                   lnl(@{typ "8 word"}))),var("l",@{typ "8 word list"})]],
                     tp[lx(@{typ "4 word"}),lnl(@{typ "8 word"})]))))),
       (var_a(@{typ Zrm}),tp[lx(@{typ "4 word"}),lnl(@{typ "8 word"})])],@{context}))

val () = function
  ("rex_prefix",var("rex",@{typ "4 word"}),
   ite(eq(var("rex",@{typ "4 word"}),lw(0,4)),lnl(@{typ "8 word"}),
       ll[cc[lw(4,4),var("rex",@{typ "4 word"})]]))

val () = function
  ("e_opsize",tp[var("sz",@{typ Zsize}),var("rex",@{typ "4 word"})],
   cs(var("sz",@{typ Zsize}),
      [(call("Zsize.Z8",@{typ Zsize},var_b"have_rex",@{theory}),
        let'
          (var("p",@{typ "8 word list"}),
           call("rex_prefix",@{typ "8 word list"},var("rex",@{typ "4 word"}),@{theory}),
           tp[ite(bop(And,var_b"have_rex",eq(var("p",@{typ "8 word list"}),lnl(@{typ "8 word"}))),
                  ll[lw(64,8)],var("p",@{typ "8 word list"})),lw(0,8)])),
       (Term.Const(@{const_name "Z16"},@{typ Zsize}),
        tp[cc[ll[lw(102,8)],
              call
                ("rex_prefix",@{typ "8 word list"},bop(BAnd,var("rex",@{typ "4 word"}),lw(7,4)),
                 @{theory})],lw(1,8)]),
       (Term.Const(@{const_name "Z32"},@{typ Zsize}),
        tp[call
             ("rex_prefix",@{typ "8 word list"},bop(BAnd,var("rex",@{typ "4 word"}),lw(7,4)),
              @{theory}),lw(1,8)]),
       (Term.Const(@{const_name "Z64"},@{typ Zsize}),
        tp[call
             ("rex_prefix",@{typ "8 word list"},bop(BOr,var("rex",@{typ "4 word"}),lw(8,4)),
              @{theory}),lw(1,8)])],@{context}))

val () = function
  ("e_opsize_imm",
   tp[var("sz",@{typ Zsize}),var("rex",@{typ "4 word"}),var("imm",@{typ "64 word"}),var_b"normal"],
   let'
     (tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"})],
      call
        ("e_opsize",@{typ "(8 word list) \<times> 8 word"},
         tp[var("sz",@{typ Zsize}),var("rex",@{typ "4 word"})],@{theory}),
      cs(ite(bop(And,eq(var("sz",@{typ Zsize}),Term.Const(@{const_name "Z64"},@{typ Zsize})),
                 var_b"normal"),Term.Const(@{const_name "Z32"},@{typ Zsize}),var("sz",@{typ Zsize})),
         [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
           cs(call("e_imm8",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
              [(lnl(@{typ "8 word"}),lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"})),
               (var("l",@{typ "8 word list"}),
                ite(eq(var("v",@{typ "8 word"}),lw(0,8)),
                    mop(Some,
                        tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"}),
                           var("l",@{typ "8 word list"})]),
                    lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"})))],@{context})),
          (Term.Const(@{const_name "Z16"},@{typ Zsize}),
           cs(call("e_imm16",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
              [(lnl(@{typ "8 word"}),lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"})),
               (var("l",@{typ "8 word list"}),
                ite(eq(var("v",@{typ "8 word"}),lw(1,8)),
                    mop(Some,
                        tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"}),
                           var("l",@{typ "8 word list"})]),
                    lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"})))],@{context})),
          (Term.Const(@{const_name "Z32"},@{typ Zsize}),
           cs(call("e_imm32",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
              [(lnl(@{typ "8 word"}),lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"})),
               (var("l",@{typ "8 word list"}),
                ite(eq(var("v",@{typ "8 word"}),lw(1,8)),
                    mop(Some,
                        tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"}),
                           var("l",@{typ "8 word list"})]),
                    lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"})))],@{context})),
          (Term.Const(@{const_name "Z64"},@{typ Zsize}),
           ite(eq(var("v",@{typ "8 word"}),lw(1,8)),
               mop(Some,
                   tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"}),
                      call("e_imm64",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory})]),
               lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"})))],@{context})))

val () = function
  ("e_opc",tp[var("opc1",@{typ "8 word"}),var("opc2",@{typ "3 word"}),var("rm",@{typ Zrm})],
   cs(call
        ("e_ModRM",@{typ "4 word \<times> 8 word list"},
         tp[mop(Cast(@{typ "4 word"}),var("opc2",@{typ "3 word"})),var("rm",@{typ Zrm})],@{theory}),
      [(tp[var_a(@{typ "4 word"}),lnl(@{typ "8 word"})],lnl(@{typ "8 word"})),
       (tp[var("rex",@{typ "4 word"}),var("strm",@{typ "8 word list"})],
        cc[call("rex_prefix",@{typ "8 word list"},var("rex",@{typ "4 word"}),@{theory}),
           llc([var("opc1",@{typ "8 word"})],var("strm",@{typ "8 word list"}))])],@{context}))

val () = function
  ("e_gen_rm_reg",
   tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ "4 word"}),
      var("p",@{typ "8 word list"}),var("opc",@{typ "8 word"}),var("mo",@{typ "8 word option"})],
   cs(call
        ("e_ModRM",@{typ "4 word \<times> 8 word list"},
         tp[var("r",@{typ "4 word"}),var("rm",@{typ Zrm})],@{theory}),
      [(tp[var_a(@{typ "4 word"}),lnl(@{typ "8 word"})],lnl(@{typ "8 word"})),
       (tp[var("rex",@{typ "4 word"}),var("strm",@{typ "8 word list"})],
        let'
          (tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"})],
           call
             ("e_opsize",@{typ "(8 word list) \<times> 8 word"},
              tp[var("sz",@{typ Zsize}),var("rex",@{typ "4 word"})],@{theory}),
           cc[var("prefixes",@{typ "8 word list"}),var("p",@{typ "8 word list"}),
              ll[bop(BOr,var("opc",@{typ "8 word"}),
                     cs(var("mo",@{typ "8 word option"}),
                        [(mop(Some,var("x",@{typ "8 word"})),var("x",@{typ "8 word"})),
                         (lo(@{typ "8 word"}),var("v",@{typ "8 word"}))],@{context}))],
              var("strm",@{typ "8 word list"})]))],@{context}))

val () = function
  ("e_rm_reg",
   tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ "4 word"}),
      var("p",@{typ "8 word list"}),var("opc",@{typ "8 word"})],
   call
     ("e_gen_rm_reg",@{typ "8 word list"},
      tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ "4 word"}),
         var("p",@{typ "8 word list"}),var("opc",@{typ "8 word"}),lo(@{typ "8 word"})],@{theory}))

val () = function
  ("e_rm_imm",
   tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("imm",@{typ "64 word"}),
      var("opc1",@{typ "4 word"}),var("opc2",@{typ "8 word"})],
   cs(call
        ("e_ModRM",@{typ "4 word \<times> 8 word list"},
         tp[var("opc1",@{typ "4 word"}),var("rm",@{typ Zrm})],@{theory}),
      [(tp[var_a(@{typ "4 word"}),lnl(@{typ "8 word"})],lnl(@{typ "8 word"})),
       (tp[var("rex",@{typ "4 word"}),var("strm",@{typ "8 word list"})],
        cs(call
             ("e_opsize_imm",@{typ "((8 word list) \<times> 8 word \<times> 8 word list) option"},
              tp[var("sz",@{typ Zsize}),var("rex",@{typ "4 word"}),var("imm",@{typ "64 word"}),lt],
              @{theory}),
           [(mop(Some,
                 tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"}),
                    var("l",@{typ "8 word list"})]),
             cc[var("prefixes",@{typ "8 word list"}),
                ll[bop(BOr,var("opc2",@{typ "8 word"}),var("v",@{typ "8 word"}))],
                var("strm",@{typ "8 word list"}),var("l",@{typ "8 word list"})]),
            (lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"}),lnl(@{typ "8 word"}))],
           @{context}))],@{context}))

val () = function
  ("e_rm_imm8",
   tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("imm",@{typ "64 word"}),
      var("opc1",@{typ "4 word"}),var("opc2",@{typ "8 word"})],
   cs(call
        ("e_ModRM",@{typ "4 word \<times> 8 word list"},
         tp[var("opc1",@{typ "4 word"}),var("rm",@{typ Zrm})],@{theory}),
      [(tp[var_a(@{typ "4 word"}),lnl(@{typ "8 word"})],lnl(@{typ "8 word"})),
       (tp[var("rex",@{typ "4 word"}),var("strm",@{typ "8 word list"})],
        let'
          (tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"})],
           call
             ("e_opsize",@{typ "(8 word list) \<times> 8 word"},
              tp[var("sz",@{typ Zsize}),var("rex",@{typ "4 word"})],@{theory}),
           cs(call("e_imm8",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
              [(lnl(@{typ "8 word"}),lnl(@{typ "8 word"})),
               (var("l",@{typ "8 word list"}),
                cc[var("prefixes",@{typ "8 word list"}),
                   ll[bop(BOr,var("opc2",@{typ "8 word"}),var("v",@{typ "8 word"}))],
                   var("strm",@{typ "8 word list"}),var("l",@{typ "8 word list"})])],@{context})))],
      @{context}))

val () = function
  ("e_rax_imm",tp[var("sz",@{typ Zsize}),var("imm",@{typ "64 word"}),var("opc",@{typ "8 word"})],
   cs(call
        ("e_opsize_imm",@{typ "((8 word list) \<times> 8 word \<times> 8 word list) option"},
         tp[var("sz",@{typ Zsize}),lw(0,4),var("imm",@{typ "64 word"}),lt],@{theory}),
      [(mop(Some,
            tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"}),
               var("l",@{typ "8 word list"})]),
        cc[var("prefixes",@{typ "8 word list"}),
           ll[bop(BOr,var("opc",@{typ "8 word"}),var("v",@{typ "8 word"}))],
           var("l",@{typ "8 word list"})]),
       (lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"}),lnl(@{typ "8 word"}))],
      @{context}))

val () = function
  ("e_jcc_rel32",var("i",@{typ instruction}),
   cs(var("i",@{typ instruction}),
      [(call
          ("instruction.Zjcc",@{typ instruction},
           tp[var("cond",@{typ Zcond}),var("imm",@{typ "64 word"})],@{theory}),
        cs(tp[call("e_imm32",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
              var("cond",@{typ Zcond})],
           [(tp[lnl(@{typ "8 word"}),var_a(@{typ Zcond})],lnl(@{typ "8 word"})),
            (tp[var("l",@{typ "8 word list"}),lc("Z_ALWAYS","Zcond",@{theory})],
             llc([lw(233,8)],var("l",@{typ "8 word list"}))),
            (tp[var("l",@{typ "8 word list"}),var_a(@{typ Zcond})],
             cc[ll[lw(15,8),cc[lw(8,4),mop(Cast(@{typ "4 word"}),var("cond",@{typ Zcond}))]],
                var("l",@{typ "8 word list"})])],@{context})),
       (var_a(@{typ instruction}),lnl(@{typ "8 word"}))],@{context}))

val () = function
  ("not_byte",var("sz",@{typ Zsize}),
   cs(var("sz",@{typ Zsize}),
      [(call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),lf),(var_a(@{typ Zsize}),lt)],
      @{context}))

val () = function
  ("is_rax",var("rm",@{typ Zrm}),
   cs(var("rm",@{typ Zrm}),
      [(call("Zrm.Zr",@{typ Zrm},lc("RAX","Zreg",@{theory}),@{theory}),lt),(var_a(@{typ Zrm}),lf)],
      @{context}))

val () = function
  ("encode",var("i",@{typ instruction}),
   cs(var("i",@{typ instruction}),
      [(call
          ("instruction.Zbinop",@{typ instruction},
           var("v#0",@{typ "Zbinop_name \<times> Zsize \<times> Zdest_src"}),@{theory}),
        cs(var("v#0",@{typ "Zbinop_name \<times> Zsize \<times> Zdest_src"}),
           [(tp[var("bop",@{typ Zbinop_name}),var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zrm_i",@{typ Zdest_src},
                   tp[var("rm",@{typ Zrm}),var("imm",@{typ "64 word"})],@{theory})],
             ite(eq(var("bop",@{typ Zbinop_name}),lc("Ztest","Zbinop_name",@{theory})),
                 ite(call("is_rax",@{typ bool},var("rm",@{typ Zrm}),@{theory}),
                     call
                       ("e_rax_imm",@{typ "8 word list"},
                        tp[var("sz",@{typ Zsize}),var("imm",@{typ "64 word"}),lw(168,8)],@{theory}),
                     call
                       ("e_rm_imm",@{typ "8 word list"},
                        tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("imm",@{typ "64 word"}),
                           lw(0,4),lw(246,8)],@{theory})),
                 let'
                   (var("opc",@{typ "4 word"}),
                    mop(Cast(@{typ "4 word"}),var("bop",@{typ Zbinop_name})),
                    itb([(bop(Bit,var("opc",@{typ "4 word"}),ln 3),
                          ite(eq(var("imm",@{typ "64 word"}),lw(1,64)),
                              call
                                ("e_rm_reg",@{typ "8 word list"},
                                 tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                                    bop(BAnd,var("opc",@{typ "4 word"}),lw(7,4)),
                                    lnl(@{typ "8 word"}),lw(208,8)],@{theory}),
                              call
                                ("e_rm_imm8",@{typ "8 word list"},
                                 tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                                    var("imm",@{typ "64 word"}),
                                    bop(BAnd,var("opc",@{typ "4 word"}),lw(7,4)),lw(192,8)],
                                 @{theory}))),
                         (bop(And,call("not_byte",@{typ bool},var("sz",@{typ Zsize}),@{theory}),
                              mop(Not,
                                  eq(call
                                       ("e_imm8",@{typ "8 word list"},var("imm",@{typ "64 word"}),
                                        @{theory}),lnl(@{typ "8 word"})))),
                          call
                            ("e_rm_imm8",@{typ "8 word list"},
                             tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                                var("imm",@{typ "64 word"}),var("opc",@{typ "4 word"}),lw(131,8)],
                             @{theory})),
                         (call("is_rax",@{typ bool},var("rm",@{typ Zrm}),@{theory}),
                          call
                            ("e_rax_imm",@{typ "8 word list"},
                             tp[var("sz",@{typ Zsize}),var("imm",@{typ "64 word"}),
                                cc[lw(0,2),ex(var("opc",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),
                                   lw(4,3)]],@{theory}))],
                        call
                          ("e_rm_imm",@{typ "8 word list"},
                           tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                              var("imm",@{typ "64 word"}),var("opc",@{typ "4 word"}),lw(128,8)],
                           @{theory}))))),
            (tp[var("bop",@{typ Zbinop_name}),var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zrm_r",@{typ Zdest_src},tp[var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
                   @{theory})],
             ite(eq(var("bop",@{typ Zbinop_name}),lc("Ztest","Zbinop_name",@{theory})),
                 call
                   ("e_rm_reg",@{typ "8 word list"},
                    tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                       mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),lnl(@{typ "8 word"}),
                       lw(132,8)],@{theory}),
                 let'
                   (var("opc",@{typ "4 word"}),
                    mop(Cast(@{typ "4 word"}),var("bop",@{typ Zbinop_name})),
                    ite(bop(Bit,var("opc",@{typ "4 word"}),ln 3),
                        ite(eq(var("r",@{typ Zreg}),lc("RCX","Zreg",@{theory})),
                            call
                              ("e_rm_reg",@{typ "8 word list"},
                               tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                                  bop(BAnd,var("opc",@{typ "4 word"}),lw(7,4)),lnl(@{typ "8 word"}),
                                  lw(210,8)],@{theory}),lnl(@{typ "8 word"})),
                        call
                          ("e_rm_reg",@{typ "8 word list"},
                           tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                              mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),lnl(@{typ "8 word"}),
                              cc[lw(0,2),ex(var("opc",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),
                                 lw(0,3)]],@{theory}))))),
            (tp[var("bop",@{typ Zbinop_name}),var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var("r",@{typ Zreg}),var("rm",@{typ Zrm})],
                   @{theory})],
             let'
               (var("opc",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("bop",@{typ Zbinop_name})),
                ite(bop(Bit,var("opc",@{typ "4 word"}),ln 3),lnl(@{typ "8 word"}),
                    call
                      ("e_rm_reg",@{typ "8 word list"},
                       tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                          mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),lnl(@{typ "8 word"}),
                          cc[lw(0,2),ex(var("opc",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"}),
                             lw(2,3)]],@{theory}))))],@{context})),
       (call("instruction.Zcall",@{typ instruction},var("v#1",@{typ Zimm_rm}),@{theory}),
        cs(var("v#1",@{typ Zimm_rm}),
           [(call("Zimm_rm.Zrm",@{typ Zimm_rm},var("rm",@{typ Zrm}),@{theory}),
             call("e_opc",@{typ "8 word list"},tp[lw(255,8),lw(2,3),var("rm",@{typ Zrm})],@{theory})),
            (call("Zimm_rm.Zimm",@{typ Zimm_rm},var("imm",@{typ "64 word"}),@{theory}),
             cs(call("e_imm32",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
                [(lnl(@{typ "8 word"}),lnl(@{typ "8 word"})),
                 (var("l",@{typ "8 word list"}),llc([lw(232,8)],var("l",@{typ "8 word list"})))],
                @{context}))],@{context})),
       (call
          ("instruction.Zcmpxchg",@{typ instruction},
           var("v#2",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
        cs(var("v#2",@{typ "Zsize \<times> Zrm \<times> Zreg"}),
           [(tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                   mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),ll[lw(15,8)],lw(176,8)],@{theory}))],
           @{context})),
       (call("instruction.Zdiv",@{typ instruction},var("v#3",@{typ "Zsize \<times> Zrm"}),@{theory}),
        cs(var("v#3",@{typ "Zsize \<times> Zrm"}),
           [(tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),lw(6,4),lnl(@{typ "8 word"}),
                   lw(246,8)],@{theory}))],@{context})),
       (call
          ("instruction.Zjcc",@{typ instruction},var("v#4",@{typ "Zcond \<times> 64 word"}),
           @{theory}),
        cs(var("v#4",@{typ "Zcond \<times> 64 word"}),
           [(tp[var("cond",@{typ Zcond}),var("imm",@{typ "64 word"})],
             let'
               (tp[var_n"s",var("l",@{typ "8 word list"})],
                call
                  ("e_imm_8_32",@{typ "nat \<times> 8 word list"},var("imm",@{typ "64 word"}),
                   @{theory}),
                itb([(eq(var("cond",@{typ Zcond}),lc("Z_ALWAYS","Zcond",@{theory})),
                      itb([(eq(var_n"s",ln 1),llc([lw(235,8)],var("l",@{typ "8 word list"}))),
                           (eq(var_n"s",ln 4),llc([lw(233,8)],var("l",@{typ "8 word list"})))],
                          lnl(@{typ "8 word"}))),
                     (eq(var_n"s",ln 1),
                      llc([cc[lw(7,4),mop(Cast(@{typ "4 word"}),var("cond",@{typ Zcond}))]],
                          var("l",@{typ "8 word list"}))),
                     (eq(var_n"s",ln 4),
                      cc[ll[lw(15,8),cc[lw(8,4),mop(Cast(@{typ "4 word"}),var("cond",@{typ Zcond}))]],
                         var("l",@{typ "8 word list"})])],lnl(@{typ "8 word"}))))],@{context})),
       (call("instruction.Zjmp",@{typ instruction},var("v#5",@{typ Zrm}),@{theory}),
        call("e_opc",@{typ "8 word list"},tp[lw(255,8),lw(4,3),var("v#5",@{typ Zrm})],@{theory})),
       (call
          ("instruction.Zlea",@{typ instruction},var("v#6",@{typ "Zsize \<times> Zdest_src"}),
           @{theory}),
        cs(var("v#6",@{typ "Zsize \<times> Zdest_src"}),
           [(tp[call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),var_a(@{typ Zdest_src})],
             lnl(@{typ "8 word"})),
            (tp[var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zr_rm",@{typ Zdest_src},
                   tp[var("r",@{typ Zreg}),
                      call
                        ("Zrm.Zm",@{typ Zrm},
                         var("m",
                             @{typ
                             "((2 word \<times> Zreg) option) \<times> Zbase \<times> 64 word"}),
                         @{theory})],@{theory})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),
                   call
                     ("Zrm.Zm",@{typ Zrm},
                      var("m",
                          @{typ "((2 word \<times> Zreg) option) \<times> Zbase \<times> 64 word"}),
                      @{theory}),mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),
                   lnl(@{typ "8 word"}),lw(141,8)],@{theory})),
            (var_a(@{typ "Zsize \<times> Zdest_src"}),lnl(@{typ "8 word"}))],@{context})),
       (Term.Const(@{const_name "Zleave"},@{typ instruction}),ll[lw(201,8)]),
       (call
          ("instruction.Zloop",@{typ instruction},var("v#7",@{typ "Zcond \<times> 64 word"}),
           @{theory}),
        cs(var("v#7",@{typ "Zcond \<times> 64 word"}),
           [(tp[var("cond",@{typ Zcond}),var("imm",@{typ "64 word"})],
             cs(tp[var("cond",@{typ Zcond}),
                   call("e_imm8",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory})],
                [(tp[var_a(@{typ Zcond}),lnl(@{typ "8 word"})],lnl(@{typ "8 word"})),
                 (tp[lc("Z_NE","Zcond",@{theory}),var("l",@{typ "8 word list"})],
                  llc([lw(224,8)],var("l",@{typ "8 word list"}))),
                 (tp[lc("Z_E","Zcond",@{theory}),var("l",@{typ "8 word list"})],
                  llc([lw(225,8)],var("l",@{typ "8 word list"}))),
                 (tp[lc("Z_ALWAYS","Zcond",@{theory}),var("l",@{typ "8 word list"})],
                  llc([lw(226,8)],var("l",@{typ "8 word list"}))),
                 (var_a(@{typ "Zcond \<times> 8 word list"}),lnl(@{typ "8 word"}))],@{context}))],
           @{context})),
       (call
          ("instruction.Zmonop",@{typ instruction},
           var("v#8",@{typ "Zmonop_name \<times> Zsize \<times> Zrm"}),@{theory}),
        cs(var("v#8",@{typ "Zmonop_name \<times> Zsize \<times> Zrm"}),
           [(tp[lc("Zinc","Zmonop_name",@{theory}),
                call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),var("rm",@{typ Zrm})],
             call("e_opc",@{typ "8 word list"},tp[lw(254,8),lw(0,3),var("rm",@{typ Zrm})],@{theory})),
            (tp[lc("Zdec","Zmonop_name",@{theory}),
                call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),var("rm",@{typ Zrm})],
             call("e_opc",@{typ "8 word list"},tp[lw(254,8),lw(1,3),var("rm",@{typ Zrm})],@{theory})),
            (tp[lc("Zinc","Zmonop_name",@{theory}),var("sz",@{typ Zsize}),var("rm",@{typ Zrm})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),lw(0,4),lnl(@{typ "8 word"}),
                   lw(255,8)],@{theory})),
            (tp[lc("Zdec","Zmonop_name",@{theory}),var("sz",@{typ Zsize}),var("rm",@{typ Zrm})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),lw(1,4),lnl(@{typ "8 word"}),
                   lw(255,8)],@{theory})),
            (tp[lc("Znot","Zmonop_name",@{theory}),var("sz",@{typ Zsize}),var("rm",@{typ Zrm})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),lw(2,4),lnl(@{typ "8 word"}),
                   lw(246,8)],@{theory})),
            (tp[lc("Zneg","Zmonop_name",@{theory}),var("sz",@{typ Zsize}),var("rm",@{typ Zrm})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),lw(3,4),lnl(@{typ "8 word"}),
                   lw(246,8)],@{theory}))],@{context})),
       (call
          ("instruction.Zmov",@{typ instruction},
           var("v#9",@{typ "Zcond \<times> Zsize \<times> Zdest_src"}),@{theory}),
        cs(var("v#9",@{typ "Zcond \<times> Zsize \<times> Zdest_src"}),
           [(tp[lc("Z_ALWAYS","Zcond",@{theory}),var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zrm_r",@{typ Zdest_src},tp[var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
                   @{theory})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                   mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),lnl(@{typ "8 word"}),lw(136,8)],
                @{theory})),
            (tp[lc("Z_ALWAYS","Zcond",@{theory}),var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var("r",@{typ Zreg}),var("rm",@{typ Zrm})],
                   @{theory})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                   mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),lnl(@{typ "8 word"}),lw(138,8)],
                @{theory})),
            (tp[lc("Z_ALWAYS","Zcond",@{theory}),var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zrm_i",@{typ Zdest_src},
                   tp[call("Zrm.Zr",@{typ Zrm},var("reg",@{typ Zreg}),@{theory}),
                      var("imm",@{typ "64 word"})],@{theory})],
             let'
               (var("r",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("reg",@{typ Zreg})),
                cs(call
                     ("e_opsize_imm",
                      @{typ "((8 word list) \<times> 8 word \<times> 8 word list) option"},
                      tp[var("sz",@{typ Zsize}),
                         ite(bop(Bit,var("r",@{typ "4 word"}),ln 3),lw(1,4),lw(0,4)),
                         var("imm",@{typ "64 word"}),lf],@{theory}),
                   [(mop(Some,
                         tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"}),
                            var("l",@{typ "8 word list"})]),
                     cc[var("prefixes",@{typ "8 word list"}),
                        ll[cc[lw(11,4),mop(Cast(@{typ "1 word"}),var("v",@{typ "8 word"})),
                              ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"})]],
                        var("l",@{typ "8 word list"})]),
                    (lo(@{typ "(8 word list) \<times> 8 word \<times> 8 word list"}),
                     lnl(@{typ "8 word"}))],@{context}))),
            (tp[lc("Z_ALWAYS","Zcond",@{theory}),var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zrm_i",@{typ Zdest_src},
                   tp[var("rm",@{typ Zrm}),var("imm",@{typ "64 word"})],@{theory})],
             call
               ("e_rm_imm",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("imm",@{typ "64 word"}),lw(0,4),
                   lw(198,8)],@{theory})),
            (tp[var("cond",@{typ Zcond}),call("Zsize.Z8",@{typ Zsize},var_a(@{typ bool}),@{theory}),
                var_a(@{typ Zdest_src})],lnl(@{typ "8 word"})),
            (tp[var("cond",@{typ Zcond}),var("sz",@{typ Zsize}),
                call
                  ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var("r",@{typ Zreg}),var("rm",@{typ Zrm})],
                   @{theory})],
             call
               ("e_gen_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                   mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),ll[lw(15,8)],lw(64,8),
                   mop(Some,mop(Cast(@{typ "8 word"}),var("cond",@{typ Zcond})))],@{theory})),
            (var_a(@{typ "Zcond \<times> Zsize \<times> Zdest_src"}),lnl(@{typ "8 word"}))],
           @{context})),
       (call
          ("instruction.Zmovsx",@{typ instruction},
           var("v#10",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory}),
        cs(var("v#10",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),
           [(tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),
                call
                  ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var("r",@{typ Zreg}),var("rm",@{typ Zrm})],
                   @{theory}),Term.Const(@{const_name "Z64"},@{typ Zsize})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("rm",@{typ Zrm}),
                   mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),lnl(@{typ "8 word"}),lw(99,8)],
                @{theory})),
            (tp[var("sz1",@{typ Zsize}),
                call
                  ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var("r",@{typ Zreg}),var("rm",@{typ Zrm})],
                   @{theory}),var("sz2",@{typ Zsize})],
             ite(bop(Lt,call("Zsize_width",@{typ nat},var("sz1",@{typ Zsize}),@{theory}),
                     call("Zsize_width",@{typ nat},var("sz2",@{typ Zsize}),@{theory})),
                 call
                   ("e_gen_rm_reg",@{typ "8 word list"},
                    tp[var("sz2",@{typ Zsize}),var("rm",@{typ Zrm}),
                       mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),ll[lw(15,8)],lw(190,8),
                       mop(Some,
                           ite(eq(var("sz1",@{typ Zsize}),
                                  Term.Const(@{const_name "Z16"},@{typ Zsize})),lw(1,8),lw(0,8)))],
                    @{theory}),lnl(@{typ "8 word"}))),
            (var_a(@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),lnl(@{typ "8 word"}))],
           @{context})),
       (call
          ("instruction.Zmovzx",@{typ instruction},
           var("v#11",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory}),
        cs(var("v#11",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),
           [(tp[var("sz1",@{typ Zsize}),
                call
                  ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var("r",@{typ Zreg}),var("rm",@{typ Zrm})],
                   @{theory}),var("sz2",@{typ Zsize})],
             ite(bop(And,
                     bop(Lt,call("Zsize_width",@{typ nat},var("sz1",@{typ Zsize}),@{theory}),
                         call("Zsize_width",@{typ nat},var("sz2",@{typ Zsize}),@{theory})),
                     mop(Not,
                         eq(var("sz1",@{typ Zsize}),Term.Const(@{const_name "Z32"},@{typ Zsize})))),
                 call
                   ("e_gen_rm_reg",@{typ "8 word list"},
                    tp[var("sz2",@{typ Zsize}),var("rm",@{typ Zrm}),
                       mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),ll[lw(15,8)],lw(182,8),
                       mop(Some,
                           ite(eq(var("sz1",@{typ Zsize}),
                                  Term.Const(@{const_name "Z16"},@{typ Zsize})),lw(1,8),lw(0,8)))],
                    @{theory}),lnl(@{typ "8 word"}))),
            (var_a(@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),lnl(@{typ "8 word"}))],
           @{context})),
       (call
          ("instruction.Zmul",@{typ instruction},var("v#12",@{typ "Zsize \<times> Zrm"}),@{theory}),
        cs(var("v#12",@{typ "Zsize \<times> Zrm"}),
           [(tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),lw(4,4),lnl(@{typ "8 word"}),
                   lw(246,8)],@{theory}))],@{context})),
       (Term.Const(@{const_name "Znop"},@{typ instruction}),ll[lw(144,8)]),
       (call("instruction.Zpop",@{typ instruction},var("v#13",@{typ Zrm}),@{theory}),
        cs(var("v#13",@{typ Zrm}),
           [(call("Zrm.Zr",@{typ Zrm},var("reg",@{typ Zreg}),@{theory}),
             let'
               (var("r",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("reg",@{typ Zreg})),
                cc[ite(bop(Bit,var("r",@{typ "4 word"}),ln 3),ll[lw(73,8)],lnl(@{typ "8 word"})),
                   ll[cc[lw(11,5),ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"})]]])),
            (var("rm",@{typ Zrm}),
             call("e_opc",@{typ "8 word list"},tp[lw(143,8),lw(0,3),var("rm",@{typ Zrm})],@{theory}))],
           @{context})),
       (call("instruction.Zpush",@{typ instruction},var("v#14",@{typ Zimm_rm}),@{theory}),
        cs(var("v#14",@{typ Zimm_rm}),
           [(call
               ("Zimm_rm.Zrm",@{typ Zimm_rm},
                call("Zrm.Zr",@{typ Zrm},var("reg",@{typ Zreg}),@{theory}),@{theory}),
             let'
               (var("r",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("reg",@{typ Zreg})),
                cc[ite(bop(Bit,var("r",@{typ "4 word"}),ln 3),ll[lw(73,8)],lnl(@{typ "8 word"})),
                   ll[cc[lw(10,5),ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"})]]])),
            (call("Zimm_rm.Zrm",@{typ Zimm_rm},var("rm",@{typ Zrm}),@{theory}),
             call("e_opc",@{typ "8 word list"},tp[lw(255,8),lw(6,3),var("rm",@{typ Zrm})],@{theory})),
            (call("Zimm_rm.Zimm",@{typ Zimm_rm},var("imm",@{typ "64 word"}),@{theory}),
             let'
               (tp[var_n"s",var("l",@{typ "8 word list"})],
                call
                  ("e_imm_8_32",@{typ "nat \<times> 8 word list"},var("imm",@{typ "64 word"}),
                   @{theory}),
                itb([(eq(var_n"s",ln 1),llc([lw(106,8)],var("l",@{typ "8 word list"}))),
                     (eq(var_n"s",ln 4),llc([lw(104,8)],var("l",@{typ "8 word list"})))],
                    lnl(@{typ "8 word"}))))],@{context})),
       (call("instruction.Zret",@{typ instruction},var("v#15",@{typ "64 word"}),@{theory}),
        cs(var("v#15",@{typ "64 word"}),
           [(var("imm",@{typ "64 word"}),
             ite(eq(var("imm",@{typ "64 word"}),lw(0,64)),ll[lw(195,8)],
                 cs(call("e_imm16",@{typ "8 word list"},var("imm",@{typ "64 word"}),@{theory}),
                    [(lnl(@{typ "8 word"}),lnl(@{typ "8 word"})),
                     (var("l",@{typ "8 word list"}),llc([lw(194,8)],var("l",@{typ "8 word list"})))],
                    @{context})))],@{context})),
       (call
          ("instruction.Zxadd",@{typ instruction},
           var("v#16",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
        cs(var("v#16",@{typ "Zsize \<times> Zrm \<times> Zreg"}),
           [(tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
             call
               ("e_rm_reg",@{typ "8 word list"},
                tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                   mop(Cast(@{typ "4 word"}),var("r",@{typ Zreg})),ll[lw(15,8)],lw(192,8)],@{theory}))],
           @{context})),
       (call
          ("instruction.Zxchg",@{typ instruction},
           var("v#17",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
        cs(var("v#17",@{typ "Zsize \<times> Zrm \<times> Zreg"}),
           [(tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
             ite(bop(And,call("not_byte",@{typ bool},var("sz",@{typ Zsize}),@{theory}),
                     bop(Or,eq(var("reg",@{typ Zreg}),lc("RAX","Zreg",@{theory})),
                         call("is_rax",@{typ bool},var("rm",@{typ Zrm}),@{theory}))),
                 let'
                   (var("r",@{typ "4 word"}),mop(Cast(@{typ "4 word"}),var("reg",@{typ Zreg})),
                    let'
                      (tp[var("prefixes",@{typ "8 word list"}),var("v",@{typ "8 word"})],
                       call
                         ("e_opsize",@{typ "(8 word list) \<times> 8 word"},
                          tp[var("sz",@{typ Zsize}),
                             ite(bop(Bit,var("r",@{typ "4 word"}),ln 3),lw(1,4),lw(0,4))],@{theory}),
                       ite(eq(var("v",@{typ "8 word"}),lw(1,8)),
                           cc[var("prefixes",@{typ "8 word list"}),
                              ll[cc[lw(18,5),ex(var("r",@{typ "4 word"}),ln 2,ln 0,@{typ "3 word"})]]],
                           lnl(@{typ "8 word"})))),
                 call
                   ("e_rm_reg",@{typ "8 word list"},
                    tp[var("sz",@{typ Zsize}),var("rm",@{typ Zrm}),
                       mop(Cast(@{typ "4 word"}),var("reg",@{typ Zreg})),lnl(@{typ "8 word"}),
                       lw(134,8)],@{theory})))],@{context}))],@{context}))
end
\<close>
termination raise'exception by lexicographic_order
termination mem8 by lexicographic_order
termination write'mem8 by lexicographic_order
termination mem16 by lexicographic_order
termination write'mem16 by lexicographic_order
termination mem32 by lexicographic_order
termination write'mem32 by lexicographic_order
termination mem64 by lexicographic_order
termination write'mem64 by lexicographic_order
termination Eflag by lexicographic_order
termination write'Eflag by lexicographic_order
termination FlagUnspecified by lexicographic_order
termination CF by lexicographic_order
termination write'CF by lexicographic_order
termination PF by lexicographic_order
termination write'PF by lexicographic_order
termination AF by lexicographic_order
termination write'AF by lexicographic_order
termination ZF by lexicographic_order
termination write'ZF by lexicographic_order
termination SF by lexicographic_order
termination write'SF by lexicographic_order
termination OF by lexicographic_order
termination write'OF by lexicographic_order
termination ea_index by lexicographic_order
termination ea_base by lexicographic_order
termination ea_Zrm by lexicographic_order
termination ea_Zdest by lexicographic_order
termination ea_Zsrc by lexicographic_order
termination ea_Zimm_rm by lexicographic_order
termination restrictSize by lexicographic_order
termination EA by lexicographic_order
termination write'EA by lexicographic_order
termination read_dest_src_ea by lexicographic_order
termination call_dest_from_ea by lexicographic_order
termination get_ea_address by lexicographic_order
termination jump_to_ea by lexicographic_order
termination ByteParity by lexicographic_order
termination Zsize_width by lexicographic_order
termination word_size_msb by lexicographic_order
termination write_PF by lexicographic_order
termination write_SF by lexicographic_order
termination write_ZF by lexicographic_order
termination write_logical_eflags by lexicographic_order
termination write_arith_eflags_except_CF_OF by lexicographic_order
termination write_arith_eflags by lexicographic_order
termination erase_eflags by lexicographic_order
termination value_width by lexicographic_order
termination word_signed_overflow_add by lexicographic_order
termination word_signed_overflow_sub by lexicographic_order
termination add_with_carry_out by lexicographic_order
termination sub_with_borrow by lexicographic_order
termination write_arith_result by lexicographic_order
termination write_arith_result_no_CF_OF by lexicographic_order
termination write_logical_result by lexicographic_order
termination write_result_erase_eflags by lexicographic_order
termination SignExtension by lexicographic_order
termination maskShift by lexicographic_order
termination ROL by lexicographic_order
termination ROR by lexicographic_order
termination SAR by lexicographic_order
termination write_binop by lexicographic_order
termination write_monop by lexicographic_order
termination read_cond by lexicographic_order
termination x64_pop_aux by lexicographic_order
termination x64_pop by lexicographic_order
termination x64_pop_rip by lexicographic_order
termination x64_push_aux by lexicographic_order
termination x64_push by lexicographic_order
termination x64_push_rip by lexicographic_order
termination x64_drop by lexicographic_order
termination dfn'Zbinop by lexicographic_order
termination dfn'Zcall by lexicographic_order
termination dfn'Zcmpxchg by lexicographic_order
termination dfn'Zdiv by lexicographic_order
termination dfn'Zjcc by lexicographic_order
termination dfn'Zjmp by lexicographic_order
termination dfn'Zlea by lexicographic_order
termination dfn'Zleave by lexicographic_order
termination dfn'Zloop by lexicographic_order
termination dfn'Zmonop by lexicographic_order
termination dfn'Zmov by lexicographic_order
termination dfn'Zmovsx by lexicographic_order
termination dfn'Zmovzx by lexicographic_order
termination dfn'Zmul by lexicographic_order
termination dfn'Zpop by lexicographic_order
termination dfn'Zpush by lexicographic_order
termination dfn'Zret by lexicographic_order
termination dfn'Zxadd by lexicographic_order
termination dfn'Zxchg by lexicographic_order
termination Run by lexicographic_order
termination immediate8 by lexicographic_order
termination immediate16 by lexicographic_order
termination immediate32 by lexicographic_order
termination immediate64 by lexicographic_order
termination immediate by lexicographic_order
termination full_immediate by lexicographic_order
termination rec'REX by lexicographic_order
termination reg'REX by lexicographic_order
termination write'rec'REX by lexicographic_order
termination write'reg'REX by lexicographic_order
termination RexReg by lexicographic_order
termination readDisplacement by lexicographic_order
termination readSibDisplacement by lexicographic_order
termination readSIB by lexicographic_order
termination readModRM by lexicographic_order
termination readOpcodeModRM by lexicographic_order
termination prefixGroup by lexicographic_order
termination readPrefix by lexicographic_order
termination readPrefixes by lexicographic_order
termination OpSize by lexicographic_order
termination isZm by lexicographic_order
termination x64_decode by lexicographic_order
termination x64_fetch by lexicographic_order
termination x64_next by lexicographic_order
termination e_imm8 by lexicographic_order
termination e_imm16 by lexicographic_order
termination e_imm32 by lexicographic_order
termination e_imm64 by lexicographic_order
termination e_imm by lexicographic_order
termination e_imm_8_32 by lexicographic_order
termination e_ModRM by lexicographic_order
termination rex_prefix by lexicographic_order
termination e_opsize by lexicographic_order
termination e_opsize_imm by lexicographic_order
termination e_opc by lexicographic_order
termination e_gen_rm_reg by lexicographic_order
termination e_rm_reg by lexicographic_order
termination e_rm_imm by lexicographic_order
termination e_rm_imm8 by lexicographic_order
termination e_rax_imm by lexicographic_order
termination e_jcc_rel32 by lexicographic_order
termination not_byte by lexicographic_order
termination is_rax by lexicographic_order
termination encode by lexicographic_order
end