// SPDX-License-Identifier: GPL-2.0-only
/*
 * Spreadtrum pin controller driver
 * Copyright (C) 2017 Spreadtrum  - http://www.spreadtrum.com
 */

#include <linux/module.h>
#include <linux/mod_devicetable.h>
#include <linux/platform_device.h>

#include "pinctrl-sprd.h"

enum sprd_sc9860_pins {
	/* pin global control register 0 */
	SC9860_VIO28_0_IRTE = SPRD_PIN_INFO(0, GLOBAL_CTRL_PIN, 11, 1, 0),
	SC9860_VIO_SD2_IRTE = SPRD_PIN_INFO(1, GLOBAL_CTRL_PIN, 10, 1, 0),
	SC9860_VIO_SD0_IRTE = SPRD_PIN_INFO(2, GLOBAL_CTRL_PIN, 9, 1, 0),
	SC9860_VIO_SIM2_IRTE = SPRD_PIN_INFO(3, GLOBAL_CTRL_PIN, 8, 1, 0),
	SC9860_VIO_SIM1_IRTE = SPRD_PIN_INFO(4, GLOBAL_CTRL_PIN, 7, 1, 0),
	SC9860_VIO_SIM0_IRTE = SPRD_PIN_INFO(5, GLOBAL_CTRL_PIN, 6, 1, 0),
	SC9860_VIO28_0_MS = SPRD_PIN_INFO(6, GLOBAL_CTRL_PIN, 5, 1, 0),
	SC9860_VIO_SD2_MS = SPRD_PIN_INFO(7, GLOBAL_CTRL_PIN, 4, 1, 0),
	SC9860_VIO_SD0_MS = SPRD_PIN_INFO(8, GLOBAL_CTRL_PIN, 3, 1, 0),
	SC9860_VIO_SIM2_MS = SPRD_PIN_INFO(9, GLOBAL_CTRL_PIN, 2, 1, 0),
	SC9860_VIO_SIM1_MS = SPRD_PIN_INFO(10, GLOBAL_CTRL_PIN, 1, 1, 0),
	SC9860_VIO_SIM0_MS = SPRD_PIN_INFO(11, GLOBAL_CTRL_PIN, 0, 1, 0),

	/* pin global control register 2 */
	SC9860_SPSPI_PIN_IN_SEL = SPRD_PIN_INFO(12, GLOBAL_CTRL_PIN, 31, 1, 2),
	SC9860_UART1_USB30_PHY_SEL = SPRD_PIN_INFO(13, GLOBAL_CTRL_PIN, 30, 1, 2),
	SC9860_USB30_PHY_DM_OE = SPRD_PIN_INFO(14, GLOBAL_CTRL_PIN, 29, 1, 2),
	SC9860_USB30_PHY_DP_OE = SPRD_PIN_INFO(15, GLOBAL_CTRL_PIN, 28, 1, 2),
	SC9860_UART5_SYS_SEL = SPRD_PIN_INFO(16, GLOBAL_CTRL_PIN, 25, 3, 2),
	SC9860_ORP_URXD_PIN_IN_SEL = SPRD_PIN_INFO(17, GLOBAL_CTRL_PIN, 24, 1, 2),
	SC9860_SIM2_SYS_SEL = SPRD_PIN_INFO(18, GLOBAL_CTRL_PIN, 23, 1, 2),
	SC9860_SIM1_SYS_SEL = SPRD_PIN_INFO(19, GLOBAL_CTRL_PIN, 22, 1, 2),
	SC9860_SIM0_SYS_SEL = SPRD_PIN_INFO(20, GLOBAL_CTRL_PIN, 21, 1, 2),
	SC9860_CLK26MHZ_BUF_OUT_SEL = SPRD_PIN_INFO(21, GLOBAL_CTRL_PIN, 20, 1, 2),
	SC9860_UART4_SYS_SEL = SPRD_PIN_INFO(22, GLOBAL_CTRL_PIN, 16, 3, 2),
	SC9860_UART3_SYS_SEL = SPRD_PIN_INFO(23, GLOBAL_CTRL_PIN, 13, 3, 2),
	SC9860_UART2_SYS_SEL = SPRD_PIN_INFO(24, GLOBAL_CTRL_PIN, 10, 3, 2),
	SC9860_UART1_SYS_SEL = SPRD_PIN_INFO(25, GLOBAL_CTRL_PIN, 7, 3, 2),
	SC9860_UART0_SYS_SEL = SPRD_PIN_INFO(26, GLOBAL_CTRL_PIN, 4, 3, 2),
	SC9860_UART24_LOOP_SEL = SPRD_PIN_INFO(27, GLOBAL_CTRL_PIN, 3, 1, 2),
	SC9860_UART23_LOOP_SEL = SPRD_PIN_INFO(28, GLOBAL_CTRL_PIN, 2, 1, 2),
	SC9860_UART14_LOOP_SEL = SPRD_PIN_INFO(29, GLOBAL_CTRL_PIN, 1, 1, 2),
	SC9860_UART13_LOOP_SEL = SPRD_PIN_INFO(30, GLOBAL_CTRL_PIN, 0, 1, 2),

	/* pin global control register 3 */
	SC9860_IIS3_SYS_SEL = SPRD_PIN_INFO(31, GLOBAL_CTRL_PIN, 18, 4, 3),
	SC9860_IIS2_SYS_SEL = SPRD_PIN_INFO(32, GLOBAL_CTRL_PIN, 14, 4, 3),
	SC9860_IIS1_SYS_SEL = SPRD_PIN_INFO(33, GLOBAL_CTRL_PIN, 10, 4, 3),
	SC9860_IIS0_SYS_SEL = SPRD_PIN_INFO(34, GLOBAL_CTRL_PIN, 6, 4, 3),
	SC9860_IIS23_LOOP_SEL = SPRD_PIN_INFO(35, GLOBAL_CTRL_PIN, 5, 1, 3),
	SC9860_IIS13_LOOP_SEL = SPRD_PIN_INFO(36, GLOBAL_CTRL_PIN, 4, 1, 3),
	SC9860_IIS12_LOOP_SEL = SPRD_PIN_INFO(37, GLOBAL_CTRL_PIN, 3, 1, 3),
	SC9860_IIS03_LOOP_SEL = SPRD_PIN_INFO(38, GLOBAL_CTRL_PIN, 2, 1, 3),
	SC9860_IIS02_LOOP_SEL = SPRD_PIN_INFO(39, GLOBAL_CTRL_PIN, 1, 1, 3),
	SC9860_IIS01_LOOP_SEL = SPRD_PIN_INFO(40, GLOBAL_CTRL_PIN, 0, 1, 3),

	/* pin global control register 4 */
	SC9860_IIS6_SYS_SEL = SPRD_PIN_INFO(41, GLOBAL_CTRL_PIN, 27, 4, 4),
	SC9860_IIS5_SYS_SEL = SPRD_PIN_INFO(42, GLOBAL_CTRL_PIN, 23, 4, 4),
	SC9860_IIS4_SYS_SEL = SPRD_PIN_INFO(43, GLOBAL_CTRL_PIN, 19, 4, 4),
	SC9860_I2C_INF6_SYS_SEL = SPRD_PIN_INFO(44, GLOBAL_CTRL_PIN, 8, 2, 4),
	SC9860_I2C_INF4_SYS_SEL = SPRD_PIN_INFO(45, GLOBAL_CTRL_PIN, 6, 2, 4),
	SC9860_I2C_INF2_SYS_SEL = SPRD_PIN_INFO(46, GLOBAL_CTRL_PIN, 4, 2, 4),
	SC9860_I2C_INF1_SYS_SEL = SPRD_PIN_INFO(47, GLOBAL_CTRL_PIN, 2, 2, 4),
	SC9860_I2C_INF0_SYS_SEL = SPRD_PIN_INFO(48, GLOBAL_CTRL_PIN, 0, 2, 4),

	/* pin global control register 5 */
	SC9860_GPIO_INF7_SYS_SEL = SPRD_PIN_INFO(49, GLOBAL_CTRL_PIN, 27, 1, 5),
	SC9860_GPIO_INF6_SYS_SEL = SPRD_PIN_INFO(50, GLOBAL_CTRL_PIN, 26, 1, 5),
	SC9860_GPIO_INF5_SYS_SEL = SPRD_PIN_INFO(51, GLOBAL_CTRL_PIN, 25, 1, 5),
	SC9860_GPIO_INF4_SYS_SEL = SPRD_PIN_INFO(52, GLOBAL_CTRL_PIN, 24, 1, 5),
	SC9860_GPIO_INF3_SYS_SEL = SPRD_PIN_INFO(53, GLOBAL_CTRL_PIN, 23, 1, 5),
	SC9860_GPIO_INF2_SYS_SEL = SPRD_PIN_INFO(54, GLOBAL_CTRL_PIN, 22, 1, 5),
	SC9860_GPIO_INF1_SYS_SEL = SPRD_PIN_INFO(55, GLOBAL_CTRL_PIN, 21, 1, 5),
	SC9860_GPIO_INF0_SYS_SEL = SPRD_PIN_INFO(56, GLOBAL_CTRL_PIN, 20, 1, 5),
	SC9860_WDRST_OUT_SEL = SPRD_PIN_INFO(57, GLOBAL_CTRL_PIN, 16, 3, 5),
	SC9860_ADI_SYNC_PIN_OUT_SEL = SPRD_PIN_INFO(58, GLOBAL_CTRL_PIN, 14, 1, 5),
	SC9860_CMRST_SEL = SPRD_PIN_INFO(59, GLOBAL_CTRL_PIN, 13, 1, 5),
	SC9860_CMPD_SEL = SPRD_PIN_INFO(60, GLOBAL_CTRL_PIN, 12, 1, 5),
	SC9860_TEST_DBG_MODE11 = SPRD_PIN_INFO(61, GLOBAL_CTRL_PIN, 11, 1, 5),
	SC9860_TEST_DBG_MODE10 = SPRD_PIN_INFO(62, GLOBAL_CTRL_PIN, 10, 1, 5),
	SC9860_TEST_DBG_MODE9 = SPRD_PIN_INFO(63, GLOBAL_CTRL_PIN, 9, 1, 5),
	SC9860_TEST_DBG_MODE8 = SPRD_PIN_INFO(64, GLOBAL_CTRL_PIN, 8, 1, 5),
	SC9860_TEST_DBG_MODE7 = SPRD_PIN_INFO(65, GLOBAL_CTRL_PIN, 7, 1, 5),
	SC9860_TEST_DBG_MODE6 = SPRD_PIN_INFO(66, GLOBAL_CTRL_PIN, 6, 1, 5),
	SC9860_TEST_DBG_MODE5 = SPRD_PIN_INFO(67, GLOBAL_CTRL_PIN, 5, 1, 5),
	SC9860_TEST_DBG_MODE4 = SPRD_PIN_INFO(68, GLOBAL_CTRL_PIN, 4, 1, 5),
	SC9860_TEST_DBG_MODE3 = SPRD_PIN_INFO(69, GLOBAL_CTRL_PIN, 3, 1, 5),
	SC9860_TEST_DBG_MODE2 = SPRD_PIN_INFO(70, GLOBAL_CTRL_PIN, 2, 1, 5),
	SC9860_TEST_DBG_MODE1 = SPRD_PIN_INFO(71, GLOBAL_CTRL_PIN, 1, 1, 5),
	SC9860_TEST_DBG_MODE0 = SPRD_PIN_INFO(72, GLOBAL_CTRL_PIN, 0, 1, 5),

	/* pin global control register 6 */
	SC9860_SP_EIC_DPAD3_SEL = SPRD_PIN_INFO(73, GLOBAL_CTRL_PIN, 24, 8, 6),
	SC9860_SP_EIC_DPAD2_SEL = SPRD_PIN_INFO(74, GLOBAL_CTRL_PIN, 16, 8, 6),
	SC9860_SP_EIC_DPAD1_SEL = SPRD_PIN_INFO(75, GLOBAL_CTRL_PIN, 8, 8, 6),
	SC9860_SP_EIC_DPAD0_SEL = SPRD_PIN_INFO(76, GLOBAL_CTRL_PIN, 0, 8, 6),

	/* pin global control register 7 */
	SC9860_SP_EIC_DPAD7_SEL = SPRD_PIN_INFO(77, GLOBAL_CTRL_PIN, 24, 8, 7),
	SC9860_SP_EIC_DPAD6_SEL = SPRD_PIN_INFO(78, GLOBAL_CTRL_PIN, 16, 8, 7),
	SC9860_SP_EIC_DPAD5_SEL = SPRD_PIN_INFO(79, GLOBAL_CTRL_PIN, 8, 8, 7),
	SC9860_SP_EIC_DPAD4_SEL = SPRD_PIN_INFO(80, GLOBAL_CTRL_PIN, 0, 8, 7),

	/* common pin registers definitions */
	SC9860_RFCTL20 = SPRD_PIN_INFO(81, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL21 = SPRD_PIN_INFO(83, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL30 = SPRD_PIN_INFO(85, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL31 = SPRD_PIN_INFO(87, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL32 = SPRD_PIN_INFO(89, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL33 = SPRD_PIN_INFO(91, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL34 = SPRD_PIN_INFO(93, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL35 = SPRD_PIN_INFO(95, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL36 = SPRD_PIN_INFO(97, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL37 = SPRD_PIN_INFO(99, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL22 = SPRD_PIN_INFO(101, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL23 = SPRD_PIN_INFO(103, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL24 = SPRD_PIN_INFO(105, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL25 = SPRD_PIN_INFO(107, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL26 = SPRD_PIN_INFO(109, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL27 = SPRD_PIN_INFO(111, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL28 = SPRD_PIN_INFO(113, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL29 = SPRD_PIN_INFO(115, COMMON_PIN, 0, 0, 0),
	SC9860_SCL2 = SPRD_PIN_INFO(117, COMMON_PIN, 0, 0, 0),
	SC9860_SDA2 = SPRD_PIN_INFO(119, COMMON_PIN, 0, 0, 0),
	SC9860_MTCK_ARM = SPRD_PIN_INFO(121, COMMON_PIN, 0, 0, 0),
	SC9860_MTMS_ARM = SPRD_PIN_INFO(123, COMMON_PIN, 0, 0, 0),
	SC9860_XTL_EN0 = SPRD_PIN_INFO(125, COMMON_PIN, 0, 0, 0),
	SC9860_PTEST = SPRD_PIN_INFO(127, COMMON_PIN, 0, 0, 0),
	SC9860_AUD_DAD1 = SPRD_PIN_INFO(129, COMMON_PIN, 0, 0, 0),
	SC9860_AUD_ADD0 = SPRD_PIN_INFO(131, COMMON_PIN, 0, 0, 0),
	SC9860_AUD_ADSYNC = SPRD_PIN_INFO(133, COMMON_PIN, 0, 0, 0),
	SC9860_AUD_SCLK = SPRD_PIN_INFO(135, COMMON_PIN, 0, 0, 0),
	SC9860_CHIP_SLEEP = SPRD_PIN_INFO(137, COMMON_PIN, 0, 0, 0),
	SC9860_CLK_32K = SPRD_PIN_INFO(139, COMMON_PIN, 0, 0, 0),
	SC9860_DCDC_ARM_EN = SPRD_PIN_INFO(141, COMMON_PIN, 0, 0, 0),
	SC9860_EXT_RST_B = SPRD_PIN_INFO(143, COMMON_PIN, 0, 0, 0),
	SC9860_ADI_D = SPRD_PIN_INFO(145, COMMON_PIN, 0, 0, 0),
	SC9860_ADI_SCLK = SPRD_PIN_INFO(147, COMMON_PIN, 0, 0, 0),
	SC9860_XTL_EN1 = SPRD_PIN_INFO(149, COMMON_PIN, 0, 0, 0),
	SC9860_ANA_INT = SPRD_PIN_INFO(151, COMMON_PIN, 0, 0, 0),
	SC9860_AUD_DAD0 = SPRD_PIN_INFO(153, COMMON_PIN, 0, 0, 0),
	SC9860_AUD_DASYNC = SPRD_PIN_INFO(155, COMMON_PIN, 0, 0, 0),
	SC9860_LCM_RSTN = SPRD_PIN_INFO(157, COMMON_PIN, 0, 0, 0),
	SC9860_DSI_TE = SPRD_PIN_INFO(159, COMMON_PIN, 0, 0, 0),
	SC9860_PWMA = SPRD_PIN_INFO(161, COMMON_PIN, 0, 0, 0),
	SC9860_EXTINT0 = SPRD_PIN_INFO(163, COMMON_PIN, 0, 0, 0),
	SC9860_EXTINT1 = SPRD_PIN_INFO(165, COMMON_PIN, 0, 0, 0),
	SC9860_SDA1 = SPRD_PIN_INFO(167, COMMON_PIN, 0, 0, 0),
	SC9860_SCL1 = SPRD_PIN_INFO(169, COMMON_PIN, 0, 0, 0),
	SC9860_SIMCLK2 = SPRD_PIN_INFO(171, COMMON_PIN, 0, 0, 0),
	SC9860_SIMDA2 = SPRD_PIN_INFO(173, COMMON_PIN, 0, 0, 0),
	SC9860_SIMRST2 = SPRD_PIN_INFO(175, COMMON_PIN, 0, 0, 0),
	SC9860_SIMCLK1 = SPRD_PIN_INFO(177, COMMON_PIN, 0, 0, 0),
	SC9860_SIMDA1 = SPRD_PIN_INFO(179, COMMON_PIN, 0, 0, 0),
	SC9860_SIMRST1 = SPRD_PIN_INFO(181, COMMON_PIN, 0, 0, 0),
	SC9860_SIMCLK0 = SPRD_PIN_INFO(183, COMMON_PIN, 0, 0, 0),
	SC9860_SIMDA0 = SPRD_PIN_INFO(185, COMMON_PIN, 0, 0, 0),
	SC9860_SIMRST0 = SPRD_PIN_INFO(187, COMMON_PIN, 0, 0, 0),
	SC9860_SD2_CMD = SPRD_PIN_INFO(189, COMMON_PIN, 0, 0, 0),
	SC9860_SD2_D0 = SPRD_PIN_INFO(191, COMMON_PIN, 0, 0, 0),
	SC9860_SD2_D1 = SPRD_PIN_INFO(193, COMMON_PIN, 0, 0, 0),
	SC9860_SD2_CLK = SPRD_PIN_INFO(195, COMMON_PIN, 0, 0, 0),
	SC9860_SD2_D2 = SPRD_PIN_INFO(197, COMMON_PIN, 0, 0, 0),
	SC9860_SD2_D3 = SPRD_PIN_INFO(199, COMMON_PIN, 0, 0, 0),
	SC9860_SD0_D3 = SPRD_PIN_INFO(201, COMMON_PIN, 0, 0, 0),
	SC9860_SD0_D2 = SPRD_PIN_INFO(203, COMMON_PIN, 0, 0, 0),
	SC9860_SD0_CMD = SPRD_PIN_INFO(205, COMMON_PIN, 0, 0, 0),
	SC9860_SD0_D0 = SPRD_PIN_INFO(207, COMMON_PIN, 0, 0, 0),
	SC9860_SD0_D1 = SPRD_PIN_INFO(209, COMMON_PIN, 0, 0, 0),
	SC9860_SD0_CLK = SPRD_PIN_INFO(211, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_CMD_reserved = SPRD_PIN_INFO(213, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_CMD = SPRD_PIN_INFO(215, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D6 = SPRD_PIN_INFO(217, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D7 = SPRD_PIN_INFO(219, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_CLK = SPRD_PIN_INFO(221, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D5 = SPRD_PIN_INFO(223, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D4 = SPRD_PIN_INFO(225, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_DS = SPRD_PIN_INFO(227, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D3_reserved = SPRD_PIN_INFO(229, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D3 = SPRD_PIN_INFO(231, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_RST = SPRD_PIN_INFO(233, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D1 = SPRD_PIN_INFO(235, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D2 = SPRD_PIN_INFO(237, COMMON_PIN, 0, 0, 0),
	SC9860_EMMC_D0 = SPRD_PIN_INFO(239, COMMON_PIN, 0, 0, 0),
	SC9860_IIS0DI = SPRD_PIN_INFO(241, COMMON_PIN, 0, 0, 0),
	SC9860_IIS0DO = SPRD_PIN_INFO(243, COMMON_PIN, 0, 0, 0),
	SC9860_IIS0CLK = SPRD_PIN_INFO(245, COMMON_PIN, 0, 0, 0),
	SC9860_IIS0LRCK = SPRD_PIN_INFO(247, COMMON_PIN, 0, 0, 0),
	SC9860_SD1_CLK = SPRD_PIN_INFO(249, COMMON_PIN, 0, 0, 0),
	SC9860_SD1_CMD = SPRD_PIN_INFO(251, COMMON_PIN, 0, 0, 0),
	SC9860_SD1_D0 = SPRD_PIN_INFO(253, COMMON_PIN, 0, 0, 0),
	SC9860_SD1_D1 = SPRD_PIN_INFO(255, COMMON_PIN, 0, 0, 0),
	SC9860_SD1_D2 = SPRD_PIN_INFO(257, COMMON_PIN, 0, 0, 0),
	SC9860_SD1_D3 = SPRD_PIN_INFO(259, COMMON_PIN, 0, 0, 0),
	SC9860_CLK_AUX0 = SPRD_PIN_INFO(261, COMMON_PIN, 0, 0, 0),
	SC9860_WIFI_COEXIST = SPRD_PIN_INFO(263, COMMON_PIN, 0, 0, 0),
	SC9860_BEIDOU_COEXIST = SPRD_PIN_INFO(265, COMMON_PIN, 0, 0, 0),
	SC9860_U3TXD = SPRD_PIN_INFO(267, COMMON_PIN, 0, 0, 0),
	SC9860_U3RXD = SPRD_PIN_INFO(269, COMMON_PIN, 0, 0, 0),
	SC9860_U3CTS = SPRD_PIN_INFO(271, COMMON_PIN, 0, 0, 0),
	SC9860_U3RTS = SPRD_PIN_INFO(273, COMMON_PIN, 0, 0, 0),
	SC9860_U0TXD = SPRD_PIN_INFO(275, COMMON_PIN, 0, 0, 0),
	SC9860_U0RXD = SPRD_PIN_INFO(277, COMMON_PIN, 0, 0, 0),
	SC9860_U0CTS = SPRD_PIN_INFO(279, COMMON_PIN, 0, 0, 0),
	SC9860_U0RTS = SPRD_PIN_INFO(281, COMMON_PIN, 0, 0, 0),
	SC9860_IIS1DI = SPRD_PIN_INFO(283, COMMON_PIN, 0, 0, 0),
	SC9860_IIS1DO = SPRD_PIN_INFO(285, COMMON_PIN, 0, 0, 0),
	SC9860_IIS1CLK = SPRD_PIN_INFO(287, COMMON_PIN, 0, 0, 0),
	SC9860_IIS1LRCK = SPRD_PIN_INFO(289, COMMON_PIN, 0, 0, 0),
	SC9860_SPI0_CSN = SPRD_PIN_INFO(291, COMMON_PIN, 0, 0, 0),
	SC9860_SPI0_DO = SPRD_PIN_INFO(293, COMMON_PIN, 0, 0, 0),
	SC9860_SPI0_DI = SPRD_PIN_INFO(295, COMMON_PIN, 0, 0, 0),
	SC9860_SPI0_CLK = SPRD_PIN_INFO(297, COMMON_PIN, 0, 0, 0),
	SC9860_U2TXD = SPRD_PIN_INFO(299, COMMON_PIN, 0, 0, 0),
	SC9860_U2RXD = SPRD_PIN_INFO(301, COMMON_PIN, 0, 0, 0),
	SC9860_U4TXD = SPRD_PIN_INFO(303, COMMON_PIN, 0, 0, 0),
	SC9860_U4RXD = SPRD_PIN_INFO(305, COMMON_PIN, 0, 0, 0),
	SC9860_CMMCLK1 = SPRD_PIN_INFO(307, COMMON_PIN, 0, 0, 0),
	SC9860_CMRST1 = SPRD_PIN_INFO(309, COMMON_PIN, 0, 0, 0),
	SC9860_CMMCLK0 = SPRD_PIN_INFO(311, COMMON_PIN, 0, 0, 0),
	SC9860_CMRST0 = SPRD_PIN_INFO(313, COMMON_PIN, 0, 0, 0),
	SC9860_CMPD0 = SPRD_PIN_INFO(315, COMMON_PIN, 0, 0, 0),
	SC9860_CMPD1 = SPRD_PIN_INFO(317, COMMON_PIN, 0, 0, 0),
	SC9860_SCL0 = SPRD_PIN_INFO(319, COMMON_PIN, 0, 0, 0),
	SC9860_SDA0 = SPRD_PIN_INFO(321, COMMON_PIN, 0, 0, 0),
	SC9860_SDA6 = SPRD_PIN_INFO(323, COMMON_PIN, 0, 0, 0),
	SC9860_SCL6 = SPRD_PIN_INFO(325, COMMON_PIN, 0, 0, 0),
	SC9860_U1TXD = SPRD_PIN_INFO(327, COMMON_PIN, 0, 0, 0),
	SC9860_U1RXD = SPRD_PIN_INFO(329, COMMON_PIN, 0, 0, 0),
	SC9860_KEYOUT0 = SPRD_PIN_INFO(331, COMMON_PIN, 0, 0, 0),
	SC9860_KEYOUT1 = SPRD_PIN_INFO(333, COMMON_PIN, 0, 0, 0),
	SC9860_KEYOUT2 = SPRD_PIN_INFO(335, COMMON_PIN, 0, 0, 0),
	SC9860_KEYIN0 = SPRD_PIN_INFO(337, COMMON_PIN, 0, 0, 0),
	SC9860_KEYIN1 = SPRD_PIN_INFO(339, COMMON_PIN, 0, 0, 0),
	SC9860_KEYIN2 = SPRD_PIN_INFO(341, COMMON_PIN, 0, 0, 0),
	SC9860_IIS3DI = SPRD_PIN_INFO(343, COMMON_PIN, 0, 0, 0),
	SC9860_IIS3DO = SPRD_PIN_INFO(345, COMMON_PIN, 0, 0, 0),
	SC9860_IIS3CLK = SPRD_PIN_INFO(347, COMMON_PIN, 0, 0, 0),
	SC9860_IIS3LRCK = SPRD_PIN_INFO(349, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL0 = SPRD_PIN_INFO(351, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL1 = SPRD_PIN_INFO(353, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL10 = SPRD_PIN_INFO(355, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL11 = SPRD_PIN_INFO(357, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL12 = SPRD_PIN_INFO(359, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL13 = SPRD_PIN_INFO(361, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL14 = SPRD_PIN_INFO(363, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL15 = SPRD_PIN_INFO(365, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL16 = SPRD_PIN_INFO(367, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL17 = SPRD_PIN_INFO(369, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL18 = SPRD_PIN_INFO(371, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL19 = SPRD_PIN_INFO(373, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL2 = SPRD_PIN_INFO(375, COMMON_PIN, 0, 0, 0),
	SC9860_EXTINT5 = SPRD_PIN_INFO(377, COMMON_PIN, 0, 0, 0),
	SC9860_EXTINT6 = SPRD_PIN_INFO(379, COMMON_PIN, 0, 0, 0),
	SC9860_EXTINT7 = SPRD_PIN_INFO(381, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO30 = SPRD_PIN_INFO(383, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO31 = SPRD_PIN_INFO(385, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO32 = SPRD_PIN_INFO(387, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO33 = SPRD_PIN_INFO(389, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO34 = SPRD_PIN_INFO(391, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL3 = SPRD_PIN_INFO(393, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL4 = SPRD_PIN_INFO(395, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL5 = SPRD_PIN_INFO(397, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL6 = SPRD_PIN_INFO(399, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL7 = SPRD_PIN_INFO(401, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL8 = SPRD_PIN_INFO(403, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL9 = SPRD_PIN_INFO(405, COMMON_PIN, 0, 0, 0),
	SC9860_RFFE0_SCK0 = SPRD_PIN_INFO(407, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO38 = SPRD_PIN_INFO(409, COMMON_PIN, 0, 0, 0),
	SC9860_RFFE0_SDA0 = SPRD_PIN_INFO(411, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO39 = SPRD_PIN_INFO(413, COMMON_PIN, 0, 0, 0),
	SC9860_RFFE1_SCK0 = SPRD_PIN_INFO(415, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO181 = SPRD_PIN_INFO(417, COMMON_PIN, 0, 0, 0),
	SC9860_RFFE1_SDA0 = SPRD_PIN_INFO(419, COMMON_PIN, 0, 0, 0),
	SC9860_GPIO182 = SPRD_PIN_INFO(421, COMMON_PIN, 0, 0, 0),
	SC9860_RF_LVDS0_ADC_ON = SPRD_PIN_INFO(423, COMMON_PIN, 0, 0, 0),
	SC9860_RF_LVDS0_DAC_ON = SPRD_PIN_INFO(425, COMMON_PIN, 0, 0, 0),
	SC9860_RFSCK0 = SPRD_PIN_INFO(427, COMMON_PIN, 0, 0, 0),
	SC9860_RFSDA0 = SPRD_PIN_INFO(429, COMMON_PIN, 0, 0, 0),
	SC9860_RFSEN0 = SPRD_PIN_INFO(431, COMMON_PIN, 0, 0, 0),
	SC9860_RF_LVDS1_ADC_ON = SPRD_PIN_INFO(433, COMMON_PIN, 0, 0, 0),
	SC9860_RF_LVDS1_DAC_ON = SPRD_PIN_INFO(435, COMMON_PIN, 0, 0, 0),
	SC9860_RFSCK1 = SPRD_PIN_INFO(437, COMMON_PIN, 0, 0, 0),
	SC9860_RFSDA1 = SPRD_PIN_INFO(439, COMMON_PIN, 0, 0, 0),
	SC9860_RFSEN1 = SPRD_PIN_INFO(441, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL38 = SPRD_PIN_INFO(443, COMMON_PIN, 0, 0, 0),
	SC9860_RFCTL39 = SPRD_PIN_INFO(445, COMMON_PIN, 0, 0, 0),

	/* MSIC pin registers definitions */
	SC9860_RFCTL20_MISC = SPRD_PIN_INFO(82, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL21_MISC = SPRD_PIN_INFO(84, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL30_MISC = SPRD_PIN_INFO(86, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL31_MISC = SPRD_PIN_INFO(88, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL32_MISC = SPRD_PIN_INFO(90, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL33_MISC = SPRD_PIN_INFO(92, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL34_MISC = SPRD_PIN_INFO(94, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL35_MISC = SPRD_PIN_INFO(96, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL36_MISC = SPRD_PIN_INFO(98, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL37_MISC = SPRD_PIN_INFO(100, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL22_MISC = SPRD_PIN_INFO(102, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL23_MISC = SPRD_PIN_INFO(104, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL24_MISC = SPRD_PIN_INFO(106, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL25_MISC = SPRD_PIN_INFO(108, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL26_MISC = SPRD_PIN_INFO(110, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL27_MISC = SPRD_PIN_INFO(112, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL28_MISC = SPRD_PIN_INFO(114, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL29_MISC = SPRD_PIN_INFO(116, MISC_PIN, 0, 0, 0),
	SC9860_SCL2_MISC = SPRD_PIN_INFO(118, MISC_PIN, 0, 0, 0),
	SC9860_SDA2_MISC = SPRD_PIN_INFO(120, MISC_PIN, 0, 0, 0),
	SC9860_MTCK_ARM_MISC = SPRD_PIN_INFO(122, MISC_PIN, 0, 0, 0),
	SC9860_MTMS_ARM_MISC = SPRD_PIN_INFO(124, MISC_PIN, 0, 0, 0),
	SC9860_XTL_EN0_MISC = SPRD_PIN_INFO(126, MISC_PIN, 0, 0, 0),
	SC9860_PTEST_MISC = SPRD_PIN_INFO(128, MISC_PIN, 0, 0, 0),
	SC9860_AUD_DAD1_MISC = SPRD_PIN_INFO(130, MISC_PIN, 0, 0, 0),
	SC9860_AUD_ADD0_MISC = SPRD_PIN_INFO(132, MISC_PIN, 0, 0, 0),
	SC9860_AUD_ADSYNC_MISC = SPRD_PIN_INFO(134, MISC_PIN, 0, 0, 0),
	SC9860_AUD_SCLK_MISC = SPRD_PIN_INFO(136, MISC_PIN, 0, 0, 0),
	SC9860_CHIP_SLEEP_MISC = SPRD_PIN_INFO(138, MISC_PIN, 0, 0, 0),
	SC9860_CLK_32K_MISC = SPRD_PIN_INFO(140, MISC_PIN, 0, 0, 0),
	SC9860_DCDC_ARM_EN_MISC = SPRD_PIN_INFO(142, MISC_PIN, 0, 0, 0),
	SC9860_EXT_RST_B_MISC = SPRD_PIN_INFO(144, MISC_PIN, 0, 0, 0),
	SC9860_ADI_D_MISC = SPRD_PIN_INFO(146, MISC_PIN, 0, 0, 0),
	SC9860_ADI_SCLK_MISC = SPRD_PIN_INFO(148, MISC_PIN, 0, 0, 0),
	SC9860_XTL_EN1_MISC = SPRD_PIN_INFO(150, MISC_PIN, 0, 0, 0),
	SC9860_ANA_INT_MISC = SPRD_PIN_INFO(152, MISC_PIN, 0, 0, 0),
	SC9860_AUD_DAD0_MISC = SPRD_PIN_INFO(154, MISC_PIN, 0, 0, 0),
	SC9860_AUD_DASYNC_MISC = SPRD_PIN_INFO(156, MISC_PIN, 0, 0, 0),
	SC9860_LCM_RSTN_MISC = SPRD_PIN_INFO(158, MISC_PIN, 0, 0, 0),
	SC9860_DSI_TE_MISC = SPRD_PIN_INFO(160, MISC_PIN, 0, 0, 0),
	SC9860_PWMA_MISC = SPRD_PIN_INFO(162, MISC_PIN, 0, 0, 0),
	SC9860_EXTINT0_MISC = SPRD_PIN_INFO(164, MISC_PIN, 0, 0, 0),
	SC9860_EXTINT1_MISC = SPRD_PIN_INFO(166, MISC_PIN, 0, 0, 0),
	SC9860_SDA1_MISC = SPRD_PIN_INFO(168, MISC_PIN, 0, 0, 0),
	SC9860_SCL1_MISC = SPRD_PIN_INFO(170, MISC_PIN, 0, 0, 0),
	SC9860_SIMCLK2_MISC = SPRD_PIN_INFO(172, MISC_PIN, 0, 0, 0),
	SC9860_SIMDA2_MISC = SPRD_PIN_INFO(174, MISC_PIN, 0, 0, 0),
	SC9860_SIMRST2_MISC = SPRD_PIN_INFO(176, MISC_PIN, 0, 0, 0),
	SC9860_SIMCLK1_MISC = SPRD_PIN_INFO(178, MISC_PIN, 0, 0, 0),
	SC9860_SIMDA1_MISC = SPRD_PIN_INFO(180, MISC_PIN, 0, 0, 0),
	SC9860_SIMRST1_MISC = SPRD_PIN_INFO(182, MISC_PIN, 0, 0, 0),
	SC9860_SIMCLK0_MISC = SPRD_PIN_INFO(184, MISC_PIN, 0, 0, 0),
	SC9860_SIMDA0_MISC = SPRD_PIN_INFO(186, MISC_PIN, 0, 0, 0),
	SC9860_SIMRST0_MISC = SPRD_PIN_INFO(188, MISC_PIN, 0, 0, 0),
	SC9860_SD2_CMD_MISC = SPRD_PIN_INFO(190, MISC_PIN, 0, 0, 0),
	SC9860_SD2_D0_MISC = SPRD_PIN_INFO(192, MISC_PIN, 0, 0, 0),
	SC9860_SD2_D1_MISC = SPRD_PIN_INFO(194, MISC_PIN, 0, 0, 0),
	SC9860_SD2_CLK_MISC = SPRD_PIN_INFO(196, MISC_PIN, 0, 0, 0),
	SC9860_SD2_D2_MISC = SPRD_PIN_INFO(198, MISC_PIN, 0, 0, 0),
	SC9860_SD2_D3_MISC = SPRD_PIN_INFO(200, MISC_PIN, 0, 0, 0),
	SC9860_SD0_D3_MISC = SPRD_PIN_INFO(202, MISC_PIN, 0, 0, 0),
	SC9860_SD0_D2_MISC = SPRD_PIN_INFO(204, MISC_PIN, 0, 0, 0),
	SC9860_SD0_CMD_MISC = SPRD_PIN_INFO(206, MISC_PIN, 0, 0, 0),
	SC9860_SD0_D0_MISC = SPRD_PIN_INFO(208, MISC_PIN, 0, 0, 0),
	SC9860_SD0_D1_MISC = SPRD_PIN_INFO(210, MISC_PIN, 0, 0, 0),
	SC9860_SD0_CLK_MISC = SPRD_PIN_INFO(212, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_CMD_reserved_MISC = SPRD_PIN_INFO(214, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_CMD_MISC = SPRD_PIN_INFO(216, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D6_MISC = SPRD_PIN_INFO(218, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D7_MISC = SPRD_PIN_INFO(220, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_CLK_MISC = SPRD_PIN_INFO(222, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D5_MISC = SPRD_PIN_INFO(224, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D4_MISC = SPRD_PIN_INFO(226, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_DS_MISC = SPRD_PIN_INFO(228, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D3_reserved_MISC = SPRD_PIN_INFO(230, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D3_MISC = SPRD_PIN_INFO(232, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_RST_MISC = SPRD_PIN_INFO(234, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D1_MISC = SPRD_PIN_INFO(236, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D2_MISC = SPRD_PIN_INFO(238, MISC_PIN, 0, 0, 0),
	SC9860_EMMC_D0_MISC = SPRD_PIN_INFO(240, MISC_PIN, 0, 0, 0),
	SC9860_IIS0DI_MISC = SPRD_PIN_INFO(242, MISC_PIN, 0, 0, 0),
	SC9860_IIS0DO_MISC = SPRD_PIN_INFO(244, MISC_PIN, 0, 0, 0),
	SC9860_IIS0CLK_MISC = SPRD_PIN_INFO(246, MISC_PIN, 0, 0, 0),
	SC9860_IIS0LRCK_MISC = SPRD_PIN_INFO(248, MISC_PIN, 0, 0, 0),
	SC9860_SD1_CLK_MISC = SPRD_PIN_INFO(250, MISC_PIN, 0, 0, 0),
	SC9860_SD1_CMD_MISC = SPRD_PIN_INFO(252, MISC_PIN, 0, 0, 0),
	SC9860_SD1_D0_MISC = SPRD_PIN_INFO(254, MISC_PIN, 0, 0, 0),
	SC9860_SD1_D1_MISC = SPRD_PIN_INFO(256, MISC_PIN, 0, 0, 0),
	SC9860_SD1_D2_MISC = SPRD_PIN_INFO(258, MISC_PIN, 0, 0, 0),
	SC9860_SD1_D3_MISC = SPRD_PIN_INFO(260, MISC_PIN, 0, 0, 0),
	SC9860_CLK_AUX0_MISC = SPRD_PIN_INFO(262, MISC_PIN, 0, 0, 0),
	SC9860_WIFI_COEXIST_MISC = SPRD_PIN_INFO(264, MISC_PIN, 0, 0, 0),
	SC9860_BEIDOU_COEXIST_MISC = SPRD_PIN_INFO(266, MISC_PIN, 0, 0, 0),
	SC9860_U3TXD_MISC = SPRD_PIN_INFO(268, MISC_PIN, 0, 0, 0),
	SC9860_U3RXD_MISC = SPRD_PIN_INFO(270, MISC_PIN, 0, 0, 0),
	SC9860_U3CTS_MISC = SPRD_PIN_INFO(272, MISC_PIN, 0, 0, 0),
	SC9860_U3RTS_MISC = SPRD_PIN_INFO(274, MISC_PIN, 0, 0, 0),
	SC9860_U0TXD_MISC = SPRD_PIN_INFO(276, MISC_PIN, 0, 0, 0),
	SC9860_U0RXD_MISC = SPRD_PIN_INFO(278, MISC_PIN, 0, 0, 0),
	SC9860_U0CTS_MISC = SPRD_PIN_INFO(280, MISC_PIN, 0, 0, 0),
	SC9860_U0RTS_MISC = SPRD_PIN_INFO(282, MISC_PIN, 0, 0, 0),
	SC9860_IIS1DI_MISC = SPRD_PIN_INFO(284, MISC_PIN, 0, 0, 0),
	SC9860_IIS1DO_MISC = SPRD_PIN_INFO(286, MISC_PIN, 0, 0, 0),
	SC9860_IIS1CLK_MISC = SPRD_PIN_INFO(288, MISC_PIN, 0, 0, 0),
	SC9860_IIS1LRCK_MISC = SPRD_PIN_INFO(290, MISC_PIN, 0, 0, 0),
	SC9860_SPI0_CSN_MISC = SPRD_PIN_INFO(292, MISC_PIN, 0, 0, 0),
	SC9860_SPI0_DO_MISC = SPRD_PIN_INFO(294, MISC_PIN, 0, 0, 0),
	SC9860_SPI0_DI_MISC = SPRD_PIN_INFO(296, MISC_PIN, 0, 0, 0),
	SC9860_SPI0_CLK_MISC = SPRD_PIN_INFO(298, MISC_PIN, 0, 0, 0),
	SC9860_U2TXD_MISC = SPRD_PIN_INFO(300, MISC_PIN, 0, 0, 0),
	SC9860_U2RXD_MISC = SPRD_PIN_INFO(302, MISC_PIN, 0, 0, 0),
	SC9860_U4TXD_MISC = SPRD_PIN_INFO(304, MISC_PIN, 0, 0, 0),
	SC9860_U4RXD_MISC = SPRD_PIN_INFO(306, MISC_PIN, 0, 0, 0),
	SC9860_CMMCLK1_MISC = SPRD_PIN_INFO(308, MISC_PIN, 0, 0, 0),
	SC9860_CMRST1_MISC = SPRD_PIN_INFO(310, MISC_PIN, 0, 0, 0),
	SC9860_CMMCLK0_MISC = SPRD_PIN_INFO(312, MISC_PIN, 0, 0, 0),
	SC9860_CMRST0_MISC = SPRD_PIN_INFO(314, MISC_PIN, 0, 0, 0),
	SC9860_CMPD0_MISC = SPRD_PIN_INFO(316, MISC_PIN, 0, 0, 0),
	SC9860_CMPD1_MISC = SPRD_PIN_INFO(318, MISC_PIN, 0, 0, 0),
	SC9860_SCL0_MISC = SPRD_PIN_INFO(320, MISC_PIN, 0, 0, 0),
	SC9860_SDA0_MISC = SPRD_PIN_INFO(322, MISC_PIN, 0, 0, 0),
	SC9860_SDA6_MISC = SPRD_PIN_INFO(324, MISC_PIN, 0, 0, 0),
	SC9860_SCL6_MISC = SPRD_PIN_INFO(326, MISC_PIN, 0, 0, 0),
	SC9860_U1TXD_MISC = SPRD_PIN_INFO(328, MISC_PIN, 0, 0, 0),
	SC9860_U1RXD_MISC = SPRD_PIN_INFO(330, MISC_PIN, 0, 0, 0),
	SC9860_KEYOUT0_MISC = SPRD_PIN_INFO(332, MISC_PIN, 0, 0, 0),
	SC9860_KEYOUT1_MISC = SPRD_PIN_INFO(334, MISC_PIN, 0, 0, 0),
	SC9860_KEYOUT2_MISC = SPRD_PIN_INFO(336, MISC_PIN, 0, 0, 0),
	SC9860_KEYIN0_MISC = SPRD_PIN_INFO(338, MISC_PIN, 0, 0, 0),
	SC9860_KEYIN1_MISC = SPRD_PIN_INFO(340, MISC_PIN, 0, 0, 0),
	SC9860_KEYIN2_MISC = SPRD_PIN_INFO(342, MISC_PIN, 0, 0, 0),
	SC9860_IIS3DI_MISC = SPRD_PIN_INFO(344, MISC_PIN, 0, 0, 0),
	SC9860_IIS3DO_MISC = SPRD_PIN_INFO(346, MISC_PIN, 0, 0, 0),
	SC9860_IIS3CLK_MISC = SPRD_PIN_INFO(348, MISC_PIN, 0, 0, 0),
	SC9860_IIS3LRCK_MISC = SPRD_PIN_INFO(350, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL0_MISC = SPRD_PIN_INFO(352, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL1_MISC = SPRD_PIN_INFO(354, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL10_MISC = SPRD_PIN_INFO(356, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL11_MISC = SPRD_PIN_INFO(358, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL12_MISC = SPRD_PIN_INFO(360, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL13_MISC = SPRD_PIN_INFO(362, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL14_MISC = SPRD_PIN_INFO(364, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL15_MISC = SPRD_PIN_INFO(366, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL16_MISC = SPRD_PIN_INFO(368, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL17_MISC = SPRD_PIN_INFO(370, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL18_MISC = SPRD_PIN_INFO(372, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL19_MISC = SPRD_PIN_INFO(374, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL2_MISC = SPRD_PIN_INFO(376, MISC_PIN, 0, 0, 0),
	SC9860_EXTINT5_MISC = SPRD_PIN_INFO(378, MISC_PIN, 0, 0, 0),
	SC9860_EXTINT6_MISC = SPRD_PIN_INFO(380, MISC_PIN, 0, 0, 0),
	SC9860_EXTINT7_MISC = SPRD_PIN_INFO(382, MISC_PIN, 0, 0, 0),
	SC9860_GPIO30_MISC = SPRD_PIN_INFO(384, MISC_PIN, 0, 0, 0),
	SC9860_GPIO31_MISC = SPRD_PIN_INFO(386, MISC_PIN, 0, 0, 0),
	SC9860_GPIO32_MISC = SPRD_PIN_INFO(388, MISC_PIN, 0, 0, 0),
	SC9860_GPIO33_MISC = SPRD_PIN_INFO(390, MISC_PIN, 0, 0, 0),
	SC9860_GPIO34_MISC = SPRD_PIN_INFO(392, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL3_MISC = SPRD_PIN_INFO(394, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL4_MISC = SPRD_PIN_INFO(396, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL5_MISC = SPRD_PIN_INFO(398, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL6_MISC = SPRD_PIN_INFO(400, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL7_MISC = SPRD_PIN_INFO(402, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL8_MISC = SPRD_PIN_INFO(404, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL9_MISC = SPRD_PIN_INFO(406, MISC_PIN, 0, 0, 0),
	SC9860_RFFE0_SCK0_MISC = SPRD_PIN_INFO(408, MISC_PIN, 0, 0, 0),
	SC9860_GPIO38_MISC = SPRD_PIN_INFO(410, MISC_PIN, 0, 0, 0),
	SC9860_RFFE0_SDA0_MISC = SPRD_PIN_INFO(412, MISC_PIN, 0, 0, 0),
	SC9860_GPIO39_MISC = SPRD_PIN_INFO(414, MISC_PIN, 0, 0, 0),
	SC9860_RFFE1_SCK0_MISC = SPRD_PIN_INFO(416, MISC_PIN, 0, 0, 0),
	SC9860_GPIO181_MISC = SPRD_PIN_INFO(418, MISC_PIN, 0, 0, 0),
	SC9860_RFFE1_SDA0_MISC = SPRD_PIN_INFO(420, MISC_PIN, 0, 0, 0),
	SC9860_GPIO182_MISC = SPRD_PIN_INFO(422, MISC_PIN, 0, 0, 0),
	SC9860_RF_LVDS0_ADC_ON_MISC = SPRD_PIN_INFO(424, MISC_PIN, 0, 0, 0),
	SC9860_RF_LVDS0_DAC_ON_MISC = SPRD_PIN_INFO(426, MISC_PIN, 0, 0, 0),
	SC9860_RFSCK0_MISC = SPRD_PIN_INFO(428, MISC_PIN, 0, 0, 0),
	SC9860_RFSDA0_MISC = SPRD_PIN_INFO(430, MISC_PIN, 0, 0, 0),
	SC9860_RFSEN0_MISC = SPRD_PIN_INFO(432, MISC_PIN, 0, 0, 0),
	SC9860_RF_LVDS1_ADC_ON_MISC = SPRD_PIN_INFO(434, MISC_PIN, 0, 0, 0),
	SC9860_RF_LVDS1_DAC_ON_MISC = SPRD_PIN_INFO(436, MISC_PIN, 0, 0, 0),
	SC9860_RFSCK1_MISC = SPRD_PIN_INFO(438, MISC_PIN, 0, 0, 0),
	SC9860_RFSDA1_MISC = SPRD_PIN_INFO(440, MISC_PIN, 0, 0, 0),
	SC9860_RFSEN1_MISC = SPRD_PIN_INFO(442, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL38_MISC = SPRD_PIN_INFO(444, MISC_PIN, 0, 0, 0),
	SC9860_RFCTL39_MISC = SPRD_PIN_INFO(446, MISC_PIN, 0, 0, 0),
};

static struct sprd_pins_info sprd_sc9860_pins_info[] = {
	SPRD_PINCTRL_PIN(SC9860_VIO28_0_IRTE),
	SPRD_PINCTRL_PIN(SC9860_VIO_SD2_IRTE),
	SPRD_PINCTRL_PIN(SC9860_VIO_SD0_IRTE),
	SPRD_PINCTRL_PIN(SC9860_VIO_SIM2_IRTE),
	SPRD_PINCTRL_PIN(SC9860_VIO_SIM1_IRTE),
	SPRD_PINCTRL_PIN(SC9860_VIO_SIM0_IRTE),
	SPRD_PINCTRL_PIN(SC9860_VIO28_0_MS),
	SPRD_PINCTRL_PIN(SC9860_VIO_SD2_MS),
	SPRD_PINCTRL_PIN(SC9860_VIO_SD0_MS),
	SPRD_PINCTRL_PIN(SC9860_VIO_SIM2_MS),
	SPRD_PINCTRL_PIN(SC9860_VIO_SIM1_MS),
	SPRD_PINCTRL_PIN(SC9860_VIO_SIM0_MS),
	SPRD_PINCTRL_PIN(SC9860_SPSPI_PIN_IN_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART1_USB30_PHY_SEL),
	SPRD_PINCTRL_PIN(SC9860_USB30_PHY_DM_OE),
	SPRD_PINCTRL_PIN(SC9860_USB30_PHY_DP_OE),
	SPRD_PINCTRL_PIN(SC9860_UART5_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_ORP_URXD_PIN_IN_SEL),
	SPRD_PINCTRL_PIN(SC9860_SIM2_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_SIM1_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_SIM0_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_CLK26MHZ_BUF_OUT_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART4_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART3_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART2_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART1_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART0_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART24_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART23_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART14_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_UART13_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS3_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS2_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS1_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS0_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS23_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS13_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS12_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS03_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS02_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS01_LOOP_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS6_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS5_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_IIS4_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_I2C_INF6_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_I2C_INF4_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_I2C_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_I2C_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_I2C_INF0_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_GPIO_INF7_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_GPIO_INF6_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_GPIO_INF5_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_GPIO_INF4_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_GPIO_INF3_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_GPIO_INF2_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_GPIO_INF1_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_GPIO_INF0_SYS_SEL),
	SPRD_PINCTRL_PIN(SC9860_WDRST_OUT_SEL),
	SPRD_PINCTRL_PIN(SC9860_ADI_SYNC_PIN_OUT_SEL),
	SPRD_PINCTRL_PIN(SC9860_CMRST_SEL),
	SPRD_PINCTRL_PIN(SC9860_CMPD_SEL),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE11),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE10),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE9),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE8),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE7),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE6),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE5),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE4),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE3),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE2),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE1),
	SPRD_PINCTRL_PIN(SC9860_TEST_DBG_MODE0),
	SPRD_PINCTRL_PIN(SC9860_SP_EIC_DPAD3_SEL),
	SPRD_PINCTRL_PIN(SC9860_SP_EIC_DPAD2_SEL),
	SPRD_PINCTRL_PIN(SC9860_SP_EIC_DPAD1_SEL),
	SPRD_PINCTRL_PIN(SC9860_SP_EIC_DPAD0_SEL),
	SPRD_PINCTRL_PIN(SC9860_SP_EIC_DPAD7_SEL),
	SPRD_PINCTRL_PIN(SC9860_SP_EIC_DPAD6_SEL),
	SPRD_PINCTRL_PIN(SC9860_SP_EIC_DPAD5_SEL),
	SPRD_PINCTRL_PIN(SC9860_SP_EIC_DPAD4_SEL),
	SPRD_PINCTRL_PIN(SC9860_RFCTL20),
	SPRD_PINCTRL_PIN(SC9860_RFCTL21),
	SPRD_PINCTRL_PIN(SC9860_RFCTL30),
	SPRD_PINCTRL_PIN(SC9860_RFCTL31),
	SPRD_PINCTRL_PIN(SC9860_RFCTL32),
	SPRD_PINCTRL_PIN(SC9860_RFCTL33),
	SPRD_PINCTRL_PIN(SC9860_RFCTL34),
	SPRD_PINCTRL_PIN(SC9860_RFCTL35),
	SPRD_PINCTRL_PIN(SC9860_RFCTL36),
	SPRD_PINCTRL_PIN(SC9860_RFCTL37),
	SPRD_PINCTRL_PIN(SC9860_RFCTL22),
	SPRD_PINCTRL_PIN(SC9860_RFCTL23),
	SPRD_PINCTRL_PIN(SC9860_RFCTL24),
	SPRD_PINCTRL_PIN(SC9860_RFCTL25),
	SPRD_PINCTRL_PIN(SC9860_RFCTL26),
	SPRD_PINCTRL_PIN(SC9860_RFCTL27),
	SPRD_PINCTRL_PIN(SC9860_RFCTL28),
	SPRD_PINCTRL_PIN(SC9860_RFCTL29),
	SPRD_PINCTRL_PIN(SC9860_SCL2),
	SPRD_PINCTRL_PIN(SC9860_SDA2),
	SPRD_PINCTRL_PIN(SC9860_MTCK_ARM),
	SPRD_PINCTRL_PIN(SC9860_MTMS_ARM),
	SPRD_PINCTRL_PIN(SC9860_XTL_EN0),
	SPRD_PINCTRL_PIN(SC9860_PTEST),
	SPRD_PINCTRL_PIN(SC9860_AUD_DAD1),
	SPRD_PINCTRL_PIN(SC9860_AUD_ADD0),
	SPRD_PINCTRL_PIN(SC9860_AUD_ADSYNC),
	SPRD_PINCTRL_PIN(SC9860_AUD_SCLK),
	SPRD_PINCTRL_PIN(SC9860_CHIP_SLEEP),
	SPRD_PINCTRL_PIN(SC9860_CLK_32K),
	SPRD_PINCTRL_PIN(SC9860_DCDC_ARM_EN),
	SPRD_PINCTRL_PIN(SC9860_EXT_RST_B),
	SPRD_PINCTRL_PIN(SC9860_ADI_D),
	SPRD_PINCTRL_PIN(SC9860_ADI_SCLK),
	SPRD_PINCTRL_PIN(SC9860_XTL_EN1),
	SPRD_PINCTRL_PIN(SC9860_ANA_INT),
	SPRD_PINCTRL_PIN(SC9860_AUD_DAD0),
	SPRD_PINCTRL_PIN(SC9860_AUD_DASYNC),
	SPRD_PINCTRL_PIN(SC9860_LCM_RSTN),
	SPRD_PINCTRL_PIN(SC9860_DSI_TE),
	SPRD_PINCTRL_PIN(SC9860_PWMA),
	SPRD_PINCTRL_PIN(SC9860_EXTINT0),
	SPRD_PINCTRL_PIN(SC9860_EXTINT1),
	SPRD_PINCTRL_PIN(SC9860_SDA1),
	SPRD_PINCTRL_PIN(SC9860_SCL1),
	SPRD_PINCTRL_PIN(SC9860_SIMCLK2),
	SPRD_PINCTRL_PIN(SC9860_SIMDA2),
	SPRD_PINCTRL_PIN(SC9860_SIMRST2),
	SPRD_PINCTRL_PIN(SC9860_SIMCLK1),
	SPRD_PINCTRL_PIN(SC9860_SIMDA1),
	SPRD_PINCTRL_PIN(SC9860_SIMRST1),
	SPRD_PINCTRL_PIN(SC9860_SIMCLK0),
	SPRD_PINCTRL_PIN(SC9860_SIMDA0),
	SPRD_PINCTRL_PIN(SC9860_SIMRST0),
	SPRD_PINCTRL_PIN(SC9860_SD2_CMD),
	SPRD_PINCTRL_PIN(SC9860_SD2_D0),
	SPRD_PINCTRL_PIN(SC9860_SD2_D1),
	SPRD_PINCTRL_PIN(SC9860_SD2_CLK),
	SPRD_PINCTRL_PIN(SC9860_SD2_D2),
	SPRD_PINCTRL_PIN(SC9860_SD2_D3),
	SPRD_PINCTRL_PIN(SC9860_SD0_D3),
	SPRD_PINCTRL_PIN(SC9860_SD0_D2),
	SPRD_PINCTRL_PIN(SC9860_SD0_CMD),
	SPRD_PINCTRL_PIN(SC9860_SD0_D0),
	SPRD_PINCTRL_PIN(SC9860_SD0_D1),
	SPRD_PINCTRL_PIN(SC9860_SD0_CLK),
	SPRD_PINCTRL_PIN(SC9860_EMMC_CMD),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D6),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D7),
	SPRD_PINCTRL_PIN(SC9860_EMMC_CLK),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D5),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D4),
	SPRD_PINCTRL_PIN(SC9860_EMMC_DS),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D3),
	SPRD_PINCTRL_PIN(SC9860_EMMC_RST),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D1),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D2),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D0),
	SPRD_PINCTRL_PIN(SC9860_IIS0DI),
	SPRD_PINCTRL_PIN(SC9860_IIS0DO),
	SPRD_PINCTRL_PIN(SC9860_IIS0CLK),
	SPRD_PINCTRL_PIN(SC9860_IIS0LRCK),
	SPRD_PINCTRL_PIN(SC9860_SD1_CLK),
	SPRD_PINCTRL_PIN(SC9860_SD1_CMD),
	SPRD_PINCTRL_PIN(SC9860_SD1_D0),
	SPRD_PINCTRL_PIN(SC9860_SD1_D1),
	SPRD_PINCTRL_PIN(SC9860_SD1_D2),
	SPRD_PINCTRL_PIN(SC9860_SD1_D3),
	SPRD_PINCTRL_PIN(SC9860_CLK_AUX0),
	SPRD_PINCTRL_PIN(SC9860_WIFI_COEXIST),
	SPRD_PINCTRL_PIN(SC9860_BEIDOU_COEXIST),
	SPRD_PINCTRL_PIN(SC9860_U3TXD),
	SPRD_PINCTRL_PIN(SC9860_U3RXD),
	SPRD_PINCTRL_PIN(SC9860_U3CTS),
	SPRD_PINCTRL_PIN(SC9860_U3RTS),
	SPRD_PINCTRL_PIN(SC9860_U0TXD),
	SPRD_PINCTRL_PIN(SC9860_U0RXD),
	SPRD_PINCTRL_PIN(SC9860_U0CTS),
	SPRD_PINCTRL_PIN(SC9860_U0RTS),
	SPRD_PINCTRL_PIN(SC9860_IIS1DI),
	SPRD_PINCTRL_PIN(SC9860_IIS1DO),
	SPRD_PINCTRL_PIN(SC9860_IIS1CLK),
	SPRD_PINCTRL_PIN(SC9860_IIS1LRCK),
	SPRD_PINCTRL_PIN(SC9860_SPI0_CSN),
	SPRD_PINCTRL_PIN(SC9860_SPI0_DO),
	SPRD_PINCTRL_PIN(SC9860_SPI0_DI),
	SPRD_PINCTRL_PIN(SC9860_SPI0_CLK),
	SPRD_PINCTRL_PIN(SC9860_U2TXD),
	SPRD_PINCTRL_PIN(SC9860_U2RXD),
	SPRD_PINCTRL_PIN(SC9860_U4TXD),
	SPRD_PINCTRL_PIN(SC9860_U4RXD),
	SPRD_PINCTRL_PIN(SC9860_CMMCLK1),
	SPRD_PINCTRL_PIN(SC9860_CMRST1),
	SPRD_PINCTRL_PIN(SC9860_CMMCLK0),
	SPRD_PINCTRL_PIN(SC9860_CMRST0),
	SPRD_PINCTRL_PIN(SC9860_CMPD0),
	SPRD_PINCTRL_PIN(SC9860_CMPD1),
	SPRD_PINCTRL_PIN(SC9860_SCL0),
	SPRD_PINCTRL_PIN(SC9860_SDA0),
	SPRD_PINCTRL_PIN(SC9860_SDA6),
	SPRD_PINCTRL_PIN(SC9860_SCL6),
	SPRD_PINCTRL_PIN(SC9860_U1TXD),
	SPRD_PINCTRL_PIN(SC9860_U1RXD),
	SPRD_PINCTRL_PIN(SC9860_KEYOUT0),
	SPRD_PINCTRL_PIN(SC9860_KEYOUT1),
	SPRD_PINCTRL_PIN(SC9860_KEYOUT2),
	SPRD_PINCTRL_PIN(SC9860_KEYIN0),
	SPRD_PINCTRL_PIN(SC9860_KEYIN1),
	SPRD_PINCTRL_PIN(SC9860_KEYIN2),
	SPRD_PINCTRL_PIN(SC9860_IIS3DI),
	SPRD_PINCTRL_PIN(SC9860_IIS3DO),
	SPRD_PINCTRL_PIN(SC9860_IIS3CLK),
	SPRD_PINCTRL_PIN(SC9860_IIS3LRCK),
	SPRD_PINCTRL_PIN(SC9860_RFCTL0),
	SPRD_PINCTRL_PIN(SC9860_RFCTL1),
	SPRD_PINCTRL_PIN(SC9860_RFCTL10),
	SPRD_PINCTRL_PIN(SC9860_RFCTL11),
	SPRD_PINCTRL_PIN(SC9860_RFCTL12),
	SPRD_PINCTRL_PIN(SC9860_RFCTL13),
	SPRD_PINCTRL_PIN(SC9860_RFCTL14),
	SPRD_PINCTRL_PIN(SC9860_RFCTL15),
	SPRD_PINCTRL_PIN(SC9860_RFCTL16),
	SPRD_PINCTRL_PIN(SC9860_RFCTL17),
	SPRD_PINCTRL_PIN(SC9860_RFCTL18),
	SPRD_PINCTRL_PIN(SC9860_RFCTL19),
	SPRD_PINCTRL_PIN(SC9860_RFCTL2),
	SPRD_PINCTRL_PIN(SC9860_EXTINT5),
	SPRD_PINCTRL_PIN(SC9860_EXTINT6),
	SPRD_PINCTRL_PIN(SC9860_EXTINT7),
	SPRD_PINCTRL_PIN(SC9860_GPIO30),
	SPRD_PINCTRL_PIN(SC9860_GPIO31),
	SPRD_PINCTRL_PIN(SC9860_GPIO32),
	SPRD_PINCTRL_PIN(SC9860_GPIO33),
	SPRD_PINCTRL_PIN(SC9860_GPIO34),
	SPRD_PINCTRL_PIN(SC9860_RFCTL3),
	SPRD_PINCTRL_PIN(SC9860_RFCTL4),
	SPRD_PINCTRL_PIN(SC9860_RFCTL5),
	SPRD_PINCTRL_PIN(SC9860_RFCTL6),
	SPRD_PINCTRL_PIN(SC9860_RFCTL7),
	SPRD_PINCTRL_PIN(SC9860_RFCTL8),
	SPRD_PINCTRL_PIN(SC9860_RFCTL9),
	SPRD_PINCTRL_PIN(SC9860_RFFE0_SCK0),
	SPRD_PINCTRL_PIN(SC9860_GPIO38),
	SPRD_PINCTRL_PIN(SC9860_RFFE0_SDA0),
	SPRD_PINCTRL_PIN(SC9860_GPIO39),
	SPRD_PINCTRL_PIN(SC9860_RFFE1_SCK0),
	SPRD_PINCTRL_PIN(SC9860_GPIO181),
	SPRD_PINCTRL_PIN(SC9860_RFFE1_SDA0),
	SPRD_PINCTRL_PIN(SC9860_GPIO182),
	SPRD_PINCTRL_PIN(SC9860_RF_LVDS0_ADC_ON),
	SPRD_PINCTRL_PIN(SC9860_RF_LVDS0_DAC_ON),
	SPRD_PINCTRL_PIN(SC9860_RFSCK0),
	SPRD_PINCTRL_PIN(SC9860_RFSDA0),
	SPRD_PINCTRL_PIN(SC9860_RFSEN0),
	SPRD_PINCTRL_PIN(SC9860_RF_LVDS1_ADC_ON),
	SPRD_PINCTRL_PIN(SC9860_RF_LVDS1_DAC_ON),
	SPRD_PINCTRL_PIN(SC9860_RFSCK1),
	SPRD_PINCTRL_PIN(SC9860_RFSDA1),
	SPRD_PINCTRL_PIN(SC9860_RFSEN1),
	SPRD_PINCTRL_PIN(SC9860_RFCTL38),
	SPRD_PINCTRL_PIN(SC9860_RFCTL39),
	SPRD_PINCTRL_PIN(SC9860_RFCTL20_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL21_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL30_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL31_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL32_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL33_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL34_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL35_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL36_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL37_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL22_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL23_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL24_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL25_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL26_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL27_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL28_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL29_MISC),
	SPRD_PINCTRL_PIN(SC9860_SCL2_MISC),
	SPRD_PINCTRL_PIN(SC9860_SDA2_MISC),
	SPRD_PINCTRL_PIN(SC9860_MTCK_ARM_MISC),
	SPRD_PINCTRL_PIN(SC9860_MTMS_ARM_MISC),
	SPRD_PINCTRL_PIN(SC9860_XTL_EN0_MISC),
	SPRD_PINCTRL_PIN(SC9860_PTEST_MISC),
	SPRD_PINCTRL_PIN(SC9860_AUD_DAD1_MISC),
	SPRD_PINCTRL_PIN(SC9860_AUD_ADD0_MISC),
	SPRD_PINCTRL_PIN(SC9860_AUD_ADSYNC_MISC),
	SPRD_PINCTRL_PIN(SC9860_AUD_SCLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_CHIP_SLEEP_MISC),
	SPRD_PINCTRL_PIN(SC9860_CLK_32K_MISC),
	SPRD_PINCTRL_PIN(SC9860_DCDC_ARM_EN_MISC),
	SPRD_PINCTRL_PIN(SC9860_EXT_RST_B_MISC),
	SPRD_PINCTRL_PIN(SC9860_ADI_D_MISC),
	SPRD_PINCTRL_PIN(SC9860_ADI_SCLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_XTL_EN1_MISC),
	SPRD_PINCTRL_PIN(SC9860_ANA_INT_MISC),
	SPRD_PINCTRL_PIN(SC9860_AUD_DAD0_MISC),
	SPRD_PINCTRL_PIN(SC9860_AUD_DASYNC_MISC),
	SPRD_PINCTRL_PIN(SC9860_LCM_RSTN_MISC),
	SPRD_PINCTRL_PIN(SC9860_DSI_TE_MISC),
	SPRD_PINCTRL_PIN(SC9860_PWMA_MISC),
	SPRD_PINCTRL_PIN(SC9860_EXTINT0_MISC),
	SPRD_PINCTRL_PIN(SC9860_EXTINT1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SDA1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SCL1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMCLK2_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMDA2_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMRST2_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMCLK1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMDA1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMRST1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMCLK0_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMDA0_MISC),
	SPRD_PINCTRL_PIN(SC9860_SIMRST0_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD2_CMD_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD2_D0_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD2_D1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD2_CLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD2_D2_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD2_D3_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD0_D3_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD0_D2_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD0_CMD_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD0_D0_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD0_D1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD0_CLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_CMD_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D6_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D7_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_CLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D5_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D4_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_DS_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D3_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_RST_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D1_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D2_MISC),
	SPRD_PINCTRL_PIN(SC9860_EMMC_D0_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS0DI_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS0DO_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS0CLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS0LRCK_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD1_CLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD1_CMD_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD1_D0_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD1_D1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD1_D2_MISC),
	SPRD_PINCTRL_PIN(SC9860_SD1_D3_MISC),
	SPRD_PINCTRL_PIN(SC9860_CLK_AUX0_MISC),
	SPRD_PINCTRL_PIN(SC9860_WIFI_COEXIST_MISC),
	SPRD_PINCTRL_PIN(SC9860_BEIDOU_COEXIST_MISC),
	SPRD_PINCTRL_PIN(SC9860_U3TXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_U3RXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_U3CTS_MISC),
	SPRD_PINCTRL_PIN(SC9860_U3RTS_MISC),
	SPRD_PINCTRL_PIN(SC9860_U0TXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_U0RXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_U0CTS_MISC),
	SPRD_PINCTRL_PIN(SC9860_U0RTS_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS1DI_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS1DO_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS1CLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS1LRCK_MISC),
	SPRD_PINCTRL_PIN(SC9860_SPI0_CSN_MISC),
	SPRD_PINCTRL_PIN(SC9860_SPI0_DO_MISC),
	SPRD_PINCTRL_PIN(SC9860_SPI0_DI_MISC),
	SPRD_PINCTRL_PIN(SC9860_SPI0_CLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_U2TXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_U2RXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_U4TXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_U4RXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_CMMCLK1_MISC),
	SPRD_PINCTRL_PIN(SC9860_CMRST1_MISC),
	SPRD_PINCTRL_PIN(SC9860_CMMCLK0_MISC),
	SPRD_PINCTRL_PIN(SC9860_CMRST0_MISC),
	SPRD_PINCTRL_PIN(SC9860_CMPD0_MISC),
	SPRD_PINCTRL_PIN(SC9860_CMPD1_MISC),
	SPRD_PINCTRL_PIN(SC9860_SCL0_MISC),
	SPRD_PINCTRL_PIN(SC9860_SDA0_MISC),
	SPRD_PINCTRL_PIN(SC9860_SDA6_MISC),
	SPRD_PINCTRL_PIN(SC9860_SCL6_MISC),
	SPRD_PINCTRL_PIN(SC9860_U1TXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_U1RXD_MISC),
	SPRD_PINCTRL_PIN(SC9860_KEYOUT0_MISC),
	SPRD_PINCTRL_PIN(SC9860_KEYOUT1_MISC),
	SPRD_PINCTRL_PIN(SC9860_KEYOUT2_MISC),
	SPRD_PINCTRL_PIN(SC9860_KEYIN0_MISC),
	SPRD_PINCTRL_PIN(SC9860_KEYIN1_MISC),
	SPRD_PINCTRL_PIN(SC9860_KEYIN2_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS3DI_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS3DO_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS3CLK_MISC),
	SPRD_PINCTRL_PIN(SC9860_IIS3LRCK_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL0_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL1_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL10_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL11_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL12_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL13_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL14_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL15_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL16_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL17_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL18_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL19_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL2_MISC),
	SPRD_PINCTRL_PIN(SC9860_EXTINT5_MISC),
	SPRD_PINCTRL_PIN(SC9860_EXTINT6_MISC),
	SPRD_PINCTRL_PIN(SC9860_EXTINT7_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO30_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO31_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO32_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO33_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO34_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL3_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL4_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL5_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL6_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL7_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL8_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL9_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFFE0_SCK0_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO38_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFFE0_SDA0_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO39_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFFE1_SCK0_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO181_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFFE1_SDA0_MISC),
	SPRD_PINCTRL_PIN(SC9860_GPIO182_MISC),
	SPRD_PINCTRL_PIN(SC9860_RF_LVDS0_ADC_ON_MISC),
	SPRD_PINCTRL_PIN(SC9860_RF_LVDS0_DAC_ON_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFSCK0_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFSDA0_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFSEN0_MISC),
	SPRD_PINCTRL_PIN(SC9860_RF_LVDS1_ADC_ON_MISC),
	SPRD_PINCTRL_PIN(SC9860_RF_LVDS1_DAC_ON_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFSCK1_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFSDA1_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFSEN1_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL38_MISC),
	SPRD_PINCTRL_PIN(SC9860_RFCTL39_MISC),
};

static int sprd_pinctrl_probe(struct platform_device *pdev)
{
	return sprd_pinctrl_core_probe(pdev, sprd_sc9860_pins_info,
				       ARRAY_SIZE(sprd_sc9860_pins_info));
}

static const struct of_device_id sprd_pinctrl_of_match[] = {
	{
		.compatible = "sprd,sc9860-pinctrl",
	},
	{ },
};
MODULE_DEVICE_TABLE(of, sprd_pinctrl_of_match);

static struct platform_driver sprd_pinctrl_driver = {
	.driver = {
		.name = "sprd-pinctrl",
		.of_match_table = sprd_pinctrl_of_match,
	},
	.probe = sprd_pinctrl_probe,
	.remove_new = sprd_pinctrl_remove,
	.shutdown = sprd_pinctrl_shutdown,
};
module_platform_driver(sprd_pinctrl_driver);

MODULE_DESCRIPTION("SPREADTRUM Pin Controller Driver");
MODULE_AUTHOR("Baolin Wang <baolin.wang@spreadtrum.com>");
MODULE_LICENSE("GPL v2");
