package tests::LrTimeslotTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::SQLExt::LrTimeslot;

use POSIX qw/tzset/;

sub test_lr_timeslot {
    my $self = $_[0];

    my @tests =
      (
       [ '2003-10-13 14:12:03 EDT', 'EST5EDT', 1066068723, 1, 's', 3 ],
       [ '2003-10-13 14:12:03 EDT', 'EST5EDT', 1066068723, 1, 'm', 12 ],

       [ '2003-10-13 00:00 EDT', 'EST5EDT', 1066017600, 1, 'h', 0 ],
       [ '2003-10-13 14:00 EDT', 'EST5EDT', 1066068000, 1, 'h', 14 ],
       [ '2003-10-13 14:12 EDT', 'EST5EDT', 1066068720, 1, 'h', 14 ],
       [ '2003-10-13 23:12 EDT', 'EST5EDT', 1066101120, 1, 'h', 23 ],
       [ '2003-10-13 00:00 EDT', 'EST5EDT', 1066017600, 4, 'h', 0 ],
       [ '2003-10-13 14:00 EDT', 'EST5EDT', 1066068000, 4, 'h', 12 ],
       [ '2003-10-13 23:12 EDT', 'EST5EDT', 1066101120, 4, 'h', 20 ],
       [ '2003-10-13 23:12 EDT', 'EST5EDT', 1066101120, 5, 'h', 20 ],

       [ '2003-10-13 00:00 EDT', 'EST5EDT', 1066017600, 1, 'd', 1 ],
       [ '2003-10-13 00:00 UTC', 'UTC', 1066003200, 1, 'd', 1 ],
       [ '2003-10-12 01:00 EDT', 'EST5EDT', 1065934800, 1, 'd', 0 ],
       [ '2003-10-12 01:00 UTC', 'UTC', 1065920400, 1, 'd', 0 ],
       [ '2003-10-13 00:00 EDT', 'EST5EDT', 1066017600, 2, 'd', 0 ],
       [ '2003-10-13 00:00 UTC', 'UTC', 1066003200, 2, 'd', 0 ],

       [ '2003-01-01 00:00 EDT', 'EST5EDT', 1041397200, 1, 'M', 0 ],
       [ '2003-01-01 00:00 UTC', 'UTC', 1041379200, 1, 'M', 0 ],
       [ '2003-12-31 00:00 EDT', 'EST5EDT', 1072846800, 1, 'M', 11 ],
       [ '2003-12-31 00:00 UTC', 'UTC', 1072828800, 1, 'M', 11 ],
       [ '2003-01-01 00:00 EDT', 'EST5EDT', 1041397200, 3, 'M', 0 ],
       [ '2003-01-01 00:00 UTC', 'UTC', 1041379200, 3, 'M', 0 ],
       [ '2003-12-31 00:00 EDT', 'EST5EDT', 1072846800, 3, 'M', 9 ],
       [ '2003-12-31 00:00 UTC', 'UTC', 1072828800, 3, 'M', 9 ],

       );

    $self->assert_null( Lire::SQLExt::LrTimeslot::lr_timeslot( undef, 1, 'h' ),
                        "lr_timeslot( undef ) should return undef" );
    $self->assert_null( Lire::SQLExt::LrTimeslot::lr_timeslot( time, 1, 'x' ),
                        "lr_timeslot( time(), 1, 'x' ) should return undef" );
    $self->assert_null( Lire::SQLExt::LrTimeslot::lr_timeslot( time, undef, 'h' ),
                        "lr_timeslot( time(), undef, 'h' ) should return undef" );
    my $old_tz = $ENV{'TZ'};
    foreach my $t ( @tests ) {
        my ( $date, $tz, $epoch, $mult, $unit, $result ) = @$t;
        $ENV{'TZ'} = $tz;
        tzset();
        my $r =
          Lire::SQLExt::LrTimeslot::lr_timeslot( $epoch, $mult, $unit );
        $ENV{'TZ'} =  $old_tz || '';
        tzset();
        $self->assert_not_null( $r, "lr_timeslot( '$date', $mult, $unit ) returned undef" );
        $self->assert_equals( $result, $r, 
                              "lr_timeslot( '$date', $mult, $unit ) returned $r, expected $result" );
    }
}

sub test_lr_timeslot_week {
        my $self = $_[0];

    my @tests =
      ( [ '2003-01-01 00:15 CET', 'CET', 'ISO', 1, 1041376500, 1 ],
        [ '2003-01-01 00:15 CET', 'CET', 'ISO', 4, 1041376500, 1 ],
        [ '2002-12-31 23:15 CET', 'CET', 'ISO', 1, 1041372900, 1 ],
        [ '2003-10-14 12:00 UTC', 'UTC', 'ISO', 1, 1066125600, 42 ],
        [ '2003-10-14 12:00 UTC', 'UTC', 'ISO', 4, 1066125600, 41 ],
        [ '2003-01-22 00:00 EST', 'EST', 'ISO', 4, 1043211600, 1 ],
        [ '2003-01-29 00:00 EST', 'EST', 'ISO', 4, 1043816400, 5 ],
        [ '2003-02-19 00:00 EST', 'EST', 'ISO', 4, 1045630800, 5 ],

        # Weeks start on sunday
        [ '2003-01-01 00:15 CET', 'CET', 'U', 1, 1041376500,  0 ],
        # Week 0 is grouped in Week 1
        [ '2003-01-01 00:15 CET', 'CET', 'U', 4, 1041376500,  1 ],
        [ '2002-12-31 23:15 CET', 'CET', 'U', 1, 1041372900,  52 ],
        [ '2003-10-14 12:00 UTC', 'UTC', 'U', 1, 1066125600,  41 ],
        [ '2003-10-14 12:00 UTC', 'UTC', 'U', 4, 1066125600,  41 ],
        [ '2003-01-29 00:00 EST', 'EST', 'U', 4, 1043816400,  1 ],
        [ '2003-02-04 00:00 EST', 'EST', 'U', 4, 1044334800,  5 ],
      );
    $self->assert_null( Lire::SQLExt::LrTimeslot::lr_timeslot_week( undef ),
                        "lr_timeslot_week( undef ) should return undef" );
    $self->assert_null( Lire::SQLExt::LrTimeslot::lr_timeslot_week( time(),
                                                                    undef ),
                        "lr_timeslot_week( time(), undef ) should return undef" );
    my $old_tz = $ENV{'TZ'};
    foreach my $t ( @tests ) {
        my ( $date, $tz, $style, $mult, $epoch, $result ) = @$t;
        $ENV{'TZ'} = $tz;
        tzset();
        $self->{'cfg'}{'lr_week_numbering'} = $style;
        $Lire::SQLExt::LrTimeslot::calc = undef;
        my $r = Lire::SQLExt::LrTimeslot::lr_timeslot_week( $epoch, $mult );
        $ENV{'TZ'} =  $old_tz || '';
        tzset();
        $self->assert_not_null( "lr_timeslot_week( '$date', $mult ) using $style returned undef" );
        $self->assert_equals( $result, $r,
                              "lr_timeslot_week( '$date', $mult ) using $style returned $r, expected $result" );
    }
}

1;
