; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+f,+d,+v -verify-machineinstrs < %s | FileCheck %s

; i32 saturate

define <2 x i32> @stest_f64i32(<2 x double> %x) {
; CHECK-LABEL: stest_f64i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a1
; CHECK-NEXT:    fmv.d.x ft1, a0
; CHECK-NEXT:    fcvt.l.d a1, ft0, rtz
; CHECK-NEXT:    lui a2, 524288
; CHECK-NEXT:    addiw a3, a2, -1
; CHECK-NEXT:    fcvt.l.d a0, ft1, rtz
; CHECK-NEXT:    bge a1, a3, .LBB0_5
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bge a0, a3, .LBB0_6
; CHECK-NEXT:  .LBB0_2: # %entry
; CHECK-NEXT:    bge a2, a0, .LBB0_7
; CHECK-NEXT:  .LBB0_3: # %entry
; CHECK-NEXT:    bge a2, a1, .LBB0_8
; CHECK-NEXT:  .LBB0_4: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB0_5: # %entry
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    blt a0, a3, .LBB0_2
; CHECK-NEXT:  .LBB0_6: # %entry
; CHECK-NEXT:    mv a0, a3
; CHECK-NEXT:    blt a2, a0, .LBB0_3
; CHECK-NEXT:  .LBB0_7: # %entry
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    blt a2, a1, .LBB0_4
; CHECK-NEXT:  .LBB0_8: # %entry
; CHECK-NEXT:    lui a1, 524288
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 2147483647, i64 2147483647>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>
  %1 = icmp sgt <2 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32(<2 x double> %x) {
; CHECK-LABEL: utest_f64i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a0
; CHECK-NEXT:    fmv.d.x ft1, a1
; CHECK-NEXT:    fcvt.lu.d a0, ft0, rtz
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    srli a2, a1, 32
; CHECK-NEXT:    fcvt.lu.d a1, ft1, rtz
; CHECK-NEXT:    bgeu a0, a2, .LBB1_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bgeu a1, a2, .LBB1_4
; CHECK-NEXT:  .LBB1_2: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB1_3: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bltu a1, a2, .LBB1_2
; CHECK-NEXT:  .LBB1_4: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %0 = icmp ult <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a1
; CHECK-NEXT:    fmv.d.x ft1, a0
; CHECK-NEXT:    fcvt.l.d a1, ft0, rtz
; CHECK-NEXT:    li a0, -1
; CHECK-NEXT:    srli a2, a0, 32
; CHECK-NEXT:    fcvt.l.d a0, ft1, rtz
; CHECK-NEXT:    bge a1, a2, .LBB2_5
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bge a0, a2, .LBB2_6
; CHECK-NEXT:  .LBB2_2: # %entry
; CHECK-NEXT:    blez a0, .LBB2_7
; CHECK-NEXT:  .LBB2_3: # %entry
; CHECK-NEXT:    blez a1, .LBB2_8
; CHECK-NEXT:  .LBB2_4: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB2_5: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    blt a0, a2, .LBB2_2
; CHECK-NEXT:  .LBB2_6: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bgtz a0, .LBB2_3
; CHECK-NEXT:  .LBB2_7: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    bgtz a1, .LBB2_4
; CHECK-NEXT:  .LBB2_8: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %1 = icmp sgt <2 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> zeroinitializer
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32(<4 x float> %x) {
; CHECK-LABEL: stest_f32i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fmv.w.x ft2, a3
; CHECK-NEXT:    fmv.w.x ft0, a2
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    lui a4, 524288
; CHECK-NEXT:    addiw a6, a4, -1
; CHECK-NEXT:    fcvt.l.s a3, ft2, rtz
; CHECK-NEXT:    blt a2, a6, .LBB3_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a6
; CHECK-NEXT:  .LBB3_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fcvt.l.s a1, ft0, rtz
; CHECK-NEXT:    bge a3, a6, .LBB3_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.l.s a5, ft1, rtz
; CHECK-NEXT:    bge a1, a6, .LBB3_12
; CHECK-NEXT:  .LBB3_4: # %entry
; CHECK-NEXT:    bge a5, a6, .LBB3_13
; CHECK-NEXT:  .LBB3_5: # %entry
; CHECK-NEXT:    bge a4, a5, .LBB3_14
; CHECK-NEXT:  .LBB3_6: # %entry
; CHECK-NEXT:    bge a4, a1, .LBB3_15
; CHECK-NEXT:  .LBB3_7: # %entry
; CHECK-NEXT:    bge a4, a3, .LBB3_16
; CHECK-NEXT:  .LBB3_8: # %entry
; CHECK-NEXT:    blt a4, a2, .LBB3_10
; CHECK-NEXT:  .LBB3_9: # %entry
; CHECK-NEXT:    lui a2, 524288
; CHECK-NEXT:  .LBB3_10: # %entry
; CHECK-NEXT:    sw a2, 12(a0)
; CHECK-NEXT:    sw a3, 8(a0)
; CHECK-NEXT:    sw a1, 4(a0)
; CHECK-NEXT:    sw a5, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB3_11: # %entry
; CHECK-NEXT:    mv a3, a6
; CHECK-NEXT:    fcvt.l.s a5, ft1, rtz
; CHECK-NEXT:    blt a1, a6, .LBB3_4
; CHECK-NEXT:  .LBB3_12: # %entry
; CHECK-NEXT:    mv a1, a6
; CHECK-NEXT:    blt a5, a6, .LBB3_5
; CHECK-NEXT:  .LBB3_13: # %entry
; CHECK-NEXT:    mv a5, a6
; CHECK-NEXT:    blt a4, a5, .LBB3_6
; CHECK-NEXT:  .LBB3_14: # %entry
; CHECK-NEXT:    lui a5, 524288
; CHECK-NEXT:    blt a4, a1, .LBB3_7
; CHECK-NEXT:  .LBB3_15: # %entry
; CHECK-NEXT:    lui a1, 524288
; CHECK-NEXT:    blt a4, a3, .LBB3_8
; CHECK-NEXT:  .LBB3_16: # %entry
; CHECK-NEXT:    lui a3, 524288
; CHECK-NEXT:    bge a4, a2, .LBB3_9
; CHECK-NEXT:    j .LBB3_10
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32(<4 x float> %x) {
; CHECK-LABEL: utest_f32i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fmv.w.x ft2, a2
; CHECK-NEXT:    fmv.w.x ft0, a3
; CHECK-NEXT:    fcvt.lu.s a1, ft1, rtz
; CHECK-NEXT:    li a2, -1
; CHECK-NEXT:    srli a3, a2, 32
; CHECK-NEXT:    fcvt.lu.s a2, ft2, rtz
; CHECK-NEXT:    bltu a1, a3, .LBB4_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB4_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fcvt.lu.s a4, ft0, rtz
; CHECK-NEXT:    bgeu a2, a3, .LBB4_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.lu.s a5, ft1, rtz
; CHECK-NEXT:    bgeu a4, a3, .LBB4_8
; CHECK-NEXT:  .LBB4_4: # %entry
; CHECK-NEXT:    bltu a5, a3, .LBB4_6
; CHECK-NEXT:  .LBB4_5: # %entry
; CHECK-NEXT:    mv a5, a3
; CHECK-NEXT:  .LBB4_6: # %entry
; CHECK-NEXT:    sw a5, 12(a0)
; CHECK-NEXT:    sw a4, 8(a0)
; CHECK-NEXT:    sw a2, 4(a0)
; CHECK-NEXT:    sw a1, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB4_7: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    fcvt.lu.s a5, ft1, rtz
; CHECK-NEXT:    bltu a4, a3, .LBB4_4
; CHECK-NEXT:  .LBB4_8: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bgeu a5, a3, .LBB4_5
; CHECK-NEXT:    j .LBB4_6
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fmv.w.x ft2, a3
; CHECK-NEXT:    fmv.w.x ft0, a2
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    li a3, -1
; CHECK-NEXT:    srli a5, a3, 32
; CHECK-NEXT:    fcvt.l.s a3, ft2, rtz
; CHECK-NEXT:    blt a2, a5, .LBB5_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a5
; CHECK-NEXT:  .LBB5_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fcvt.l.s a1, ft0, rtz
; CHECK-NEXT:    bge a3, a5, .LBB5_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.l.s a4, ft1, rtz
; CHECK-NEXT:    bge a1, a5, .LBB5_12
; CHECK-NEXT:  .LBB5_4: # %entry
; CHECK-NEXT:    bge a4, a5, .LBB5_13
; CHECK-NEXT:  .LBB5_5: # %entry
; CHECK-NEXT:    blez a4, .LBB5_14
; CHECK-NEXT:  .LBB5_6: # %entry
; CHECK-NEXT:    blez a1, .LBB5_15
; CHECK-NEXT:  .LBB5_7: # %entry
; CHECK-NEXT:    blez a3, .LBB5_16
; CHECK-NEXT:  .LBB5_8: # %entry
; CHECK-NEXT:    bgtz a2, .LBB5_10
; CHECK-NEXT:  .LBB5_9: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:  .LBB5_10: # %entry
; CHECK-NEXT:    sw a2, 12(a0)
; CHECK-NEXT:    sw a3, 8(a0)
; CHECK-NEXT:    sw a1, 4(a0)
; CHECK-NEXT:    sw a4, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB5_11: # %entry
; CHECK-NEXT:    mv a3, a5
; CHECK-NEXT:    fcvt.l.s a4, ft1, rtz
; CHECK-NEXT:    blt a1, a5, .LBB5_4
; CHECK-NEXT:  .LBB5_12: # %entry
; CHECK-NEXT:    mv a1, a5
; CHECK-NEXT:    blt a4, a5, .LBB5_5
; CHECK-NEXT:  .LBB5_13: # %entry
; CHECK-NEXT:    mv a4, a5
; CHECK-NEXT:    bgtz a4, .LBB5_6
; CHECK-NEXT:  .LBB5_14: # %entry
; CHECK-NEXT:    li a4, 0
; CHECK-NEXT:    bgtz a1, .LBB5_7
; CHECK-NEXT:  .LBB5_15: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgtz a3, .LBB5_8
; CHECK-NEXT:  .LBB5_16: # %entry
; CHECK-NEXT:    li a3, 0
; CHECK-NEXT:    blez a2, .LBB5_9
; CHECK-NEXT:    j .LBB5_10
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32(<4 x half> %x) {
; CHECK-LABEL: stest_f16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    lhu s2, 24(a1)
; CHECK-NEXT:    lhu s1, 0(a1)
; CHECK-NEXT:    lhu s3, 8(a1)
; CHECK-NEXT:    lhu a1, 16(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s3
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.l.s s3, ft0, rtz
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.l.s a0, ft0, rtz
; CHECK-NEXT:    lui a1, 524288
; CHECK-NEXT:    addiw a4, a1, -1
; CHECK-NEXT:    blt a0, a4, .LBB6_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a4
; CHECK-NEXT:  .LBB6_2: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s1
; CHECK-NEXT:    flw ft1, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    bge s3, a4, .LBB6_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.l.s a3, ft0, rtz
; CHECK-NEXT:    bge a2, a4, .LBB6_12
; CHECK-NEXT:  .LBB6_4: # %entry
; CHECK-NEXT:    bge a3, a4, .LBB6_13
; CHECK-NEXT:  .LBB6_5: # %entry
; CHECK-NEXT:    bge a1, a3, .LBB6_14
; CHECK-NEXT:  .LBB6_6: # %entry
; CHECK-NEXT:    bge a1, a2, .LBB6_15
; CHECK-NEXT:  .LBB6_7: # %entry
; CHECK-NEXT:    bge a1, s3, .LBB6_16
; CHECK-NEXT:  .LBB6_8: # %entry
; CHECK-NEXT:    blt a1, a0, .LBB6_10
; CHECK-NEXT:  .LBB6_9: # %entry
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:  .LBB6_10: # %entry
; CHECK-NEXT:    sw a0, 12(s0)
; CHECK-NEXT:    sw s3, 8(s0)
; CHECK-NEXT:    sw a2, 4(s0)
; CHECK-NEXT:    sw a3, 0(s0)
; CHECK-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB6_11: # %entry
; CHECK-NEXT:    mv s3, a4
; CHECK-NEXT:    fcvt.l.s a3, ft0, rtz
; CHECK-NEXT:    blt a2, a4, .LBB6_4
; CHECK-NEXT:  .LBB6_12: # %entry
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:    blt a3, a4, .LBB6_5
; CHECK-NEXT:  .LBB6_13: # %entry
; CHECK-NEXT:    mv a3, a4
; CHECK-NEXT:    blt a1, a3, .LBB6_6
; CHECK-NEXT:  .LBB6_14: # %entry
; CHECK-NEXT:    lui a3, 524288
; CHECK-NEXT:    blt a1, a2, .LBB6_7
; CHECK-NEXT:  .LBB6_15: # %entry
; CHECK-NEXT:    lui a2, 524288
; CHECK-NEXT:    blt a1, s3, .LBB6_8
; CHECK-NEXT:  .LBB6_16: # %entry
; CHECK-NEXT:    lui s3, 524288
; CHECK-NEXT:    bge a1, a0, .LBB6_9
; CHECK-NEXT:    j .LBB6_10
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32(<4 x half> %x) {
; CHECK-LABEL: utesth_f16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    lhu s2, 0(a1)
; CHECK-NEXT:    lhu s1, 24(a1)
; CHECK-NEXT:    lhu s3, 16(a1)
; CHECK-NEXT:    lhu a1, 8(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s3
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.lu.s s3, ft0, rtz
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.lu.s a0, ft0, rtz
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    srli a1, a1, 32
; CHECK-NEXT:    bltu a0, a1, .LBB7_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB7_2: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s1
; CHECK-NEXT:    flw ft1, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.lu.s a2, ft1, rtz
; CHECK-NEXT:    bgeu s3, a1, .LBB7_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.lu.s a3, ft0, rtz
; CHECK-NEXT:    bgeu a2, a1, .LBB7_8
; CHECK-NEXT:  .LBB7_4: # %entry
; CHECK-NEXT:    bltu a3, a1, .LBB7_6
; CHECK-NEXT:  .LBB7_5: # %entry
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:  .LBB7_6: # %entry
; CHECK-NEXT:    sw a3, 12(s0)
; CHECK-NEXT:    sw a2, 8(s0)
; CHECK-NEXT:    sw s3, 4(s0)
; CHECK-NEXT:    sw a0, 0(s0)
; CHECK-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB7_7: # %entry
; CHECK-NEXT:    mv s3, a1
; CHECK-NEXT:    fcvt.lu.s a3, ft0, rtz
; CHECK-NEXT:    bltu a2, a1, .LBB7_4
; CHECK-NEXT:  .LBB7_8: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    bgeu a3, a1, .LBB7_5
; CHECK-NEXT:    j .LBB7_6
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32(<4 x half> %x) {
; CHECK-LABEL: ustest_f16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    lhu s2, 24(a1)
; CHECK-NEXT:    lhu s1, 0(a1)
; CHECK-NEXT:    lhu s3, 8(a1)
; CHECK-NEXT:    lhu a1, 16(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s3
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.l.s s3, ft0, rtz
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.l.s a0, ft0, rtz
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    srli a3, a1, 32
; CHECK-NEXT:    blt a0, a3, .LBB8_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a3
; CHECK-NEXT:  .LBB8_2: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s1
; CHECK-NEXT:    flw ft1, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.l.s a1, ft1, rtz
; CHECK-NEXT:    bge s3, a3, .LBB8_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.l.s a2, ft0, rtz
; CHECK-NEXT:    bge a1, a3, .LBB8_12
; CHECK-NEXT:  .LBB8_4: # %entry
; CHECK-NEXT:    bge a2, a3, .LBB8_13
; CHECK-NEXT:  .LBB8_5: # %entry
; CHECK-NEXT:    blez a2, .LBB8_14
; CHECK-NEXT:  .LBB8_6: # %entry
; CHECK-NEXT:    blez a1, .LBB8_15
; CHECK-NEXT:  .LBB8_7: # %entry
; CHECK-NEXT:    blez s3, .LBB8_16
; CHECK-NEXT:  .LBB8_8: # %entry
; CHECK-NEXT:    bgtz a0, .LBB8_10
; CHECK-NEXT:  .LBB8_9: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB8_10: # %entry
; CHECK-NEXT:    sw a0, 12(s0)
; CHECK-NEXT:    sw s3, 8(s0)
; CHECK-NEXT:    sw a1, 4(s0)
; CHECK-NEXT:    sw a2, 0(s0)
; CHECK-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB8_11: # %entry
; CHECK-NEXT:    mv s3, a3
; CHECK-NEXT:    fcvt.l.s a2, ft0, rtz
; CHECK-NEXT:    blt a1, a3, .LBB8_4
; CHECK-NEXT:  .LBB8_12: # %entry
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    blt a2, a3, .LBB8_5
; CHECK-NEXT:  .LBB8_13: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    bgtz a2, .LBB8_6
; CHECK-NEXT:  .LBB8_14: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    bgtz a1, .LBB8_7
; CHECK-NEXT:  .LBB8_15: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgtz s3, .LBB8_8
; CHECK-NEXT:  .LBB8_16: # %entry
; CHECK-NEXT:    li s3, 0
; CHECK-NEXT:    blez a0, .LBB8_9
; CHECK-NEXT:    j .LBB8_10
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16(<2 x double> %x) {
; CHECK-LABEL: stest_f64i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a1
; CHECK-NEXT:    fmv.d.x ft1, a0
; CHECK-NEXT:    fcvt.w.d a1, ft0, rtz
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    addiw a2, a0, -1
; CHECK-NEXT:    fcvt.w.d a0, ft1, rtz
; CHECK-NEXT:    bge a1, a2, .LBB9_5
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bge a0, a2, .LBB9_6
; CHECK-NEXT:  .LBB9_2: # %entry
; CHECK-NEXT:    lui a2, 1048568
; CHECK-NEXT:    bge a2, a0, .LBB9_7
; CHECK-NEXT:  .LBB9_3: # %entry
; CHECK-NEXT:    bge a2, a1, .LBB9_8
; CHECK-NEXT:  .LBB9_4: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB9_5: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    blt a0, a2, .LBB9_2
; CHECK-NEXT:  .LBB9_6: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    lui a2, 1048568
; CHECK-NEXT:    blt a2, a0, .LBB9_3
; CHECK-NEXT:  .LBB9_7: # %entry
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    blt a2, a1, .LBB9_4
; CHECK-NEXT:  .LBB9_8: # %entry
; CHECK-NEXT:    lui a1, 1048568
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 32767, i32 32767>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>
  %1 = icmp sgt <2 x i32> %spec.store.select, <i32 -32768, i32 -32768>
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16(<2 x double> %x) {
; CHECK-LABEL: utest_f64i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a0
; CHECK-NEXT:    fmv.d.x ft1, a1
; CHECK-NEXT:    fcvt.wu.d a0, ft0, rtz
; CHECK-NEXT:    lui a1, 16
; CHECK-NEXT:    addiw a2, a1, -1
; CHECK-NEXT:    fcvt.wu.d a1, ft1, rtz
; CHECK-NEXT:    bgeu a0, a2, .LBB10_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bgeu a1, a2, .LBB10_4
; CHECK-NEXT:  .LBB10_2: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB10_3: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bltu a1, a2, .LBB10_2
; CHECK-NEXT:  .LBB10_4: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %0 = icmp ult <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a1
; CHECK-NEXT:    fmv.d.x ft1, a0
; CHECK-NEXT:    fcvt.w.d a1, ft0, rtz
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addiw a2, a0, -1
; CHECK-NEXT:    fcvt.w.d a0, ft1, rtz
; CHECK-NEXT:    bge a1, a2, .LBB11_5
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bge a0, a2, .LBB11_6
; CHECK-NEXT:  .LBB11_2: # %entry
; CHECK-NEXT:    blez a0, .LBB11_7
; CHECK-NEXT:  .LBB11_3: # %entry
; CHECK-NEXT:    blez a1, .LBB11_8
; CHECK-NEXT:  .LBB11_4: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB11_5: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    blt a0, a2, .LBB11_2
; CHECK-NEXT:  .LBB11_6: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bgtz a0, .LBB11_3
; CHECK-NEXT:  .LBB11_7: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    bgtz a1, .LBB11_4
; CHECK-NEXT:  .LBB11_8: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %1 = icmp sgt <2 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> zeroinitializer
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16(<4 x float> %x) {
; CHECK-LABEL: stest_f32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fmv.w.x ft2, a3
; CHECK-NEXT:    fmv.w.x ft0, a2
; CHECK-NEXT:    fcvt.w.s a2, ft1, rtz
; CHECK-NEXT:    lui a3, 8
; CHECK-NEXT:    addiw a5, a3, -1
; CHECK-NEXT:    fcvt.w.s a3, ft2, rtz
; CHECK-NEXT:    blt a2, a5, .LBB12_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a5
; CHECK-NEXT:  .LBB12_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fcvt.w.s a1, ft0, rtz
; CHECK-NEXT:    bge a3, a5, .LBB12_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.w.s a4, ft1, rtz
; CHECK-NEXT:    bge a1, a5, .LBB12_12
; CHECK-NEXT:  .LBB12_4: # %entry
; CHECK-NEXT:    bge a4, a5, .LBB12_13
; CHECK-NEXT:  .LBB12_5: # %entry
; CHECK-NEXT:    lui a5, 1048568
; CHECK-NEXT:    bge a5, a4, .LBB12_14
; CHECK-NEXT:  .LBB12_6: # %entry
; CHECK-NEXT:    bge a5, a1, .LBB12_15
; CHECK-NEXT:  .LBB12_7: # %entry
; CHECK-NEXT:    bge a5, a3, .LBB12_16
; CHECK-NEXT:  .LBB12_8: # %entry
; CHECK-NEXT:    blt a5, a2, .LBB12_10
; CHECK-NEXT:  .LBB12_9: # %entry
; CHECK-NEXT:    lui a2, 1048568
; CHECK-NEXT:  .LBB12_10: # %entry
; CHECK-NEXT:    sh a2, 6(a0)
; CHECK-NEXT:    sh a3, 4(a0)
; CHECK-NEXT:    sh a1, 2(a0)
; CHECK-NEXT:    sh a4, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB12_11: # %entry
; CHECK-NEXT:    mv a3, a5
; CHECK-NEXT:    fcvt.w.s a4, ft1, rtz
; CHECK-NEXT:    blt a1, a5, .LBB12_4
; CHECK-NEXT:  .LBB12_12: # %entry
; CHECK-NEXT:    mv a1, a5
; CHECK-NEXT:    blt a4, a5, .LBB12_5
; CHECK-NEXT:  .LBB12_13: # %entry
; CHECK-NEXT:    mv a4, a5
; CHECK-NEXT:    lui a5, 1048568
; CHECK-NEXT:    blt a5, a4, .LBB12_6
; CHECK-NEXT:  .LBB12_14: # %entry
; CHECK-NEXT:    lui a4, 1048568
; CHECK-NEXT:    blt a5, a1, .LBB12_7
; CHECK-NEXT:  .LBB12_15: # %entry
; CHECK-NEXT:    lui a1, 1048568
; CHECK-NEXT:    blt a5, a3, .LBB12_8
; CHECK-NEXT:  .LBB12_16: # %entry
; CHECK-NEXT:    lui a3, 1048568
; CHECK-NEXT:    bge a5, a2, .LBB12_9
; CHECK-NEXT:    j .LBB12_10
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <4 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16(<4 x float> %x) {
; CHECK-LABEL: utest_f32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fmv.w.x ft2, a2
; CHECK-NEXT:    fmv.w.x ft0, a3
; CHECK-NEXT:    fcvt.wu.s a1, ft1, rtz
; CHECK-NEXT:    lui a2, 16
; CHECK-NEXT:    addiw a3, a2, -1
; CHECK-NEXT:    fcvt.wu.s a2, ft2, rtz
; CHECK-NEXT:    bltu a1, a3, .LBB13_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB13_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fcvt.wu.s a4, ft0, rtz
; CHECK-NEXT:    bgeu a2, a3, .LBB13_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.wu.s a5, ft1, rtz
; CHECK-NEXT:    bgeu a4, a3, .LBB13_8
; CHECK-NEXT:  .LBB13_4: # %entry
; CHECK-NEXT:    bltu a5, a3, .LBB13_6
; CHECK-NEXT:  .LBB13_5: # %entry
; CHECK-NEXT:    mv a5, a3
; CHECK-NEXT:  .LBB13_6: # %entry
; CHECK-NEXT:    sh a5, 6(a0)
; CHECK-NEXT:    sh a4, 4(a0)
; CHECK-NEXT:    sh a2, 2(a0)
; CHECK-NEXT:    sh a1, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB13_7: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    fcvt.wu.s a5, ft1, rtz
; CHECK-NEXT:    bltu a4, a3, .LBB13_4
; CHECK-NEXT:  .LBB13_8: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bgeu a5, a3, .LBB13_5
; CHECK-NEXT:    j .LBB13_6
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %0 = icmp ult <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fmv.w.x ft2, a3
; CHECK-NEXT:    fmv.w.x ft0, a2
; CHECK-NEXT:    fcvt.w.s a2, ft1, rtz
; CHECK-NEXT:    lui a3, 16
; CHECK-NEXT:    addiw a5, a3, -1
; CHECK-NEXT:    fcvt.w.s a3, ft2, rtz
; CHECK-NEXT:    blt a2, a5, .LBB14_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a5
; CHECK-NEXT:  .LBB14_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fcvt.w.s a1, ft0, rtz
; CHECK-NEXT:    bge a3, a5, .LBB14_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.w.s a4, ft1, rtz
; CHECK-NEXT:    bge a1, a5, .LBB14_12
; CHECK-NEXT:  .LBB14_4: # %entry
; CHECK-NEXT:    bge a4, a5, .LBB14_13
; CHECK-NEXT:  .LBB14_5: # %entry
; CHECK-NEXT:    blez a4, .LBB14_14
; CHECK-NEXT:  .LBB14_6: # %entry
; CHECK-NEXT:    blez a1, .LBB14_15
; CHECK-NEXT:  .LBB14_7: # %entry
; CHECK-NEXT:    blez a3, .LBB14_16
; CHECK-NEXT:  .LBB14_8: # %entry
; CHECK-NEXT:    bgtz a2, .LBB14_10
; CHECK-NEXT:  .LBB14_9: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:  .LBB14_10: # %entry
; CHECK-NEXT:    sh a2, 6(a0)
; CHECK-NEXT:    sh a3, 4(a0)
; CHECK-NEXT:    sh a1, 2(a0)
; CHECK-NEXT:    sh a4, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB14_11: # %entry
; CHECK-NEXT:    mv a3, a5
; CHECK-NEXT:    fcvt.w.s a4, ft1, rtz
; CHECK-NEXT:    blt a1, a5, .LBB14_4
; CHECK-NEXT:  .LBB14_12: # %entry
; CHECK-NEXT:    mv a1, a5
; CHECK-NEXT:    blt a4, a5, .LBB14_5
; CHECK-NEXT:  .LBB14_13: # %entry
; CHECK-NEXT:    mv a4, a5
; CHECK-NEXT:    bgtz a4, .LBB14_6
; CHECK-NEXT:  .LBB14_14: # %entry
; CHECK-NEXT:    li a4, 0
; CHECK-NEXT:    bgtz a1, .LBB14_7
; CHECK-NEXT:  .LBB14_15: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgtz a3, .LBB14_8
; CHECK-NEXT:  .LBB14_16: # %entry
; CHECK-NEXT:    li a3, 0
; CHECK-NEXT:    blez a2, .LBB14_9
; CHECK-NEXT:    j .LBB14_10
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <4 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> zeroinitializer
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16(<8 x half> %x) {
; CHECK-LABEL: stest_f16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -96
; CHECK-NEXT:    .cfi_def_cfa_offset 96
; CHECK-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s7, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s8, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    .cfi_offset s5, -56
; CHECK-NEXT:    .cfi_offset s6, -64
; CHECK-NEXT:    .cfi_offset s7, -72
; CHECK-NEXT:    .cfi_offset s8, -80
; CHECK-NEXT:    lhu s6, 56(a1)
; CHECK-NEXT:    lhu s1, 0(a1)
; CHECK-NEXT:    lhu s2, 8(a1)
; CHECK-NEXT:    lhu s3, 16(a1)
; CHECK-NEXT:    lhu s4, 24(a1)
; CHECK-NEXT:    lhu s5, 32(a1)
; CHECK-NEXT:    lhu s7, 40(a1)
; CHECK-NEXT:    lhu a1, 48(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s8, a0
; CHECK-NEXT:    mv a0, s7
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s7, a0
; CHECK-NEXT:    mv a0, s5
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s5, a0
; CHECK-NEXT:    mv a0, s4
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s7
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s8
; CHECK-NEXT:    fcvt.l.s s7, ft0, rtz
; CHECK-NEXT:    mv a0, s6
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.l.s a0, ft0, rtz
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    addiw a7, a1, -1
; CHECK-NEXT:    blt a0, a7, .LBB15_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a7
; CHECK-NEXT:  .LBB15_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s5
; CHECK-NEXT:    flw ft0, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.l.s a1, ft0, rtz
; CHECK-NEXT:    blt s7, a7, .LBB15_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mv s7, a7
; CHECK-NEXT:  .LBB15_4: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    blt a1, a7, .LBB15_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    mv a1, a7
; CHECK-NEXT:  .LBB15_6: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s3
; CHECK-NEXT:    fcvt.l.s a3, ft0, rtz
; CHECK-NEXT:    blt a2, a7, .LBB15_8
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    mv a2, a7
; CHECK-NEXT:  .LBB15_8: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s2
; CHECK-NEXT:    fcvt.l.s a4, ft1, rtz
; CHECK-NEXT:    blt a3, a7, .LBB15_10
; CHECK-NEXT:  # %bb.9: # %entry
; CHECK-NEXT:    mv a3, a7
; CHECK-NEXT:  .LBB15_10: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s1
; CHECK-NEXT:    fcvt.l.s a5, ft0, rtz
; CHECK-NEXT:    bge a4, a7, .LBB15_23
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    fcvt.l.s a6, ft1, rtz
; CHECK-NEXT:    bge a5, a7, .LBB15_24
; CHECK-NEXT:  .LBB15_12: # %entry
; CHECK-NEXT:    bge a6, a7, .LBB15_25
; CHECK-NEXT:  .LBB15_13: # %entry
; CHECK-NEXT:    lui a7, 1048568
; CHECK-NEXT:    bge a7, a6, .LBB15_26
; CHECK-NEXT:  .LBB15_14: # %entry
; CHECK-NEXT:    bge a7, a5, .LBB15_27
; CHECK-NEXT:  .LBB15_15: # %entry
; CHECK-NEXT:    bge a7, a4, .LBB15_28
; CHECK-NEXT:  .LBB15_16: # %entry
; CHECK-NEXT:    bge a7, a3, .LBB15_29
; CHECK-NEXT:  .LBB15_17: # %entry
; CHECK-NEXT:    bge a7, a2, .LBB15_30
; CHECK-NEXT:  .LBB15_18: # %entry
; CHECK-NEXT:    bge a7, a1, .LBB15_31
; CHECK-NEXT:  .LBB15_19: # %entry
; CHECK-NEXT:    bge a7, s7, .LBB15_32
; CHECK-NEXT:  .LBB15_20: # %entry
; CHECK-NEXT:    blt a7, a0, .LBB15_22
; CHECK-NEXT:  .LBB15_21: # %entry
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:  .LBB15_22: # %entry
; CHECK-NEXT:    sh a0, 14(s0)
; CHECK-NEXT:    sh s7, 12(s0)
; CHECK-NEXT:    sh a1, 10(s0)
; CHECK-NEXT:    sh a2, 8(s0)
; CHECK-NEXT:    sh a3, 6(s0)
; CHECK-NEXT:    sh a4, 4(s0)
; CHECK-NEXT:    sh a5, 2(s0)
; CHECK-NEXT:    sh a6, 0(s0)
; CHECK-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s7, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s8, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 96
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB15_23: # %entry
; CHECK-NEXT:    mv a4, a7
; CHECK-NEXT:    fcvt.l.s a6, ft1, rtz
; CHECK-NEXT:    blt a5, a7, .LBB15_12
; CHECK-NEXT:  .LBB15_24: # %entry
; CHECK-NEXT:    mv a5, a7
; CHECK-NEXT:    blt a6, a7, .LBB15_13
; CHECK-NEXT:  .LBB15_25: # %entry
; CHECK-NEXT:    mv a6, a7
; CHECK-NEXT:    lui a7, 1048568
; CHECK-NEXT:    blt a7, a6, .LBB15_14
; CHECK-NEXT:  .LBB15_26: # %entry
; CHECK-NEXT:    lui a6, 1048568
; CHECK-NEXT:    blt a7, a5, .LBB15_15
; CHECK-NEXT:  .LBB15_27: # %entry
; CHECK-NEXT:    lui a5, 1048568
; CHECK-NEXT:    blt a7, a4, .LBB15_16
; CHECK-NEXT:  .LBB15_28: # %entry
; CHECK-NEXT:    lui a4, 1048568
; CHECK-NEXT:    blt a7, a3, .LBB15_17
; CHECK-NEXT:  .LBB15_29: # %entry
; CHECK-NEXT:    lui a3, 1048568
; CHECK-NEXT:    blt a7, a2, .LBB15_18
; CHECK-NEXT:  .LBB15_30: # %entry
; CHECK-NEXT:    lui a2, 1048568
; CHECK-NEXT:    blt a7, a1, .LBB15_19
; CHECK-NEXT:  .LBB15_31: # %entry
; CHECK-NEXT:    lui a1, 1048568
; CHECK-NEXT:    blt a7, s7, .LBB15_20
; CHECK-NEXT:  .LBB15_32: # %entry
; CHECK-NEXT:    lui s7, 1048568
; CHECK-NEXT:    bge a7, a0, .LBB15_21
; CHECK-NEXT:    j .LBB15_22
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <8 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16(<8 x half> %x) {
; CHECK-LABEL: utesth_f16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -96
; CHECK-NEXT:    .cfi_def_cfa_offset 96
; CHECK-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s7, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s8, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    .cfi_offset s5, -56
; CHECK-NEXT:    .cfi_offset s6, -64
; CHECK-NEXT:    .cfi_offset s7, -72
; CHECK-NEXT:    .cfi_offset s8, -80
; CHECK-NEXT:    lhu s6, 0(a1)
; CHECK-NEXT:    lhu s1, 56(a1)
; CHECK-NEXT:    lhu s2, 48(a1)
; CHECK-NEXT:    lhu s3, 40(a1)
; CHECK-NEXT:    lhu s4, 32(a1)
; CHECK-NEXT:    lhu s5, 24(a1)
; CHECK-NEXT:    lhu s7, 16(a1)
; CHECK-NEXT:    lhu a1, 8(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s8, a0
; CHECK-NEXT:    mv a0, s7
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s7, a0
; CHECK-NEXT:    mv a0, s5
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s5, a0
; CHECK-NEXT:    mv a0, s4
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s7
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s8
; CHECK-NEXT:    fcvt.lu.s s7, ft0, rtz
; CHECK-NEXT:    mv a0, s6
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.lu.s a0, ft0, rtz
; CHECK-NEXT:    lui a1, 16
; CHECK-NEXT:    addiw a1, a1, -1
; CHECK-NEXT:    bltu a0, a1, .LBB16_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB16_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s5
; CHECK-NEXT:    flw ft0, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.lu.s a2, ft0, rtz
; CHECK-NEXT:    bltu s7, a1, .LBB16_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mv s7, a1
; CHECK-NEXT:  .LBB16_4: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.lu.s a3, ft1, rtz
; CHECK-NEXT:    bltu a2, a1, .LBB16_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:  .LBB16_6: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s3
; CHECK-NEXT:    fcvt.lu.s a4, ft0, rtz
; CHECK-NEXT:    bltu a3, a1, .LBB16_8
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:  .LBB16_8: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s2
; CHECK-NEXT:    fcvt.lu.s a5, ft1, rtz
; CHECK-NEXT:    bltu a4, a1, .LBB16_10
; CHECK-NEXT:  # %bb.9: # %entry
; CHECK-NEXT:    mv a4, a1
; CHECK-NEXT:  .LBB16_10: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s1
; CHECK-NEXT:    fcvt.lu.s a6, ft0, rtz
; CHECK-NEXT:    bgeu a5, a1, .LBB16_15
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    fcvt.lu.s a7, ft1, rtz
; CHECK-NEXT:    bgeu a6, a1, .LBB16_16
; CHECK-NEXT:  .LBB16_12: # %entry
; CHECK-NEXT:    bltu a7, a1, .LBB16_14
; CHECK-NEXT:  .LBB16_13: # %entry
; CHECK-NEXT:    mv a7, a1
; CHECK-NEXT:  .LBB16_14: # %entry
; CHECK-NEXT:    sh a7, 14(s0)
; CHECK-NEXT:    sh a6, 12(s0)
; CHECK-NEXT:    sh a5, 10(s0)
; CHECK-NEXT:    sh a4, 8(s0)
; CHECK-NEXT:    sh a3, 6(s0)
; CHECK-NEXT:    sh a2, 4(s0)
; CHECK-NEXT:    sh s7, 2(s0)
; CHECK-NEXT:    sh a0, 0(s0)
; CHECK-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s7, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s8, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 96
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB16_15: # %entry
; CHECK-NEXT:    mv a5, a1
; CHECK-NEXT:    fcvt.lu.s a7, ft1, rtz
; CHECK-NEXT:    bltu a6, a1, .LBB16_12
; CHECK-NEXT:  .LBB16_16: # %entry
; CHECK-NEXT:    mv a6, a1
; CHECK-NEXT:    bgeu a7, a1, .LBB16_13
; CHECK-NEXT:    j .LBB16_14
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %0 = icmp ult <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16(<8 x half> %x) {
; CHECK-LABEL: ustest_f16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -96
; CHECK-NEXT:    .cfi_def_cfa_offset 96
; CHECK-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s7, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s8, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    .cfi_offset s5, -56
; CHECK-NEXT:    .cfi_offset s6, -64
; CHECK-NEXT:    .cfi_offset s7, -72
; CHECK-NEXT:    .cfi_offset s8, -80
; CHECK-NEXT:    lhu s6, 56(a1)
; CHECK-NEXT:    lhu s1, 0(a1)
; CHECK-NEXT:    lhu s2, 8(a1)
; CHECK-NEXT:    lhu s3, 16(a1)
; CHECK-NEXT:    lhu s4, 24(a1)
; CHECK-NEXT:    lhu s5, 32(a1)
; CHECK-NEXT:    lhu s7, 40(a1)
; CHECK-NEXT:    lhu a1, 48(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s8, a0
; CHECK-NEXT:    mv a0, s7
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s7, a0
; CHECK-NEXT:    mv a0, s5
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s5, a0
; CHECK-NEXT:    mv a0, s4
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s7
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s8
; CHECK-NEXT:    fcvt.l.s s7, ft0, rtz
; CHECK-NEXT:    mv a0, s6
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.l.s a0, ft0, rtz
; CHECK-NEXT:    lui a1, 16
; CHECK-NEXT:    addiw a7, a1, -1
; CHECK-NEXT:    blt a0, a7, .LBB17_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a7
; CHECK-NEXT:  .LBB17_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s5
; CHECK-NEXT:    flw ft0, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.l.s a1, ft0, rtz
; CHECK-NEXT:    blt s7, a7, .LBB17_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mv s7, a7
; CHECK-NEXT:  .LBB17_4: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    blt a1, a7, .LBB17_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    mv a1, a7
; CHECK-NEXT:  .LBB17_6: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s3
; CHECK-NEXT:    fcvt.l.s a3, ft0, rtz
; CHECK-NEXT:    blt a2, a7, .LBB17_8
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    mv a2, a7
; CHECK-NEXT:  .LBB17_8: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s2
; CHECK-NEXT:    fcvt.l.s a4, ft1, rtz
; CHECK-NEXT:    blt a3, a7, .LBB17_10
; CHECK-NEXT:  # %bb.9: # %entry
; CHECK-NEXT:    mv a3, a7
; CHECK-NEXT:  .LBB17_10: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s1
; CHECK-NEXT:    fcvt.l.s a5, ft0, rtz
; CHECK-NEXT:    bge a4, a7, .LBB17_23
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    fcvt.l.s a6, ft1, rtz
; CHECK-NEXT:    bge a5, a7, .LBB17_24
; CHECK-NEXT:  .LBB17_12: # %entry
; CHECK-NEXT:    bge a6, a7, .LBB17_25
; CHECK-NEXT:  .LBB17_13: # %entry
; CHECK-NEXT:    blez a6, .LBB17_26
; CHECK-NEXT:  .LBB17_14: # %entry
; CHECK-NEXT:    blez a5, .LBB17_27
; CHECK-NEXT:  .LBB17_15: # %entry
; CHECK-NEXT:    blez a4, .LBB17_28
; CHECK-NEXT:  .LBB17_16: # %entry
; CHECK-NEXT:    blez a3, .LBB17_29
; CHECK-NEXT:  .LBB17_17: # %entry
; CHECK-NEXT:    blez a2, .LBB17_30
; CHECK-NEXT:  .LBB17_18: # %entry
; CHECK-NEXT:    blez a1, .LBB17_31
; CHECK-NEXT:  .LBB17_19: # %entry
; CHECK-NEXT:    blez s7, .LBB17_32
; CHECK-NEXT:  .LBB17_20: # %entry
; CHECK-NEXT:    bgtz a0, .LBB17_22
; CHECK-NEXT:  .LBB17_21: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB17_22: # %entry
; CHECK-NEXT:    sh a0, 14(s0)
; CHECK-NEXT:    sh s7, 12(s0)
; CHECK-NEXT:    sh a1, 10(s0)
; CHECK-NEXT:    sh a2, 8(s0)
; CHECK-NEXT:    sh a3, 6(s0)
; CHECK-NEXT:    sh a4, 4(s0)
; CHECK-NEXT:    sh a5, 2(s0)
; CHECK-NEXT:    sh a6, 0(s0)
; CHECK-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s7, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s8, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 96
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB17_23: # %entry
; CHECK-NEXT:    mv a4, a7
; CHECK-NEXT:    fcvt.l.s a6, ft1, rtz
; CHECK-NEXT:    blt a5, a7, .LBB17_12
; CHECK-NEXT:  .LBB17_24: # %entry
; CHECK-NEXT:    mv a5, a7
; CHECK-NEXT:    blt a6, a7, .LBB17_13
; CHECK-NEXT:  .LBB17_25: # %entry
; CHECK-NEXT:    mv a6, a7
; CHECK-NEXT:    bgtz a6, .LBB17_14
; CHECK-NEXT:  .LBB17_26: # %entry
; CHECK-NEXT:    li a6, 0
; CHECK-NEXT:    bgtz a5, .LBB17_15
; CHECK-NEXT:  .LBB17_27: # %entry
; CHECK-NEXT:    li a5, 0
; CHECK-NEXT:    bgtz a4, .LBB17_16
; CHECK-NEXT:  .LBB17_28: # %entry
; CHECK-NEXT:    li a4, 0
; CHECK-NEXT:    bgtz a3, .LBB17_17
; CHECK-NEXT:  .LBB17_29: # %entry
; CHECK-NEXT:    li a3, 0
; CHECK-NEXT:    bgtz a2, .LBB17_18
; CHECK-NEXT:  .LBB17_30: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    bgtz a1, .LBB17_19
; CHECK-NEXT:  .LBB17_31: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgtz s7, .LBB17_20
; CHECK-NEXT:  .LBB17_32: # %entry
; CHECK-NEXT:    li s7, 0
; CHECK-NEXT:    blez a0, .LBB17_21
; CHECK-NEXT:    j .LBB17_22
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <8 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> zeroinitializer
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64(<2 x double> %x) {
; CHECK-LABEL: stest_f64i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __fixdfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixdfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    li a0, -1
; CHECK-NEXT:    srli a3, a0, 1
; CHECK-NEXT:    beqz a1, .LBB18_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    slti a4, a1, 0
; CHECK-NEXT:    bnez s1, .LBB18_4
; CHECK-NEXT:  .LBB18_2:
; CHECK-NEXT:    sltu a5, s0, a3
; CHECK-NEXT:    beqz a5, .LBB18_5
; CHECK-NEXT:    j .LBB18_6
; CHECK-NEXT:  .LBB18_3:
; CHECK-NEXT:    sltu a4, a2, a3
; CHECK-NEXT:    beqz s1, .LBB18_2
; CHECK-NEXT:  .LBB18_4: # %entry
; CHECK-NEXT:    slti a5, s1, 0
; CHECK-NEXT:    bnez a5, .LBB18_6
; CHECK-NEXT:  .LBB18_5: # %entry
; CHECK-NEXT:    li s1, 0
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:  .LBB18_6: # %entry
; CHECK-NEXT:    beqz a4, .LBB18_10
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    beq a1, a0, .LBB18_11
; CHECK-NEXT:  .LBB18_8: # %entry
; CHECK-NEXT:    slt a1, a0, a1
; CHECK-NEXT:    bne s1, a0, .LBB18_12
; CHECK-NEXT:  .LBB18_9:
; CHECK-NEXT:    sltu a0, a3, s0
; CHECK-NEXT:    beqz a0, .LBB18_13
; CHECK-NEXT:    j .LBB18_14
; CHECK-NEXT:  .LBB18_10: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    bne a1, a0, .LBB18_8
; CHECK-NEXT:  .LBB18_11:
; CHECK-NEXT:    sltu a1, a3, a2
; CHECK-NEXT:    beq s1, a0, .LBB18_9
; CHECK-NEXT:  .LBB18_12: # %entry
; CHECK-NEXT:    slt a0, a0, s1
; CHECK-NEXT:    bnez a0, .LBB18_14
; CHECK-NEXT:  .LBB18_13: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:  .LBB18_14: # %entry
; CHECK-NEXT:    bnez a1, .LBB18_16
; CHECK-NEXT:  # %bb.15: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:  .LBB18_16: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64(<2 x double> %x) {
; CHECK-LABEL: utest_f64i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __fixunsdfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixunsdfti@plt
; CHECK-NEXT:    beqz a1, .LBB19_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB19_2: # %entry
; CHECK-NEXT:    beqz s1, .LBB19_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:  .LBB19_4: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __fixdfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixdfti@plt
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    bgtz a1, .LBB20_7
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a3, s1
; CHECK-NEXT:    bgtz s1, .LBB20_8
; CHECK-NEXT:  .LBB20_2: # %entry
; CHECK-NEXT:    bgtz a1, .LBB20_9
; CHECK-NEXT:  .LBB20_3: # %entry
; CHECK-NEXT:    bgtz s1, .LBB20_10
; CHECK-NEXT:  .LBB20_4: # %entry
; CHECK-NEXT:    beqz a3, .LBB20_11
; CHECK-NEXT:  .LBB20_5: # %entry
; CHECK-NEXT:    sgtz a1, a3
; CHECK-NEXT:    bnez a2, .LBB20_12
; CHECK-NEXT:  .LBB20_6:
; CHECK-NEXT:    snez a2, a0
; CHECK-NEXT:    beqz a2, .LBB20_13
; CHECK-NEXT:    j .LBB20_14
; CHECK-NEXT:  .LBB20_7: # %entry
; CHECK-NEXT:    li a2, 1
; CHECK-NEXT:    mv a3, s1
; CHECK-NEXT:    blez s1, .LBB20_2
; CHECK-NEXT:  .LBB20_8: # %entry
; CHECK-NEXT:    li a3, 1
; CHECK-NEXT:    blez a1, .LBB20_3
; CHECK-NEXT:  .LBB20_9: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    blez s1, .LBB20_4
; CHECK-NEXT:  .LBB20_10: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:    bnez a3, .LBB20_5
; CHECK-NEXT:  .LBB20_11:
; CHECK-NEXT:    snez a1, s0
; CHECK-NEXT:    beqz a2, .LBB20_6
; CHECK-NEXT:  .LBB20_12: # %entry
; CHECK-NEXT:    sgtz a2, a2
; CHECK-NEXT:    bnez a2, .LBB20_14
; CHECK-NEXT:  .LBB20_13: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB20_14: # %entry
; CHECK-NEXT:    bnez a1, .LBB20_16
; CHECK-NEXT:  # %bb.15: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:  .LBB20_16: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64(<2 x float> %x) {
; CHECK-LABEL: stest_f32i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    li a0, -1
; CHECK-NEXT:    srli a3, a0, 1
; CHECK-NEXT:    beqz a1, .LBB21_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    slti a4, a1, 0
; CHECK-NEXT:    bnez s1, .LBB21_4
; CHECK-NEXT:  .LBB21_2:
; CHECK-NEXT:    sltu a5, s0, a3
; CHECK-NEXT:    beqz a5, .LBB21_5
; CHECK-NEXT:    j .LBB21_6
; CHECK-NEXT:  .LBB21_3:
; CHECK-NEXT:    sltu a4, a2, a3
; CHECK-NEXT:    beqz s1, .LBB21_2
; CHECK-NEXT:  .LBB21_4: # %entry
; CHECK-NEXT:    slti a5, s1, 0
; CHECK-NEXT:    bnez a5, .LBB21_6
; CHECK-NEXT:  .LBB21_5: # %entry
; CHECK-NEXT:    li s1, 0
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:  .LBB21_6: # %entry
; CHECK-NEXT:    beqz a4, .LBB21_10
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    beq a1, a0, .LBB21_11
; CHECK-NEXT:  .LBB21_8: # %entry
; CHECK-NEXT:    slt a1, a0, a1
; CHECK-NEXT:    bne s1, a0, .LBB21_12
; CHECK-NEXT:  .LBB21_9:
; CHECK-NEXT:    sltu a0, a3, s0
; CHECK-NEXT:    beqz a0, .LBB21_13
; CHECK-NEXT:    j .LBB21_14
; CHECK-NEXT:  .LBB21_10: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    bne a1, a0, .LBB21_8
; CHECK-NEXT:  .LBB21_11:
; CHECK-NEXT:    sltu a1, a3, a2
; CHECK-NEXT:    beq s1, a0, .LBB21_9
; CHECK-NEXT:  .LBB21_12: # %entry
; CHECK-NEXT:    slt a0, a0, s1
; CHECK-NEXT:    bnez a0, .LBB21_14
; CHECK-NEXT:  .LBB21_13: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:  .LBB21_14: # %entry
; CHECK-NEXT:    bnez a1, .LBB21_16
; CHECK-NEXT:  # %bb.15: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:  .LBB21_16: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64(<2 x float> %x) {
; CHECK-LABEL: utest_f32i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __fixunssfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixunssfti@plt
; CHECK-NEXT:    beqz a1, .LBB22_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB22_2: # %entry
; CHECK-NEXT:    beqz s1, .LBB22_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:  .LBB22_4: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64(<2 x float> %x) {
; CHECK-LABEL: ustest_f32i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    bgtz a1, .LBB23_7
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a3, s1
; CHECK-NEXT:    bgtz s1, .LBB23_8
; CHECK-NEXT:  .LBB23_2: # %entry
; CHECK-NEXT:    bgtz a1, .LBB23_9
; CHECK-NEXT:  .LBB23_3: # %entry
; CHECK-NEXT:    bgtz s1, .LBB23_10
; CHECK-NEXT:  .LBB23_4: # %entry
; CHECK-NEXT:    beqz a3, .LBB23_11
; CHECK-NEXT:  .LBB23_5: # %entry
; CHECK-NEXT:    sgtz a1, a3
; CHECK-NEXT:    bnez a2, .LBB23_12
; CHECK-NEXT:  .LBB23_6:
; CHECK-NEXT:    snez a2, a0
; CHECK-NEXT:    beqz a2, .LBB23_13
; CHECK-NEXT:    j .LBB23_14
; CHECK-NEXT:  .LBB23_7: # %entry
; CHECK-NEXT:    li a2, 1
; CHECK-NEXT:    mv a3, s1
; CHECK-NEXT:    blez s1, .LBB23_2
; CHECK-NEXT:  .LBB23_8: # %entry
; CHECK-NEXT:    li a3, 1
; CHECK-NEXT:    blez a1, .LBB23_3
; CHECK-NEXT:  .LBB23_9: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    blez s1, .LBB23_4
; CHECK-NEXT:  .LBB23_10: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:    bnez a3, .LBB23_5
; CHECK-NEXT:  .LBB23_11:
; CHECK-NEXT:    snez a1, s0
; CHECK-NEXT:    beqz a2, .LBB23_6
; CHECK-NEXT:  .LBB23_12: # %entry
; CHECK-NEXT:    sgtz a2, a2
; CHECK-NEXT:    bnez a2, .LBB23_14
; CHECK-NEXT:  .LBB23_13: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB23_14: # %entry
; CHECK-NEXT:    bnez a1, .LBB23_16
; CHECK-NEXT:  # %bb.15: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:  .LBB23_16: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64(<2 x half> %x) {
; CHECK-LABEL: stest_f16i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    li a0, -1
; CHECK-NEXT:    srli a3, a0, 1
; CHECK-NEXT:    beqz a1, .LBB24_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    slti a4, a1, 0
; CHECK-NEXT:    bnez s1, .LBB24_4
; CHECK-NEXT:  .LBB24_2:
; CHECK-NEXT:    sltu a5, s0, a3
; CHECK-NEXT:    beqz a5, .LBB24_5
; CHECK-NEXT:    j .LBB24_6
; CHECK-NEXT:  .LBB24_3:
; CHECK-NEXT:    sltu a4, a2, a3
; CHECK-NEXT:    beqz s1, .LBB24_2
; CHECK-NEXT:  .LBB24_4: # %entry
; CHECK-NEXT:    slti a5, s1, 0
; CHECK-NEXT:    bnez a5, .LBB24_6
; CHECK-NEXT:  .LBB24_5: # %entry
; CHECK-NEXT:    li s1, 0
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:  .LBB24_6: # %entry
; CHECK-NEXT:    beqz a4, .LBB24_10
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    beq a1, a0, .LBB24_11
; CHECK-NEXT:  .LBB24_8: # %entry
; CHECK-NEXT:    slt a1, a0, a1
; CHECK-NEXT:    bne s1, a0, .LBB24_12
; CHECK-NEXT:  .LBB24_9:
; CHECK-NEXT:    sltu a0, a3, s0
; CHECK-NEXT:    beqz a0, .LBB24_13
; CHECK-NEXT:    j .LBB24_14
; CHECK-NEXT:  .LBB24_10: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    bne a1, a0, .LBB24_8
; CHECK-NEXT:  .LBB24_11:
; CHECK-NEXT:    sltu a1, a3, a2
; CHECK-NEXT:    beq s1, a0, .LBB24_9
; CHECK-NEXT:  .LBB24_12: # %entry
; CHECK-NEXT:    slt a0, a0, s1
; CHECK-NEXT:    bnez a0, .LBB24_14
; CHECK-NEXT:  .LBB24_13: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:  .LBB24_14: # %entry
; CHECK-NEXT:    bnez a1, .LBB24_16
; CHECK-NEXT:  # %bb.15: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:  .LBB24_16: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64(<2 x half> %x) {
; CHECK-LABEL: utesth_f16i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixunssfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixunssfti@plt
; CHECK-NEXT:    beqz a1, .LBB25_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB25_2: # %entry
; CHECK-NEXT:    beqz s1, .LBB25_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:  .LBB25_4: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64(<2 x half> %x) {
; CHECK-LABEL: ustest_f16i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    bgtz a1, .LBB26_7
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a3, s1
; CHECK-NEXT:    bgtz s1, .LBB26_8
; CHECK-NEXT:  .LBB26_2: # %entry
; CHECK-NEXT:    bgtz a1, .LBB26_9
; CHECK-NEXT:  .LBB26_3: # %entry
; CHECK-NEXT:    bgtz s1, .LBB26_10
; CHECK-NEXT:  .LBB26_4: # %entry
; CHECK-NEXT:    beqz a3, .LBB26_11
; CHECK-NEXT:  .LBB26_5: # %entry
; CHECK-NEXT:    sgtz a1, a3
; CHECK-NEXT:    bnez a2, .LBB26_12
; CHECK-NEXT:  .LBB26_6:
; CHECK-NEXT:    snez a2, a0
; CHECK-NEXT:    beqz a2, .LBB26_13
; CHECK-NEXT:    j .LBB26_14
; CHECK-NEXT:  .LBB26_7: # %entry
; CHECK-NEXT:    li a2, 1
; CHECK-NEXT:    mv a3, s1
; CHECK-NEXT:    blez s1, .LBB26_2
; CHECK-NEXT:  .LBB26_8: # %entry
; CHECK-NEXT:    li a3, 1
; CHECK-NEXT:    blez a1, .LBB26_3
; CHECK-NEXT:  .LBB26_9: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    blez s1, .LBB26_4
; CHECK-NEXT:  .LBB26_10: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:    bnez a3, .LBB26_5
; CHECK-NEXT:  .LBB26_11:
; CHECK-NEXT:    snez a1, s0
; CHECK-NEXT:    beqz a2, .LBB26_6
; CHECK-NEXT:  .LBB26_12: # %entry
; CHECK-NEXT:    sgtz a2, a2
; CHECK-NEXT:    bnez a2, .LBB26_14
; CHECK-NEXT:  .LBB26_13: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB26_14: # %entry
; CHECK-NEXT:    bnez a1, .LBB26_16
; CHECK-NEXT:  # %bb.15: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:  .LBB26_16: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}



; i32 saturate

define <2 x i32> @stest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a1
; CHECK-NEXT:    fmv.d.x ft1, a0
; CHECK-NEXT:    fcvt.l.d a1, ft0, rtz
; CHECK-NEXT:    lui a2, 524288
; CHECK-NEXT:    addiw a3, a2, -1
; CHECK-NEXT:    fcvt.l.d a0, ft1, rtz
; CHECK-NEXT:    bge a1, a3, .LBB27_5
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bge a0, a3, .LBB27_6
; CHECK-NEXT:  .LBB27_2: # %entry
; CHECK-NEXT:    bge a2, a0, .LBB27_7
; CHECK-NEXT:  .LBB27_3: # %entry
; CHECK-NEXT:    bge a2, a1, .LBB27_8
; CHECK-NEXT:  .LBB27_4: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB27_5: # %entry
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    blt a0, a3, .LBB27_2
; CHECK-NEXT:  .LBB27_6: # %entry
; CHECK-NEXT:    mv a0, a3
; CHECK-NEXT:    blt a2, a0, .LBB27_3
; CHECK-NEXT:  .LBB27_7: # %entry
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    blt a2, a1, .LBB27_4
; CHECK-NEXT:  .LBB27_8: # %entry
; CHECK-NEXT:    lui a1, 524288
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a0
; CHECK-NEXT:    fmv.d.x ft1, a1
; CHECK-NEXT:    fcvt.lu.d a0, ft0, rtz
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    srli a2, a1, 32
; CHECK-NEXT:    fcvt.lu.d a1, ft1, rtz
; CHECK-NEXT:    bgeu a0, a2, .LBB28_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bgeu a1, a2, .LBB28_4
; CHECK-NEXT:  .LBB28_2: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB28_3: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bltu a1, a2, .LBB28_2
; CHECK-NEXT:  .LBB28_4: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.umin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a1
; CHECK-NEXT:    fmv.d.x ft1, a0
; CHECK-NEXT:    fcvt.l.d a1, ft0, rtz
; CHECK-NEXT:    li a0, -1
; CHECK-NEXT:    srli a2, a0, 32
; CHECK-NEXT:    fcvt.l.d a0, ft1, rtz
; CHECK-NEXT:    bge a1, a2, .LBB29_5
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bge a0, a2, .LBB29_6
; CHECK-NEXT:  .LBB29_2: # %entry
; CHECK-NEXT:    blez a0, .LBB29_7
; CHECK-NEXT:  .LBB29_3: # %entry
; CHECK-NEXT:    blez a1, .LBB29_8
; CHECK-NEXT:  .LBB29_4: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB29_5: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    blt a0, a2, .LBB29_2
; CHECK-NEXT:  .LBB29_6: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bgtz a0, .LBB29_3
; CHECK-NEXT:  .LBB29_7: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    bgtz a1, .LBB29_4
; CHECK-NEXT:  .LBB29_8: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> zeroinitializer)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: stest_f32i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fmv.w.x ft2, a3
; CHECK-NEXT:    fmv.w.x ft0, a2
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    lui a4, 524288
; CHECK-NEXT:    addiw a6, a4, -1
; CHECK-NEXT:    fcvt.l.s a3, ft2, rtz
; CHECK-NEXT:    blt a2, a6, .LBB30_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a6
; CHECK-NEXT:  .LBB30_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fcvt.l.s a1, ft0, rtz
; CHECK-NEXT:    bge a3, a6, .LBB30_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.l.s a5, ft1, rtz
; CHECK-NEXT:    bge a1, a6, .LBB30_12
; CHECK-NEXT:  .LBB30_4: # %entry
; CHECK-NEXT:    bge a5, a6, .LBB30_13
; CHECK-NEXT:  .LBB30_5: # %entry
; CHECK-NEXT:    bge a4, a5, .LBB30_14
; CHECK-NEXT:  .LBB30_6: # %entry
; CHECK-NEXT:    bge a4, a1, .LBB30_15
; CHECK-NEXT:  .LBB30_7: # %entry
; CHECK-NEXT:    bge a4, a3, .LBB30_16
; CHECK-NEXT:  .LBB30_8: # %entry
; CHECK-NEXT:    blt a4, a2, .LBB30_10
; CHECK-NEXT:  .LBB30_9: # %entry
; CHECK-NEXT:    lui a2, 524288
; CHECK-NEXT:  .LBB30_10: # %entry
; CHECK-NEXT:    sw a2, 12(a0)
; CHECK-NEXT:    sw a3, 8(a0)
; CHECK-NEXT:    sw a1, 4(a0)
; CHECK-NEXT:    sw a5, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB30_11: # %entry
; CHECK-NEXT:    mv a3, a6
; CHECK-NEXT:    fcvt.l.s a5, ft1, rtz
; CHECK-NEXT:    blt a1, a6, .LBB30_4
; CHECK-NEXT:  .LBB30_12: # %entry
; CHECK-NEXT:    mv a1, a6
; CHECK-NEXT:    blt a5, a6, .LBB30_5
; CHECK-NEXT:  .LBB30_13: # %entry
; CHECK-NEXT:    mv a5, a6
; CHECK-NEXT:    blt a4, a5, .LBB30_6
; CHECK-NEXT:  .LBB30_14: # %entry
; CHECK-NEXT:    lui a5, 524288
; CHECK-NEXT:    blt a4, a1, .LBB30_7
; CHECK-NEXT:  .LBB30_15: # %entry
; CHECK-NEXT:    lui a1, 524288
; CHECK-NEXT:    blt a4, a3, .LBB30_8
; CHECK-NEXT:  .LBB30_16: # %entry
; CHECK-NEXT:    lui a3, 524288
; CHECK-NEXT:    bge a4, a2, .LBB30_9
; CHECK-NEXT:    j .LBB30_10
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: utest_f32i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fmv.w.x ft2, a2
; CHECK-NEXT:    fmv.w.x ft0, a3
; CHECK-NEXT:    fcvt.lu.s a1, ft1, rtz
; CHECK-NEXT:    li a2, -1
; CHECK-NEXT:    srli a3, a2, 32
; CHECK-NEXT:    fcvt.lu.s a2, ft2, rtz
; CHECK-NEXT:    bltu a1, a3, .LBB31_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB31_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fcvt.lu.s a4, ft0, rtz
; CHECK-NEXT:    bgeu a2, a3, .LBB31_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.lu.s a5, ft1, rtz
; CHECK-NEXT:    bgeu a4, a3, .LBB31_8
; CHECK-NEXT:  .LBB31_4: # %entry
; CHECK-NEXT:    bltu a5, a3, .LBB31_6
; CHECK-NEXT:  .LBB31_5: # %entry
; CHECK-NEXT:    mv a5, a3
; CHECK-NEXT:  .LBB31_6: # %entry
; CHECK-NEXT:    sw a5, 12(a0)
; CHECK-NEXT:    sw a4, 8(a0)
; CHECK-NEXT:    sw a2, 4(a0)
; CHECK-NEXT:    sw a1, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB31_7: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    fcvt.lu.s a5, ft1, rtz
; CHECK-NEXT:    bltu a4, a3, .LBB31_4
; CHECK-NEXT:  .LBB31_8: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bgeu a5, a3, .LBB31_5
; CHECK-NEXT:    j .LBB31_6
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fmv.w.x ft2, a3
; CHECK-NEXT:    fmv.w.x ft0, a2
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    li a3, -1
; CHECK-NEXT:    srli a5, a3, 32
; CHECK-NEXT:    fcvt.l.s a3, ft2, rtz
; CHECK-NEXT:    blt a2, a5, .LBB32_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a5
; CHECK-NEXT:  .LBB32_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fcvt.l.s a1, ft0, rtz
; CHECK-NEXT:    bge a3, a5, .LBB32_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.l.s a4, ft1, rtz
; CHECK-NEXT:    bge a1, a5, .LBB32_12
; CHECK-NEXT:  .LBB32_4: # %entry
; CHECK-NEXT:    bge a4, a5, .LBB32_13
; CHECK-NEXT:  .LBB32_5: # %entry
; CHECK-NEXT:    blez a4, .LBB32_14
; CHECK-NEXT:  .LBB32_6: # %entry
; CHECK-NEXT:    blez a1, .LBB32_15
; CHECK-NEXT:  .LBB32_7: # %entry
; CHECK-NEXT:    blez a3, .LBB32_16
; CHECK-NEXT:  .LBB32_8: # %entry
; CHECK-NEXT:    bgtz a2, .LBB32_10
; CHECK-NEXT:  .LBB32_9: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:  .LBB32_10: # %entry
; CHECK-NEXT:    sw a2, 12(a0)
; CHECK-NEXT:    sw a3, 8(a0)
; CHECK-NEXT:    sw a1, 4(a0)
; CHECK-NEXT:    sw a4, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB32_11: # %entry
; CHECK-NEXT:    mv a3, a5
; CHECK-NEXT:    fcvt.l.s a4, ft1, rtz
; CHECK-NEXT:    blt a1, a5, .LBB32_4
; CHECK-NEXT:  .LBB32_12: # %entry
; CHECK-NEXT:    mv a1, a5
; CHECK-NEXT:    blt a4, a5, .LBB32_5
; CHECK-NEXT:  .LBB32_13: # %entry
; CHECK-NEXT:    mv a4, a5
; CHECK-NEXT:    bgtz a4, .LBB32_6
; CHECK-NEXT:  .LBB32_14: # %entry
; CHECK-NEXT:    li a4, 0
; CHECK-NEXT:    bgtz a1, .LBB32_7
; CHECK-NEXT:  .LBB32_15: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgtz a3, .LBB32_8
; CHECK-NEXT:  .LBB32_16: # %entry
; CHECK-NEXT:    li a3, 0
; CHECK-NEXT:    blez a2, .LBB32_9
; CHECK-NEXT:    j .LBB32_10
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: stest_f16i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    lhu s2, 24(a1)
; CHECK-NEXT:    lhu s1, 0(a1)
; CHECK-NEXT:    lhu s3, 8(a1)
; CHECK-NEXT:    lhu a1, 16(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s3
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.l.s s3, ft0, rtz
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.l.s a0, ft0, rtz
; CHECK-NEXT:    lui a1, 524288
; CHECK-NEXT:    addiw a4, a1, -1
; CHECK-NEXT:    blt a0, a4, .LBB33_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a4
; CHECK-NEXT:  .LBB33_2: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s1
; CHECK-NEXT:    flw ft1, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    bge s3, a4, .LBB33_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.l.s a3, ft0, rtz
; CHECK-NEXT:    bge a2, a4, .LBB33_12
; CHECK-NEXT:  .LBB33_4: # %entry
; CHECK-NEXT:    bge a3, a4, .LBB33_13
; CHECK-NEXT:  .LBB33_5: # %entry
; CHECK-NEXT:    bge a1, a3, .LBB33_14
; CHECK-NEXT:  .LBB33_6: # %entry
; CHECK-NEXT:    bge a1, a2, .LBB33_15
; CHECK-NEXT:  .LBB33_7: # %entry
; CHECK-NEXT:    bge a1, s3, .LBB33_16
; CHECK-NEXT:  .LBB33_8: # %entry
; CHECK-NEXT:    blt a1, a0, .LBB33_10
; CHECK-NEXT:  .LBB33_9: # %entry
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:  .LBB33_10: # %entry
; CHECK-NEXT:    sw a0, 12(s0)
; CHECK-NEXT:    sw s3, 8(s0)
; CHECK-NEXT:    sw a2, 4(s0)
; CHECK-NEXT:    sw a3, 0(s0)
; CHECK-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB33_11: # %entry
; CHECK-NEXT:    mv s3, a4
; CHECK-NEXT:    fcvt.l.s a3, ft0, rtz
; CHECK-NEXT:    blt a2, a4, .LBB33_4
; CHECK-NEXT:  .LBB33_12: # %entry
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:    blt a3, a4, .LBB33_5
; CHECK-NEXT:  .LBB33_13: # %entry
; CHECK-NEXT:    mv a3, a4
; CHECK-NEXT:    blt a1, a3, .LBB33_6
; CHECK-NEXT:  .LBB33_14: # %entry
; CHECK-NEXT:    lui a3, 524288
; CHECK-NEXT:    blt a1, a2, .LBB33_7
; CHECK-NEXT:  .LBB33_15: # %entry
; CHECK-NEXT:    lui a2, 524288
; CHECK-NEXT:    blt a1, s3, .LBB33_8
; CHECK-NEXT:  .LBB33_16: # %entry
; CHECK-NEXT:    lui s3, 524288
; CHECK-NEXT:    bge a1, a0, .LBB33_9
; CHECK-NEXT:    j .LBB33_10
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: utesth_f16i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    lhu s2, 0(a1)
; CHECK-NEXT:    lhu s1, 24(a1)
; CHECK-NEXT:    lhu s3, 16(a1)
; CHECK-NEXT:    lhu a1, 8(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s3
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.lu.s s3, ft0, rtz
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.lu.s a0, ft0, rtz
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    srli a1, a1, 32
; CHECK-NEXT:    bltu a0, a1, .LBB34_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB34_2: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s1
; CHECK-NEXT:    flw ft1, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.lu.s a2, ft1, rtz
; CHECK-NEXT:    bgeu s3, a1, .LBB34_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.lu.s a3, ft0, rtz
; CHECK-NEXT:    bgeu a2, a1, .LBB34_8
; CHECK-NEXT:  .LBB34_4: # %entry
; CHECK-NEXT:    bltu a3, a1, .LBB34_6
; CHECK-NEXT:  .LBB34_5: # %entry
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:  .LBB34_6: # %entry
; CHECK-NEXT:    sw a3, 12(s0)
; CHECK-NEXT:    sw a2, 8(s0)
; CHECK-NEXT:    sw s3, 4(s0)
; CHECK-NEXT:    sw a0, 0(s0)
; CHECK-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB34_7: # %entry
; CHECK-NEXT:    mv s3, a1
; CHECK-NEXT:    fcvt.lu.s a3, ft0, rtz
; CHECK-NEXT:    bltu a2, a1, .LBB34_4
; CHECK-NEXT:  .LBB34_8: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    bgeu a3, a1, .LBB34_5
; CHECK-NEXT:    j .LBB34_6
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: ustest_f16i32_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    lhu s2, 24(a1)
; CHECK-NEXT:    lhu s1, 0(a1)
; CHECK-NEXT:    lhu s3, 8(a1)
; CHECK-NEXT:    lhu a1, 16(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s3
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.l.s s3, ft0, rtz
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.l.s a0, ft0, rtz
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    srli a3, a1, 32
; CHECK-NEXT:    blt a0, a3, .LBB35_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a3
; CHECK-NEXT:  .LBB35_2: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s1
; CHECK-NEXT:    flw ft1, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.l.s a1, ft1, rtz
; CHECK-NEXT:    bge s3, a3, .LBB35_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.l.s a2, ft0, rtz
; CHECK-NEXT:    bge a1, a3, .LBB35_12
; CHECK-NEXT:  .LBB35_4: # %entry
; CHECK-NEXT:    bge a2, a3, .LBB35_13
; CHECK-NEXT:  .LBB35_5: # %entry
; CHECK-NEXT:    blez a2, .LBB35_14
; CHECK-NEXT:  .LBB35_6: # %entry
; CHECK-NEXT:    blez a1, .LBB35_15
; CHECK-NEXT:  .LBB35_7: # %entry
; CHECK-NEXT:    blez s3, .LBB35_16
; CHECK-NEXT:  .LBB35_8: # %entry
; CHECK-NEXT:    bgtz a0, .LBB35_10
; CHECK-NEXT:  .LBB35_9: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB35_10: # %entry
; CHECK-NEXT:    sw a0, 12(s0)
; CHECK-NEXT:    sw s3, 8(s0)
; CHECK-NEXT:    sw a1, 4(s0)
; CHECK-NEXT:    sw a2, 0(s0)
; CHECK-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB35_11: # %entry
; CHECK-NEXT:    mv s3, a3
; CHECK-NEXT:    fcvt.l.s a2, ft0, rtz
; CHECK-NEXT:    blt a1, a3, .LBB35_4
; CHECK-NEXT:  .LBB35_12: # %entry
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    blt a2, a3, .LBB35_5
; CHECK-NEXT:  .LBB35_13: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    bgtz a2, .LBB35_6
; CHECK-NEXT:  .LBB35_14: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    bgtz a1, .LBB35_7
; CHECK-NEXT:  .LBB35_15: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgtz s3, .LBB35_8
; CHECK-NEXT:  .LBB35_16: # %entry
; CHECK-NEXT:    li s3, 0
; CHECK-NEXT:    blez a0, .LBB35_9
; CHECK-NEXT:    j .LBB35_10
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a1
; CHECK-NEXT:    fmv.d.x ft1, a0
; CHECK-NEXT:    fcvt.w.d a1, ft0, rtz
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    addiw a2, a0, -1
; CHECK-NEXT:    fcvt.w.d a0, ft1, rtz
; CHECK-NEXT:    bge a1, a2, .LBB36_5
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bge a0, a2, .LBB36_6
; CHECK-NEXT:  .LBB36_2: # %entry
; CHECK-NEXT:    lui a2, 1048568
; CHECK-NEXT:    bge a2, a0, .LBB36_7
; CHECK-NEXT:  .LBB36_3: # %entry
; CHECK-NEXT:    bge a2, a1, .LBB36_8
; CHECK-NEXT:  .LBB36_4: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB36_5: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    blt a0, a2, .LBB36_2
; CHECK-NEXT:  .LBB36_6: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    lui a2, 1048568
; CHECK-NEXT:    blt a2, a0, .LBB36_3
; CHECK-NEXT:  .LBB36_7: # %entry
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    blt a2, a1, .LBB36_4
; CHECK-NEXT:  .LBB36_8: # %entry
; CHECK-NEXT:    lui a1, 1048568
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a0
; CHECK-NEXT:    fmv.d.x ft1, a1
; CHECK-NEXT:    fcvt.wu.d a0, ft0, rtz
; CHECK-NEXT:    lui a1, 16
; CHECK-NEXT:    addiw a2, a1, -1
; CHECK-NEXT:    fcvt.wu.d a1, ft1, rtz
; CHECK-NEXT:    bgeu a0, a2, .LBB37_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bgeu a1, a2, .LBB37_4
; CHECK-NEXT:  .LBB37_2: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB37_3: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bltu a1, a2, .LBB37_2
; CHECK-NEXT:  .LBB37_4: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ret
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.umin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.d.x ft0, a1
; CHECK-NEXT:    fmv.d.x ft1, a0
; CHECK-NEXT:    fcvt.w.d a1, ft0, rtz
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addiw a2, a0, -1
; CHECK-NEXT:    fcvt.w.d a0, ft1, rtz
; CHECK-NEXT:    bge a1, a2, .LBB38_5
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bge a0, a2, .LBB38_6
; CHECK-NEXT:  .LBB38_2: # %entry
; CHECK-NEXT:    blez a0, .LBB38_7
; CHECK-NEXT:  .LBB38_3: # %entry
; CHECK-NEXT:    blez a1, .LBB38_8
; CHECK-NEXT:  .LBB38_4: # %entry
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB38_5: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    blt a0, a2, .LBB38_2
; CHECK-NEXT:  .LBB38_6: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bgtz a0, .LBB38_3
; CHECK-NEXT:  .LBB38_7: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    bgtz a1, .LBB38_4
; CHECK-NEXT:  .LBB38_8: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    ret
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> zeroinitializer)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: stest_f32i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fmv.w.x ft2, a3
; CHECK-NEXT:    fmv.w.x ft0, a2
; CHECK-NEXT:    fcvt.w.s a2, ft1, rtz
; CHECK-NEXT:    lui a3, 8
; CHECK-NEXT:    addiw a5, a3, -1
; CHECK-NEXT:    fcvt.w.s a3, ft2, rtz
; CHECK-NEXT:    blt a2, a5, .LBB39_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a5
; CHECK-NEXT:  .LBB39_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fcvt.w.s a1, ft0, rtz
; CHECK-NEXT:    bge a3, a5, .LBB39_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.w.s a4, ft1, rtz
; CHECK-NEXT:    bge a1, a5, .LBB39_12
; CHECK-NEXT:  .LBB39_4: # %entry
; CHECK-NEXT:    bge a4, a5, .LBB39_13
; CHECK-NEXT:  .LBB39_5: # %entry
; CHECK-NEXT:    lui a5, 1048568
; CHECK-NEXT:    bge a5, a4, .LBB39_14
; CHECK-NEXT:  .LBB39_6: # %entry
; CHECK-NEXT:    bge a5, a1, .LBB39_15
; CHECK-NEXT:  .LBB39_7: # %entry
; CHECK-NEXT:    bge a5, a3, .LBB39_16
; CHECK-NEXT:  .LBB39_8: # %entry
; CHECK-NEXT:    blt a5, a2, .LBB39_10
; CHECK-NEXT:  .LBB39_9: # %entry
; CHECK-NEXT:    lui a2, 1048568
; CHECK-NEXT:  .LBB39_10: # %entry
; CHECK-NEXT:    sh a2, 6(a0)
; CHECK-NEXT:    sh a3, 4(a0)
; CHECK-NEXT:    sh a1, 2(a0)
; CHECK-NEXT:    sh a4, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB39_11: # %entry
; CHECK-NEXT:    mv a3, a5
; CHECK-NEXT:    fcvt.w.s a4, ft1, rtz
; CHECK-NEXT:    blt a1, a5, .LBB39_4
; CHECK-NEXT:  .LBB39_12: # %entry
; CHECK-NEXT:    mv a1, a5
; CHECK-NEXT:    blt a4, a5, .LBB39_5
; CHECK-NEXT:  .LBB39_13: # %entry
; CHECK-NEXT:    mv a4, a5
; CHECK-NEXT:    lui a5, 1048568
; CHECK-NEXT:    blt a5, a4, .LBB39_6
; CHECK-NEXT:  .LBB39_14: # %entry
; CHECK-NEXT:    lui a4, 1048568
; CHECK-NEXT:    blt a5, a1, .LBB39_7
; CHECK-NEXT:  .LBB39_15: # %entry
; CHECK-NEXT:    lui a1, 1048568
; CHECK-NEXT:    blt a5, a3, .LBB39_8
; CHECK-NEXT:  .LBB39_16: # %entry
; CHECK-NEXT:    lui a3, 1048568
; CHECK-NEXT:    bge a5, a2, .LBB39_9
; CHECK-NEXT:    j .LBB39_10
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: utest_f32i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fmv.w.x ft2, a2
; CHECK-NEXT:    fmv.w.x ft0, a3
; CHECK-NEXT:    fcvt.wu.s a1, ft1, rtz
; CHECK-NEXT:    lui a2, 16
; CHECK-NEXT:    addiw a3, a2, -1
; CHECK-NEXT:    fcvt.wu.s a2, ft2, rtz
; CHECK-NEXT:    bltu a1, a3, .LBB40_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB40_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fcvt.wu.s a4, ft0, rtz
; CHECK-NEXT:    bgeu a2, a3, .LBB40_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.wu.s a5, ft1, rtz
; CHECK-NEXT:    bgeu a4, a3, .LBB40_8
; CHECK-NEXT:  .LBB40_4: # %entry
; CHECK-NEXT:    bltu a5, a3, .LBB40_6
; CHECK-NEXT:  .LBB40_5: # %entry
; CHECK-NEXT:    mv a5, a3
; CHECK-NEXT:  .LBB40_6: # %entry
; CHECK-NEXT:    sh a5, 6(a0)
; CHECK-NEXT:    sh a4, 4(a0)
; CHECK-NEXT:    sh a2, 2(a0)
; CHECK-NEXT:    sh a1, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB40_7: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    fcvt.wu.s a5, ft1, rtz
; CHECK-NEXT:    bltu a4, a3, .LBB40_4
; CHECK-NEXT:  .LBB40_8: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bgeu a5, a3, .LBB40_5
; CHECK-NEXT:    j .LBB40_6
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.umin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a4
; CHECK-NEXT:    fmv.w.x ft2, a3
; CHECK-NEXT:    fmv.w.x ft0, a2
; CHECK-NEXT:    fcvt.w.s a2, ft1, rtz
; CHECK-NEXT:    lui a3, 16
; CHECK-NEXT:    addiw a5, a3, -1
; CHECK-NEXT:    fcvt.w.s a3, ft2, rtz
; CHECK-NEXT:    blt a2, a5, .LBB41_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a5
; CHECK-NEXT:  .LBB41_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, a1
; CHECK-NEXT:    fcvt.w.s a1, ft0, rtz
; CHECK-NEXT:    bge a3, a5, .LBB41_11
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fcvt.w.s a4, ft1, rtz
; CHECK-NEXT:    bge a1, a5, .LBB41_12
; CHECK-NEXT:  .LBB41_4: # %entry
; CHECK-NEXT:    bge a4, a5, .LBB41_13
; CHECK-NEXT:  .LBB41_5: # %entry
; CHECK-NEXT:    blez a4, .LBB41_14
; CHECK-NEXT:  .LBB41_6: # %entry
; CHECK-NEXT:    blez a1, .LBB41_15
; CHECK-NEXT:  .LBB41_7: # %entry
; CHECK-NEXT:    blez a3, .LBB41_16
; CHECK-NEXT:  .LBB41_8: # %entry
; CHECK-NEXT:    bgtz a2, .LBB41_10
; CHECK-NEXT:  .LBB41_9: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:  .LBB41_10: # %entry
; CHECK-NEXT:    sh a2, 6(a0)
; CHECK-NEXT:    sh a3, 4(a0)
; CHECK-NEXT:    sh a1, 2(a0)
; CHECK-NEXT:    sh a4, 0(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB41_11: # %entry
; CHECK-NEXT:    mv a3, a5
; CHECK-NEXT:    fcvt.w.s a4, ft1, rtz
; CHECK-NEXT:    blt a1, a5, .LBB41_4
; CHECK-NEXT:  .LBB41_12: # %entry
; CHECK-NEXT:    mv a1, a5
; CHECK-NEXT:    blt a4, a5, .LBB41_5
; CHECK-NEXT:  .LBB41_13: # %entry
; CHECK-NEXT:    mv a4, a5
; CHECK-NEXT:    bgtz a4, .LBB41_6
; CHECK-NEXT:  .LBB41_14: # %entry
; CHECK-NEXT:    li a4, 0
; CHECK-NEXT:    bgtz a1, .LBB41_7
; CHECK-NEXT:  .LBB41_15: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgtz a3, .LBB41_8
; CHECK-NEXT:  .LBB41_16: # %entry
; CHECK-NEXT:    li a3, 0
; CHECK-NEXT:    blez a2, .LBB41_9
; CHECK-NEXT:    j .LBB41_10
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> zeroinitializer)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16_mm(<8 x half> %x) {
; CHECK-LABEL: stest_f16i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -96
; CHECK-NEXT:    .cfi_def_cfa_offset 96
; CHECK-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s7, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s8, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    .cfi_offset s5, -56
; CHECK-NEXT:    .cfi_offset s6, -64
; CHECK-NEXT:    .cfi_offset s7, -72
; CHECK-NEXT:    .cfi_offset s8, -80
; CHECK-NEXT:    lhu s6, 56(a1)
; CHECK-NEXT:    lhu s1, 0(a1)
; CHECK-NEXT:    lhu s2, 8(a1)
; CHECK-NEXT:    lhu s3, 16(a1)
; CHECK-NEXT:    lhu s4, 24(a1)
; CHECK-NEXT:    lhu s5, 32(a1)
; CHECK-NEXT:    lhu s7, 40(a1)
; CHECK-NEXT:    lhu a1, 48(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s8, a0
; CHECK-NEXT:    mv a0, s7
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s7, a0
; CHECK-NEXT:    mv a0, s5
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s5, a0
; CHECK-NEXT:    mv a0, s4
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s7
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s8
; CHECK-NEXT:    fcvt.l.s s7, ft0, rtz
; CHECK-NEXT:    mv a0, s6
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.l.s a0, ft0, rtz
; CHECK-NEXT:    lui a1, 8
; CHECK-NEXT:    addiw a7, a1, -1
; CHECK-NEXT:    blt a0, a7, .LBB42_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a7
; CHECK-NEXT:  .LBB42_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s5
; CHECK-NEXT:    flw ft0, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.l.s a1, ft0, rtz
; CHECK-NEXT:    blt s7, a7, .LBB42_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mv s7, a7
; CHECK-NEXT:  .LBB42_4: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    blt a1, a7, .LBB42_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    mv a1, a7
; CHECK-NEXT:  .LBB42_6: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s3
; CHECK-NEXT:    fcvt.l.s a3, ft0, rtz
; CHECK-NEXT:    blt a2, a7, .LBB42_8
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    mv a2, a7
; CHECK-NEXT:  .LBB42_8: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s2
; CHECK-NEXT:    fcvt.l.s a4, ft1, rtz
; CHECK-NEXT:    blt a3, a7, .LBB42_10
; CHECK-NEXT:  # %bb.9: # %entry
; CHECK-NEXT:    mv a3, a7
; CHECK-NEXT:  .LBB42_10: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s1
; CHECK-NEXT:    fcvt.l.s a5, ft0, rtz
; CHECK-NEXT:    bge a4, a7, .LBB42_23
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    fcvt.l.s a6, ft1, rtz
; CHECK-NEXT:    bge a5, a7, .LBB42_24
; CHECK-NEXT:  .LBB42_12: # %entry
; CHECK-NEXT:    bge a6, a7, .LBB42_25
; CHECK-NEXT:  .LBB42_13: # %entry
; CHECK-NEXT:    lui a7, 1048568
; CHECK-NEXT:    bge a7, a6, .LBB42_26
; CHECK-NEXT:  .LBB42_14: # %entry
; CHECK-NEXT:    bge a7, a5, .LBB42_27
; CHECK-NEXT:  .LBB42_15: # %entry
; CHECK-NEXT:    bge a7, a4, .LBB42_28
; CHECK-NEXT:  .LBB42_16: # %entry
; CHECK-NEXT:    bge a7, a3, .LBB42_29
; CHECK-NEXT:  .LBB42_17: # %entry
; CHECK-NEXT:    bge a7, a2, .LBB42_30
; CHECK-NEXT:  .LBB42_18: # %entry
; CHECK-NEXT:    bge a7, a1, .LBB42_31
; CHECK-NEXT:  .LBB42_19: # %entry
; CHECK-NEXT:    bge a7, s7, .LBB42_32
; CHECK-NEXT:  .LBB42_20: # %entry
; CHECK-NEXT:    blt a7, a0, .LBB42_22
; CHECK-NEXT:  .LBB42_21: # %entry
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:  .LBB42_22: # %entry
; CHECK-NEXT:    sh a0, 14(s0)
; CHECK-NEXT:    sh s7, 12(s0)
; CHECK-NEXT:    sh a1, 10(s0)
; CHECK-NEXT:    sh a2, 8(s0)
; CHECK-NEXT:    sh a3, 6(s0)
; CHECK-NEXT:    sh a4, 4(s0)
; CHECK-NEXT:    sh a5, 2(s0)
; CHECK-NEXT:    sh a6, 0(s0)
; CHECK-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s7, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s8, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 96
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB42_23: # %entry
; CHECK-NEXT:    mv a4, a7
; CHECK-NEXT:    fcvt.l.s a6, ft1, rtz
; CHECK-NEXT:    blt a5, a7, .LBB42_12
; CHECK-NEXT:  .LBB42_24: # %entry
; CHECK-NEXT:    mv a5, a7
; CHECK-NEXT:    blt a6, a7, .LBB42_13
; CHECK-NEXT:  .LBB42_25: # %entry
; CHECK-NEXT:    mv a6, a7
; CHECK-NEXT:    lui a7, 1048568
; CHECK-NEXT:    blt a7, a6, .LBB42_14
; CHECK-NEXT:  .LBB42_26: # %entry
; CHECK-NEXT:    lui a6, 1048568
; CHECK-NEXT:    blt a7, a5, .LBB42_15
; CHECK-NEXT:  .LBB42_27: # %entry
; CHECK-NEXT:    lui a5, 1048568
; CHECK-NEXT:    blt a7, a4, .LBB42_16
; CHECK-NEXT:  .LBB42_28: # %entry
; CHECK-NEXT:    lui a4, 1048568
; CHECK-NEXT:    blt a7, a3, .LBB42_17
; CHECK-NEXT:  .LBB42_29: # %entry
; CHECK-NEXT:    lui a3, 1048568
; CHECK-NEXT:    blt a7, a2, .LBB42_18
; CHECK-NEXT:  .LBB42_30: # %entry
; CHECK-NEXT:    lui a2, 1048568
; CHECK-NEXT:    blt a7, a1, .LBB42_19
; CHECK-NEXT:  .LBB42_31: # %entry
; CHECK-NEXT:    lui a1, 1048568
; CHECK-NEXT:    blt a7, s7, .LBB42_20
; CHECK-NEXT:  .LBB42_32: # %entry
; CHECK-NEXT:    lui s7, 1048568
; CHECK-NEXT:    bge a7, a0, .LBB42_21
; CHECK-NEXT:    j .LBB42_22
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16_mm(<8 x half> %x) {
; CHECK-LABEL: utesth_f16i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -96
; CHECK-NEXT:    .cfi_def_cfa_offset 96
; CHECK-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s7, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s8, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    .cfi_offset s5, -56
; CHECK-NEXT:    .cfi_offset s6, -64
; CHECK-NEXT:    .cfi_offset s7, -72
; CHECK-NEXT:    .cfi_offset s8, -80
; CHECK-NEXT:    lhu s5, 0(a1)
; CHECK-NEXT:    lhu s1, 56(a1)
; CHECK-NEXT:    lhu s2, 48(a1)
; CHECK-NEXT:    lhu s3, 40(a1)
; CHECK-NEXT:    lhu s4, 32(a1)
; CHECK-NEXT:    lhu s6, 24(a1)
; CHECK-NEXT:    lhu s7, 16(a1)
; CHECK-NEXT:    lhu a1, 8(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s8, a0
; CHECK-NEXT:    mv a0, s7
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s7, a0
; CHECK-NEXT:    mv a0, s6
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s6, a0
; CHECK-NEXT:    mv a0, s4
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s6
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s7
; CHECK-NEXT:    fcvt.lu.s s7, ft0, rtz
; CHECK-NEXT:    fmv.w.x ft0, s8
; CHECK-NEXT:    fcvt.lu.s a0, ft0, rtz
; CHECK-NEXT:    sext.w s6, a0
; CHECK-NEXT:    mv a0, s5
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.lu.s a0, ft0, rtz
; CHECK-NEXT:    sext.w a0, a0
; CHECK-NEXT:    lui a1, 16
; CHECK-NEXT:    addiw a1, a1, -1
; CHECK-NEXT:    bltu a0, a1, .LBB43_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB43_2: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    flw ft1, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.lu.s a3, ft1, rtz
; CHECK-NEXT:    sext.w a2, s7
; CHECK-NEXT:    bltu s6, a1, .LBB43_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mv s6, a1
; CHECK-NEXT:  .LBB43_4: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s3
; CHECK-NEXT:    fcvt.lu.s a4, ft0, rtz
; CHECK-NEXT:    sext.w a3, a3
; CHECK-NEXT:    bltu a2, a1, .LBB43_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:  .LBB43_6: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s2
; CHECK-NEXT:    fcvt.lu.s a5, ft1, rtz
; CHECK-NEXT:    sext.w a4, a4
; CHECK-NEXT:    bltu a3, a1, .LBB43_8
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:  .LBB43_8: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s1
; CHECK-NEXT:    fcvt.lu.s a6, ft0, rtz
; CHECK-NEXT:    sext.w a5, a5
; CHECK-NEXT:    bltu a4, a1, .LBB43_10
; CHECK-NEXT:  # %bb.9: # %entry
; CHECK-NEXT:    mv a4, a1
; CHECK-NEXT:  .LBB43_10: # %entry
; CHECK-NEXT:    fcvt.lu.s a7, ft1, rtz
; CHECK-NEXT:    sext.w a6, a6
; CHECK-NEXT:    bgeu a5, a1, .LBB43_15
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    sext.w a7, a7
; CHECK-NEXT:    bgeu a6, a1, .LBB43_16
; CHECK-NEXT:  .LBB43_12: # %entry
; CHECK-NEXT:    bltu a7, a1, .LBB43_14
; CHECK-NEXT:  .LBB43_13: # %entry
; CHECK-NEXT:    mv a7, a1
; CHECK-NEXT:  .LBB43_14: # %entry
; CHECK-NEXT:    sh a7, 14(s0)
; CHECK-NEXT:    sh a6, 12(s0)
; CHECK-NEXT:    sh a5, 10(s0)
; CHECK-NEXT:    sh a4, 8(s0)
; CHECK-NEXT:    sh a3, 6(s0)
; CHECK-NEXT:    sh a2, 4(s0)
; CHECK-NEXT:    sh s6, 2(s0)
; CHECK-NEXT:    sh a0, 0(s0)
; CHECK-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s7, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s8, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 96
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB43_15: # %entry
; CHECK-NEXT:    mv a5, a1
; CHECK-NEXT:    sext.w a7, a7
; CHECK-NEXT:    bltu a6, a1, .LBB43_12
; CHECK-NEXT:  .LBB43_16: # %entry
; CHECK-NEXT:    mv a6, a1
; CHECK-NEXT:    bgeu a7, a1, .LBB43_13
; CHECK-NEXT:    j .LBB43_14
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.umin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16_mm(<8 x half> %x) {
; CHECK-LABEL: ustest_f16i16_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -96
; CHECK-NEXT:    .cfi_def_cfa_offset 96
; CHECK-NEXT:    sd ra, 88(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 80(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s3, 56(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s4, 48(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s5, 40(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s6, 32(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s7, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s8, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    .cfi_offset s3, -40
; CHECK-NEXT:    .cfi_offset s4, -48
; CHECK-NEXT:    .cfi_offset s5, -56
; CHECK-NEXT:    .cfi_offset s6, -64
; CHECK-NEXT:    .cfi_offset s7, -72
; CHECK-NEXT:    .cfi_offset s8, -80
; CHECK-NEXT:    lhu s6, 56(a1)
; CHECK-NEXT:    lhu s1, 0(a1)
; CHECK-NEXT:    lhu s2, 8(a1)
; CHECK-NEXT:    lhu s3, 16(a1)
; CHECK-NEXT:    lhu s4, 24(a1)
; CHECK-NEXT:    lhu s5, 32(a1)
; CHECK-NEXT:    lhu s7, 40(a1)
; CHECK-NEXT:    lhu a1, 48(a1)
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s8, a0
; CHECK-NEXT:    mv a0, s7
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s7, a0
; CHECK-NEXT:    mv a0, s5
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s5, a0
; CHECK-NEXT:    mv a0, s4
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s4, a0
; CHECK-NEXT:    mv a0, s3
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s3, a0
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    fmv.w.x ft0, s7
; CHECK-NEXT:    fsw ft0, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x ft0, s8
; CHECK-NEXT:    fcvt.l.s s7, ft0, rtz
; CHECK-NEXT:    mv a0, s6
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    fmv.w.x ft0, a0
; CHECK-NEXT:    fcvt.l.s a0, ft0, rtz
; CHECK-NEXT:    lui a1, 16
; CHECK-NEXT:    addiw a7, a1, -1
; CHECK-NEXT:    blt a0, a7, .LBB44_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a0, a7
; CHECK-NEXT:  .LBB44_2: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s5
; CHECK-NEXT:    flw ft0, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fcvt.l.s a1, ft0, rtz
; CHECK-NEXT:    blt s7, a7, .LBB44_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mv s7, a7
; CHECK-NEXT:  .LBB44_4: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s4
; CHECK-NEXT:    fcvt.l.s a2, ft1, rtz
; CHECK-NEXT:    blt a1, a7, .LBB44_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    mv a1, a7
; CHECK-NEXT:  .LBB44_6: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s3
; CHECK-NEXT:    fcvt.l.s a3, ft0, rtz
; CHECK-NEXT:    blt a2, a7, .LBB44_8
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    mv a2, a7
; CHECK-NEXT:  .LBB44_8: # %entry
; CHECK-NEXT:    fmv.w.x ft0, s2
; CHECK-NEXT:    fcvt.l.s a4, ft1, rtz
; CHECK-NEXT:    blt a3, a7, .LBB44_10
; CHECK-NEXT:  # %bb.9: # %entry
; CHECK-NEXT:    mv a3, a7
; CHECK-NEXT:  .LBB44_10: # %entry
; CHECK-NEXT:    fmv.w.x ft1, s1
; CHECK-NEXT:    fcvt.l.s a5, ft0, rtz
; CHECK-NEXT:    bge a4, a7, .LBB44_23
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    fcvt.l.s a6, ft1, rtz
; CHECK-NEXT:    bge a5, a7, .LBB44_24
; CHECK-NEXT:  .LBB44_12: # %entry
; CHECK-NEXT:    bge a6, a7, .LBB44_25
; CHECK-NEXT:  .LBB44_13: # %entry
; CHECK-NEXT:    blez a6, .LBB44_26
; CHECK-NEXT:  .LBB44_14: # %entry
; CHECK-NEXT:    blez a5, .LBB44_27
; CHECK-NEXT:  .LBB44_15: # %entry
; CHECK-NEXT:    blez a4, .LBB44_28
; CHECK-NEXT:  .LBB44_16: # %entry
; CHECK-NEXT:    blez a3, .LBB44_29
; CHECK-NEXT:  .LBB44_17: # %entry
; CHECK-NEXT:    blez a2, .LBB44_30
; CHECK-NEXT:  .LBB44_18: # %entry
; CHECK-NEXT:    blez a1, .LBB44_31
; CHECK-NEXT:  .LBB44_19: # %entry
; CHECK-NEXT:    blez s7, .LBB44_32
; CHECK-NEXT:  .LBB44_20: # %entry
; CHECK-NEXT:    bgtz a0, .LBB44_22
; CHECK-NEXT:  .LBB44_21: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:  .LBB44_22: # %entry
; CHECK-NEXT:    sh a0, 14(s0)
; CHECK-NEXT:    sh s7, 12(s0)
; CHECK-NEXT:    sh a1, 10(s0)
; CHECK-NEXT:    sh a2, 8(s0)
; CHECK-NEXT:    sh a3, 6(s0)
; CHECK-NEXT:    sh a4, 4(s0)
; CHECK-NEXT:    sh a5, 2(s0)
; CHECK-NEXT:    sh a6, 0(s0)
; CHECK-NEXT:    ld ra, 88(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 80(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s3, 56(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s4, 48(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s5, 40(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s6, 32(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s7, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s8, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 96
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB44_23: # %entry
; CHECK-NEXT:    mv a4, a7
; CHECK-NEXT:    fcvt.l.s a6, ft1, rtz
; CHECK-NEXT:    blt a5, a7, .LBB44_12
; CHECK-NEXT:  .LBB44_24: # %entry
; CHECK-NEXT:    mv a5, a7
; CHECK-NEXT:    blt a6, a7, .LBB44_13
; CHECK-NEXT:  .LBB44_25: # %entry
; CHECK-NEXT:    mv a6, a7
; CHECK-NEXT:    bgtz a6, .LBB44_14
; CHECK-NEXT:  .LBB44_26: # %entry
; CHECK-NEXT:    li a6, 0
; CHECK-NEXT:    bgtz a5, .LBB44_15
; CHECK-NEXT:  .LBB44_27: # %entry
; CHECK-NEXT:    li a5, 0
; CHECK-NEXT:    bgtz a4, .LBB44_16
; CHECK-NEXT:  .LBB44_28: # %entry
; CHECK-NEXT:    li a4, 0
; CHECK-NEXT:    bgtz a3, .LBB44_17
; CHECK-NEXT:  .LBB44_29: # %entry
; CHECK-NEXT:    li a3, 0
; CHECK-NEXT:    bgtz a2, .LBB44_18
; CHECK-NEXT:  .LBB44_30: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    bgtz a1, .LBB44_19
; CHECK-NEXT:  .LBB44_31: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgtz s7, .LBB44_20
; CHECK-NEXT:  .LBB44_32: # %entry
; CHECK-NEXT:    li s7, 0
; CHECK-NEXT:    blez a0, .LBB44_21
; CHECK-NEXT:    j .LBB44_22
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> zeroinitializer)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __fixdfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixdfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    li a0, -1
; CHECK-NEXT:    srli a3, a0, 1
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bgez a1, .LBB45_17
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bgeu a2, a3, .LBB45_18
; CHECK-NEXT:  .LBB45_2: # %entry
; CHECK-NEXT:    bnez a1, .LBB45_19
; CHECK-NEXT:  .LBB45_3: # %entry
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bgez s1, .LBB45_20
; CHECK-NEXT:  .LBB45_4: # %entry
; CHECK-NEXT:    bgeu s0, a3, .LBB45_21
; CHECK-NEXT:  .LBB45_5: # %entry
; CHECK-NEXT:    bnez s1, .LBB45_22
; CHECK-NEXT:  .LBB45_6: # %entry
; CHECK-NEXT:    bgez a1, .LBB45_23
; CHECK-NEXT:  .LBB45_7: # %entry
; CHECK-NEXT:    bltz s1, .LBB45_9
; CHECK-NEXT:  .LBB45_8: # %entry
; CHECK-NEXT:    li s1, 0
; CHECK-NEXT:  .LBB45_9: # %entry
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bltz s1, .LBB45_24
; CHECK-NEXT:  # %bb.10: # %entry
; CHECK-NEXT:    bgeu a3, s0, .LBB45_25
; CHECK-NEXT:  .LBB45_11: # %entry
; CHECK-NEXT:    bne s1, a0, .LBB45_26
; CHECK-NEXT:  .LBB45_12: # %entry
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bltz a1, .LBB45_27
; CHECK-NEXT:  .LBB45_13: # %entry
; CHECK-NEXT:    bgeu a3, a2, .LBB45_28
; CHECK-NEXT:  .LBB45_14: # %entry
; CHECK-NEXT:    beq a1, a0, .LBB45_16
; CHECK-NEXT:  .LBB45_15: # %entry
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:  .LBB45_16: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB45_17: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a2, a3, .LBB45_2
; CHECK-NEXT:  .LBB45_18: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    beqz a1, .LBB45_3
; CHECK-NEXT:  .LBB45_19: # %entry
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bltz s1, .LBB45_4
; CHECK-NEXT:  .LBB45_20: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu s0, a3, .LBB45_5
; CHECK-NEXT:  .LBB45_21: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:    beqz s1, .LBB45_6
; CHECK-NEXT:  .LBB45_22: # %entry
; CHECK-NEXT:    mv s0, a4
; CHECK-NEXT:    bltz a1, .LBB45_7
; CHECK-NEXT:  .LBB45_23: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgez s1, .LBB45_8
; CHECK-NEXT:    j .LBB45_9
; CHECK-NEXT:  .LBB45_24: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a3, s0, .LBB45_11
; CHECK-NEXT:  .LBB45_25: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:    beq s1, a0, .LBB45_12
; CHECK-NEXT:  .LBB45_26: # %entry
; CHECK-NEXT:    mv s0, a4
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bgez a1, .LBB45_13
; CHECK-NEXT:  .LBB45_27: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a3, a2, .LBB45_14
; CHECK-NEXT:  .LBB45_28: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    bne a1, a0, .LBB45_15
; CHECK-NEXT:    j .LBB45_16
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __fixunsdfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixunsdfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    beqz a3, .LBB46_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:  .LBB46_2: # %entry
; CHECK-NEXT:    li a4, 1
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    bne a3, a4, .LBB46_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    bne s1, a1, .LBB46_8
; CHECK-NEXT:  .LBB46_4: # %entry
; CHECK-NEXT:    beq s1, a4, .LBB46_6
; CHECK-NEXT:  .LBB46_5: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:  .LBB46_6: # %entry
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB46_7: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    beq s1, a1, .LBB46_4
; CHECK-NEXT:  .LBB46_8: # %entry
; CHECK-NEXT:    mv s0, a1
; CHECK-NEXT:    bne s1, a4, .LBB46_5
; CHECK-NEXT:    j .LBB46_6
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __fixdfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixdfti@plt
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    li a5, 1
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:    bgtz a1, .LBB47_12
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a4, s1
; CHECK-NEXT:    bgtz s1, .LBB47_13
; CHECK-NEXT:  .LBB47_2: # %entry
; CHECK-NEXT:    bgtz a2, .LBB47_14
; CHECK-NEXT:  .LBB47_3: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bne a2, a5, .LBB47_15
; CHECK-NEXT:  .LBB47_4: # %entry
; CHECK-NEXT:    bgtz s1, .LBB47_16
; CHECK-NEXT:  .LBB47_5: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    bne s1, a5, .LBB47_17
; CHECK-NEXT:  .LBB47_6: # %entry
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    blez a4, .LBB47_18
; CHECK-NEXT:  .LBB47_7: # %entry
; CHECK-NEXT:    bnez a4, .LBB47_19
; CHECK-NEXT:  .LBB47_8: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    blez a3, .LBB47_20
; CHECK-NEXT:  .LBB47_9: # %entry
; CHECK-NEXT:    beqz a3, .LBB47_11
; CHECK-NEXT:  .LBB47_10: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:  .LBB47_11: # %entry
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB47_12: # %entry
; CHECK-NEXT:    li a3, 1
; CHECK-NEXT:    mv a4, s1
; CHECK-NEXT:    blez s1, .LBB47_2
; CHECK-NEXT:  .LBB47_13: # %entry
; CHECK-NEXT:    li a4, 1
; CHECK-NEXT:    blez a2, .LBB47_3
; CHECK-NEXT:  .LBB47_14: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    beq a2, a5, .LBB47_4
; CHECK-NEXT:  .LBB47_15: # %entry
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    blez s1, .LBB47_5
; CHECK-NEXT:  .LBB47_16: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    beq s1, a5, .LBB47_6
; CHECK-NEXT:  .LBB47_17: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    bgtz a4, .LBB47_7
; CHECK-NEXT:  .LBB47_18: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    beqz a4, .LBB47_8
; CHECK-NEXT:  .LBB47_19: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    bgtz a3, .LBB47_9
; CHECK-NEXT:  .LBB47_20: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    bnez a3, .LBB47_10
; CHECK-NEXT:    j .LBB47_11
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: stest_f32i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    li a0, -1
; CHECK-NEXT:    srli a3, a0, 1
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bgez a1, .LBB48_17
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bgeu a2, a3, .LBB48_18
; CHECK-NEXT:  .LBB48_2: # %entry
; CHECK-NEXT:    bnez a1, .LBB48_19
; CHECK-NEXT:  .LBB48_3: # %entry
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bgez s1, .LBB48_20
; CHECK-NEXT:  .LBB48_4: # %entry
; CHECK-NEXT:    bgeu s0, a3, .LBB48_21
; CHECK-NEXT:  .LBB48_5: # %entry
; CHECK-NEXT:    bnez s1, .LBB48_22
; CHECK-NEXT:  .LBB48_6: # %entry
; CHECK-NEXT:    bgez a1, .LBB48_23
; CHECK-NEXT:  .LBB48_7: # %entry
; CHECK-NEXT:    bltz s1, .LBB48_9
; CHECK-NEXT:  .LBB48_8: # %entry
; CHECK-NEXT:    li s1, 0
; CHECK-NEXT:  .LBB48_9: # %entry
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bltz s1, .LBB48_24
; CHECK-NEXT:  # %bb.10: # %entry
; CHECK-NEXT:    bgeu a3, s0, .LBB48_25
; CHECK-NEXT:  .LBB48_11: # %entry
; CHECK-NEXT:    bne s1, a0, .LBB48_26
; CHECK-NEXT:  .LBB48_12: # %entry
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bltz a1, .LBB48_27
; CHECK-NEXT:  .LBB48_13: # %entry
; CHECK-NEXT:    bgeu a3, a2, .LBB48_28
; CHECK-NEXT:  .LBB48_14: # %entry
; CHECK-NEXT:    beq a1, a0, .LBB48_16
; CHECK-NEXT:  .LBB48_15: # %entry
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:  .LBB48_16: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB48_17: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a2, a3, .LBB48_2
; CHECK-NEXT:  .LBB48_18: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    beqz a1, .LBB48_3
; CHECK-NEXT:  .LBB48_19: # %entry
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bltz s1, .LBB48_4
; CHECK-NEXT:  .LBB48_20: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu s0, a3, .LBB48_5
; CHECK-NEXT:  .LBB48_21: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:    beqz s1, .LBB48_6
; CHECK-NEXT:  .LBB48_22: # %entry
; CHECK-NEXT:    mv s0, a4
; CHECK-NEXT:    bltz a1, .LBB48_7
; CHECK-NEXT:  .LBB48_23: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgez s1, .LBB48_8
; CHECK-NEXT:    j .LBB48_9
; CHECK-NEXT:  .LBB48_24: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a3, s0, .LBB48_11
; CHECK-NEXT:  .LBB48_25: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:    beq s1, a0, .LBB48_12
; CHECK-NEXT:  .LBB48_26: # %entry
; CHECK-NEXT:    mv s0, a4
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bgez a1, .LBB48_13
; CHECK-NEXT:  .LBB48_27: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a3, a2, .LBB48_14
; CHECK-NEXT:  .LBB48_28: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    bne a1, a0, .LBB48_15
; CHECK-NEXT:    j .LBB48_16
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: utest_f32i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __fixunssfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixunssfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    beqz a3, .LBB49_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:  .LBB49_2: # %entry
; CHECK-NEXT:    li a4, 1
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    bne a3, a4, .LBB49_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    bne s1, a1, .LBB49_8
; CHECK-NEXT:  .LBB49_4: # %entry
; CHECK-NEXT:    beq s1, a4, .LBB49_6
; CHECK-NEXT:  .LBB49_5: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:  .LBB49_6: # %entry
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB49_7: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    beq s1, a1, .LBB49_4
; CHECK-NEXT:  .LBB49_8: # %entry
; CHECK-NEXT:    mv s0, a1
; CHECK-NEXT:    bne s1, a4, .LBB49_5
; CHECK-NEXT:    j .LBB49_6
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: ustest_f32i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    li a5, 1
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:    bgtz a1, .LBB50_12
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a4, s1
; CHECK-NEXT:    bgtz s1, .LBB50_13
; CHECK-NEXT:  .LBB50_2: # %entry
; CHECK-NEXT:    bgtz a2, .LBB50_14
; CHECK-NEXT:  .LBB50_3: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bne a2, a5, .LBB50_15
; CHECK-NEXT:  .LBB50_4: # %entry
; CHECK-NEXT:    bgtz s1, .LBB50_16
; CHECK-NEXT:  .LBB50_5: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    bne s1, a5, .LBB50_17
; CHECK-NEXT:  .LBB50_6: # %entry
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    blez a4, .LBB50_18
; CHECK-NEXT:  .LBB50_7: # %entry
; CHECK-NEXT:    bnez a4, .LBB50_19
; CHECK-NEXT:  .LBB50_8: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    blez a3, .LBB50_20
; CHECK-NEXT:  .LBB50_9: # %entry
; CHECK-NEXT:    beqz a3, .LBB50_11
; CHECK-NEXT:  .LBB50_10: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:  .LBB50_11: # %entry
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB50_12: # %entry
; CHECK-NEXT:    li a3, 1
; CHECK-NEXT:    mv a4, s1
; CHECK-NEXT:    blez s1, .LBB50_2
; CHECK-NEXT:  .LBB50_13: # %entry
; CHECK-NEXT:    li a4, 1
; CHECK-NEXT:    blez a2, .LBB50_3
; CHECK-NEXT:  .LBB50_14: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    beq a2, a5, .LBB50_4
; CHECK-NEXT:  .LBB50_15: # %entry
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    blez s1, .LBB50_5
; CHECK-NEXT:  .LBB50_16: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    beq s1, a5, .LBB50_6
; CHECK-NEXT:  .LBB50_17: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    bgtz a4, .LBB50_7
; CHECK-NEXT:  .LBB50_18: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    beqz a4, .LBB50_8
; CHECK-NEXT:  .LBB50_19: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    bgtz a3, .LBB50_9
; CHECK-NEXT:  .LBB50_20: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    bnez a3, .LBB50_10
; CHECK-NEXT:    j .LBB50_11
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64_mm(<2 x half> %x) {
; CHECK-LABEL: stest_f16i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    li a0, -1
; CHECK-NEXT:    srli a3, a0, 1
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bgez a1, .LBB51_17
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    bgeu a2, a3, .LBB51_18
; CHECK-NEXT:  .LBB51_2: # %entry
; CHECK-NEXT:    bnez a1, .LBB51_19
; CHECK-NEXT:  .LBB51_3: # %entry
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bgez s1, .LBB51_20
; CHECK-NEXT:  .LBB51_4: # %entry
; CHECK-NEXT:    bgeu s0, a3, .LBB51_21
; CHECK-NEXT:  .LBB51_5: # %entry
; CHECK-NEXT:    bnez s1, .LBB51_22
; CHECK-NEXT:  .LBB51_6: # %entry
; CHECK-NEXT:    bgez a1, .LBB51_23
; CHECK-NEXT:  .LBB51_7: # %entry
; CHECK-NEXT:    bltz s1, .LBB51_9
; CHECK-NEXT:  .LBB51_8: # %entry
; CHECK-NEXT:    li s1, 0
; CHECK-NEXT:  .LBB51_9: # %entry
; CHECK-NEXT:    slli a3, a0, 63
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bltz s1, .LBB51_24
; CHECK-NEXT:  # %bb.10: # %entry
; CHECK-NEXT:    bgeu a3, s0, .LBB51_25
; CHECK-NEXT:  .LBB51_11: # %entry
; CHECK-NEXT:    bne s1, a0, .LBB51_26
; CHECK-NEXT:  .LBB51_12: # %entry
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bltz a1, .LBB51_27
; CHECK-NEXT:  .LBB51_13: # %entry
; CHECK-NEXT:    bgeu a3, a2, .LBB51_28
; CHECK-NEXT:  .LBB51_14: # %entry
; CHECK-NEXT:    beq a1, a0, .LBB51_16
; CHECK-NEXT:  .LBB51_15: # %entry
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:  .LBB51_16: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB51_17: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a2, a3, .LBB51_2
; CHECK-NEXT:  .LBB51_18: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    beqz a1, .LBB51_3
; CHECK-NEXT:  .LBB51_19: # %entry
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:    mv a4, s0
; CHECK-NEXT:    bltz s1, .LBB51_4
; CHECK-NEXT:  .LBB51_20: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu s0, a3, .LBB51_5
; CHECK-NEXT:  .LBB51_21: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:    beqz s1, .LBB51_6
; CHECK-NEXT:  .LBB51_22: # %entry
; CHECK-NEXT:    mv s0, a4
; CHECK-NEXT:    bltz a1, .LBB51_7
; CHECK-NEXT:  .LBB51_23: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bgez s1, .LBB51_8
; CHECK-NEXT:    j .LBB51_9
; CHECK-NEXT:  .LBB51_24: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a3, s0, .LBB51_11
; CHECK-NEXT:  .LBB51_25: # %entry
; CHECK-NEXT:    mv s0, a3
; CHECK-NEXT:    beq s1, a0, .LBB51_12
; CHECK-NEXT:  .LBB51_26: # %entry
; CHECK-NEXT:    mv s0, a4
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bgez a1, .LBB51_13
; CHECK-NEXT:  .LBB51_27: # %entry
; CHECK-NEXT:    mv a4, a3
; CHECK-NEXT:    bltu a3, a2, .LBB51_14
; CHECK-NEXT:  .LBB51_28: # %entry
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    bne a1, a0, .LBB51_15
; CHECK-NEXT:    j .LBB51_16
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64_mm(<2 x half> %x) {
; CHECK-LABEL: utesth_f16i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixunssfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixunssfti@plt
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    beqz a3, .LBB52_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:  .LBB52_2: # %entry
; CHECK-NEXT:    li a4, 1
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    bne a3, a4, .LBB52_7
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    bne s1, a1, .LBB52_8
; CHECK-NEXT:  .LBB52_4: # %entry
; CHECK-NEXT:    beq s1, a4, .LBB52_6
; CHECK-NEXT:  .LBB52_5: # %entry
; CHECK-NEXT:    mv a1, s0
; CHECK-NEXT:  .LBB52_6: # %entry
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB52_7: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    beq s1, a1, .LBB52_4
; CHECK-NEXT:  .LBB52_8: # %entry
; CHECK-NEXT:    mv s0, a1
; CHECK-NEXT:    bne s1, a4, .LBB52_5
; CHECK-NEXT:    j .LBB52_6
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64_mm(<2 x half> %x) {
; CHECK-LABEL: ustest_f16i64_mm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset ra, -8
; CHECK-NEXT:    .cfi_offset s0, -16
; CHECK-NEXT:    .cfi_offset s1, -24
; CHECK-NEXT:    .cfi_offset s2, -32
; CHECK-NEXT:    mv s2, a1
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    mv s1, a1
; CHECK-NEXT:    mv a0, s2
; CHECK-NEXT:    call __extendhfsf2@plt
; CHECK-NEXT:    call __fixsfti@plt
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    li a5, 1
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:    bgtz a1, .LBB53_12
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mv a4, s1
; CHECK-NEXT:    bgtz s1, .LBB53_13
; CHECK-NEXT:  .LBB53_2: # %entry
; CHECK-NEXT:    bgtz a2, .LBB53_14
; CHECK-NEXT:  .LBB53_3: # %entry
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    bne a2, a5, .LBB53_15
; CHECK-NEXT:  .LBB53_4: # %entry
; CHECK-NEXT:    bgtz s1, .LBB53_16
; CHECK-NEXT:  .LBB53_5: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    bne s1, a5, .LBB53_17
; CHECK-NEXT:  .LBB53_6: # %entry
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    blez a4, .LBB53_18
; CHECK-NEXT:  .LBB53_7: # %entry
; CHECK-NEXT:    bnez a4, .LBB53_19
; CHECK-NEXT:  .LBB53_8: # %entry
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    blez a3, .LBB53_20
; CHECK-NEXT:  .LBB53_9: # %entry
; CHECK-NEXT:    beqz a3, .LBB53_11
; CHECK-NEXT:  .LBB53_10: # %entry
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:  .LBB53_11: # %entry
; CHECK-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 32
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB53_12: # %entry
; CHECK-NEXT:    li a3, 1
; CHECK-NEXT:    mv a4, s1
; CHECK-NEXT:    blez s1, .LBB53_2
; CHECK-NEXT:  .LBB53_13: # %entry
; CHECK-NEXT:    li a4, 1
; CHECK-NEXT:    blez a2, .LBB53_3
; CHECK-NEXT:  .LBB53_14: # %entry
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    li a1, 0
; CHECK-NEXT:    beq a2, a5, .LBB53_4
; CHECK-NEXT:  .LBB53_15: # %entry
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    blez s1, .LBB53_5
; CHECK-NEXT:  .LBB53_16: # %entry
; CHECK-NEXT:    li s0, 0
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    beq s1, a5, .LBB53_6
; CHECK-NEXT:  .LBB53_17: # %entry
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    bgtz a4, .LBB53_7
; CHECK-NEXT:  .LBB53_18: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    beqz a4, .LBB53_8
; CHECK-NEXT:  .LBB53_19: # %entry
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    bgtz a3, .LBB53_9
; CHECK-NEXT:  .LBB53_20: # %entry
; CHECK-NEXT:    li a2, 0
; CHECK-NEXT:    bnez a3, .LBB53_10
; CHECK-NEXT:    j .LBB53_11
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

declare <2 x i32> @llvm.smin.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.smax.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.umin.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.umin.v4i64(<4 x i64>, <4 x i64>)
declare <2 x i128> @llvm.smin.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.smax.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.umin.v2i128(<2 x i128>, <2 x i128>)
