package org.jboss.cache.marshall;

import org.jboss.cache.CacheException;

/**
 * Thrown by a {@link org.jboss.cache.marshall.AbstractMarshaller} instance when attempting to perform an operation on an inactive region.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.0.0
 */
public class InactiveRegionException extends CacheException
{

   private static final long serialVersionUID = -5672201755094521936L;

   public InactiveRegionException()
   {
      super();
   }

   public InactiveRegionException(String msg)
   {
      super(msg);
   }

   public InactiveRegionException(String msg, Throwable cause)
   {
      super(msg, cause);
   }
}
