package org.jboss.cache.notifications.event;

import java.util.Map;

/**
 * This event is passed in to any method annotated with {@link org.jboss.cache.notifications.annotation.NodeRemoved}.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.0.0
 */
public interface NodeRemovedEvent extends NodeEvent
{
   /**
    * @return an unmodifiable {@link Map} of data.  When <tt>isPre() == true</tt>, this is the initial state of the {@link org.jboss.cache.Node}
    *         before removal.  When called with <tt>isPre() == false</tt>, this is <tt>null</tt>.
    */
   Map getData();
}
