/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.beans;

import java.io.Serializable;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;

import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/**
 * General metadata.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 71794 $
 */
public abstract class AFeatureMetaData extends JBossObject
   implements Serializable
{
   private static final long serialVersionUID = 2L;

   /** The description */
   private String description;

   /** The annotations */
   private Set<IAnnotationMetaData> annotations;

   /**
    * Create a new meta data
    */
   public AFeatureMetaData()
   {
   }
   
   /**
    * Set the description.
    * 
    * @param description the description.
    */
   public void setDescription(String description)
   {
      this.description = description;
      flushJBossObjectCache();
   }

   /**
    * Set the annotations.
    * 
    * @param annotations Set<AnnotationMetaData>
    */
   @XmlElement(name="annotation", type=DirectAnnotationMetaData.class)
   public void setAnnotations(Set<IAnnotationMetaData> annotations)
   {
      this.annotations = annotations;
      flushJBossObjectCache();
   }
   
   public String getDescription()
   {
      return description;
   }
   
   public Set<IAnnotationMetaData> getAnnotations()
   {
      return annotations;
   }

   protected TypeInfo applyCollectionOrMapCheck(TypeInfo typeInfo) throws Throwable
   {
      // cannot determine on map, since we don't know if we are key or value
      if (typeInfo instanceof ClassInfo)
      {
         ClassInfo classInfo = (ClassInfo)typeInfo;
         TypeInfo componentType = classInfo.getComponentType();
         if (componentType != null)
            return componentType;
      }
      if (typeInfo.isCollection() || typeInfo.isMap())
      {
         throw new IllegalArgumentException("Should not be here - set element/value class type in collection/map: " + this);
      }
      return typeInfo;
   }

   public void toString(JBossStringBuilder buffer)
   {
      if (description != null)
         buffer.append("description=").append(description);
      if (annotations != null)
         buffer.append(" annotations=").append(annotations);
   }
   
   public void toShortString(JBossStringBuilder buffer)
   {
      buffer.append(description);
   }

}
