/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tuckey.web.filters.urlrewrite.RunConfig;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class Run {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$Run == null ? (class$org$tuckey$web$filters$urlrewrite$Run = Run.class$("org.tuckey.web.filters.urlrewrite.Run")) : class$org$tuckey$web$filters$urlrewrite$Run);
    private boolean newEachTime = false;
    private String classStr;
    private static final String DEAULT_METHOD_STR = "run";
    private String methodStr = "run";
    private int id = 0;
    private String error = null;
    private boolean valid = false;
    private boolean initialised = false;
    private Object runClassInstance;
    private Constructor runConstructor;
    private Method initMethod;
    private Method runMethod;
    private Method destroyMethod;
    private RunConfig runServletConfig;
    private Hashtable initParams = new Hashtable();
    private static Class[] runMethodParameterTypesHttp = new Class[2];
    private static Class[] runMethodParameterTypes;
    private static boolean checkRunObjectExists;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$Run;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$javax$servlet$ServletRequest;
    static /* synthetic */ Class class$javax$servlet$ServletResponse;
    static /* synthetic */ Class class$javax$servlet$ServletConfig;

    public boolean initialise(ServletContext context) {
        log.debug("initialising run");
        this.runServletConfig = new RunConfig(context, this.initParams);
        this.initialised = true;
        this.valid = false;
        if (StringUtils.isBlank(this.classStr)) {
            this.setError("cannot initialise run " + this.id + " value is empty");
            return this.valid;
        }
        if (this.methodStr == null) {
            this.methodStr = DEAULT_METHOD_STR;
        }
        if (checkRunObjectExists) {
            this.prepareRunObject();
        } else {
            this.valid = true;
        }
        return this.valid;
    }

    private void prepareRunObject() {
        Class<?> runClass;
        if (log.isDebugEnabled()) {
            log.debug("looking for class " + this.classStr);
        }
        try {
            runClass = Class.forName(this.classStr);
            if (runClass == null) {
                this.setError("had trouble finding " + this.classStr + " after Class.forName got a null object");
                return;
            }
        }
        catch (ClassNotFoundException e) {
            this.setError("could not find " + this.classStr + " got a " + e.toString(), e);
            return;
        }
        catch (NoClassDefFoundError e) {
            this.setError("could not find " + this.classStr + " got a " + e.toString(), e);
            return;
        }
        try {
            this.runConstructor = runClass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            this.setError("could not get constructor for " + this.classStr, e);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("looking for " + this.methodStr + "(ServletRequest, ServletResponse)");
        }
        try {
            this.runMethod = runClass.getMethod(this.methodStr, runMethodParameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (log.isDebugEnabled()) {
                log.debug("looking for " + this.methodStr + "(HttpServletRequest, HttpServletResponse)");
            }
            try {
                this.runMethod = runClass.getMethod(this.methodStr, runMethodParameterTypesHttp);
            }
            catch (NoSuchMethodException e2) {
                this.setError("could not find " + this.methodStr + "(ServletRequest, ServletResponse) on " + this.classStr, e);
                this.setError("or " + this.methodStr + "(HttpServletRequest, HttpServletResponse) on " + this.classStr, e);
                return;
            }
        }
        Method[] methods = runClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if ("destroy".equals(method.getName()) && method.getParameterTypes().length == 0) {
                log.debug("found destroy methodStr");
                this.destroyMethod = method;
            }
            if ("init".equals(method.getName()) && method.getParameterTypes().length == 1 && (class$javax$servlet$ServletConfig == null ? Run.class$("javax.servlet.ServletConfig") : class$javax$servlet$ServletConfig).getName().equals(method.getParameterTypes()[0].getName())) {
                log.debug("found init methodStr");
                this.initMethod = method;
            }
            if (this.initMethod != null && this.destroyMethod != null) break;
        }
        if (!this.newEachTime) {
            this.runClassInstance = this.fetchNewInstance();
        }
        this.valid = true;
    }

    private void invokeDestroy(Object runClassInstanceToDestroy) {
        if (runClassInstanceToDestroy != null && this.destroyMethod != null) {
            if (log.isDebugEnabled()) {
                log.debug("running " + this.classStr + ".destroy()");
            }
            try {
                this.destroyMethod.invoke(runClassInstanceToDestroy, null);
            }
            catch (IllegalAccessException e) {
                this.logInvokeException("destroy()", e);
            }
            catch (InvocationTargetException e) {
                this.logInvokeException("destroy()", e);
            }
        }
    }

    private void invokeRunMethod(Object classInstanceToRun, Object[] args) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("running " + this.classStr + "." + this.methodStr + "(HttpServletRequest, HttpServletResponse)");
        }
        if (classInstanceToRun == null || this.runMethod == null) {
            return;
        }
        try {
            this.runMethod.invoke(classInstanceToRun, args);
        }
        catch (IllegalAccessException e) {
            if (log.isDebugEnabled()) {
                log.debug(e);
            }
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable originalThrowable;
            if (log.isDebugEnabled()) {
                log.debug(e);
            }
            if ((originalThrowable = e.getTargetException()) == null) {
                throw new ServletException((Throwable)e);
            }
            if (originalThrowable instanceof RuntimeException) {
                throw (RuntimeException)originalThrowable;
            }
            if (originalThrowable instanceof ServletException) {
                throw (ServletException)originalThrowable;
            }
            if (originalThrowable instanceof IOException) {
                throw (IOException)originalThrowable;
            }
            throw new ServletException(originalThrowable);
        }
    }

    public void destroy() {
        this.initialised = false;
        this.valid = false;
        this.invokeDestroy(this.runClassInstance);
        this.destroyMethod = null;
        this.runMethod = null;
        this.initMethod = null;
        this.runServletConfig = null;
        this.runConstructor = null;
        this.runClassInstance = null;
        this.methodStr = null;
        this.classStr = null;
        this.error = null;
    }

    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (!this.initialised) {
            log.debug("not initialised skipping");
            return;
        }
        if (!this.valid) {
            log.debug("not valid skipping");
            return;
        }
        Object[] args = new Object[]{httpServletRequest, httpServletResponse};
        if (this.newEachTime) {
            Object newRunClassInstance = this.fetchNewInstance();
            this.invokeRunMethod(newRunClassInstance, args);
            this.invokeDestroy(newRunClassInstance);
        } else {
            this.invokeRunMethod(this.runClassInstance, args);
        }
    }

    private void logInvokeException(String methodStr, Exception e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            this.setError("when invoking " + methodStr + " on " + this.classStr + " got an " + e.toString(), e);
        } else {
            this.setError("when invoking " + methodStr + " on " + this.classStr + " got an " + e.toString() + " caused by " + cause.toString(), cause);
        }
    }

    private Object fetchNewInstance() {
        Object obj;
        log.debug("getting new instance of " + this.classStr);
        try {
            obj = this.runConstructor.newInstance(null);
        }
        catch (InstantiationException e) {
            this.logInvokeException("constructor", e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.logInvokeException("constructor", e);
            return null;
        }
        catch (InvocationTargetException e) {
            this.logInvokeException("constructor", e);
            return null;
        }
        if (this.initMethod != null) {
            log.debug("about to run init(ServletConfig) on " + this.classStr);
            Object[] args = new Object[]{this.runServletConfig};
            try {
                this.initMethod.invoke(obj, args);
            }
            catch (IllegalAccessException e) {
                this.logInvokeException("init(ServletConfig)", e);
                return null;
            }
            catch (InvocationTargetException e) {
                this.logInvokeException("init(ServletConfig)", e);
                return null;
            }
        }
        return obj;
    }

    public String getError() {
        return this.error;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public String getClassStr() {
        return this.classStr;
    }

    public String getMethodStr() {
        return this.methodStr;
    }

    public boolean isNewEachTime() {
        return this.newEachTime;
    }

    public void setNewEachTime(boolean newEachTime) {
        this.newEachTime = newEachTime;
    }

    public Object getRunClassInstance() {
        return this.runClassInstance;
    }

    public void addInitParam(String name, String value) {
        if (name != null) {
            this.initParams.put(name, value);
        }
    }

    public String getInitParam(String paramName) {
        return (String)this.initParams.get(paramName);
    }

    public void setClassStr(String classStr) {
        this.classStr = classStr;
    }

    public void setMethodStr(String methodStr) {
        this.methodStr = methodStr;
    }

    public static void setCheckRunObjectExists(boolean checkRunObjectExists) {
        Run.checkRunObjectExists = checkRunObjectExists;
    }

    public void setError(String error, Throwable t) {
        this.error = error;
        log.error(error, t);
    }

    public void setError(String error) {
        this.error = error;
        log.error(error);
    }

    public String getDisplayName() {
        return "Run " + this.id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Run.runMethodParameterTypesHttp[0] = class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = Run.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest;
        Run.runMethodParameterTypesHttp[1] = class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = Run.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse;
        runMethodParameterTypes = new Class[2];
        Run.runMethodParameterTypes[0] = class$javax$servlet$ServletRequest == null ? (class$javax$servlet$ServletRequest = Run.class$("javax.servlet.ServletRequest")) : class$javax$servlet$ServletRequest;
        Run.runMethodParameterTypes[1] = class$javax$servlet$ServletResponse == null ? (class$javax$servlet$ServletResponse = Run.class$("javax.servlet.ServletResponse")) : class$javax$servlet$ServletResponse;
        checkRunObjectExists = true;
    }

    public static class SimpleInvocationHandler
    implements InvocationHandler {
        private Object theWrappedPojo;

        SimpleInvocationHandler(Object pojo) {
            this.theWrappedPojo = pojo;
        }

        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            try {
                return m.invoke(this.theWrappedPojo, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

