// Geometric Tools, LLC
// Copyright (c) 1998-2014
// Distributed under the Boost Software License, Version 1.0.
// http://www.boost.org/LICENSE_1_0.txt
// http://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
//
// File Version: 5.14.1 (2017/05/26)

#include <fstream>
#include "TemplateVC120.h"

//----------------------------------------------------------------------------
void TemplateVC120::GenerateDx9 (const char* projectName)
{
    char prefix[128];
    sprintf_s(prefix, 128, "%sDx9_VC120", projectName);
    Generate(projectName, prefix, msDx9ProjectLines);
}
//----------------------------------------------------------------------------
void TemplateVC120::GenerateWgl (const char* projectName)
{
    char prefix[128];
    sprintf_s(prefix, 128, "%sWgl_VC120", projectName);
    Generate(projectName, prefix, msWglProjectLines);
}
//----------------------------------------------------------------------------
void TemplateVC120::Generate (const char* projectName, const char* prefix,
    char* projectLines[])
{
    char projectFile[128];
    char currentLine[512];

    // Create the project file.
    sprintf_s(projectFile, 128, "%s.vcxproj", prefix);
    std::ofstream outFile(projectFile);
    if (!outFile)
    {
        return;
    }

    for (int line = 0; line < NUM_PROJECT_LINES; ++line)
    {
        strcpy_s(currentLine, 512, projectLines[line]);

        char* sub;
        int index, i;

        sub = strstr(currentLine, "PROJECTNAME");
        if (sub)
        {
            index = (int)(sub - currentLine);
            for (i = 0; i < index; ++i)
            {
                outFile << currentLine[i];
            }

            outFile << projectName;
            sub += strlen("PROJECTNAME");
            outFile << sub << std::endl;
            continue;
        }

        outFile << currentLine << std::endl;
    }

    outFile.close();

    // Create the filter file.
    sprintf_s(projectFile, 128, "%s.vcxproj.filters", prefix);
    outFile.open(projectFile);
    if (!outFile)
    {
        return;
    }

    for (int line = 0; line < NUM_FILTER_LINES; ++line)
    {
        strcpy_s(currentLine, 512, msFilterLines[line]);

        char* sub;
        int index, i;

        sub = strstr(currentLine, "PROJECTNAME");
        if (sub)
        {
            index = (int)(sub - currentLine);
            for (i = 0; i < index; ++i)
            {
                outFile << currentLine[i];
            }

            outFile << projectName;
            sub += strlen("PROJECTNAME");
            outFile << sub << std::endl;
            continue;
        }

        outFile << currentLine << std::endl;
    }

    outFile.close();
}
//----------------------------------------------------------------------------
char* TemplateVC120::msDx9ProjectLines[NUM_PROJECT_LINES] =
{
"﻿<?xml version=\"1.0\" encoding=\"utf-8\"?>",
"<Project DefaultTargets=\"Build\" ToolsVersion=\"12.0\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">",
"  <ItemGroup Label=\"ProjectConfigurations\">",
"    <ProjectConfiguration Include=\"DebugDLL|Win32\">",
"      <Configuration>DebugDLL</Configuration>",
"      <Platform>Win32</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"DebugDLL|x64\">",
"      <Configuration>DebugDLL</Configuration>",
"      <Platform>x64</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"Debug|Win32\">",
"      <Configuration>Debug</Configuration>",
"      <Platform>Win32</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"Debug|x64\">",
"      <Configuration>Debug</Configuration>",
"      <Platform>x64</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"ReleaseDLL|Win32\">",
"      <Configuration>ReleaseDLL</Configuration>",
"      <Platform>Win32</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"ReleaseDLL|x64\">",
"      <Configuration>ReleaseDLL</Configuration>",
"      <Platform>x64</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"Release|Win32\">",
"      <Configuration>Release</Configuration>",
"      <Platform>Win32</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"Release|x64\">",
"      <Configuration>Release</Configuration>",
"      <Platform>x64</Platform>",
"    </ProjectConfiguration>",
"  </ItemGroup>",
"  <PropertyGroup Label=\"Globals\">",
"    <ProjectName>PROJECTNAME</ProjectName>",
"    <ProjectGuid>{}</ProjectGuid>",
"    <RootNamespace>PROJECTNAME</RootNamespace>",
"    <Keyword>Win32Proj</Keyword>",
"  </PropertyGroup>",
"  <Import Project=\"$(VCTargetsPath)\\Microsoft.Cpp.Default.props\" />",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <WholeProgramOptimization>true</WholeProgramOptimization>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <WholeProgramOptimization>true</WholeProgramOptimization>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <WholeProgramOptimization>true</WholeProgramOptimization>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <WholeProgramOptimization>true</WholeProgramOptimization>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <Import Project=\"$(VCTargetsPath)\\Microsoft.Cpp.props\" />",
"  <ImportGroup Label=\"ExtensionSettings\">",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <PropertyGroup Label=\"UserMacros\" />",
"  <PropertyGroup>",
"    <_ProjectFileVersion>10.0.30319.1</_ProjectFileVersion>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</OutDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</IntDir>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\">true</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\">true</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\">true</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\">true</LinkIncremental>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</OutDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Dx9$(Configuration)\\</IntDir>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\">false</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\">false</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\">false</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\">false</LinkIncremental>",
"  </PropertyGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\">",
"    <ClCompile>",
"      <Optimization>Disabled</Optimization>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;$(DXSDK_DIR)\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;_DEBUG;_CONSOLE;WM5_USE_DX9;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <MinimalRebuild>true</MinimalRebuild>",
"      <BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>",
"      <RuntimeLibrary>MultiThreadedDebugDLL</RuntimeLibrary>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5CoreD.lib;Wm5MathematicsD.lib;Wm5ImagicsD.lib;Wm5PhysicsD.lib;Wm5Dx9GraphicsD.lib;Wm5Dx9ApplicationsD.lib;d3d9.lib;d3dx9.lib;dxerr.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration);$(DXSDK_DIR)\\Lib\\x86</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"      <TargetMachine>MachineX86</TargetMachine>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\">",
"    <ClCompile>",
"      <Optimization>Disabled</Optimization>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;$(DXSDK_DIR)\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;_DEBUG;_CONSOLE;WM5_USE_DX9;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>",
"      <RuntimeLibrary>MultiThreadedDebugDLL</RuntimeLibrary>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5CoreD.lib;Wm5MathematicsD.lib;Wm5ImagicsD.lib;Wm5PhysicsD.lib;Wm5Dx9GraphicsD.lib;Wm5Dx9ApplicationsD.lib;d3d9.lib;d3dx9.lib;dxerr.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration);$(DXSDK_DIR)\\Lib\\x64</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\">",
"    <ClCompile>",
"      <Optimization>Disabled</Optimization>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;$(DXSDK_DIR)\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;_DEBUG;_CONSOLE;WM5_CORE_DLL_IMPORT;WM5_MATHEMATICS_DLL_IMPORT;WM5_IMAGICS_DLL_IMPORT;WM5_PHYSICS_DLL_IMPORT;WM5_GRAPHICS_DLL_IMPORT;WM5_USE_DX9;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <MinimalRebuild>true</MinimalRebuild>",
"      <BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>",
"      <RuntimeLibrary>MultiThreadedDebugDLL</RuntimeLibrary>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5CoreD.lib;Wm5MathematicsD.lib;Wm5ImagicsD.lib;Wm5PhysicsD.lib;Wm5Dx9GraphicsD.lib;Wm5Dx9ApplicationsD.lib;d3d9.lib;d3dx9.lib;dxerr.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration);$(DXSDK_DIR)\\Lib\\x86</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"      <TargetMachine>MachineX86</TargetMachine>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\">",
"    <ClCompile>",
"      <Optimization>Disabled</Optimization>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;$(DXSDK_DIR)\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;_DEBUG;_CONSOLE;WM5_CORE_DLL_IMPORT;WM5_MATHEMATICS_DLL_IMPORT;WM5_IMAGICS_DLL_IMPORT;WM5_PHYSICS_DLL_IMPORT;WM5_GRAPHICS_DLL_IMPORT;WM5_USE_DX9;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>",
"      <RuntimeLibrary>MultiThreadedDebugDLL</RuntimeLibrary>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5CoreD.lib;Wm5MathematicsD.lib;Wm5ImagicsD.lib;Wm5PhysicsD.lib;Wm5Dx9GraphicsD.lib;Wm5Dx9ApplicationsD.lib;d3d9.lib;d3dx9.lib;dxerr.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration);$(DXSDK_DIR)\\Lib\\x64</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\">",
"    <ClCompile>",
"      <Optimization>MaxSpeed</Optimization>",
"      <IntrinsicFunctions>true</IntrinsicFunctions>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;$(DXSDK_DIR)\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;NDEBUG;_CONSOLE;WM5_USE_DX9;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <RuntimeLibrary>MultiThreadedDLL</RuntimeLibrary>",
"      <FunctionLevelLinking>true</FunctionLevelLinking>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5Core.lib;Wm5Mathematics.lib;Wm5Imagics.lib;Wm5Physics.lib;Wm5Dx9Graphics.lib;Wm5Dx9Applications.lib;d3d9.lib;d3dx9.lib;dxerr.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration);$(DXSDK_DIR)\\Lib\\x86</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <OptimizeReferences>true</OptimizeReferences>",
"      <EnableCOMDATFolding>true</EnableCOMDATFolding>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"      <TargetMachine>MachineX86</TargetMachine>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\">",
"    <ClCompile>",
"      <Optimization>MaxSpeed</Optimization>",
"      <IntrinsicFunctions>true</IntrinsicFunctions>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;$(DXSDK_DIR)\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;NDEBUG;_CONSOLE;WM5_USE_DX9;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <RuntimeLibrary>MultiThreadedDLL</RuntimeLibrary>",
"      <FunctionLevelLinking>true</FunctionLevelLinking>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5Core.lib;Wm5Mathematics.lib;Wm5Imagics.lib;Wm5Physics.lib;Wm5Dx9Graphics.lib;Wm5Dx9Applications.lib;d3d9.lib;d3dx9.lib;dxerr.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration);$(DXSDK_DIR)\\Lib\\x64</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <OptimizeReferences>true</OptimizeReferences>",
"      <EnableCOMDATFolding>true</EnableCOMDATFolding>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\">",
"    <ClCompile>",
"      <Optimization>MaxSpeed</Optimization>",
"      <IntrinsicFunctions>true</IntrinsicFunctions>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;$(DXSDK_DIR)\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;NDEBUG;_CONSOLE;WM5_CORE_DLL_IMPORT;WM5_MATHEMATICS_DLL_IMPORT;WM5_IMAGICS_DLL_IMPORT;WM5_PHYSICS_DLL_IMPORT;WM5_GRAPHICS_DLL_IMPORT;WM5_USE_DX9;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <RuntimeLibrary>MultiThreadedDLL</RuntimeLibrary>",
"      <FunctionLevelLinking>true</FunctionLevelLinking>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5Core.lib;Wm5Mathematics.lib;Wm5Imagics.lib;Wm5Physics.lib;Wm5Dx9Graphics.lib;Wm5Dx9Applications.lib;d3d9.lib;d3dx9.lib;dxerr.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration);$(DXSDK_DIR)\\Lib\\x86</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <OptimizeReferences>true</OptimizeReferences>",
"      <EnableCOMDATFolding>true</EnableCOMDATFolding>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"      <TargetMachine>MachineX86</TargetMachine>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\">",
"    <ClCompile>",
"      <Optimization>MaxSpeed</Optimization>",
"      <IntrinsicFunctions>true</IntrinsicFunctions>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;$(DXSDK_DIR)\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;NDEBUG;_CONSOLE;WM5_CORE_DLL_IMPORT;WM5_MATHEMATICS_DLL_IMPORT;WM5_IMAGICS_DLL_IMPORT;WM5_PHYSICS_DLL_IMPORT;WM5_GRAPHICS_DLL_IMPORT;WM5_USE_DX9;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <RuntimeLibrary>MultiThreadedDLL</RuntimeLibrary>",
"      <FunctionLevelLinking>true</FunctionLevelLinking>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5Core.lib;Wm5Mathematics.lib;Wm5Imagics.lib;Wm5Physics.lib;Wm5Dx9Graphics.lib;Wm5Dx9Applications.lib;d3d9.lib;d3dx9.lib;dxerr.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration);$(DXSDK_DIR)\\Lib\\x64</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <OptimizeReferences>true</OptimizeReferences>",
"      <EnableCOMDATFolding>true</EnableCOMDATFolding>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemGroup>",
"    <ClCompile Include=\"PROJECTNAME.cpp\" />",
"  </ItemGroup>",
"  <ItemGroup>",
"    <ClInclude Include=\"PROJECTNAME.h\" />",
"  </ItemGroup>",
"  <ItemGroup>",
"    <ProjectReference Include = \"..\\..\\LibApplications\\LibDx9Applications_VC120.vcxproj\">",
"    <Project>{d070aff0-e688-4e38-9c89-ab016371b618}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibCore\\LibCore_VC120.vcxproj\">",
"    <Project>{4915b5b4-800b-40e2-a46b-703f8f38e066}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibGraphics\\LibDx9Graphics_VC120.vcxproj\">",
"    <Project>{63500b2e-1745-47a8-a4cc-ef1ab127c8a3}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibImagics\\LibImagics_VC120.vcxproj\">",
"    <Project>{280ab789-07ff-49fd-9fdd-4459ac601d24}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibMathematics\\LibMathematics_VC120.vcxproj\">",
"    <Project>{d7b74341-c2e2-470b-a375-3e97ceca3457}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibPhysics\\LibPhysics_VC120.vcxproj\">",
"    <Project>{31c32484-5292-4bd4-a89a-4fb089bb047f}</Project>",
"    </ProjectReference>",
"  </ItemGroup>",
"  <Import Project=\"$(VCTargetsPath)\\Microsoft.Cpp.targets\" />",
"  <ImportGroup Label=\"ExtensionTargets\">",
"  </ImportGroup>",
"</Project>"
};
//----------------------------------------------------------------------------
char* TemplateVC120::msWglProjectLines[NUM_PROJECT_LINES] =
{
"﻿<?xml version=\"1.0\" encoding=\"utf-8\"?>",
"<Project DefaultTargets=\"Build\" ToolsVersion=\"12.0\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">",
"  <ItemGroup Label=\"ProjectConfigurations\">",
"    <ProjectConfiguration Include=\"DebugDLL|Win32\">",
"      <Configuration>DebugDLL</Configuration>",
"      <Platform>Win32</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"DebugDLL|x64\">",
"      <Configuration>DebugDLL</Configuration>",
"      <Platform>x64</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"Debug|Win32\">",
"      <Configuration>Debug</Configuration>",
"      <Platform>Win32</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"Debug|x64\">",
"      <Configuration>Debug</Configuration>",
"      <Platform>x64</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"ReleaseDLL|Win32\">",
"      <Configuration>ReleaseDLL</Configuration>",
"      <Platform>Win32</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"ReleaseDLL|x64\">",
"      <Configuration>ReleaseDLL</Configuration>",
"      <Platform>x64</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"Release|Win32\">",
"      <Configuration>Release</Configuration>",
"      <Platform>Win32</Platform>",
"    </ProjectConfiguration>",
"    <ProjectConfiguration Include=\"Release|x64\">",
"      <Configuration>Release</Configuration>",
"      <Platform>x64</Platform>",
"    </ProjectConfiguration>",
"  </ItemGroup>",
"  <PropertyGroup Label=\"Globals\">",
"    <ProjectName>PROJECTNAME</ProjectName>",
"    <ProjectGuid>{}</ProjectGuid>",
"    <RootNamespace>PROJECTNAME</RootNamespace>",
"    <Keyword>Win32Proj</Keyword>",
"  </PropertyGroup>",
"  <Import Project=\"$(VCTargetsPath)\\Microsoft.Cpp.Default.props\" />",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <WholeProgramOptimization>true</WholeProgramOptimization>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <WholeProgramOptimization>true</WholeProgramOptimization>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <WholeProgramOptimization>true</WholeProgramOptimization>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <WholeProgramOptimization>true</WholeProgramOptimization>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <PropertyGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\" Label=\"Configuration\">",
"    <ConfigurationType>Application</ConfigurationType>",
"    <CharacterSet>NotSet</CharacterSet>",
"    <PlatformToolset>v120</PlatformToolset>",
"  </PropertyGroup>",
"  <Import Project=\"$(VCTargetsPath)\\Microsoft.Cpp.props\" />",
"  <ImportGroup Label=\"ExtensionSettings\">",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <ImportGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\" Label=\"PropertySheets\">",
"    <Import Project=\"$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists('$(UserRootDir)\\Microsoft.Cpp.$(Platform).user.props')\" Label=\"LocalAppDataPlatform\" />",
"  </ImportGroup>",
"  <PropertyGroup Label=\"UserMacros\" />",
"  <PropertyGroup>",
"    <_ProjectFileVersion>10.0.30319.1</_ProjectFileVersion>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</OutDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</IntDir>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\">true</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\">true</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\">true</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\">true</LinkIncremental>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</OutDir>",
"    <OutDir Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</OutDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</IntDir>",
"    <IntDir Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\">_Output\\$(PlatformToolset)\\$(Platform)\\Wgl$(Configuration)\\</IntDir>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\">false</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\">false</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\">false</LinkIncremental>",
"    <LinkIncremental Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\">false</LinkIncremental>",
"  </PropertyGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|Win32'\">",
"    <ClCompile>",
"      <Optimization>Disabled</Optimization>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;_DEBUG;_CONSOLE;WM5_USE_OPENGL;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <MinimalRebuild>true</MinimalRebuild>",
"      <BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>",
"      <RuntimeLibrary>MultiThreadedDebugDLL</RuntimeLibrary>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5CoreD.lib;Wm5MathematicsD.lib;Wm5ImagicsD.lib;Wm5PhysicsD.lib;Wm5WglGraphicsD.lib;Wm5WglApplicationsD.lib;opengl32.lib;glu32.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration)</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"      <TargetMachine>MachineX86</TargetMachine>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='Debug|x64'\">",
"    <ClCompile>",
"      <Optimization>Disabled</Optimization>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;_DEBUG;_CONSOLE;WM5_USE_OPENGL;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>",
"      <RuntimeLibrary>MultiThreadedDebugDLL</RuntimeLibrary>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5CoreD.lib;Wm5MathematicsD.lib;Wm5ImagicsD.lib;Wm5PhysicsD.lib;Wm5WglGraphicsD.lib;Wm5WglApplicationsD.lib;opengl32.lib;glu32.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration)</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|Win32'\">",
"    <ClCompile>",
"      <Optimization>Disabled</Optimization>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;_DEBUG;_CONSOLE;WM5_CORE_DLL_IMPORT;WM5_MATHEMATICS_DLL_IMPORT;WM5_IMAGICS_DLL_IMPORT;WM5_PHYSICS_DLL_IMPORT;WM5_GRAPHICS_DLL_IMPORT;WM5_USE_OPENGL;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <MinimalRebuild>true</MinimalRebuild>",
"      <BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>",
"      <RuntimeLibrary>MultiThreadedDebugDLL</RuntimeLibrary>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5CoreD.lib;Wm5MathematicsD.lib;Wm5ImagicsD.lib;Wm5PhysicsD.lib;Wm5WglGraphicsD.lib;Wm5WglApplicationsD.lib;opengl32.lib;glu32.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration)</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"      <TargetMachine>MachineX86</TargetMachine>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='DebugDLL|x64'\">",
"    <ClCompile>",
"      <Optimization>Disabled</Optimization>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;_DEBUG;_CONSOLE;WM5_CORE_DLL_IMPORT;WM5_MATHEMATICS_DLL_IMPORT;WM5_IMAGICS_DLL_IMPORT;WM5_PHYSICS_DLL_IMPORT;WM5_GRAPHICS_DLL_IMPORT;WM5_USE_OPENGL;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>",
"      <RuntimeLibrary>MultiThreadedDebugDLL</RuntimeLibrary>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5CoreD.lib;Wm5MathematicsD.lib;Wm5ImagicsD.lib;Wm5PhysicsD.lib;Wm5WglGraphicsD.lib;Wm5WglApplicationsD.lib;opengl32.lib;glu32.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration)</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|Win32'\">",
"    <ClCompile>",
"      <Optimization>MaxSpeed</Optimization>",
"      <IntrinsicFunctions>true</IntrinsicFunctions>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;NDEBUG;_CONSOLE;WM5_USE_OPENGL;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <RuntimeLibrary>MultiThreadedDLL</RuntimeLibrary>",
"      <FunctionLevelLinking>true</FunctionLevelLinking>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5Core.lib;Wm5Mathematics.lib;Wm5Imagics.lib;Wm5Physics.lib;Wm5WglGraphics.lib;Wm5WglApplications.lib;opengl32.lib;glu32.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration)</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <OptimizeReferences>true</OptimizeReferences>",
"      <EnableCOMDATFolding>true</EnableCOMDATFolding>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"      <TargetMachine>MachineX86</TargetMachine>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='Release|x64'\">",
"    <ClCompile>",
"      <Optimization>MaxSpeed</Optimization>",
"      <IntrinsicFunctions>true</IntrinsicFunctions>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;NDEBUG;_CONSOLE;WM5_USE_OPENGL;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <RuntimeLibrary>MultiThreadedDLL</RuntimeLibrary>",
"      <FunctionLevelLinking>true</FunctionLevelLinking>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5Core.lib;Wm5Mathematics.lib;Wm5Imagics.lib;Wm5Physics.lib;Wm5WglGraphics.lib;Wm5WglApplications.lib;opengl32.lib;glu32.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration)</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <OptimizeReferences>true</OptimizeReferences>",
"      <EnableCOMDATFolding>true</EnableCOMDATFolding>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|Win32'\">",
"    <ClCompile>",
"      <Optimization>MaxSpeed</Optimization>",
"      <IntrinsicFunctions>true</IntrinsicFunctions>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;NDEBUG;_CONSOLE;WM5_CORE_DLL_IMPORT;WM5_MATHEMATICS_DLL_IMPORT;WM5_IMAGICS_DLL_IMPORT;WM5_PHYSICS_DLL_IMPORT;WM5_GRAPHICS_DLL_IMPORT;WM5_USE_OPENGL;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <RuntimeLibrary>MultiThreadedDLL</RuntimeLibrary>",
"      <FunctionLevelLinking>true</FunctionLevelLinking>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5Core.lib;Wm5Mathematics.lib;Wm5Imagics.lib;Wm5Physics.lib;Wm5WglGraphics.lib;Wm5WglApplications.lib;opengl32.lib;glu32.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration)</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <OptimizeReferences>true</OptimizeReferences>",
"      <EnableCOMDATFolding>true</EnableCOMDATFolding>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"      <TargetMachine>MachineX86</TargetMachine>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemDefinitionGroup Condition=\"'$(Configuration)|$(Platform)'=='ReleaseDLL|x64'\">",
"    <ClCompile>",
"      <Optimization>MaxSpeed</Optimization>",
"      <IntrinsicFunctions>true</IntrinsicFunctions>",
"      <AdditionalIncludeDirectories>..\\..\\SDK\\Include;%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>",
"      <PreprocessorDefinitions>WIN32;NDEBUG;_CONSOLE;WM5_CORE_DLL_IMPORT;WM5_MATHEMATICS_DLL_IMPORT;WM5_IMAGICS_DLL_IMPORT;WM5_PHYSICS_DLL_IMPORT;WM5_GRAPHICS_DLL_IMPORT;WM5_USE_OPENGL;%(PreprocessorDefinitions)</PreprocessorDefinitions>",
"      <RuntimeLibrary>MultiThreadedDLL</RuntimeLibrary>",
"      <FunctionLevelLinking>true</FunctionLevelLinking>",
"      <PrecompiledHeader>",
"      </PrecompiledHeader>",
"      <WarningLevel>Level4</WarningLevel>",
"      <DebugInformationFormat>ProgramDatabase</DebugInformationFormat>",
"      <ProgramDataBaseFileName>$(IntDir)$(TargetName).pdb</ProgramDataBaseFileName>",
"      <TreatWarningAsError>true</TreatWarningAsError>",
"    </ClCompile>",
"    <Link>",
"      <AdditionalDependencies>Wm5Core.lib;Wm5Mathematics.lib;Wm5Imagics.lib;Wm5Physics.lib;Wm5WglGraphics.lib;Wm5WglApplications.lib;opengl32.lib;glu32.lib;%(AdditionalDependencies)</AdditionalDependencies>",
"      <AdditionalLibraryDirectories>..\\..\\SDK\\Library\\$(PlatformToolset)\\$(Platform)\\$(Configuration)</AdditionalLibraryDirectories>",
"      <GenerateDebugInformation>true</GenerateDebugInformation>",
"      <SubSystem>Windows</SubSystem>",
"      <OptimizeReferences>true</OptimizeReferences>",
"      <EnableCOMDATFolding>true</EnableCOMDATFolding>",
"      <EntryPointSymbol>mainCRTStartup</EntryPointSymbol>",
"    </Link>",
"  </ItemDefinitionGroup>",
"  <ItemGroup>",
"    <ClCompile Include=\"PROJECTNAME.cpp\" />",
"  </ItemGroup>",
"  <ItemGroup>",
"    <ClInclude Include=\"PROJECTNAME.h\" />",
"  </ItemGroup>",
"  <ItemGroup>",
"    <ProjectReference Include = \"..\\..\\LibApplications\\LibWglApplications_VC120.vcxproj\">",
"    <Project>{c6e70fee-edef-47ca-ba86-cbe4698b387f}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibCore\\LibCore_VC120.vcxproj\">",
"    <Project>{4915b5b4-800b-40e2-a46b-703f8f38e066}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibGraphics\\LibWglGraphics_VC120.vcxproj\">",
"    <Project>{d710fed2-d476-487d-b22f-63ff60737f7b}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibImagics\\LibImagics_VC120.vcxproj\">",
"    <Project>{280ab789-07ff-49fd-9fdd-4459ac601d24}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibMathematics\\LibMathematics_VC120.vcxproj\">",
"    <Project>{d7b74341-c2e2-470b-a375-3e97ceca3457}</Project>",
"    </ProjectReference>",
"    <ProjectReference Include = \"..\\..\\LibPhysics\\LibPhysics_VC120.vcxproj\">",
"    <Project>{e78b9daf-8937-4c0d-8c49-9c01ebfcf529}</Project>",
"    </ProjectReference>",
"    </ItemGroup>",
"  <Import Project=\"$(VCTargetsPath)\\Microsoft.Cpp.targets\" />",
"  <ImportGroup Label=\"ExtensionTargets\">",
"  </ImportGroup>",
"</Project>"
};
//----------------------------------------------------------------------------
char* TemplateVC120::msFilterLines[NUM_FILTER_LINES] =
{
"﻿<?xml version=\"1.0\" encoding=\"utf-8\"?>",
"<Project ToolsVersion=\"4.0\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">",
"  <ItemGroup>",
"    <Filter Include=\"Source Files\">",
"      <UniqueIdentifier>{4FC737F1-C7A5-4376-A066-2A32D752A2FF}</UniqueIdentifier>",
"      <Extensions>cpp;c;cc;cxx;def;odl;idl;hpj;bat;asm;asmx</Extensions>",
"    </Filter>",
"    <Filter Include=\"Header Files\">",
"      <UniqueIdentifier>{93995380-89BD-4b04-88EB-625FBE52EBFB}</UniqueIdentifier>",
"      <Extensions>h;hpp;hxx;hm;inl;inc;xsd</Extensions>",
"    </Filter>",
"  </ItemGroup>",
"  <ItemGroup>",
"    <ClCompile Include=\"PROJECTNAME.cpp\">",
"      <Filter>Source Files</Filter>",
"    </ClCompile>",
"  </ItemGroup>",
"  <ItemGroup>",
"    <ClInclude Include=\"PROJECTNAME.h\">",
"      <Filter>Header Files</Filter>",
"    </ClInclude>",
"  </ItemGroup>",
"</Project>"
};
//----------------------------------------------------------------------------
