// Author(s): Rimco Boudewijns
// Copyright: see the accompanying file COPYING or copy at
// https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//

#include <QDesktopServices>
#include <QUrl>
#include <QFileSystemModel>
#include <QContextMenuEvent>
#include <QFileInfo>

#include "toolcatalog.h"
#include "toolaction.h"
#include "toolinformation.h"

#include "copydialog.h"
#include "copythread.h"

#ifndef FILEBROWSER_H
#define FILEBROWSER_H

#include <QTreeView>

class FileBrowser : public QTreeView
{
    Q_OBJECT
  public:
    explicit FileBrowser(QWidget *parent = 0);
    void setCatalog(ToolCatalog catalog) { m_catalog = catalog; }

  public slots:
    void onToolSelected();
    void onRemoveRequested(QString filename = QString());

    void onNewFile();
    void onNewFolder();
    void onOpenFile();
    void onDeleteFile();

  signals:
    void openToolInstance(QString filename, ToolInformation tool);
    void openProperties(QString filename);

  protected:
    void contextMenuEvent(QContextMenuEvent *event);
    void mouseDoubleClickEvent(QMouseEvent *event);
    void keyPressEvent(QKeyEvent *event);

  private:
    QAction* addConditionalAction(QMenu* menu, QString action, bool condition);
    void createContextMenu(QList<QFileInfo> info);
    void copyDirectory(QString oldPath, QString newPath, bool move = false);
    bool askRemove(QModelIndexList files);
    bool askRemove(QString filename, bool copy = false);


    QFileSystemModel m_model;
    QMenu *m_context;
    ToolCatalog m_catalog;

    QStringList m_pastefiles;
    bool m_cut;
    bool m_copy;

    CopyThread m_copythread;
    CopyDialog m_copydialog;
    
};

#endif // FILEBROWSER_H
