#pragma once
#include "camera.h"
#include "dcp.h"
#include <libmegapixels.h>
#include <stdbool.h>

typedef struct cstate {
        MPControl control;
        int32_t value;
        int32_t value_req;
        int32_t min;
        int32_t max;
        bool manual;
        bool manual_req;
        MPControl auto_control;
} controlstate;

typedef struct state_main {
        libmegapixels_devconfig *configuration;
        libmegapixels_camera *camera;
        libmegapixels_aaa_stats stats;

        // Size of the preview widget
        int preview_width;
        int preview_height;

        // Size of the frame to draw in the preview widget
        int preview_buffer_width;
        int preview_buffer_height;

        int device_rotation;
        int device_accel_rotation;
        bool device_accel_rotation_good;

        int burst_length;

        // Control state
        bool flash_enabled;
        controlstate gain;
        controlstate dgain;
        controlstate exposure;
        controlstate focus;

        bool has_auto_focus_continuous;
        bool has_auto_focus_start;
} mp_state_main;

typedef struct state_io {
        libmegapixels_devconfig *configuration;
        libmegapixels_camera *camera;
        libmegapixels_mode *mode_capture;
        libmegapixels_mode *mode_preview;
        libmegapixels_aaa_stats stats;

        int burst_length;
        int captures_remaining;
        bool flush_pipeline;
        int blank_frame_count;

        // Control state
        controlstate gain;
        controlstate dgain;
        controlstate exposure;
        controlstate focus;
        controlstate red;
        controlstate blue;
        bool can_af_trigger;
        bool trigger_af;
        bool flash_enabled;

        // State passed through to the process pipeline
        int preview_width;
        int preview_height;
        int device_rotation;
        int device_accel_rotation;
        bool device_accel_rotation_good;
} mp_state_io;

typedef enum aaa_mode {
        AAA_DISABLED,
        AAA_BY_SENSOR,
        AAA_BY_V4L2_CONTROLS,
        AAA_BY_POST,
} aaa_mode;

typedef struct state_proc {
        libmegapixels_devconfig *configuration;
        libmegapixels_camera *camera;
        libmegapixels_mode *mode;
        libmegapixels_aaa_stats stats;

        int burst_length;
        int captures_remaining;
        int counter;
        int preview_width;
        int preview_height;

        // Device orientation in degrees
        int device_rotation;
        int device_accel_rotation;
        bool device_accel_rotation_good;
        // Camera orientation as number
        int camera_rotation;

        bool is_capturing;

        float balance[3];
        controlstate gain;
        controlstate dgain;
        controlstate exposure;
        controlstate focus;

        struct MPCameraCalibration calibration;

        float red;
        float blue;
        float blacklevel;

        int mode_balance;
        int mode_exposure;
        int mode_focus;

        bool flash_enabled;

        bool has_auto_focus_start;
} mp_state_proc;
