/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_TABLE_H_
#define _STUB_TABLE_H_

#include "stub_view.h"

namespace mforms {
namespace stub {

class TableImpl : public ViewImpl
{  
protected:
  TableImpl(::mforms::Table *self)
    : ViewImpl(self)
  {
  }

  static bool __stdcall create(::mforms::Table *self)
  {
    return true;
  }
  
  
  static void __stdcall set_row_count(Table *self, int count)
  {
  }


  static void __stdcall set_col_count(Table *self, int count)
  {
  }


  static void __stdcall add(Table *self, View *child, int left, int right,
                  int top, int bottom, int flags)
  {
  }

  static void __stdcall remove(Table *self, View *child)
  {
  }
  
  static void __stdcall set_row_spacing(Table *self, int space)
  {
  }


  static void __stdcall set_col_spacing(Table *self, int space)
  {
  }


  static void __stdcall set_homogeneous(Table *self, bool flag)
  {
  }

  static void __stdcall set_back_color(Table *self, const std::string&)
  {
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_table_impl.create= &TableImpl::create;
    f->_table_impl.set_row_count= &TableImpl::set_row_count;
    f->_table_impl.set_column_count= &TableImpl::set_col_count;
    f->_table_impl.add= &TableImpl::add;
    f->_table_impl.remove= &TableImpl::remove;
    f->_table_impl.set_row_spacing= &TableImpl::set_row_spacing;
    f->_table_impl.set_column_spacing= &TableImpl::set_col_spacing;
    f->_table_impl.set_homogeneous= &TableImpl::set_homogeneous;
  }
  
  virtual ~TableImpl()
  {
  }
};

}
}


#endif /* _STUB_TABLE_H_ */
