# Contributing to Olive

Thank you for your interest in contributing to Olive! In order to keep the code as readable and maintainable as possible, code submitted should abide by the following standards:

### Standards

When contributing to Olive, it's recommended to use the following rules:

* The code style generally follows the [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html) including, but not limited to:
  * Indentation is 2 spaces wide, spaces only (no tabs)
  * `lowercase_underscored_variable_names`
  * `lowercase_underscored_functions()` or `SentenceCaseFunctions()`
  * `class SentenceCaseClassesAndStructs {}`
  * `kSentenceCaseConstants` prepended with a lowercase `k`
  * `UPPERCASE_UNDERSCORED_MACROS` for variables or same style as functions for macro functions
  * `class_member_variables_` end with a `_`
* 100 column limit (where it doesn't impair readability)
* Unix line endings (only LF no CRLF)
* Javadoc documentation where appropriate
