/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHPROTOCOLENDPOINTACCESS_H_
#define OPENDRIM_SSHPROTOCOLENDPOINTACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_SSHProtocolEndpoint.h"

int SSH_OpenDRIM_SSHProtocolEndpoint_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolEndpoint_unload(string& errorMessage);

int SSH_OpenDRIM_SSHProtocolEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHProtocolEndpoint>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHProtocolEndpoint& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolEndpoint& newInstance, const OpenDRIM_SSHProtocolEndpoint& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolEndpoint& instance, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolEndpoint& instance, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolEndpoint& instance, unsigned int& returnValue, const OpenDRIM_SSHProtocolEndpoint_RequestStateChange_In& in, OpenDRIM_SSHProtocolEndpoint_RequestStateChange_Out& out, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolEndpoint_BroadcastReset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolEndpoint& instance, unsigned int& returnValue, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolEndpoint_populate(OpenDRIM_SSHProtocolEndpoint& instance, string& errorMessage);

#endif /*OPENDRIM_SSHPROTOCOLENDPOINTACCESS_H_*/
