macro(CreateCFortranOutput)
  # Construct mangling macro definitions.
  set(_name_LOWER "name")
  set(_name_UPPER "NAME")
  foreach(form "" "_")
    if(FortranCInterface_GLOBAL_${form}SYMBOL)
      if(FortranCInterface_GLOBAL_${form}PREFIX)
        set(_prefix "${FortranCInterface_GLOBAL_${form}PREFIX}##")
      else()
        set(_prefix "")
      endif()
      if(FortranCInterface_GLOBAL_${form}SUFFIX)
        set(_suffix "##${FortranCInterface_GLOBAL_${form}SUFFIX}")
      else()
        set(_suffix "")
      endif()
      set(_name "${_name_${FortranCInterface_GLOBAL_${form}CASE}}")
      set(FortranCInterface_GLOBAL${form}_MACRO
        "(name,NAME) ${_prefix}${_name}${_suffix}")
    endif()
    if(FortranCInterface_MODULE_${form}SYMBOL)
      if(FortranCInterface_MODULE_${form}PREFIX)
        set(_prefix "${FortranCInterface_MODULE_${form}PREFIX}##")
      else()
        set(_prefix "")
      endif()
      if(FortranCInterface_MODULE_${form}SUFFIX)
        set(_suffix "##${FortranCInterface_MODULE_${form}SUFFIX}")
      else()
        set(_suffix "")
      endif()
      set(_name "${_name_${FortranCInterface_MODULE_${form}CASE}}")
      set(_middle "##${FortranCInterface_MODULE_${form}MIDDLE}##")
      set(FortranCInterface_MODULE${form}_MACRO
        "(mod_name,name, mod_NAME,NAME) ${_prefix}mod_${_name}${_middle}${_name}${_suffix}")
    endif()
  endforeach()

  # Summarize what is available.
  foreach(scope GLOBAL MODULE)
    if(FortranCInterface_${scope}_SYMBOL AND
        FortranCInterface_${scope}__SYMBOL)
      set(FortranCInterface_${scope}_FOUND 1)
    else()
      set(FortranCInterface_${scope}_FOUND 0)
    endif()
  endforeach()

  # Record the detection results.
  configure_file(${FortranCInterface_SOURCE_DIR}/Output.cmake.in
                 ${FortranCInterface_BINARY_DIR}/Output.cmake @ONLY)
  file(APPEND ${FortranCInterface_BINARY_DIR}/Output.cmake "\n")

  # Report the results.
  if(FortranCInterface_GLOBAL_FOUND)
    if(FortranCInterface_MODULE_FOUND)
      set(_result "Found GLOBAL and MODULE mangling")
    else(FortranCInterface_MODULE_FOUND)
      set(_result "Found GLOBAL but not MODULE mangling")
    endif()
  elseif(NOT _result)
    set(_result "Failed to recognize symbols")
  endif()
  message(STATUS "Detecting Fortran/C Interface - ${_result}")
endmacro()
