# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8779 (nagios)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64708);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 10 FEDORA-2009-8779 (nagios)");

 desc = "The remote host is missing an update to nagios
announced via advisory FEDORA-2009-8779.

Update Information:

Upstream released new version
ChangeLog:

* Mon Aug 17 2009 Mike McGrath  - 3.2.0-2
- s/datarootdir/datadir/
* Sun Aug 16 2009 Jose Pedro Oliveira  - 3.2.0-1
- Upgrade to 3.2.0 (#517210).
* Fri Jul 24 2009 Jose Pedro Oliveira  - 3.1.2-3
- Corrected the package version in the last two changelog entries (#499853)
- Using configure --datarootdir option instead of --datadir (#499853)
(fixes the physical_html_path value in cgi.cfg)
- Fixes permissions to the new php configuration file config.inc.php (#499853)
- Re-enables the httpd requirement as its removal caused several problems
(see #487411 for more information)

References:

[ 1 ] Bug #476635 - nagios: update to version 3.0.6
https://bugzilla.redhat.com/show_bug.cgi?id=476635

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update nagios' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8779

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8779 (nagios)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"nagios", rpm:"nagios~3.2.0~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nagios-devel", rpm:"nagios-devel~3.2.0~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nagios-debuginfo", rpm:"nagios-debuginfo~3.2.0~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
