#
#ADV FreeBSD-SA-05:01.telnet.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(52660);
 script_bugtraq_id(12919);
 script_cve_id("CVE-2005-0468");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Security Advisory (FreeBSD-SA-05:01.telnet.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-05:01.telnet.asc

The telnet(1) command is a TELNET protocol client, used primarily to
establish terminal sessions across a network.

Buffer overflows were discovered in the env_opt_add() and
slc_add_reply() functions of the telnet(1) command.  TELNET protocol
commands, options, and data are copied from the network to a
fixed-sized buffer.  In the case of env_opt_add (CVE-2005-0468), the
buffer is located on the heap.  In the case of slc_add_reply
(CVE-2005-0469), the buffer is global uninitialized data (BSS).

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-05:01.telnet.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-05:01.telnet.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"5.3", patchlevel:"6")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.11", patchlevel:"1")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.10", patchlevel:"6")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.8", patchlevel:"28")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
