###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ibm_install_manager_detect_win.nasl 5170 2009-10-08 13:40:29Z oct $
#
# IBM Installation Manager Version Detection (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801010);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("IBM Installation Manager Version Detection (Win)");
  desc = "
  Overview: The script detects the installed IBM Installation Manager
  version and saves the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Check for the version of IBM Installation Manager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

iimVer= registry_get_sz(key:"SOFTWARE\IBM\Installation Manager", item:"version");

if(iimVer != NULL)
{
  set_kb_item(name:"IBM/InstallMang/Win/Ver", value:iimVer);
  security_note(data:"IBM Install Maneger version " + iimVer +
                     " was detected on the host");
}
