#
# This script was written by Noam Rathaus
#
# GPLv2
#
# From: JeiAr [security@gulftech.org]
# Subject: phpShop Vulnerabilities
# Date: Friday 16/01/2004 03:14
#
#
# changes by rd:
# - language-insensitive egrep() matching
# - description
#

if(description)
{
  script_id(12022);
  script_bugtraq_id(9437);
  script_version("$Revision: 8096 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  name = "Multiple phpShop Vulnerabilities";
  script_name(name);
 
  desc = "
Synopsis :

The remote web server contains several PHP scripts that suffer from
multiple vulnerabilities. 

Description :

The remote host is running phpShop, a PHP-based e-commerce application
and PHP development framework. 

Multiple vulnerabilities have been discovered in this product, which may
allow a remote attacker to send arbitrary SQL commands to the remote
database, or to insert malicious HTML and/or JavaScript into existing
pages. 

See also : 

http://www.securityfocus.com/archive/1/350026

Solution : 

Upgrade to the latest version of phpShop.

Risk factor :

Medium / CVSS Base Score : 5 
(AV:R/AC:L/Au:NR/C:P/A:N/I:P/B:N)";

  script_description(desc);
 
  summary = "Detect phpShop SQL Injection";
  script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright("This script is Copyright (C) 2004 Noam Rathaus");

  family = "Web application abuses";
  script_family(family);
  script_dependencie("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);

if (! get_port_state(port) ) exit(0);
if (! can_host_php(port:port) ) exit(0);

function check_dir(path)
{
 req = http_get(item:string(path, "/?page=shop/cart&func=cartAdd&product_id='"), port:port);
 res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
 if ( res == NULL ) exit(0);
 #find = string("You have an error in your SQL syntax near ");
 find = ".*SQL.*item_enquiry_details.*auth=a";
 if (egrep(pattern:find, string:res))
 {
  security_warning(port);
  exit(0);
 }
}

foreach dir (cgi_dirs()) check_dir(path:dir);
