###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms08-038.nasl 886 2009-01-30 14:40:24Z jan $
#
# Microsoft Autorun Arbitrary Code Execution Vulnerability (08-038)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900445);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0243", "CVE-2008-0951");
  script_bugtraq_id(28360);
  script_name("Microsoft Autorun Arbitrary Code Execution Vulnerability (08-038)");
  desc = "

  Overview: This host is running Windows Operating System and is prone to
  Autorun Arbitrary Code Execution Vulnerability.

  Vulnerability Insight:
  MS Windows OSes are not able to enforce the 'Autorun' and 'NoDriveTypeAutoRun'
  registry values. Allows physically proximate attackers to execute malicious
  code by inserting CD-ROM media, inserting DVD media, connecting a USB device,
  connecting a Firewire device, by mapping a network drive, by clicking on an
  icon under My Computer\Devices with Removable Storage and AutoPlay dialog
  related to the Autorun.inf file.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the affected Windows system and can gain sensitive information or
  can make the system resources completely unavailable.

  Impact Level: System/Network

  Affected Software/OS:
  Microsoft Windows 2K SP4 / XP SP2 / 2003 SP2 and prior.

  Fix: Apply the security patch (KB950582).
  http://www.microsoft.com/downloads/results.aspx?pocId=7&freetext=KB950582&DisplayLang=en

  References:
  http://secunia.com/advisories/29458
  http://support.microsoft.com/kb/953252
  http://isc.sans.org/diary.html?storyid=5695
  http://www.us-cert.gov/cas/techalerts/TA09-020A.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the hotfix existence");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

if(hotfix_missing(name:"950582") == 0){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                         item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\shell32.dll");

shellVer = GetVer(file:file, share:share);
if(!shellVer){
  exit(0);
}

# Windows 2000
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for shell32.dll version < 5.0.3900.7155
  if(version_is_less(version:shellVer, test_version:"5.0.3900.7155")){
    security_hole(0);
  }
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for shell32.dll < 6.0.2900.3402
    if(version_is_less(version:shellVer, test_version:"6.0.2900.3402")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for shell32.dll < 6.0.2900.5622
    if(version_is_less(version:shellVer, test_version:"6.0.2900.5622")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for shell32.dll version < 6.0.3790.3158
    if(version_is_less(version:shellVer, test_version:"6.0.3790.3158")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep for shell32.dll version < 6.0.3790.4315
    if(version_is_less(version:shellVer, test_version:"6.0.3790.4315")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
