///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/viewport/Viewport.h>

namespace Core {

/**
 * \brief The context menu of the Viewport window.
 * 
 * This is an internal class used by the Viewport class.
 * 
 * \author Alexander Stukowski.
 * \sa Viewport
 */ 
class ViewportMenu : public QMenu
{
	Q_OBJECT
	
public:
	/// Initializes the menu.
	ViewportMenu(Viewport* vp);

private Q_SLOTS:

	void OnShowGrid(bool checked);
	void OnShowRenderFrame(bool checked);
	void OnWireframeMode();	
	void OnShadedMode();
	void OnShadedWithEdgesMode();	
	void OnViewType(QAction* action);
	void OnViewNode(QAction* action);
	
	void OnShowViewTypeMenu();
	
private:
    
	/// The viewport this menu belongs to.
	Viewport* viewport;
	
	/// The view type sub-menu.
	QMenu* viewTypeMenu;
	
	QActionGroup* viewNodeGroup;
};


};
