#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-11-02 09:45:05   
# conf/config.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="-v"
	shift
fi
MYNOSHARES=
if [ "$1" = "-noshares" ]; then
	MYNOSHARES="$1"
	shift
fi
MYREALM="$1"
MYDNS="$2"
MYKDC="$3"
MYDOMAIN="$4"
MYSERVER="$5"
MYOU="$6"
MYADMIN="$7"
MYADMINPWD="$8"
MYUSERS="$9"
shift
MYHOSTALLOW="$9"
shift
MYWINSSERVER="$9"
shift
#echo "realm=${MYREALM}"
#echo "dns=${MYDNS}"
#echo "kdc=${MYKDC}"
#echo "domain=${MYDOMAIN}"
#echo "server=${MYSERVER}"
#echo "ou=${MYOU}"
#echo "admin=${MYADMIN}"
#echo "admin passwd=${MYADMINPWD}"
#echo "users=${MYUSERS}"
#echo "host allow=${MYHOSTALLOW}"
#echo "wins server=${MYWINSSERVER}"

### S T A R T

function logMark()
{
	logger -t "sadms" "sadms $1"
}

function logTail()
{
	line=`grep -n "sadms start" /var/log/messages | tail -n 1 | cut -d ':' -f 1`
	echo 'log extract'
	echo 'vvvvv'
	tail --line +${line} /var/log/messages
	echo '^^^^^'
}

logMark "start"

echo "[1]"
if ! ./config-bugfix.sh "${MYREALM}" "${MYDNS}" "${MYKDC}.${MYDNS}"; then
	echo "[1>] with error"
	logMark "finish error 1 bug fix"
	logTail
	exit 1
fi

echo "[2]"
if ! ./config-kerberos.sh "${MYREALM}" "${MYDNS}" "${MYKDC}.${MYDNS}"; then
	echo "[2>] with error"
	logMark "finish error 2 kerberos conf"
	logTail
	exit 2
fi

echo "[3]"
if ! ./config-smbconf.sh ${MYNOSHARES} "${MYREALM}" "${MYDOMAIN}" "${MYSERVER}" "${MYADMIN}" "${MYUSERS}" "${MYHOSTALLOW}" "${MYWINSSERVER}"; then
	echo "[3>] with error"
	logMark "finish error 3 smb conf"
	logTail
	exit 3
fi

echo "[4]"
if ! ./kerberos-connect-kdc.sh "${MYDNS}" "${MYKDC}"; then
	echo "[4>] with error"
	logMark "finish error 4 kdc"
	logTail
	exit 4
fi

echo "[5]"
if ! ./sync-clocks.sh "${MYKDC}"; then
	echo "[5>] with error"
	logMark "finish error 5 sync clocks"
	logTail
	exit 5
fi

echo "[6]"
if ! ./kerberos-get-tgt.sh "${MYREALM}" "${MYADMIN}" "${MYADMINPWD}"; then
	echo "[6>] with error"
	logMark "finish error 6 kerberos"
	logTail
	exit 6
fi

echo "[7]"
if ! ./join-domain.sh ${MYVERBOSE} "${MYREALM}" "${MYADMIN}" "${MYADMINPWD}" "${MYOU}"; then
	echo "[7>] with error"
	logMark "finish error 7 join domain"
	logTail
	exit 7
fi

echo "[8]"
if ! ./config-winbind.sh; then
	echo "[8>] with error"
	logMark "finish error 8 winbind"
	logTail
	exit 8
fi

echo "[9]"
if ! ./config-smb.sh; then
	echo "[9>] with error"
	logMark "finish error 9 smb"
	logTail
	exit 9
fi

echo "[10]"
if ! ./config-nss.sh; then
	echo "[10>] with error"
	logMark "finish error 10 nss"
	logTail
	exit 10
fi

echo "[11]"
echo "+finalize"
sleep 10
echo "restart name caching daemon"
${SERVICE} ${NSCDSERVICE} stop > /dev/null 2> /dev/null
if ! ${SERVICE} ${NSCDSERVICE} start > /dev/null 2> /dev/null;then
	echo "[11>] with error"
	logMark "finish error 11 name caching daemon"
	logTail
	exit 11
fi
echo "restart winbind daemon"
if ! ${SERVICE} ${WINBINDSERVICE} restart > /dev/null 2> /dev/null;then
	echo "[12>] with error"
	logMark "finish error 12 winbind daemon"
	logTail
	exit 12
fi
echo "restart samba daemons"
if ! ${SERVICE} ${SAMBASERVICE} restart > /dev/null 2> /dev/null;then
	echo "[13>] with error"
	logMark "finish error 13 samba daemons"
	logTail
	exit 13
fi

echo "[install ok]"

./config-warn.sh

logMark "finish ok"
