#ifndef _sch_bxl__defines_h_
#define _sch_bxl__defines_h_

typedef short sch_bxl_int_t;
#define sch_bxl_chr yyctx->chr
#define sch_bxl_val yyctx->val
#define sch_bxl_lval yyctx->lval
#define sch_bxl_stack yyctx->stack
#define sch_bxl_debug yyctx->debug
#define sch_bxl_nerrs yyctx->nerrs
#define sch_bxl_errflag yyctx->errflag
#define sch_bxl_state yyctx->state
#define sch_bxl_yyn yyctx->yyn
#define sch_bxl_yym yyctx->yym
#define sch_bxl_jump yyctx->jump
#line 18 "../plugins/io_bxl/bxl_gram.y"
/*
 *                            COPYRIGHT
 *
 *  pcb-rnd, interactive printed circuit board design
 *
 *  BXL IO plugin - BXL grammar
 *  pcb-rnd Copyright (C) 2020 Tibor 'Igor2' Palinkas
 *  (Supported by NLnet NGI0 PET Fund in 2020)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Contact:
 *    Project page: http://repo.hu/projects/pcb-rnd
 *    lead developer: http://repo.hu/projects/pcb-rnd/contact.html
 *    mailing list: pcb-rnd (at) list.repo.hu (send "subscribe")
 */
#include <stdio.h>
#include "bxl_gram.h"
#include "bxl.h"

#line 8 "../plugins/io_bxl/bxl_gram.y"
typedef union sch_bxl_tokunion_u
{
	double d;
	int i;
	char *s;
	double c;
} sch_bxl_tokunion_t;
#line 3 "../plugins/io_bxl/bxl_gram.y"
typedef struct sch_bxl_tokstruct_s
{
	sch_bxl_tokunion_t un;
	long line, first_col, last_col;
} sch_bxl_tokstruct_t;
typedef sch_bxl_tokstruct_t sch_bxl_STYPE;


#define T_ID 257
#define T_INTEGER 258
#define T_REAL_ONLY 259
#define T_QSTR 260
#define T_TRUE 261
#define T_FALSE 262
#define T_TEXTSTYLE 263
#define T_FONTWIDTH 264
#define T_FONTCHARWIDTH 265
#define T_FONTHEIGHT 266
#define T_FONTFAMILY 267
#define T_FONTFACE 268
#define T_PADSTACK 269
#define T_ENDPADSTACK 270
#define T_SHAPES 271
#define T_PADSHAPE 272
#define T_HOLEDIAM 273
#define T_SURFACE 274
#define T_PLATED 275
#define T_WIDTH 276
#define T_HEIGHT 277
#define T_PADTYPE 278
#define T_LAYER 279
#define T_PATTERN 280
#define T_ENDPATTERN 281
#define T_DATA 282
#define T_ENDDATA 283
#define T_ORIGINPOINT 284
#define T_PICKPOINT 285
#define T_GLUEPOINT 286
#define T_PAD 287
#define T_NUMBER 288
#define T_PINNAME 289
#define T_PADSTYLE 290
#define T_ORIGINALPADSTYLE 291
#define T_ORIGIN 292
#define T_ORIGINALPINNUMBER 293
#define T_ROTATE 294
#define T_POLY 295
#define T_LINE 296
#define T_ENDPOINT 297
#define T_ATTRIBUTE 298
#define T_ATTR 299
#define T_JUSTIFY 300
#define T_ARC 301
#define T_RADIUS 302
#define T_STARTANGLE 303
#define T_SWEEPANGLE 304
#define T_TEXT 305
#define T_ISVISIBLE 306
#define T_PROPERTY 307
#define T_WIZARD 308
#define T_VARNAME 309
#define T_VARDATA 310
#define T_TEMPLATEDATA 311
#define T_ISFLIPPED 312
#define T_NOPASTE 313
#define T_ORIGINALNAME 314
#define T_SYMBOL 315
#define T_ENDSYMBOL 316
#define T_PIN 317
#define T_PINNUM 318
#define T_PINLENGTH 319
#define T_PINDES 320
#define T_TEXTSTYLEREF 321
#define T_COMPONENT 322
#define T_ENDCOMPONENT 323
#define common_layer 324
#define sch_bxl_ERRCODE 256

#ifndef sch_bxl_INITSTACKSIZE
#define sch_bxl_INITSTACKSIZE 200
#endif

typedef struct {
	unsigned stacksize;
	sch_bxl_int_t *s_base;
	sch_bxl_int_t *s_mark;
	sch_bxl_int_t *s_last;
	sch_bxl_STYPE *l_base;
	sch_bxl_STYPE *l_mark;
#if sch_bxl_DEBUG
	int debug;
#endif
} sch_bxl_STACKDATA;

typedef struct {
	int errflag;
	int chr;
	sch_bxl_STYPE val;
	sch_bxl_STYPE lval;
	int nerrs;
	int yym, yyn, state;
	int jump;
	int stack_max_depth;
	int debug;

	/* variables for the parser stack */
	sch_bxl_STACKDATA stack;
} sch_bxl_yyctx_t;

typedef enum { sch_bxl_RES_NEXT, sch_bxl_RES_DONE, sch_bxl_RES_ABORT } sch_bxl_res_t;

extern int sch_bxl_parse_init(sch_bxl_yyctx_t *yyctx);
extern sch_bxl_res_t sch_bxl_parse(sch_bxl_yyctx_t *yyctx, sch_bxl_ctx_t *ctx, int tok, sch_bxl_STYPE *lval);
extern void sch_bxl_error(sch_bxl_ctx_t *ctx, sch_bxl_STYPE tok, const char *msg);


#endif /* _sch_bxl__defines_h_ */
