/* sockd_dumpcf */

#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include <syslog.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "socks.h"


void sockd_dumprt(rtAddr, Nrt, useSyslog)
struct config *rtAddr;
int Nrt;
int useSyslog;
{
	char buf[1024], *bp;
	struct config *cp;
	int i, t;
	struct in_addr addr;
	
	if (useSyslog)
		syslog(LOG_HIGH,"Effective route entries: %d\n",Nrt);
	else
		printf("Effective route entries: %d\n",Nrt);
	for (i = 0, cp = rtAddr; i++ < Nrt; cp++) {
		strcpy(buf, inet_ntoa(cp->saddr));
		strcat(buf, " ");
		addr.s_addr = cp->daddr.s_addr;
		if (cp->ddomain != NULL)
			strcat(buf, cp->ddomain);
		else
			strcat(buf, inet_ntoa(cp->daddr));
		strcat(buf, " ");
		addr.s_addr = cp->dmask.s_addr;
		strcat(buf, inet_ntoa(cp->dmask));
		if (useSyslog)
			syslog(LOG_HIGH, "RT%3d>>%s<<\n",i,buf);
		else
			printf("RT%3d>>%s<<\n",i,buf);
	}
}
