-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-- Node is SP_Symbols.machine_code_insertion
-- If Scope is body of a function then machine code is illegal in SPARK 83
-- In all other cases, issue warning

separate (Sem.CompUnit)
procedure Wf_Machine_Code_Insertion (Node  : in STree.SyntaxNode;
                                     Scope : in Dictionary.Scopes) is
   Subprog_Sym : Dictionary.Symbol;
begin
   Subprog_Sym := Dictionary.GetRegion (Scope);
   if CommandLineData.Content.Language_Profile = CommandLineData.SPARK83 and then Dictionary.IsFunction (Subprog_Sym) then
      ErrorHandler.Semantic_Error
        (Err_Num   => 67,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   else
      ErrorHandler.Semantic_Warning
        (Err_Num  => 6,
         Position => Node_Position (Node => Node),
         Id_Str   => LexTokenManager.Null_String);
   end if;
end Wf_Machine_Code_Insertion;
