-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Ada.Integer_Text_IO;
with Ada.Text_IO;
with SPARK.Ada.Text_IO.Not_SPARK;

package body SPARK_Ada_Integer_Text_IO is
   --# hide SPARK_Ada_Integer_Text_IO;

   function Default_Width return  SPARK.Ada.Text_IO.Field is
   begin
      return Integer'Width;
   end Default_Width;

   procedure Get_File (File  : in out SPARK.Ada.Text_IO.File_Type;
                       Item  :    out Integer;
                       Width : in     SPARK.Ada.Text_IO.Field) is
   begin
      Standard.Ada.Integer_Text_IO.Get
        (File  => SPARK.Ada.Text_IO.Not_SPARK.To_File_Type (From => File),
         Item  => Item,
         Width => Width);
   end Get_File;

   procedure Put_File
     (File  : in out SPARK.Ada.Text_IO.File_Type;
      Item  : in     Integer;
      Width : in     SPARK.Ada.Text_IO.Field;
      Base  : in     SPARK.Ada.Text_IO.Number_Base)
   is
   begin
      Standard.Ada.Integer_Text_IO.Put
        (File  => SPARK.Ada.Text_IO.Not_SPARK.To_File_Type (From => File),
         Item  => Item,
         Width => Width,
         Base  => Base);
   end Put_File;

   procedure Put_Output (Item  : in Integer;
                         Width : in SPARK.Ada.Text_IO.Field;
                         Base  : in SPARK.Ada.Text_IO.Number_Base) is
   begin
      Standard.Ada.Integer_Text_IO.Put (File  => Standard.Ada.Text_IO.Standard_Output,
                                        Item  => Item,
                                        Width => Width,
                                        Base  => Base);
   end Put_Output;

end SPARK_Ada_Integer_Text_IO;
