/*
 * Copyright (c) 2002-2009 Moxie Marlinspike
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __HTTPS_BRIDGE_H__
#define __HTTPS_BRIDGE_H__


#include "SSLBridge.hpp"
#include "http/HttpHeaders.hpp"

using namespace boost::asio;

class HTTPSBridge : public SSLBridge {

private:
  void buildRequestFromHeaders(HttpHeaders &headers, std::string &request);

protected:
  HttpHeaders headers;
  virtual bool readFromClient();


public:

  HTTPSBridge(boost::shared_ptr<ip::tcp::socket> clientSocket,
	    ip::tcp::socket *serverSocket) 
    : SSLBridge(clientSocket, serverSocket) {}

};



#endif
