/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;

public final class StringConstant
implements ADQLOperand {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "STRING_VALUE", false, "A string value.");
    private String value;
    private TextPosition position = null;

    public StringConstant(String value) {
        this.value = value;
    }

    public StringConstant(StringConstant toCopy) {
        this.value = toCopy.value;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    @Override
    public final boolean isNumeric() {
        return false;
    }

    @Override
    public final boolean isString() {
        return true;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLObject getCopy() {
        return new StringConstant(this);
    }

    @Override
    public String getName() {
        return this.toADQL();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    @Override
    public String toADQL() {
        return "'" + this.value.replaceAll("'", "''") + "'";
    }
}

