/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Info.h"


namespace svn
{

Info::Info( const sc::String& name, const svn_info_t* info )
: _name(name)
{
  _url    = info->URL;
  _root   = info->repos_root_URL;
  _revnum = info->rev;
}

Info::Info( const Info& src )
{
  _name   = src._name;
  _url    = src._url;
  _root   = src._root;

  _revnum = src._revnum;
}

Info::~Info()
{
}

const sc::String& Info::getName() const
{
  return _name;
}

const sc::String& Info::getUrl() const
{
  return _url;
}

const sc::String& Info::getRootUrl() const
{
  return _root;
}

Revnumber Info::getRevnumber() const
{
  return _revnum;
}

} // namespace
