/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _OPTIONS_HH
#define _OPTIONS_HH

#include <string>



struct Toptions {
private:
	int cursor;
	std::string current_arg;
	int argc;
	char **argv;

	void init();
	bool parse_arg();
	bool next_arg();

public:
	bool version;
	bool help;	
	int action;
	std::string action_arg;	
	std::string target;	

	bool parse(int argc, char *argv[]);
	void show_short_help();
	void show_help();
};




#define CLEAR 1
#define SELECT 2
#define DESELECT 3
#define LIST 5
#define UPGRADE 6
#define UPDATE 7
#define SOURCE_SELECT 8
#define SOURCE_DESELECT 9
#define SOURCE_DELETE 10
#define LIST_SOURCES 11
#define LIST_AVAILABLE 12
#define SQL 13

#endif
