C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE RESRAY
C                       *****************
C
C     -------------------------------------------------------------
     * (NDIM,NELRAY,NPOINR,COORAY,NODRAY,NRFRAY,
     *  FDFRAY,SUFRAY,TEMRAY,RADIOS,FIRAY,TRAYEQ,ERAYEQ,
     *  EMISSI,EPROPR,NFFIRA,NGFFIR,VFIRAY,TABRAY,
     *  NFMST,NGFMST,FLUMST,PHMSTO)
C     -------------------------------------------------------------
C 
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C
C                     TRAITEMENT DU RAYONNEMENT TRANSPARENT
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     : 
C
C     SOUS PROGRAMME(S) APPELE(S) :
C
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofct.h"
#include "mobil.h"
#include "divct.h"
#include "nlofes.h"
#include "rayonn.h"
#include "syrthu.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NELRAY,NPOINR,NFFIRA,NFMST,NBSCAL
      INTEGER NODRAY(NELRAY,NDIM),NRFRAY(NELRAY),NGFFIR(NFFIRA)
      INTEGER NGFMST(NFMST,2)
      DOUBLE PRECISION FDFRAY(NELRAY*(NELRAY+1)/2)
      DOUBLE PRECISION TEMRAY(NELRAY),RADIOS(NELRAY,NBANDE)
      DOUBLE PRECISION FIRAY(NELRAY,NBANDE),EMISSI(NELRAY,2,NBANDE)
      DOUBLE PRECISION EPROPR(NELRAY,NBANDE)
      DOUBLE PRECISION ERAYEQ(NELRAY),TRAYEQ(NELRAY)
      DOUBLE PRECISION SUFRAY(NELRAY)
      DOUBLE PRECISION COORAY(NPOINR,NDIM)
      DOUBLE PRECISION VFIRAY(NFFIRA,NBANDE,2)
      DOUBLE PRECISION TABRAY(NELRAY,9)
      DOUBLE PRECISION FLUMST(NFMST,NBANDE),PHMSTO(NFMST,5,NBANDE)
C
C
C..Variables Internes
      INTEGER NUMBS,N,NGFAC,I
      LOGICAL LPREM
      CHARACTER*2 CHI
C
C***********************************************************************
      DATA  LPREM / .TRUE. /
      SAVE LPREM
C
C     1- PROPRIETES PHYSIQUES ET CONDITIONS AUX LIMITES
C     =================================================
C
      DO  N=1,NELRAY
        TEMRAY(N) = TEMRAY(N) + TKEL
      ENDDO
C
      DO NUMBS=1,NBANDE
        DO  N=1,NELRAY
          EMISSI(N,2,NUMBS)=1-EMISSI(N,1,NUMBS)
        ENDDO
      ENDDO
C
      IF (NFMST.GT.0) THEN
        DO NUMBS=1,NBANDE
          DO N=1,NFMST
            EMISSI(NGFMST(N,1),1,NUMBS)=PHMSTO(N,1,NUMBS)
            EMISSI(NGFMST(N,1),2,NUMBS)=PHMSTO(N,2,NUMBS)
          ENDDO
        ENDDO
      ENDIF
C
C
C     2- RESOLUTION DE LA DIFFUSION SOLIDE 
C     ====================================
C
      DO 200 NUMBS=1,NBANDE
C
        CALL SMBRAY (NUMBS,NELRAY,SUFRAY,TEMRAY,EMISSI,EPROPR,
     *               TABRAY(1,9))
C
        DO N=1,NFFIRA
           NGFAC = NGFFIR(N)
           EPROPR(NGFAC,NUMBS) = VFIRAY(N,NUMBS,1)*SUFRAY(NGFAC)
        ENDDO
C
        IF (NTSYR.GT.1) THEN
         DO N=1,NFMST
           NGFAC = NGFMST(N,1)
           EPROPR(NGFAC,NUMBS) =  EPROPR(NGFAC,NUMBS)
     *                          + FLUMST(N,NUMBS)*SUFRAY(NGFAC)
         ENDDO
        ENDIF
C
  200 CONTINUE
C
        IF (LPREM) THEN
          DO I=1,NBANDE
           DO N=1,NELRAY
            RADIOS(N,I) = EPROPR(N,I)/SUFRAY(N)
           ENDDO
          ENDDO
          LPREM = .FALSE.
        ENDIF
C
      WRITE(NFECRA,2300)
      DO 230 NUMBS=1,NBANDE
        CALL GAUSEI(NELRAY,NUMBS,FDFRAY,SUFRAY,EMISSI,EPROPR,
     *              NFFIRA,NGFFIR,RADIOS,TABRAY)
  230 CONTINUE
C
C     3- PREPARATION DES DONNEES EQUIVALENTES
C     =======================================
C
      CALL FI2TEQ(NELRAY,NFFIRA,NGFFIR,EMISSI,TEMRAY,FIRAY,VFIRAY,
     *            FDFRAY,RADIOS,ERAYEQ,TRAYEQ,SUFRAY,TABRAY(1,9))
C
      DO N=1,NELRAY
        TEMRAY(N) = TEMRAY(N) - TKEL
        TRAYEQ(N) = TRAYEQ(N) - TKEL
      ENDDO
C
C
C     4- ECRITURES SUR FICHIERS
C     =========================
C
      IF (LHISOR) CALL WHISOR(NELRAY,TEMRAY)
C
C     fichier chrono
C     --------------
      IF (NCHROR.GE.1 .AND. 
     *    (MOD ((NTSYR-NTSYRD),NCHROR).EQ.0 .OR.
     *    (MOD ((NTSYR-NTSYRD),NCHROR).NE.0 .AND. 
     *                   (LDERN.OR.LSTOPS) )) ) THEN
         NBSCAL=1+NBANDE
         CALL ECRG2E(NBSCAL,NFGCRA,NDIM,NDIM-1,NELRAY,NPOINR) 
         CALL ECRG3E(NFGCRA) 
C
         CALL ECRG2R(TEMRAY,NELRAY,'T_RAYT      ','1',NFGCRA)
         DO NUMBS=1,NBANDE
            IF (NUMBS.LE.9) THEN
               CHI(1:1)='0'
               WRITE(CHI(2:2),'(I1)') NUMBS
            ELSE
               WRITE(CHI,'(I2)') NUMBS
            ENDIF
           CALL ECRG2R(FIRAY(1,NUMBS),NELRAY,
     &                 'FLUX_RAY_B'//CHI,'1',NFGCRA)
         ENDDO
         CALL FLUSHF(NFGCRA)
      ENDIF
C
C     fichier resultat
C     ----------------
      IF (LDERN.OR.LSTOPS) THEN
C
        CALL ECRG3E(NFGRRA)
        CALL ECRG2R(TEMRAY,NELRAY,'T_RAYT      ','1',NFGRRA)
        DO NUMBS=1,NBANDE
            IF (NUMBS.LE.9) THEN
               CHI(1:1)='0'
               WRITE(CHI(2:2),'(I1)') NUMBS
            ELSE
               WRITE(CHI,'(I2)') NUMBS
            ENDIF
           CALL ECRG2R(FIRAY(1,NUMBS),NELRAY,
     &                 'FLUX_RAY_B'//CHI,'1',NFGRRA)
        ENDDO
        CALL FLUSHF(NFGRRA)
      ENDIF
C
C

C--------
C FORMATS
C--------
C
 1000 FORMAT(/,
     *    5X,30('-'),/,
     *    5X,'TRAITEMENT DU RAYONNEMENT',/,
     *    5X,30('-'))
C
 2300 FORMAT(/,
     *    5X,40('='),/,
     *    5X,'RESOLUTION DU SYSTEME LIE AU RAYONNEMENT',/,
     *    5X,40('='),/)
C----
C FIN
C----
C
      END
