module Exif
  module Tag
    module NikonFmount
      LensName = {
        [0x01, 0x58, 0x50, 0x50, 0x14, 0x14, 0x02] => "Nikon AF Nikkor 50mm F1.8",
        [0x02, 0x42, 0x44, 0x5C, 0x2A, 0x34, 0x02] => "Nikon AF Zoom-Nikkor 35-70mm F3.3-4.5",
        [0x02, 0x42, 0x44, 0x5C, 0x2A, 0x34, 0x08] => "Nikon AF Zoom-Nikkor 35-70mm F3.3-4.5",
        [0x03, 0x48, 0x5C, 0x81, 0x30, 0x30, 0x02] => "Nikon AF Zoom-Nikkor 70-210mm F4",
        [0x04, 0x48, 0x3C, 0x3C, 0x24, 0x24, 0x03] => "Nikon AF Nikkor 28mm F2.8",
        [0x05, 0x54, 0x50, 0x50, 0x0C, 0x0C, 0x04] => "Nikon AF Nikkor 50mm F1.4",
        [0x06, 0x54, 0x53, 0x53, 0x24, 0x24, 0x06] => "Nikon AF Micro-Nikkor 55mm F2.8",
        [0x07, 0x40, 0x3C, 0x62, 0x2C, 0x34, 0x03] => "Nikon AF Zoom-Nikkor 28-85mm F3.5-4.5",
        [0x08, 0x40, 0x44, 0x6A, 0x2C, 0x34, 0x04] => "Nikon AF Zoom-Nikkor 35-105mm F3.5-4.5",
        [0x09, 0x48, 0x37, 0x37, 0x24, 0x24, 0x04] => "Nikon AF Nikkor 24mm F2.8",
        [0x0A, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0x03] => "Nikon AF Nikkor 300mm F2.8 IF-ED",
        [0x0A, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0x05] => "Nikon AF Nikkor 300mm F2.8 IF-ED N",
        [0x0B, 0x48, 0x7C, 0x7C, 0x24, 0x24, 0x05] => "Nikon AF Nikkor 180mm F2.8 IF-ED",
        [0x0D, 0x40, 0x44, 0x72, 0x2C, 0x34, 0x07] => "Nikon AF Zoom-Nikkor 35-135mm F3.5-4.5",
        [0x0E, 0x48, 0x5C, 0x81, 0x30, 0x30, 0x05] => "Nikon AF Zoom-Nikkor 70-210mm F4",
        [0x0F, 0x58, 0x50, 0x50, 0x14, 0x14, 0x05] => "Nikon AF Nikkor 50mm F1.8 N",
        [0x10, 0x48, 0x8E, 0x8E, 0x30, 0x30, 0x08] => "Nikon AF Nikkor 300mm F4 IF-ED",
        [0x11, 0x48, 0x44, 0x5C, 0x24, 0x24, 0x08] => "Nikon AF Zoom-Nikkor 35-70mm F2.8",
        [0x12, 0x48, 0x5C, 0x81, 0x30, 0x3C, 0x09] => "Nikon AF Nikkor 70-210mm F4-5.6",
        [0x13, 0x42, 0x37, 0x50, 0x2A, 0x34, 0x0B] => "Nikon AF Zoom-Nikkor 24-50mm F3.3-4.5",
        [0x14, 0x48, 0x60, 0x80, 0x24, 0x24, 0x0B] => "Nikon AF Zoom-Nikkor 80-200mm F2.8 ED",
        [0x15, 0x4C, 0x62, 0x62, 0x14, 0x14, 0x0C] => "Nikon AF Nikkor 85mm F1.8",
        [0x17, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0x0F] => "Nikon Nikkor 500mm F4 P ED IF",
        [0x17, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0x11] => "Nikon Nikkor 500mm F4 P ED IF",
        [0x18, 0x40, 0x44, 0x72, 0x2C, 0x34, 0x0E] => "Nikon AF Zoom-Nikkor 35-135mm F3.5-4.5 N",
        [0x1A, 0x54, 0x44, 0x44, 0x18, 0x18, 0x11] => "Nikon AF Nikkor 35mm F2",
        [0x1B, 0x44, 0x5E, 0x8E, 0x34, 0x3C, 0x10] => "Nikon AF Zoom-Nikkor 75-300mm F4.5-5.6",
        [0x1C, 0x48, 0x30, 0x30, 0x24, 0x24, 0x12] => "Nikon AF Nikkor 20mm F2.8",
        [0x1D, 0x42, 0x44, 0x5C, 0x2A, 0x34, 0x12] => "Nikon AF Zoom-Nikkor 35-70mm F3.3-4.5 N",
        [0x1E, 0x54, 0x56, 0x56, 0x24, 0x24, 0x13] => "Nikon AF Micro-Nikkor 60mm F2.8",
        [0x1F, 0x54, 0x6A, 0x6A, 0x24, 0x24, 0x14] => "Nikon AF Micro-Nikkor 105mm F2.8",
        [0x20, 0x48, 0x60, 0x80, 0x24, 0x24, 0x15] => "Nikon AF Zoom-Nikkor 80-200mm F2.8 ED",
        [0x21, 0x40, 0x3C, 0x5C, 0x2C, 0x34, 0x16] => "Nikon AF Zoom-Nikkor 28-70mm F3.5-4.5",
        [0x22, 0x48, 0x72, 0x72, 0x18, 0x18, 0x16] => "Nikon AF DC-Nikkor 135mm F2",
        [0x23, 0x30, 0xBE, 0xCA, 0x3C, 0x48, 0x17] => "Nikon Zoom-Nikkor 1200-1700mm F5.6-8 P ED IF",
        [0x24, 0x48, 0x60, 0x80, 0x24, 0x24, 0x1A] => "Nikon AF Zoom-Nikkor 80-200mm F2.8D ED",
        [0x25, 0x48, 0x44, 0x5c, 0x24, 0x24, 0x1B] => "Nikon AF Zoom-Nikkor 35-70mm F2.8D",
        [0x25, 0x48, 0x44, 0x5c, 0x24, 0x24, 0x52] => "Nikon AF Zoom-Nikkor 35-70mm F2.8D",
        [0x26, 0x40, 0x3C, 0x5C, 0x2C, 0x34, 0x1C] => "Nikon AF Zoom-Nikkor 28-70mm F3.5-4.5D",
        [0x27, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0x1D] => "Nikon AF-I Nikkor 300mm F2.8D IF-ED",
        [0x27, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0xF1] => "Nikon AF-I Nikkor 300mm F2.8D IF-ED + TC-14E",
        [0x27, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0xE1] => "Nikon AF-I Nikkor 300mm F2.8D IF-ED + TC-17E",
        [0x27, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0xF2] => "Nikon AF-I Nikkor 300mm F2.8D IF-ED + TC-20E",
        [0x28, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0x1D] => "Nikon AF-I Nikkor 600mm F4D IF-ED",
        [0x28, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0xF1] => "Nikon AF-I Nikkor 600mm F4D IF-ED + TC-14E",
        [0x28, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0xE1] => "Nikon AF-I Nikkor 600mm F4D IF-ED + TC-17E",
        [0x28, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0xF2] => "Nikon AF-I Nikkor 600mm F4D IF-ED + TC-20E",
        [0x2A, 0x54, 0x3C, 0x3C, 0x0C, 0x0C, 0x26] => "Nikon AF Nikkor 28mm F1.4D",
        [0x2B, 0x3C, 0x44, 0x60, 0x30, 0x3C, 0x1F] => "Nikon AF Zoom-Nikkor 35-80mm F4-5.6D",
        [0x2C, 0x48, 0x6A, 0x6A, 0x18, 0x18, 0x27] => "Nikon AF DC-Nikkor 105mm F2D",
        [0x2D, 0x48, 0x80, 0x80, 0x30, 0x30, 0x21] => "Nikon AF Micro-Nikkor 200mm F4D IF-ED",
        [0x2E, 0x48, 0x5C, 0x82, 0x30, 0x3C, 0x22] => "Nikon AF Nikkor 70-210mm F4-5.6D",
        [0x2E, 0x48, 0x5C, 0x82, 0x30, 0x3C, 0x28] => "Nikon AF Nikkor 70-210mm F4-5.6D",
        [0x2F, 0x48, 0x30, 0x44, 0x24, 0x24, 0x29] => "Nikon AF Zoom-Nikkor 20-35mm F2.8D IF",
        [0x30, 0x48, 0x98, 0x98, 0x24, 0x24, 0x24] => "Nikon AF-I Nikkor 400mm F2.8D IF-ED",
        [0x30, 0x48, 0x98, 0x98, 0x24, 0x24, 0xF1] => "Nikon AF-I Nikkor 400mm F2.8D IF-ED + TC-14E",
        [0x30, 0x48, 0x98, 0x98, 0x24, 0x24, 0xE1] => "Nikon AF-I Nikkor 400mm F2.8D IF-ED + TC-17E",
        [0x30, 0x48, 0x98, 0x98, 0x24, 0x24, 0xF2] => "Nikon AF-I Nikkor 400mm F2.8D IF-ED + TC-20E",
        [0x31, 0x54, 0x56, 0x56, 0x24, 0x24, 0x25] => "Nikon AF Micro-Nikkor 60mm F2.8D",
        [0x32, 0x54, 0x6A, 0x6A, 0x24, 0x24, 0x35] => "Nikon AF Micro-Nikkor 105mm F2.8D",
        [0x33, 0x48, 0x2D, 0x2D, 0x24, 0x24, 0x31] => "Nikon AF Nikkor 18mm F2.8D",
        [0x34, 0x48, 0x29, 0x29, 0x24, 0x24, 0x32] => "Nikon AF Fisheye Nikkor 16mm F2.8D",
        [0x35, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0x33] => "Nikon AF-I Nikkor 500mm F4D IF-ED",
        [0x35, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0xF1] => "Nikon AF-I Nikkor 500mm F4D IF-ED + TC-14E",
        [0x35, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0xE1] => "Nikon AF-I Nikkor 500mm F4D IF-ED + TC-17E",
        [0x35, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0xF2] => "Nikon AF-I Nikkor 500mm F4D IF-ED + TC-20E",
        [0x36, 0x48, 0x37, 0x37, 0x24, 0x24, 0x34] => "Nikon AF Nikkor 24mm F2.8D",
        [0x37, 0x48, 0x30, 0x30, 0x24, 0x24, 0x36] => "Nikon AF Nikkor 20mm F2.8D",
        [0x38, 0x4C, 0x62, 0x62, 0x14, 0x14, 0x37] => "Nikon AF Nikkor 85mm F1.8D",
        [0x3A, 0x40, 0x3C, 0x5C, 0x2C, 0x34, 0x39] => "Nikon AF Zoom-Nikkor 28-70mm F3.5-4.5D",
        [0x3B, 0x48, 0x44, 0x5C, 0x24, 0x24, 0x3A] => "Nikon AF Zoom-Nikkor 35-70mm F2.8D N",
        [0x3C, 0x48, 0x60, 0x80, 0x24, 0x24, 0x3B] => "Nikon AF Zoom-Nikkor 80-200mm F2.8D ED",
        [0x3D, 0x3C, 0x44, 0x60, 0x30, 0x3C, 0x3E] => "Nikon AF Zoom-Nikkor 35-80mm F4-5.6D",
        [0x3E, 0x48, 0x3C, 0x3C, 0x24, 0x24, 0x3D] => "Nikon AF Nikkor 28mm F2.8D",
        [0x3F, 0x40, 0x44, 0x6A, 0x2C, 0x34, 0x45] => "Nikon AF Zoom-Nikkor 35-105mm F3.5-4.5D",
        [0x41, 0x48, 0x7c, 0x7c, 0x24, 0x24, 0x43] => "Nikon AF Nikkor 180mm F2.8D IF-ED",
        [0x42, 0x54, 0x44, 0x44, 0x18, 0x18, 0x44] => "Nikon AF Nikkor 35mm F2D",
        [0x43, 0x54, 0x50, 0x50, 0x0C, 0x0C, 0x46] => "Nikon AF Nikkor 50mm F1.4D",
        [0x44, 0x44, 0x60, 0x80, 0x34, 0x3C, 0x47] => "Nikon AF Zoom-Nikkor 80-200mm F4.5-5.6D",
        [0x45, 0x40, 0x3C, 0x60, 0x2C, 0x3C, 0x48] => "Nikon AF Zoom-Nikkor 28-80mm F3.5-5.6D",
        [0x46, 0x3C, 0x44, 0x60, 0x30, 0x3C, 0x49] => "Nikon AF Zoom-Nikkor 35-80mm F4-5.6D N",
        [0x47, 0x42, 0x37, 0x50, 0x2A, 0x34, 0x4A] => "Nikon AF Zoom-Nikkor 24-50mm F3.3-4.5D",
        [0x48, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0x4B] => "Nikon AF-S Nikkor 300mm F2.8D IF-ED",
        [0x48, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0xF1] => "Nikon AF-S Nikkor 300mm F2.8D IF-ED + TC-14E",
        [0x48, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0xE1] => "Nikon AF-S Nikkor 300mm F2.8D IF-ED + TC-17E",
        [0x48, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0xF2] => "Nikon AF-S Nikkor 300mm F2.8D IF-ED + TC-20E",
        [0x49, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0x4C] => "Nikon AF-S Nikkor 600mm F4D IF-ED",
        [0x49, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0xF1] => "Nikon AF-S Nikkor 600mm F4D IF-ED + TC-14E",
        [0x49, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0xE1] => "Nikon AF-S Nikkor 600mm F4D IF-ED + TC-17E",
        [0x49, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0xF2] => "Nikon AF-S Nikkor 600mm F4D IF-ED + TC-20E",
        [0x4A, 0x54, 0x62, 0x62, 0x0C, 0x0C, 0x4D] => "Nikon AF Nikkor 85mm F1.4D IF",
        [0x4B, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0x4E] => "Nikon AF-S Nikkor 500mm F4D IF-ED",
        [0x4B, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0xF1] => "Nikon AF-S Nikkor 500mm F4D IF-ED + TC-14E",
        [0x4B, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0xE1] => "Nikon AF-S Nikkor 500mm F4D IF-ED + TC-17E",
        [0x4B, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0xF2] => "Nikon AF-S Nikkor 500mm F4D IF-ED + TC-20E",
        [0x4C, 0x40, 0x37, 0x6E, 0x2C, 0x3C, 0x4F] => "Nikon AF Zoom-Nikkor 24-120mm F3.5-5.6D IF",
        [0x4D, 0x40, 0x3C, 0x80, 0x2C, 0x3C, 0x62] => "Nikon AF Zoom-Nikkor 28-200mm F3.5-5.6D IF",
        [0x4E, 0x48, 0x72, 0x72, 0x18, 0x18, 0x51] => "Nikon AF DC-Nikkor 135mm F2D",
        [0x4F, 0x40, 0x37, 0x5C, 0x2C, 0x3C, 0x53] => "Nikon IX-Nikkor 24-70mm F3.5-5.6",
        [0x50, 0x48, 0x56, 0x7C, 0x30, 0x3C, 0x54] => "Nikon IX-Nikkor 60-180mm F4-5.6",
        [0x53, 0x48, 0x60, 0x80, 0x24, 0x24, 0x57] => "Nikon AF Zoom-Nikkor 80-200mm F2.8D ED",
        [0x53, 0x48, 0x60, 0x80, 0x24, 0x24, 0x60] => "Nikon AF Zoom-Nikkor 80-200mm F2.8D ED",
        [0x54, 0x44, 0x5C, 0x7C, 0x34, 0x3C, 0x58] => "Nikon AF Zoom-Micro Nikkor 70-180mm F4.5-5.6D ED",
        [0x56, 0x48, 0x5C, 0x8E, 0x30, 0x3C, 0x5A] => "Nikon AF Zoom-Nikkor 70-300mm F4-5.6D ED",
        [0x59, 0x48, 0x98, 0x98, 0x24, 0x24, 0x5D] => "Nikon AF-S Nikkor 400mm F2.8D IF-ED",
        [0x59, 0x48, 0x98, 0x98, 0x24, 0x24, 0xF1] => "Nikon AF-S Nikkor 400mm F2.8D IF-ED + TC-14E",
        [0x59, 0x48, 0x98, 0x98, 0x24, 0x24, 0xE1] => "Nikon AF-S Nikkor 400mm F2.8D IF-ED + TC-17E",
        [0x59, 0x48, 0x98, 0x98, 0x24, 0x24, 0xF2] => "Nikon AF-S Nikkor 400mm F2.8D IF-ED + TC-20E",
        [0x5A, 0x3C, 0x3E, 0x56, 0x30, 0x3C, 0x5E] => "Nikon IX-Nikkor 30-60mm F4-5.6",
        [0x5B, 0x44, 0x56, 0x7C, 0x34, 0x3C, 0x5F] => "Nikon IX-Nikkor 60-180mm F4.5-5.6",
        [0x5D, 0x48, 0x3C, 0x5C, 0x24, 0x24, 0x63] => "Nikon AF-S Zoom-Nikkor 28-70mm F2.8D IF-ED",
        [0x5E, 0x48, 0x60, 0x80, 0x24, 0x24, 0x64] => "Nikon AF-S Zoom-Nikkor 80-200mm F2.8D IF-ED",
        [0x5F, 0x40, 0x3C, 0x6A, 0x2C, 0x34, 0x65] => "Nikon AF Zoom-Nikkor 28-105mm F3.5-4.5D IF",
        [0x60, 0x40, 0x3C, 0x60, 0x2C, 0x3C, 0x66] => "Nikon AF Zoom-Nikkor 28-80mm F3.5-5.6D",
        [0x61, 0x44, 0x5E, 0x86, 0x34, 0x3C, 0x67] => "Nikon AF Zoom-Nikkor 75-240mm F4.5-5.6D",
        [0x63, 0x48, 0x2B, 0x44, 0x24, 0x24, 0x68] => "Nikon AF-S Nikkor 17-35mm F2.8D IF-ED",
        [0x64, 0x00, 0x62, 0x62, 0x24, 0x24, 0x6A] => "Nikon PC Micro-Nikkor 85mm F2.8D",
        [0x65, 0x44, 0x60, 0x98, 0x34, 0x3C, 0x6B] => "Nikon AF VR Zoom-Nikkor 80-400mm F4.5-5.6D ED",
        [0x66, 0x40, 0x2D, 0x44, 0x2C, 0x34, 0x6C] => "Nikon AF Zoom-Nikkor 18-35mm F3.5-4.5D IF-ED",
        [0x67, 0x48, 0x37, 0x62, 0x24, 0x30, 0x6D] => "Nikon AF Zoom-Nikkor 24-85mm F2.8-4D IF",
        [0x68, 0x42, 0x3C, 0x60, 0x2A, 0x3C, 0x6E] => "Nikon AF Zoom-Nikkor 28-80mm F3.3-5.6G",
        [0x69, 0x48, 0x5C, 0x8E, 0x30, 0x3C, 0x6F] => "Nikon AF Zoom-Nikkor 70-300mm F4-5.6G",
        [0x6A, 0x48, 0x8E, 0x8E, 0x30, 0x30, 0x70] => "Nikon AF-S Nikkor 300mm F4D IF-ED",
        [0x6B, 0x48, 0x24, 0x24, 0x24, 0x24, 0x71] => "Nikon AF Nikkor ED 14mm F2.8D",
        [0x6D, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0x73] => "Nikon AF-S Nikkor 300mm F2.8D IF-ED II",
        [0x6E, 0x48, 0x98, 0x98, 0x24, 0x24, 0x74] => "Nikon AF-S Nikkor 400mm F2.8D IF-ED II",
        [0x6F, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0x75] => "Nikon AF-S Nikkor 500mm F4D IF-ED II",
        [0x70, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0x76] => "Nikon AF-S Nikkor 600mm F4D IF-ED II",
        [0x72, 0x48, 0x4C, 0x4C, 0x24, 0x24, 0x77] => "Nikon Nikkor 45mm F2.8 P",
        [0x74, 0x40, 0x37, 0x62, 0x2C, 0x34, 0x78] => "Nikon AF-S Zoom-Nikkor 24-85mm F3.5-4.5G IF-ED",
        [0x75, 0x40, 0x3C, 0x68, 0x2C, 0x3C, 0x79] => "Nikon AF Zoom-Nikkor 28-100mm F3.5-5.6G",
        [0x76, 0x58, 0x50, 0x50, 0x14, 0x14, 0x7A] => "Nikon AF Nikkor 50mm F1.8D",
        [0x77, 0x48, 0x5C, 0x80, 0x24, 0x24, 0x7B] => "Nikon AF-S VR Zoom-Nikkor 70-200mm F2.8G IF-ED",
        [0x78, 0x40, 0x37, 0x6E, 0x2C, 0x3C, 0x7C] => "Nikon AF-S VR Zoom-Nikkor 24-120mm F3.5-5.6G IF-ED",
        [0x79, 0x40, 0x3C, 0x80, 0x2C, 0x3C, 0x7F] => "Nikon AF Zoom-Nikkor 28-200mm F3.5-5.6G IF-ED",
        [0x7A, 0x3C, 0x1F, 0x37, 0x30, 0x30, 0x7E] => "Nikon AF-S DX Zoom-Nikkor 12-24mm F4G IF-ED",
        [0x7B, 0x48, 0x80, 0x98, 0x30, 0x30, 0x80] => "Nikon AF-S VR Zoom-Nikkor 200-400mm F4G IF-ED",
        [0x7D, 0x48, 0x2B, 0x53, 0x24, 0x24, 0x82] => "Nikon AF-S DX Zoom-Nikkor 17-55mm F2.8G IF-ED",
        [0x7F, 0x40, 0x2D, 0x5C, 0x2C, 0x34, 0x84] => "Nikon AF-S DX Zoom-Nikkor 18-70mm F3.5-4.5G IF-ED",
        [0x80, 0x48, 0x1A, 0x1A, 0x24, 0x24, 0x85] => "Nikon AF DX Fisheye-Nikkor 10.5mm F2.8G ED",
        [0x81, 0x54, 0x80, 0x80, 0x18, 0x18, 0x86] => "Nikon AF-S VR Nikkor 200mm F2G IF-ED",
        [0x82, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0x87] => "Nikon AF-S VR Nikkor 300mm F2.8G IF-ED",
        [0x83, 0x00, 0xB0, 0xB0, 0x5A, 0x5A, 0x88] => "Nikon FSA-L2, EDG 65, 800mm F13 G",
        [0x89, 0x3C, 0x53, 0x80, 0x30, 0x3C, 0x8B] => "Nikon AF-S DX Zoom-Nikkor 55-200mm F4-5.6G ED",
        [0x8A, 0x54, 0x6A, 0x6A, 0x24, 0x24, 0x8C] => "Nikon AF-S VR Micro-Nikkor 105mm F2.8G IF-ED",
        [0x8B, 0x40, 0x2D, 0x80, 0x2C, 0x3C, 0x8D] => "Nikon AF-S DX VR Zoom-Nikkor 18-200mm F3.5-5.6G IF-ED",
        [0x8B, 0x40, 0x2D, 0x80, 0x2C, 0x3C, 0xFD] => "Nikon AF-S DX VR Zoom-Nikkor 18-200mm F3.5-5.6G IF-ED",
        [0x8B, 0x40, 0x2D, 0x80, 0x2C, 0x3C, 0xFD] => "Nikon AF-S DX VR Zoom-Nikkor 18-200mm F3.5-5.6G IF-ED II",
        [0x8C, 0x40, 0x2D, 0x53, 0x2C, 0x3C, 0x8E] => "Nikon AF-S DX Zoom-Nikkor 18-55mm F3.5-5.6G ED",
        [0x8D, 0x44, 0x5C, 0x8E, 0x34, 0x3C, 0x8F] => "Nikon AF-S VR Zoom-Nikkor 70-300mm F4.5-5.6G IF-ED",
        [0x8F, 0x40, 0x2D, 0x72, 0x2C, 0x3C, 0x91] => "Nikon AF-S DX Zoom-Nikkor 18-135mm F3.5-5.6G IF-ED",
        [0x90, 0x3B, 0x53, 0x80, 0x30, 0x3C, 0x92] => "Nikon AF-S DX VR Zoom-Nikkor 55-200mm F4-5.6G IF-ED",
        [0x92, 0x48, 0x24, 0x37, 0x24, 0x24, 0x94] => "Nikon AF-S Zoom-Nikkor 14-24mm F2.8G ED",
        [0x93, 0x48, 0x37, 0x5C, 0x24, 0x24, 0x95] => "Nikon AF-S Zoom-Nikkor 24-70mm F2.8G ED",
        [0x94, 0x40, 0x2D, 0x53, 0x2C, 0x3C, 0x96] => "Nikon AF-S DX Zoom-Nikkor 18-55mm F3.5-5.6G ED II",
        [0x95, 0x4C, 0x37, 0x37, 0x2C, 0x2C, 0x97] => "Nikon PC-E Nikkor 24mm F3.5D ED",
        [0x95, 0x00, 0x37, 0x37, 0x2C, 0x2C, 0x97] => "Nikon PC-E Nikkor 24mm F3.5D ED",
        [0x96, 0x48, 0x98, 0x98, 0x24, 0x24, 0x98] => "Nikon AF-S VR Nikkor 400mm F2.8G ED",
        [0x97, 0x3C, 0xA0, 0xA0, 0x30, 0x30, 0x99] => "Nikon AF-S VR Nikkor 500mm F4G ED",
        [0x98, 0x3C, 0xA6, 0xA6, 0x30, 0x30, 0x9A] => "Nikon AF-S VR Nikkor 600mm F4G ED",
        [0x99, 0x40, 0x29, 0x62, 0x2C, 0x3C, 0x9B] => "Nikon AF-S DX VR Zoom-Nikkor 16-85mm F3.5-5.6G ED",
        [0x9A, 0x40, 0x2D, 0x53, 0x2C, 0x3C, 0x9C] => "Nikon AF-S DX VR Zoom-Nikkor 18-55mm F3.5-5.6G",
        [0x9B, 0x54, 0x4C, 0x4C, 0x24, 0x24, 0x9D] => "Nikon PC-E Micro Nikkor 45mm F2.8D ED",
        [0x9B, 0x00, 0x4C, 0x4C, 0x24, 0x24, 0x9D] => "Nikon PC-E Micro Nikkor 45mm F2.8D ED",
        [0x9C, 0x54, 0x56, 0x56, 0x24, 0x24, 0x9E] => "Nikon AF-S Micro Nikkor 60mm F2.8G ED",
        [0x9D, 0x54, 0x62, 0x62, 0x24, 0x24, 0x9F] => "Nikon PC-E Micro Nikkor 85mm F2.8D",
        [0x9D, 0x00, 0x62, 0x62, 0x24, 0x24, 0x9F] => "Nikon PC-E Micro Nikkor 85mm F2.8D",
        [0x9E, 0x40, 0x2D, 0x6A, 0x2C, 0x3C, 0xA0] => "Nikon AF-S DX VR Zoom-Nikkor 18-105mm F3.5-5.6G ED",
        [0x9F, 0x58, 0x44, 0x44, 0x14, 0x14, 0xA1] => "Nikon AF-S DX Nikkor 35mm F1.8G",
        [0xA0, 0x54, 0x50, 0x50, 0x0C, 0x0C, 0xA2] => "Nikon AF-S Nikkor 50mm F1.4G",
        [0xA1, 0x40, 0x18, 0x37, 0x2C, 0x34, 0xA3] => "Nikon AF-S DX Nikkor 10-24mm F3.5-4.5G ED",
        [0xA2, 0x48, 0x5C, 0x80, 0x24, 0x24, 0xA4] => "Nikon AF-S Nikkor 70-200mm F2.8G ED VR II",
        [0xA3, 0x3C, 0x29, 0x44, 0x30, 0x30, 0xA5] => "Nikon AF-S Nikkor 16-35mm F4G ED VR",
        [0xA4, 0x54, 0x37, 0x37, 0x0C, 0x0C, 0xA6] => "Nikon AF-S Nikkor 24mm F1.4G ED",
        [0xA5, 0x40, 0x3C, 0x8E, 0x2C, 0x3C, 0xA7] => "Nikon AF-S Nikkor 28-300mm F3.5-5.6G ED VR",
        [0xA6, 0x48, 0x8E, 0x8E, 0x24, 0x24, 0xA8] => "Nikon AF-S VR Nikkor 300mm F2.8G IF-ED II",
        [0xA7, 0x4B, 0x62, 0x62, 0x2C, 0x2C, 0xA9] => "Nikon AF-S DX Micro Nikkor 85mm F3.5G ED VR",
        [0xA8, 0x48, 0x80, 0x98, 0x30, 0x30, 0xAA] => "Nikon AF-S VR Zoom-Nikkor 200-400mm F4G IF-ED II",
        [0xA9, 0x54, 0x80, 0x80, 0x18, 0x18, 0xAB] => "Nikon AF-S Nikkor 200mm F2G ED VR II",
        [0xAA, 0x3C, 0x37, 0x6E, 0x30, 0x30, 0xAC] => "Nikon AF-S Nikkor 24-120mm F4G ED VR",
        [0xAC, 0x38, 0x53, 0x8E, 0x34, 0x3C, 0xAE] => "Nikon AF-S DX VR Nikkor 55-300mm 4.5-5.6G ED",
        [0xAE, 0x54, 0x62, 0x62, 0x0C, 0x0C, 0xB0] => "Nikon AF-S Nikkor 85mm F1.4G",
        [0xAF, 0x54, 0x44, 0x44, 0x0C, 0x0C, 0xB1] => "Nikon AF-S Nikkor 35mm F1.4G",
        [0xB0, 0x4C, 0x50, 0x50, 0x14, 0x14, 0xB2] => "Nikon AF-S Nikkor 50mm F1.8G",
        [0xB1, 0x48, 0x48, 0x48, 0x24, 0x24, 0xB3] => "Nikon AF-S DX Micro Nikkor 40mm F2.8G",
        [0xB3, 0x4C, 0x62, 0x62, 0x14, 0x14, 0xB5] => "Nikon AF-S Nikkor 85mm F1.8G",
        [0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02] => "Nikon TC-16A",
        [0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08] => "Nikon TC-16A",
        [0xFE, 0x47, 0x00, 0x00, 0x24, 0x24, 0x4B] => "Sigma 4.5mm F2.8 EX DC HSM Circular Fisheye",
        [0x26, 0x48, 0x11, 0x11, 0x30, 0x30, 0x1C] => "Sigma 8mm F4 EX Circular Fisheye",
        [0x79, 0x40, 0x11, 0x11, 0x2C, 0x2C, 0x1C] => "Sigma 8mm F3.5 EX Circular Fisheye",
        [0xDC, 0x48, 0x19, 0x19, 0x24, 0x24, 0x4B] => "Sigma 10mm F2.8 EX DC HSM Fisheye",
        [0x02, 0x3F, 0x24, 0x24, 0x2C, 0x2C, 0x02] => "Sigma 14mm F3.5",
        [0x48, 0x48, 0x24, 0x24, 0x24, 0x24, 0x4B] => "Sigma 14mm F2.8 EX Aspherical HSM",
        [0x26, 0x48, 0x27, 0x27, 0x24, 0x24, 0x1C] => "Sigma 15mm F2.8 EX Diagonal Fisheye",
        [0x26, 0x58, 0x31, 0x31, 0x14, 0x14, 0x1C] => "Sigma 20mm F1.8 EX DG Aspherical RF",
        [0x26, 0x58, 0x37, 0x37, 0x14, 0x14, 0x1C] => "Sigma 24mm F1.8 EX DG Aspherical Macro",
        [0xE1, 0x58, 0x37, 0x37, 0x14, 0x14, 0x1C] => "Sigma 24mm F1.8 EX DG Aspherical Macro",
        [0x02, 0x46, 0x37, 0x37, 0x25, 0x25, 0x02] => "Sigma 24mm F2.8 Super Wide II Macro",
        [0x26, 0x58, 0x3C, 0x3C, 0x14, 0x14, 0x1C] => "Sigma 28mm F1.8 EX DG Aspherical Macro",
        [0x48, 0x54, 0x3E, 0x3E, 0x0C, 0x0C, 0x4B] => "Sigma 30mm F1.4 EX DC HSM",
        [0xF8, 0x54, 0x3E, 0x3E, 0x0C, 0x0C, 0x4B] => "Sigma 30mm F1.4 EX DC HSM",
        [0xDE, 0x54, 0x50, 0x50, 0x0C, 0x0C, 0x4B] => "Sigma 50mm F1.4 EX DG HSM",
        [0x02, 0x48, 0x50, 0x50, 0x24, 0x24, 0x02] => "Sigma Macro 50mm F2.8",
        [0x32, 0x54, 0x50, 0x50, 0x24, 0x24, 0x35] => "Sigma Macro 50mm F2.8 EX DG",
        [0xE3, 0x54, 0x50, 0x50, 0x24, 0x24, 0x35] => "Sigma Macro 50mm F2.8 EX DG",
        [0x79, 0x48, 0x5C, 0x5C, 0x24, 0x24, 0x1C] => "Sigma Macro 70mm F2.8 EX DG",
        [0x9B, 0x54, 0x62, 0x62, 0x0C, 0x0C, 0x4B] => "Sigma 85mm F1.4 EX DG HSM",
        [0x02, 0x48, 0x65, 0x65, 0x24, 0x24, 0x02] => "Sigma Macro 90mm F2.8",
        [0x32, 0x54, 0x6A, 0x6A, 0x24, 0x24, 0x35] => "Sigma Macro 105mm F2.8 EX DG",
        [0xE5, 0x54, 0x6A, 0x6A, 0x24, 0x24, 0x35] => "Sigma Macro 105mm F2.8 EX DG",
        [0x48, 0x48, 0x76, 0x76, 0x24, 0x24, 0x4B] => "Sigma APO Macro 150mm F2.8 EX DG HSM",
        [0xF5, 0x48, 0x76, 0x76, 0x24, 0x24, 0x4B] => "Sigma APO Macro 150mm F2.8 EX DG HSM",
        [0x48, 0x4C, 0x7C, 0x7C, 0x2C, 0x2C, 0x4B] => "Sigma APO Macro 180mm F3.5 EX DG HSM",
        [0x48, 0x4C, 0x7D, 0x7D, 0x2C, 0x2C, 0x4B] => "Sigma APO Macro 180mm F3.5 EX DG HSM",
        [0x48, 0x54, 0x8E, 0x8E, 0x24, 0x24, 0x4B] => "Sigma APO 300mm F2.8 EX DG HSM",
        [0xFB, 0x54, 0x8E, 0x8E, 0x24, 0x24, 0x4B] => "Sigma APO 300mm F2.8 EX DG HSM",
        [0x26, 0x48, 0x8E, 0x8E, 0x30, 0x30, 0x1C] => "Sigma APO Tele Macro 300mm F4",
        [0x02, 0x2F, 0x98, 0x98, 0x3D, 0x3D, 0x02] => "Sigma APO 400mm F5.6",
        [0x26, 0x3C, 0x98, 0x98, 0x3C, 0x3C, 0x1C] => "Sigma APO Tele Macro 400mm F5.6",
        [0x02, 0x37, 0xA0, 0xA0, 0x34, 0x34, 0x02] => "Sigma APO 500mm F4.5",
        [0x48, 0x44, 0xA0, 0xA0, 0x34, 0x34, 0x4B] => "Sigma APO 500mm F4.5 EX HSM",
        [0xF1, 0x44, 0xA0, 0xA0, 0x34, 0x34, 0x4B] => "Sigma APO 500mm F4.5 EX DG HSM",
        [0x02, 0x34, 0xA0, 0xA0, 0x44, 0x44, 0x02] => "Sigma APO 500mm F7.2",
        [0x02, 0x3C, 0xB0, 0xB0, 0x3C, 0x3C, 0x02] => "Sigma APO 800mm F5.6",
        [0x48, 0x3C, 0xB0, 0xB0, 0x3C, 0x3C, 0x4B] => "Sigma APO 800mm F5.6 EX HSM",
        [0x9E, 0x38, 0x11, 0x29, 0x34, 0x3C, 0x4B] => "Sigma 8-16mm F4.5-5.6 DC HSM",
        [0xA1, 0x41, 0x19, 0x31, 0x2C, 0x2C, 0x4B] => "Sigma 10-20mm F3.5 EX DC HSM",
        [0x48, 0x3C, 0x19, 0x31, 0x30, 0x3C, 0x4B] => "Sigma 10-20mm F4-5.6 EX DC HSM",
        [0xF9, 0x3C, 0x19, 0x31, 0x30, 0x3C, 0x4B] => "Sigma 10-20mm F4-5.6 EX DC HSM",
        [0x48, 0x38, 0x1F, 0x37, 0x34, 0x3C, 0x4B] => "Sigma 12-24mm F4.5-5.6 EX DG Aspherical HSM",
        [0xF0, 0x38, 0x1F, 0x37, 0x34, 0x3C, 0x4B] => "Sigma 12-24mm F4.5-5.6 EX DG Aspherical HSM",
        [0x26, 0x40, 0x27, 0x3F, 0x2C, 0x34, 0x1C] => "Sigma 15-30mm F3.5-4.5 EX DG Aspherical DF",
        [0x48, 0x48, 0x2B, 0x44, 0x24, 0x30, 0x4B] => "Sigma 17-35mm F2.8-4 EX DG  Aspherical HSM",
        [0x26, 0x54, 0x2B, 0x44, 0x24, 0x30, 0x1C] => "Sigma 17-35mm F2.8-4 EX Aspherical",
        [0x9D, 0x48, 0x2B, 0x50, 0x24, 0x24, 0x4B] => "Sigma 17-50mm F2.8 EX DC OS HSM",
        [0x7A, 0x47, 0x2B, 0x5C, 0x24, 0x34, 0x4B] => "Sigma 17-70mm F2.8-4.5 DC Macro Asp. IF HSM",
        [0x7A, 0x48, 0x2B, 0x5C, 0x24, 0x34, 0x4B] => "Sigma 17-70mm F2.8-4.5 DC Macro Asp. IF HSM",
        [0x7F, 0x48, 0x2B, 0x5C, 0x24, 0x34, 0x1C] => "Sigma 17-70mm F2.8-4.5 DC Macro Asp. IF",
        [0x26, 0x40, 0x2D, 0x44, 0x2B, 0x34, 0x1C] => "Sigma 18-35 F3.5-4.5 Aspherical",
        [0x26, 0x48, 0x2D, 0x50, 0x24, 0x24, 0x1C] => "Sigma 18-50mm F2.8 EX DC",
        [0x7F, 0x48, 0x2D, 0x50, 0x24, 0x24, 0x1C] => "Sigma 18-50mm F2.8 EX DC Macro",
        [0x7A, 0x48, 0x2D, 0x50, 0x24, 0x24, 0x4B] => "Sigma 18-50mm F2.8 EX DC Macro",
        [0xF6, 0x48, 0x2D, 0x50, 0x24, 0x24, 0x4B] => "Sigma 18-50mm F2.8 EX DC Macro",
        [0xA4, 0x47, 0x2D, 0x50, 0x24, 0x34, 0x4B] => "Sigma 18-50mm F2.8-4.5 DC OS HSM",
        [0x26, 0x40, 0x2D, 0x50, 0x2C, 0x3C, 0x1C] => "Sigma 18-50mm F3.5-5.6 DC",
        [0x7A, 0x40, 0x2D, 0x50, 0x2C, 0x3C, 0x4B] => "Sigma 18-50mm F3.5-5.6 DC HSM",
        [0x26, 0x40, 0x2D, 0x70, 0x2B, 0x3C, 0x1C] => "Sigma 18-125mm F3.5-5.6 DC",
        [0xCD, 0x3D, 0x2D, 0x70, 0x2E, 0x3C, 0x4B] => "Sigma 18-125mm F3.8-5.6 DC OS HSM",
        [0x26, 0x40, 0x2D, 0x80, 0x2C, 0x40, 0x1C] => "Sigma 18-200mm F3.5-6.3 DC",
        [0x7A, 0x40, 0x2D, 0x80, 0x2C, 0x40, 0x4B] => "Sigma 18-200mm F3.5-6.3 DC OS HSM",
        [0xED, 0x40, 0x2D, 0x80, 0x2C, 0x40, 0x4B] => "Sigma 18-200mm F3.5-6.3 DC OS HSM",
        [0xA5, 0x40, 0x2D, 0x88, 0x2C, 0x40, 0x4B] => "Sigma 18-250mm F3.5-6.3 DC OS HSM",
        [0x26, 0x48, 0x31, 0x49, 0x24, 0x24, 0x1C] => "Sigma 20-40mm F2.8",
        [0x26, 0x48, 0x37, 0x56, 0x24, 0x24, 0x1C] => "Sigma 24-60mm F2.8 EX DG",
        [0xB6, 0x48, 0x37, 0x56, 0x24, 0x24, 0x1C] => "Sigma 24-60mm F2.8 EX DG",
        [0xA6, 0x48, 0x37, 0x5C, 0x24, 0x24, 0x4B] => "Sigma 24-70mm F2.8 IF EX DG HSM",
        [0x26, 0x54, 0x37, 0x5C, 0x24, 0x24, 0x1C] => "Sigma 24-70mm F2.8 EX DG Macro",
        [0x67, 0x54, 0x37, 0x5C, 0x24, 0x24, 0x1C] => "Sigma 24-70mm F2.8 EX DG Macro",
        [0xE9, 0x54, 0x37, 0x5C, 0x24, 0x24, 0x1C] => "Sigma 24-70mm F2.8 EX DG Macro",
        [0x26, 0x40, 0x37, 0x5C, 0x2C, 0x3C, 0x1C] => "Sigma 24-70mm F3.5-5.6 Aspherical HF",
        [0x26, 0x54, 0x37, 0x73, 0x24, 0x34, 0x1C] => "Sigma 24-135mm F2.8-4.5",
        [0x02, 0x46, 0x3C, 0x5C, 0x25, 0x25, 0x02] => "Sigma 28-70mm F2.8",
        [0x26, 0x54, 0x3C, 0x5C, 0x24, 0x24, 0x1C] => "Sigma 28-70mm F2.8 EX",
        [0x26, 0x48, 0x3C, 0x5C, 0x24, 0x24, 0x1C] => "Sigma 28-70mm F2.8 EX DG",
        [0x26, 0x48, 0x3C, 0x5C, 0x24, 0x30, 0x1C] => "Sigma 28-70mm F2.8-4 DG",
        [0x02, 0x3F, 0x3C, 0x5C, 0x2D, 0x35, 0x02] => "Sigma 28-70mm F3.5-4.5 UC",
        [0x26, 0x40, 0x3C, 0x60, 0x2C, 0x3C, 0x1C] => "Sigma 28-80mm F3.5-5.6 Mini Zoom Macro II Aspherical",
        [0x26, 0x40, 0x3C, 0x65, 0x2C, 0x3C, 0x1C] => "Sigma 28-90mm F3.5-5.6 Macro",
        [0x26, 0x48, 0x3C, 0x6A, 0x24, 0x30, 0x1C] => "Sigma 28-105mm F2.8-4 Aspherical",
        [0x26, 0x3E, 0x3C, 0x6A, 0x2E, 0x3C, 0x1C] => "Sigma 28-105mm F3.8-5.6 UC-III Aspherical IF",
        [0x26, 0x40, 0x3C, 0x80, 0x2C, 0x3C, 0x1C] => "Sigma 28-200mm F3.5-5.6 Compact Aspherical Hyperzoom Macro",
        [0x26, 0x40, 0x3C, 0x80, 0x2B, 0x3C, 0x1C] => "Sigma 28-200mm F3.5-5.6 Compact Aspherical Hyperzoom Macro",
        [0x26, 0x3D, 0x3C, 0x80, 0x2F, 0x3D, 0x1C] => "Sigma 28-300mm F3.8-5.6 Aspherical",
        [0x26, 0x41, 0x3C, 0x8E, 0x2C, 0x40, 0x1C] => "Sigma 28-300mm F3.5-6.3 DG Macro",
        [0xE6, 0x41, 0x3C, 0x8E, 0x2C, 0x40, 0x1C] => "Sigma 28-300mm F3.5-6.3 DG Macro",
        [0x26, 0x40, 0x3C, 0x8E, 0x2C, 0x40, 0x1C] => "Sigma 28-300mm F3.5-6.3 Macro",
        [0x02, 0x3B, 0x44, 0x61, 0x30, 0x3D, 0x02] => "Sigma 35-80mm F4-5.6",
        [0x02, 0x40, 0x44, 0x73, 0x2B, 0x36, 0x02] => "Sigma 35-135mm F3.5-4.5 a",
        [0x7A, 0x47, 0x50, 0x76, 0x24, 0x24, 0x4B] => "Sigma 50-150mm F2.8 EX APO DC HSM",
        [0xFD, 0x47, 0x50, 0x76, 0x24, 0x24, 0x4B] => "Sigma 50-150mm F2.8 EX APO DC HSM II",
        [0x48, 0x3C, 0x50, 0xA0, 0x30, 0x40, 0x4B] => "Sigma APO 50-500mm F4-6.3 EX HSM",
        [0x9F, 0x37, 0x50, 0xA0, 0x34, 0x40, 0x4B] => "Sigma 50-500mm F4.5-6.3 APO DG OS HSM",
        [0x26, 0x3C, 0x54, 0x80, 0x30, 0x3C, 0x1C] => "Sigma 55-200mm F4-5.6 DC",
        [0x7A, 0x3B, 0x53, 0x80, 0x30, 0x3C, 0x4B] => "Sigma 55-200mm F4-5.6 DC HSM",
        [0x48, 0x54, 0x5C, 0x80, 0x24, 0x24, 0x4B] => "Sigma 70-200mm F2.8 EX APO IF HSM",
        [0x7A, 0x48, 0x5C, 0x80, 0x24, 0x24, 0x4B] => "Sigma 70-200mm F2.8 EX APO DG Macro HSM II",
        [0xEE, 0x48, 0x5C, 0x80, 0x24, 0x24, 0x4B] => "Sigma 70-200mm F2.8 EX APO DG Macro HSM II",
        [0x9C, 0x48, 0x5C, 0x80, 0x24, 0x24, 0x4B] => "Sigma 70-200mm F2.8 EX DG OS HSM",
        [0x02, 0x46, 0x5C, 0x82, 0x25, 0x25, 0x02] => "Sigma 70-210mm F2.8 APO",
        [0x26, 0x3C, 0x5C, 0x82, 0x30, 0x3C, 0x1C] => "Sigma 70-210mm F4-5.6 UC-II",
        [0x26, 0x3C, 0x5C, 0x8E, 0x30, 0x3C, 0x1C] => "Sigma 70-300mm F4-5.6 DG Macro",
        [0x56, 0x3C, 0x5C, 0x8E, 0x30, 0x3C, 0x1C] => "Sigma 70-300mm F4-5.6 APO Macro Super II",
        [0xE0, 0x3C, 0x5C, 0x8E, 0x30, 0x3C, 0x4B] => "Sigma APO 70-300mm F4-5.6 DG Macro",
        [0xA3, 0x3C, 0x5C, 0x8E, 0x30, 0x3C, 0x4B] => "Sigma 70-300mm F4-5.6 DG OS",
        [0x02, 0x37, 0x5E, 0x8E, 0x35, 0x3D, 0x02] => "Sigma 75-300mm F4.5-5.6 APO",
        [0x02, 0x3A, 0x5E, 0x8E, 0x32, 0x3D, 0x02] => "Sigma 75-300mm F4.0-5.6",
        [0x77, 0x44, 0x61, 0x98, 0x34, 0x3C, 0x7B] => "Sigma 80-400mm f4.5-5.6 EX OS",
        [0x48, 0x48, 0x68, 0x8E, 0x30, 0x30, 0x4B] => "Sigma APO 100-300mm F4 EX IF HSM",
        [0xF3, 0x48, 0x68, 0x8E, 0x30, 0x30, 0x4B] => "Sigma APO 100-300mm F4 EX IF HSM",
        [0x48, 0x54, 0x6F, 0x8E, 0x24, 0x24, 0x4B] => "Sigma APO 120-300mm F2.8 EX DG HSM",
        [0x7A, 0x54, 0x6E, 0x8E, 0x24, 0x24, 0x4B] => "Sigma APO 120-300mm F2.8 EX DG HSM",
        [0xFA, 0x54, 0x6E, 0x8E, 0x24, 0x24, 0x4B] => "Sigma APO 120-300mm F2.8 EX DG HSM",
        [0xCF, 0x38, 0x6E, 0x98, 0x34, 0x3C, 0x4B] => "Sigma APO 120-400mm F4.5-5.6 DG OS HSM",
        [0x26, 0x44, 0x73, 0x98, 0x34, 0x3C, 0x1C] => "Sigma 135-400mm F4.5-5.6 APO Aspherical",
        [0xCE, 0x34, 0x76, 0xA0, 0x38, 0x40, 0x4B] => "Sigma APO 150-500mm F5-6.3 DG OS HSM",
        [0x26, 0x40, 0x7B, 0xA0, 0x34, 0x40, 0x1C] => "Sigma APO 170-500mm F5-6.3 Aspherical RF",
        [0xA7, 0x49, 0x80, 0xA0, 0x24, 0x24, 0x4B] => "Sigma APO 200-500mm F2.8 EX DG",
        [0x48, 0x3C, 0x8E, 0xB0, 0x3C, 0x3C, 0x4B] => "Sigma APO 300-800mm F5.6 EX DG HSM",
        [0x00, 0x47, 0x25, 0x25, 0x24, 0x24, 0x00] => "Tamron SP AF 14mm F/2.8 Aspherical (IF)",
        [0xF4, 0x54, 0x56, 0x56, 0x18, 0x18, 0x84] => "Tamron SP AF 60mm F/2 Di II LD (IF) Macro 1:1",
        [0x1E, 0x5D, 0x64, 0x64, 0x20, 0x20, 0x13] => "Tamron SP AF 90mm F/2.5",
        [0x20, 0x5A, 0x64, 0x64, 0x20, 0x20, 0x14] => "Tamron SP AF 90mm F/2.5 Macro",
        [0x22, 0x53, 0x64, 0x64, 0x24, 0x24, 0xE0] => "Tamron SP AF 90mm F/2.8 Macro 1:1",
        [0x32, 0x53, 0x64, 0x64, 0x24, 0x24, 0x35] => "Tamron SP AF 90mm F/2.8 Macro 1:1",
        [0x32, 0x53, 0x64, 0x64, 0x24, 0x24, 0x35] => "Tamron SP AF 90mm F/2.8 Di Macro 1:1",
        [0xF8, 0x55, 0x64, 0x64, 0x24, 0x24, 0x84] => "Tamron SP AF 90mm F/2.8 Di Macro 1:1",
        [0xF8, 0x54, 0x64, 0x64, 0x24, 0x24, 0xDF] => "Tamron SP AF 90mm F/2.8 Di Macro 1:1",
        [0x00, 0x4C, 0x7C, 0x7C, 0x2C, 0x2C, 0x00] => "Tamron SP AF 180mm F/3.5 Di Model",
        [0x21, 0x56, 0x8E, 0x8E, 0x24, 0x24, 0x14] => "Tamron SP AF 300mm F/2.8 LD-IF",
        [0x27, 0x54, 0x8E, 0x8E, 0x24, 0x24, 0x1D] => "Tamron SP AF 300mm F/2.8 LD-IF",
        [0xF6, 0x3F, 0x18, 0x37, 0x2C, 0x34, 0x84] => "Tamron SP AF 10-24mm F/3.5-4.5 Di II LD Aspherical (IF)",
        [0x00, 0x36, 0x1C, 0x2D, 0x34, 0x3C, 0x00] => "Tamron SP AF 11-18mm F/4.5-5.6 Di II LD Aspherical (IF)",
        [0x07, 0x46, 0x2B, 0x44, 0x24, 0x30, 0x03] => "Tamron SP AF 17-35mm F/2.8-4 Di LD Aspherical (IF)",
        [0x00, 0x53, 0x2B, 0x50, 0x24, 0x24, 0x00] => "Tamron SP AF 17-50mm F/2.8 XR Di II LD Aspherical (IF)",
        [0x00, 0x54, 0x2B, 0x50, 0x24, 0x24, 0x00] => "Tamron SP AF 17-50mm F/2.8 XR Di II LD Aspherical (IF)",
        [0xFB, 0x54, 0x2B, 0x50, 0x24, 0x24, 0x84] => "Tamron SP AF 17-50mm F/2.8 XR Di II LD Aspherical (IF)",
        [0xF3, 0x54, 0x2B, 0x50, 0x24, 0x24, 0x84] => "Tamron SP AF 17-50mm F/2.8 XR Di II VC LD Aspherical (IF)",
        [0x00, 0x3F, 0x2D, 0x80, 0x2B, 0x40, 0x00] => "Tamron AF 18-200mm F/3.5-6.3 XR Di II LD Aspherical (IF)",
        [0x00, 0x3F, 0x2D, 0x80, 0x2C, 0x40, 0x00] => "Tamron AF 18-200mm F/3.5-6.3 XR Di II LD Aspherical (IF) Macro",
        [0x00, 0x40, 0x2D, 0x80, 0x2C, 0x40, 0x00] => "Tamron AF 18-200mm F/3.5-6.3 XR Di II LD Aspherical (IF) Macro",
        [0xFC, 0x40, 0x2D, 0x80, 0x2C, 0x40, 0xDF] => "Tamron AF 18-200mm F/3.5-6.3 XR Di II LD Aspherical (IF) Macro",
        [0x00, 0x40, 0x2D, 0x88, 0x2C, 0x40, 0x62] => "Tamron AF 18-250mm F/3.5-6.3 Di II LD Aspherical (IF) Macro",
        [0x00, 0x40, 0x2D, 0x88, 0x2C, 0x40, 0x00] => "Tamron AF 18-250mm F/3.5-6.3 Di II LD Aspherical (IF) Macro ",
        [0xF5, 0x40, 0x2C, 0x8A, 0x2C, 0x40, 0x40] => "Tamron AF 18-270mm F/3.5-6.3 Di II VC LD Aspherical (IF) Macro",
        [0xF0, 0x3F, 0x2D, 0x8A, 0x2C, 0x40, 0xDF] => "Tamron AF 18-270mm F/3.5-6.3 Di II VC PZD",
        [0x07, 0x40, 0x2F, 0x44, 0x2C, 0x34, 0x03] => "Tamron AF 19-35mm F/3.5-4.5",
        [0x07, 0x40, 0x30, 0x45, 0x2D, 0x35, 0x03] => "Tamron AF 19-35mm F/3.5-4.5",
        [0x00, 0x49, 0x30, 0x48, 0x22, 0x2B, 0x00] => "Tamron SP AF 20-40mm F/2.7-3.5",
        [0x0E, 0x4A, 0x31, 0x48, 0x23, 0x2D, 0x0E] => "Tamron SP AF 20-40mm F/2.7-3.5",
        [0x45, 0x41, 0x37, 0x72, 0x2C, 0x3C, 0x48] => "Tamron SP AF 24-135mm F/3.5-5.6 AD Aspherical (IF) Macro",
        [0x33, 0x54, 0x3C, 0x5E, 0x24, 0x24, 0x62] => "Tamron SP AF 28-75mm F/2.8 XR Di LD Aspherical (IF) Macro",
        [0xFA, 0x54, 0x3C, 0x5E, 0x24, 0x24, 0x84] => "Tamron SP AF 28-75mm F/2.8 XR Di LD Aspherical (IF) Macro",
        [0x10, 0x3D, 0x3C, 0x60, 0x2C, 0x3C, 0xD2] => "Tamron AF 28-80mm F/3.5-5.6 Aspherical",
        [0x45, 0x3D, 0x3C, 0x60, 0x2C, 0x3C, 0x48] => "Tamron AF 28-80mm F/3.5-5.6 Aspherical",
        [0x00, 0x48, 0x3C, 0x6A, 0x24, 0x24, 0x00] => "Tamron SP AF 28-105mm F/2.8 LD Aspherical IF",
        [0x0B, 0x3E, 0x3D, 0x7F, 0x2F, 0x3D, 0x0E] => "Tamron AF 28-200mm F/3.8-5.6",
        [0x0B, 0x3E, 0x3D, 0x7F, 0x2F, 0x3D, 0x0E] => "Tamron AF 28-200mm F/3.8-5.6D",
        [0x12, 0x3D, 0x3C, 0x80, 0x2E, 0x3C, 0xDF] => "Tamron AF 28-200mm F/3.8-5.6 LD Aspherical (IF)",
        [0x4D, 0x41, 0x3C, 0x8E, 0x2B, 0x40, 0x62] => "Tamron AF 28-300mm F/3.5-6.3 XR Di LD Aspherical (IF)",
        [0x4D, 0x41, 0x3C, 0x8E, 0x2C, 0x40, 0x62] => "Tamron AF 28-300mm F/3.5-6.3 XR LD Aspherical (IF)",
        [0xF9, 0x40, 0x3C, 0x8E, 0x2C, 0x40, 0x40] => "Tamron AF 28-300mm F/3.5-6.3 XR Di VC LD Aspherical (IF) Macro",
        [0x00, 0x47, 0x53, 0x80, 0x30, 0x3C, 0x00] => "Tamron AF 55-200mm F/4-5.6 Di II LD",
        [0xF7, 0x53, 0x5C, 0x80, 0x24, 0x24, 0x84] => "Tamron SP AF 70-200mm F/2.8 Di LD (IF) Macro",
        [0xFE, 0x53, 0x5C, 0x80, 0x24, 0x24, 0x84] => "Tamron SP AF 70-200mm F/2.8 Di LD (IF) Macro",
        [0x69, 0x48, 0x5C, 0x8E, 0x30, 0x3C, 0x6F] => "Tamron AF 70-300mm F/4-5.6 LD Macro 1:2",
        [0x69, 0x47, 0x5C, 0x8E, 0x30, 0x3C, 0x00] => "Tamron AF 70-300mm F/4-5.6 Di LD Macro 1:2",
        [0x00, 0x48, 0x5C, 0x8E, 0x30, 0x3C, 0x00] => "Tamron AF 70-300mm F/4-5.6 Di LD Macro 1:2",
        [0xF1, 0x47, 0x5C, 0x8E, 0x30, 0x3C, 0xDF] => "Tamron SP 70-300mm F4-5.6 Di VC USD",
        [0x20, 0x3C, 0x80, 0x98, 0x3D, 0x3D, 0x1E] => "Tamron AF 200-400mm F/5.6 LD IF",
        [0x00, 0x3E, 0x80, 0xA0, 0x38, 0x3F, 0x00] => "Tamron SP AF 200-500mm F/5-6.3 Di LD (IF)",
        [0x00, 0x3F, 0x80, 0xA0, 0x38, 0x3F, 0x00] => "Tamron SP AF 200-500mm F/5-6.3 Di",
        [0x00, 0x40, 0x2B, 0x2B, 0x2C, 0x2C, 0x00] => "Tokina AT-X 17 AF PRO (AF 17mm f/3.5)",
        [0x00, 0x47, 0x44, 0x44, 0x24, 0x24, 0x00] => "Tokina AT-X M35 PRO DX (AF 35mm f/2.8 Macro)",
        [0x00, 0x54, 0x68, 0x68, 0x24, 0x24, 0x00] => "Tokina AT-X M100 PRO D (AF 100mm f/2.8 Macro)",
        [0x27, 0x48, 0x8E, 0x8E, 0x30, 0x30, 0x1D] => "Tokina AT-X 304 AF (AF 300mm f/4.0)",
        [0x00, 0x54, 0x8E, 0x8E, 0x24, 0x24, 0x00] => "Tokina AT-X 300 AF PRO (AF 300mm f/2.8)",
        [0x12, 0x3B, 0x98, 0x98, 0x3D, 0x3D, 0x09] => "Tokina AT-X 400 AF SD (AF 400mm f/5.6)",
        [0x00, 0x40, 0x18, 0x2B, 0x2C, 0x34, 0x00] => "Tokina AT-X 107 DX Fisheye (AF 10-17mm f/3.5-4.5)",
        [0x00, 0x48, 0x1C, 0x29, 0x24, 0x24, 0x00] => "Tokina AT-X 116 PRO DX (AF 11-16mm f/2.8)",
        [0x00, 0x3C, 0x1F, 0x37, 0x30, 0x30, 0x00] => "Tokina AT-X 124 AF PRO DX (AF 12-24mm f/4)",
        [0x7A, 0x3C, 0x1F, 0x37, 0x30, 0x30, 0x7E] => "Tokina AT-X 124 AF PRO DX II (AF 12-24mm f/4)",
        [0x00, 0x48, 0x29, 0x3C, 0x24, 0x24, 0x00] => "Tokina AT-X 16-28 AF PRO FX (AF 16-28mm f/2.8)",
        [0x00, 0x48, 0x29, 0x50, 0x24, 0x24, 0x00] => "Tokina AT-X 165 PRO DX (AF 16-50mm f/2.8)",
        [0x00, 0x40, 0x2A, 0x72, 0x2C, 0x3C, 0x00] => "Tokina AT-X 16.5-135 DX (AF 16.5-135mm F3.5-5.6)",
        [0x2F, 0x40, 0x30, 0x44, 0x2C, 0x34, 0x29] => "Tokina AF 193 (AF 19-35mm f/3.5-4.5)",
        [0x2F, 0x48, 0x30, 0x44, 0x24, 0x24, 0x29] => "Tokina AT-X 235 AF PRO (AF 20-35mm f/2.8)",
        [0x2F, 0x40, 0x30, 0x44, 0x2C, 0x34, 0x29] => "Tokina AF 235 II (AF 20-35mm f/3.5-4.5)",
        [0x00, 0x40, 0x37, 0x80, 0x2C, 0x3C, 0x00] => "Tokina AT-X 242 AF (AF 24-200mm f/3.5-5.6)",
        [0x25, 0x48, 0x3C, 0x5C, 0x24, 0x24, 0x1B] => "Tokina AT-X 270 AF PRO II (AF 28-70mm f/2.6-2.8)",
        [0x25, 0x48, 0x3C, 0x5C, 0x24, 0x24, 0x1B] => "Tokina AT-X 287 AF PRO SV (AF 28-70mm f/2.8)",
        [0x07, 0x48, 0x3C, 0x5C, 0x24, 0x24, 0x03] => "Tokina AT-X 287 AF (AF 28-70mm f/2.8)",
        [0x07, 0x47, 0x3C, 0x5C, 0x25, 0x35, 0x03] => "Tokina AF 287 SD (AF 28-70mm f/2.8-4.5)",
        [0x07, 0x40, 0x3C, 0x5C, 0x2C, 0x35, 0x03] => "Tokina AF 270 II (AF 28-70mm f/3.5-4.5)",
        [0x00, 0x48, 0x3C, 0x60, 0x24, 0x24, 0x00] => "Tokina AT-X 280 AF PRO (AF 28-80mm f/2.8)",
        [0x25, 0x44, 0x44, 0x8E, 0x34, 0x42, 0x1B] => "Tokina AF 353 (AF 35-300mm f/4.5-6.7)",
        [0x00, 0x48, 0x50, 0x72, 0x24, 0x24, 0x00] => "Tokina AT-X 535 PRO DX (AF 50-135mm f/2.8)",
        [0x12, 0x44, 0x5E, 0x8E, 0x34, 0x3C, 0x09] => "Tokina AF 730 (AF 75-300mm F4.5-5.6)",
        [0x14, 0x54, 0x60, 0x80, 0x24, 0x24, 0x0B] => "Tokina AT-X 828 AF (AF 80-200mm f/2.8)",
        [0x24, 0x54, 0x60, 0x80, 0x24, 0x24, 0x1A] => "Tokina AT-X 828 AF PRO (AF 80-200mm f/2.8)",
        [0x24, 0x44, 0x60, 0x98, 0x34, 0x3C, 0x1A] => "Tokina AT-X 840 AF-II (AF 80-400mm f/4.5-5.6)",
        [0x00, 0x44, 0x60, 0x98, 0x34, 0x3C, 0x00] => "Tokina AT-X 840 D (AF 80-400mm f/4.5-5.6)",
        [0x14, 0x48, 0x68, 0x8E, 0x30, 0x30, 0x0B] => "Tokina AT-X 340 AF (AF 100-300mm f/4)",
        [0x06, 0x3F, 0x68, 0x68, 0x2C, 0x2C, 0x06] => "Cosina AF 100mm F3.5 Macro",
        [0x07, 0x36, 0x3D, 0x5F, 0x2C, 0x3C, 0x03] => "Cosina AF Zoom 28-80mm F3.5-5.6 MC Macro",
        [0x07, 0x46, 0x3D, 0x6A, 0x25, 0x2F, 0x03] => "Cosina AF Zoom 28-105mm F2.8-3.8 MC",
        [0x12, 0x36, 0x5C, 0x81, 0x35, 0x3D, 0x09] => "Cosina AF Zoom 70-210mm F4.5-5.6 MC Macro",
        [0x12, 0x39, 0x5C, 0x8E, 0x34, 0x3D, 0x08] => "Cosina AF Zoom 70-300mm F4.5-5.6 MC Macro",
        [0x12, 0x3B, 0x68, 0x8D, 0x3D, 0x43, 0x09] => "Cosina AF Zoom 100-300mm F5.6-6.7 MC Macro",
        [0x00, 0x40, 0x31, 0x31, 0x2C, 0x2C, 0x00] => "Voigtlander Color Skopar 20mm F3.5 SLII Aspherical",
        [0x00, 0x54, 0x48, 0x48, 0x18, 0x18, 0x00] => "Voigtlander Ultron 40mm F2 SLII Aspherical",
        [0x00, 0x54, 0x55, 0x55, 0x0C, 0x0C, 0x00] => "Voigtlander Nokton 58mm F1.4 SLII",
        [0x00, 0x40, 0x64, 0x64, 0x2C, 0x2C, 0x00] => "Voigtlander APO-Lanthar 90mm F3.5 SLII Close Focus",
        [0x00, 0x40, 0x2D, 0x2D, 0x2C, 0x2C, 0x00] => "Carl Zeiss Distagon T* 3,5/18 ZF.2",
        [0x00, 0x48, 0x32, 0x32, 0x24, 0x24, 0x00] => "Carl Zeiss Distagon T* 2,8/21 ZF.2",
        [0x00, 0x54, 0x3C, 0x3C, 0x18, 0x18, 0x00] => "Carl Zeiss Distagon T* 2/28 ZF.2",
        [0x00, 0x54, 0x44, 0x44, 0x18, 0x18, 0x00] => "Carl Zeiss Distagon T* 2/35 ZF.2",
        [0x00, 0x54, 0x50, 0x50, 0x0C, 0x0C, 0x00] => "Carl Zeiss Planar T* 1,4/50 ZF.2",
        [0x00, 0x54, 0x50, 0x50, 0x18, 0x18, 0x00] => "Carl Zeiss Makro-Planar T* 2/50 ZF.2",
        [0x00, 0x54, 0x62, 0x62, 0x0C, 0x0C, 0x00] => "Carl Zeiss Planar T* 1,4/85 ZF.2",
        [0x00, 0x54, 0x68, 0x68, 0x18, 0x18, 0x00] => "Carl Zeiss Makro-Planar T* 2/100 ZF.2",
        [0x00, 0x54, 0x56, 0x56, 0x30, 0x30, 0x00] => "Coastal Optical Systems 60mm 1:4 UV-VIS-IR Macro Apo",
        [0x4A, 0x48, 0x24, 0x24, 0x24, 0x0C, 0x4D] => "Samyang AE 14mm f/2.8 ED AS IF UMC",
        [0x4A, 0x60, 0x44, 0x44, 0x0C, 0x0C, 0x4D] => "Samyang 35mm f/1.4 AS UMC",
        [0x4A, 0x60, 0x62, 0x62, 0x0C, 0x0C, 0x4D] => "Samyang AE 85mm f/1.4 AS IF UMC",
        [0x02, 0x40, 0x44, 0x5C, 0x2C, 0x34, 0x02] => "Exakta AF 35-70mm 1:3.5-4.5 MC",
        [0x07, 0x3E, 0x30, 0x43, 0x2D, 0x35, 0x03] => "Soligor AF Zoom 19-35mm 1:3.5-4.5 MC",
        [0x03, 0x43, 0x5C, 0x81, 0x35, 0x35, 0x02] => "Soligor AF C/D Zoom UMCS 70-210mm 1:4.5",
        [0x12, 0x4A, 0x5C, 0x81, 0x31, 0x3D, 0x09] => "Soligor AF C/D Auto Zoom+Macro 70-210mm 1:4-5.6 UMCS",
        [0x12, 0x36, 0x69, 0x97, 0x35, 0x42, 0x09] => "Soligor AF Zoom 100-400mm 1:4.5-6.7 MC",
        [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00] => "Manual Lens No CPU",
        [0x00, 0x47, 0x10, 0x10, 0x24, 0x24, 0x00] => "Nikon Fisheye Nikkor 8mm F2.8 AiS",
        [0x00, 0x54, 0x44, 0x44, 0x0C, 0x0C, 0x00] => "Nikon Nikkor 35mm F1.4 AiS",
        [0x00, 0x48, 0x50, 0x50, 0x18, 0x18, 0x00] => "Nikon Nikkor H 50mm F2",
        [0x00, 0x48, 0x68, 0x68, 0x24, 0x24, 0x00] => "Nikon Series E 100mm F2.8",
        [0x00, 0x4C, 0x6A, 0x6A, 0x20, 0x20, 0x00] => "Nikon Nikkor 105mm F2.5 AiS",
        [0x00, 0x48, 0x80, 0x80, 0x30, 0x30, 0x00] => "Nikon Nikkor 200mm F4 AiS",
        [0x00, 0x40, 0x11, 0x11, 0x2C, 0x2C, 0x00] => "Samyang 8mm f/3.5 Fish-Eye",
        [0x00, 0x58, 0x64, 0x64, 0x20, 0x20, 0x00] => "Soligor C/D Macro MC 90mm f/2.5",
        [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00] => ""
      }
    end
  end
end
