package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStorageSetDetails invokes the ecs.DescribeStorageSetDetails API synchronously
func (client *Client) DescribeStorageSetDetails(request *DescribeStorageSetDetailsRequest) (response *DescribeStorageSetDetailsResponse, err error) {
	response = CreateDescribeStorageSetDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStorageSetDetailsWithChan invokes the ecs.DescribeStorageSetDetails API asynchronously
func (client *Client) DescribeStorageSetDetailsWithChan(request *DescribeStorageSetDetailsRequest) (<-chan *DescribeStorageSetDetailsResponse, <-chan error) {
	responseChan := make(chan *DescribeStorageSetDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStorageSetDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStorageSetDetailsWithCallback invokes the ecs.DescribeStorageSetDetails API asynchronously
func (client *Client) DescribeStorageSetDetailsWithCallback(request *DescribeStorageSetDetailsRequest, callback func(response *DescribeStorageSetDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStorageSetDetailsResponse
		var err error
		defer close(result)
		response, err = client.DescribeStorageSetDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStorageSetDetailsRequest is the request struct for api DescribeStorageSetDetails
type DescribeStorageSetDetailsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken               string           `position:"Query" name:"ClientToken"`
	PageNumber                requests.Integer `position:"Query" name:"PageNumber"`
	PageSize                  requests.Integer `position:"Query" name:"PageSize"`
	StorageSetPartitionNumber requests.Integer `position:"Query" name:"StorageSetPartitionNumber"`
	DiskIds                   string           `position:"Query" name:"DiskIds"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	StorageSetId              string           `position:"Query" name:"StorageSetId"`
}

// DescribeStorageSetDetailsResponse is the response struct for api DescribeStorageSetDetails
type DescribeStorageSetDetailsResponse struct {
	*responses.BaseResponse
	PageSize   int                              `json:"PageSize" xml:"PageSize"`
	RequestId  string                           `json:"RequestId" xml:"RequestId"`
	PageNumber int                              `json:"PageNumber" xml:"PageNumber"`
	TotalCount int                              `json:"TotalCount" xml:"TotalCount"`
	Disks      DisksInDescribeStorageSetDetails `json:"Disks" xml:"Disks"`
}

// CreateDescribeStorageSetDetailsRequest creates a request to invoke DescribeStorageSetDetails API
func CreateDescribeStorageSetDetailsRequest() (request *DescribeStorageSetDetailsRequest) {
	request = &DescribeStorageSetDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeStorageSetDetails", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeStorageSetDetailsResponse creates a response to parse from DescribeStorageSetDetails response
func CreateDescribeStorageSetDetailsResponse() (response *DescribeStorageSetDetailsResponse) {
	response = &DescribeStorageSetDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
