/*
    		 Crown Copyright (c) 1997
    
    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-
    
        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;
    
        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;
    
        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;
    
        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/


/* AUTOMATICALLY GENERATED BY make_tdf VERSION 2.0 FROM TDF 4.1 */

#ifndef EXTERNS_INCLUDED
#define EXTERNS_INCLUDED


/* CONSTRUCTS FOR ACCESS */
extern access f_access_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern access f_access_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern access f_add_accesses PROTO_S ( ( access, access ) ) ;
extern access f_constant ;
extern access f_long_jump_access ;
extern access f_no_other_read ;
extern access f_no_other_write ;
extern access f_out_par ;
extern access f_preserve ;
extern access f_register ;
extern access f_standard_access ;
extern access f_used_as_volatile ;
extern access f_visible ;
extern access f_dummy_access ;
extern void init_access PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR ACCESS_OPTION */
extern access_option yes_access_option PROTO_S ( ( access ) ) ;
extern access_option no_access_option ;
extern void init_access_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR AL_TAG */
extern al_tag f_al_tag_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern al_tag f_make_al_tag PROTO_S ( ( tdfint ) ) ;
extern al_tag f_dummy_al_tag ;
extern void init_al_tag PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR AL_TAGDEF */
extern al_tagdef f_make_al_tagdef PROTO_S ( ( tdfint, alignment ) ) ;
extern al_tagdef f_dummy_al_tagdef ;
extern void init_al_tagdef PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR AL_TAGDEF_LIST */
extern al_tagdef_list new_al_tagdef_list PROTO_S ( ( int ) ) ;
extern al_tagdef_list add_al_tagdef_list PROTO_S ( ( al_tagdef_list, al_tagdef, int ) ) ;
extern void init_al_tagdef_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR AL_TAGDEF_PROPS */
extern al_tagdef_props f_make_al_tagdefs PROTO_S ( ( tdfint, al_tagdef_list ) ) ;
extern al_tagdef_props f_dummy_al_tagdef_props ;
extern void init_al_tagdef_props PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR ALIGNMENT */
extern alignment f_alignment_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern alignment f_alignment_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern alignment f_alignment PROTO_S ( ( shape ) ) ;
extern alignment f_alloca_alignment ;
extern alignment f_callees_alignment PROTO_S ( ( bool ) ) ;
extern alignment f_callers_alignment PROTO_S ( ( bool ) ) ;
extern alignment f_code_alignment ;
extern alignment f_locals_alignment ;
extern alignment f_obtain_al_tag PROTO_S ( ( al_tag ) ) ;
extern alignment f_parameter_alignment PROTO_S ( ( shape ) ) ;
extern alignment f_unite_alignments PROTO_S ( ( alignment, alignment ) ) ;
extern alignment f_var_param_alignment ;
extern alignment f_dummy_alignment ;
extern void init_alignment PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR BITFIELD_VARIETY */
extern bitfield_variety f_bfvar_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern bitfield_variety f_bfvar_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern bitfield_variety f_bfvar_bits PROTO_S ( ( bool, nat ) ) ;
extern bitfield_variety f_dummy_bitfield_variety ;
extern void init_bitfield_variety PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR BOOL */
extern bool f_bool_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern bool f_bool_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern bool f_false ;
extern bool f_true ;
extern bool f_dummy_bool ;
extern void init_bool PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR BOOL_OPTION */
extern bool_option yes_bool_option PROTO_S ( ( bool ) ) ;
extern bool_option no_bool_option ;
extern void init_bool_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR CALLEES */
extern callees f_make_callee_list PROTO_S ( ( exp_list ) ) ;
extern callees f_make_dynamic_callees PROTO_S ( ( exp, exp ) ) ;
extern callees f_same_callees ;
extern callees f_dummy_callees ;
extern void init_callees PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR CAPSULE */
extern void start_make_capsule PROTO_S ( ( tdfident_list, capsule_link_list ) ) ;
extern capsule f_make_capsule PROTO_S ( ( tdfident_list, capsule_link_list, extern_link_list, group_list ) ) ;
extern capsule f_dummy_capsule ;
extern void init_capsule PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR CAPSULE_LINK */
extern capsule_link f_make_capsule_link PROTO_S ( ( tdfident, tdfint ) ) ;
extern capsule_link f_dummy_capsule_link ;
extern void init_capsule_link PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR CAPSULE_LINK_LIST */
extern capsule_link_list new_capsule_link_list PROTO_S ( ( int ) ) ;
extern capsule_link_list add_capsule_link_list PROTO_S ( ( capsule_link_list, capsule_link, int ) ) ;
extern void init_capsule_link_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR CASELIM */
extern caselim f_make_caselim PROTO_S ( ( label, signed_nat, signed_nat ) ) ;
extern caselim f_dummy_caselim ;
extern void init_caselim PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR CASELIM_LIST */
extern caselim_list new_caselim_list PROTO_S ( ( int ) ) ;
extern caselim_list add_caselim_list PROTO_S ( ( caselim_list, caselim, int ) ) ;
extern void init_caselim_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG */
extern dg f_dg_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern dg f_make_tag_dg PROTO_S ( ( dg_tag, dg ) ) ;
extern dg f_abortable_part_dg PROTO_S ( ( dg_sourcepos, bool ) ) ;
extern dg f_accept_dg PROTO_S ( ( dg_sourcepos, dg_tag, dg_name_list, bool, dg_tag_option ) ) ;
extern dg f_barrier_dg PROTO_S ( ( dg_sourcepos, dg_tag ) ) ;
extern dg f_branch_dg PROTO_S ( ( dg_sourcepos ) ) ;
extern dg f_call_dg PROTO_S ( ( dg_idname_option, dg_sourcepos, nat_option, dg_tag_option, dg_tag_option ) ) ;
extern dg f_compilation_dg PROTO_S ( ( dg_tag ) ) ;
extern dg f_destructor_dg PROTO_S ( ( dg_sourcepos, exp_option ) ) ;
extern dg f_exception_handler_dg PROTO_S ( ( dg_name_option ) ) ;
extern dg f_exception_scope_dg PROTO_S ( ( dg_tag_list ) ) ;
extern dg f_inline_call_dg PROTO_S ( ( dg_tag, dg_name_list, nat_option ) ) ;
extern dg f_inline_result_dg PROTO_S ( ( dg_tag ) ) ;
extern dg f_inlined_dg PROTO_S ( ( dg, dg_tag ) ) ;
extern dg f_jump_dg PROTO_S ( ( dg_sourcepos ) ) ;
extern dg f_label_dg PROTO_S ( ( dg_idname, dg_sourcepos ) ) ;
extern dg f_lexical_block_dg PROTO_S ( ( dg_idname_option, dg_sourcepos ) ) ;
extern dg f_list_dg PROTO_S ( ( dg_list ) ) ;
extern dg f_long_jump_dg PROTO_S ( ( dg_sourcepos ) ) ;
extern dg f_name_decl_dg PROTO_S ( ( dg_name ) ) ;
extern dg f_params_dg PROTO_S ( ( dg_name_list, exp_option ) ) ;
extern dg f_raise_dg PROTO_S ( ( dg_sourcepos, dg_type_option, exp_option ) ) ;
extern dg f_requeue_dg PROTO_S ( ( dg_sourcepos, dg_tag, bool ) ) ;
extern dg f_rts_call_dg PROTO_S ( ( dg_sourcepos, nat, dg_tag_option, dg_tag_option ) ) ;
extern dg f_select_dg PROTO_S ( ( dg_sourcepos, bool ) ) ;
extern dg f_select_alternative_dg PROTO_S ( ( dg_sourcepos, nat, bool, exp ) ) ;
extern dg f_select_guard_dg PROTO_S ( ( dg_sourcepos, dg_tag ) ) ;
extern dg f_singlestep_dg PROTO_S ( ( dg_sourcepos ) ) ;
extern dg f_source_language_dg PROTO_S ( ( nat ) ) ;
extern dg f_sourcepos_dg PROTO_S ( ( dg_sourcepos ) ) ;
extern dg f_statement_part_dg PROTO_S ( ( dg_tag ) ) ;
extern dg f_test_dg PROTO_S ( ( dg_sourcepos, bool ) ) ;
extern dg f_triggering_alternative_dg PROTO_S ( ( dg_sourcepos, nat, bool ) ) ;
extern dg f_with_dg PROTO_S ( ( dg_type, exp ) ) ;
extern dg f_dummy_dg ;
extern void init_dg PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_ACCESSIBILITY */
extern dg_accessibility f_dg_local_accessibility ;
extern dg_accessibility f_dg_private_accessibility ;
extern dg_accessibility f_dg_protected_accessibility ;
extern dg_accessibility f_dg_public_accessibility ;
extern dg_accessibility f_dummy_dg_accessibility ;
extern void init_dg_accessibility PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_ACCESSIBILITY_OPTION */
extern dg_accessibility_option yes_dg_accessibility_option PROTO_S ( ( dg_accessibility ) ) ;
extern dg_accessibility_option no_dg_accessibility_option ;
extern void init_dg_accessibility_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_APPEND */
extern dg_append f_dg_name_append PROTO_S ( ( dg_tag, dg_name ) ) ;
extern dg_append f_dummy_dg_append ;
extern void init_dg_append PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_APPEND_LIST */
extern dg_append_list new_dg_append_list PROTO_S ( ( int ) ) ;
extern dg_append_list add_dg_append_list PROTO_S ( ( dg_append_list, dg_append, int ) ) ;
extern void init_dg_append_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_BOUND */
extern dg_bound f_dg_dynamic_bound PROTO_S ( ( dg_tag, shape ) ) ;
extern dg_bound f_dg_static_bound PROTO_S ( ( exp ) ) ;
extern dg_bound f_dg_unknown_bound PROTO_S ( ( shape ) ) ;
extern dg_bound f_dummy_dg_bound ;
extern void init_dg_bound PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_CLASS_BASE */
extern dg_class_base f_make_dg_class_base PROTO_S ( ( dg_tag, dg_sourcepos_option, token_option, dg_accessibility_option, dg_virtuality_option ) ) ;
extern dg_class_base f_dummy_dg_class_base ;
extern void init_dg_class_base PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_CLASS_BASE_LIST */
extern dg_class_base_list new_dg_class_base_list PROTO_S ( ( int ) ) ;
extern dg_class_base_list add_dg_class_base_list PROTO_S ( ( dg_class_base_list, dg_class_base, int ) ) ;
extern void init_dg_class_base_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_CLASSMEM */
extern dg_classmem f_dg_tag_classmem PROTO_S ( ( dg_tag, dg_classmem ) ) ;
extern dg_classmem f_dg_field_classmem PROTO_S ( ( dg_idname, dg_sourcepos, exp, dg_type, dg_accessibility_option, bool_option, dg_default_option ) ) ;
extern dg_classmem f_dg_function_classmem PROTO_S ( ( dg_name, exp_option ) ) ;
extern dg_classmem f_dg_indirect_classmem PROTO_S ( ( dg_idname, dg_sourcepos, token, dg_type ) ) ;
extern dg_classmem f_dg_name_classmem PROTO_S ( ( dg_name ) ) ;
extern dg_classmem f_dummy_dg_classmem ;
extern void init_dg_classmem PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_CLASSMEM_LIST */
extern dg_classmem_list new_dg_classmem_list PROTO_S ( ( int ) ) ;
extern dg_classmem_list add_dg_classmem_list PROTO_S ( ( dg_classmem_list, dg_classmem, int ) ) ;
extern void init_dg_classmem_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_COMP_PROPS */
extern dg_comp_props f_make_dg_compunit PROTO_S ( ( tdfint, dg_compilation, dg_append_list ) ) ;
extern dg_comp_props f_dummy_dg_comp_props ;
extern void init_dg_comp_props PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_COMPILATION */
extern dg_compilation f_dg_tag_compilation PROTO_S ( ( dg_tag, dg_compilation ) ) ;
extern dg_compilation f_make_dg_compilation PROTO_S ( ( dg_filename, string_list, dg_macro_list, dg_filename, nat, nat, nat, string, string_list, dg_namelist ) ) ;
extern dg_compilation f_dummy_dg_compilation ;
extern void init_dg_compilation PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_CONSTRAINT */
extern dg_constraint f_dg_type_constraint PROTO_S ( ( dg_tag_option, dg_type ) ) ;
extern dg_constraint f_dg_value_constraint PROTO_S ( ( dg_tag_option, exp ) ) ;
extern dg_constraint f_dummy_dg_constraint ;
extern void init_dg_constraint PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_CONSTRAINT_LIST */
extern dg_constraint_list new_dg_constraint_list PROTO_S ( ( int ) ) ;
extern dg_constraint_list add_dg_constraint_list PROTO_S ( ( dg_constraint_list, dg_constraint, int ) ) ;
extern void init_dg_constraint_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_CONSTRAINT_LIST_OPTION */
extern dg_constraint_list_option yes_dg_constraint_list_option PROTO_S ( ( dg_constraint_list ) ) ;
extern dg_constraint_list_option no_dg_constraint_list_option ;
extern void init_dg_constraint_list_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_DEFAULT */
extern dg_default f_make_dg_default PROTO_S ( ( exp_option, dg_sourcepos_option ) ) ;
extern dg_default f_dummy_dg_default ;
extern void init_dg_default PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_DEFAULT_OPTION */
extern dg_default_option yes_dg_default_option PROTO_S ( ( dg_default ) ) ;
extern dg_default_option no_dg_default_option ;
extern void init_dg_default_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_DIM */
extern dg_dim f_dg_dim_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern dg_dim f_dg_tag_dim PROTO_S ( ( dg_tag, dg_dim ) ) ;
extern dg_dim f_dg_bounds_dim PROTO_S ( ( dg_bound, dg_bound, dg_type ) ) ;
extern dg_dim f_dg_count_dim PROTO_S ( ( dg_bound, dg_bound, dg_type ) ) ;
extern dg_dim f_dg_type_dim PROTO_S ( ( dg_type, nat_option ) ) ;
extern dg_dim f_dg_unspecified_dim ;
extern dg_dim f_dummy_dg_dim ;
extern void init_dg_dim PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_DIM_LIST */
extern dg_dim_list new_dg_dim_list PROTO_S ( ( int ) ) ;
extern dg_dim_list add_dg_dim_list PROTO_S ( ( dg_dim_list, dg_dim, int ) ) ;
extern void init_dg_dim_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_DIM_OPTION */
extern dg_dim_option yes_dg_dim_option PROTO_S ( ( dg_dim ) ) ;
extern dg_dim_option no_dg_dim_option ;
extern void init_dg_dim_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_DISCRIM */
extern dg_discrim f_make_dg_discrim PROTO_S ( ( exp, exp ) ) ;
extern dg_discrim f_dummy_dg_discrim ;
extern void init_dg_discrim PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_DISCRIM_LIST */
extern dg_discrim_list new_dg_discrim_list PROTO_S ( ( int ) ) ;
extern dg_discrim_list add_dg_discrim_list PROTO_S ( ( dg_discrim_list, dg_discrim, int ) ) ;
extern void init_dg_discrim_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_ENUM */
extern dg_enum f_dg_tag_enum PROTO_S ( ( dg_tag, dg_enum ) ) ;
extern dg_enum f_make_dg_enum PROTO_S ( ( exp, dg_idname, dg_sourcepos ) ) ;
extern dg_enum f_dg_char_enum PROTO_S ( ( exp, nat, dg_sourcepos ) ) ;
extern dg_enum f_dummy_dg_enum ;
extern void init_dg_enum PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_ENUM_LIST */
extern dg_enum_list new_dg_enum_list PROTO_S ( ( int ) ) ;
extern dg_enum_list add_dg_enum_list PROTO_S ( ( dg_enum_list, dg_enum, int ) ) ;
extern void init_dg_enum_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_FILENAME */
extern dg_filename f_dg_filename_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern dg_filename f_make_dg_filename PROTO_S ( ( nat, string, string, string ) ) ;
extern dg_filename f_dummy_dg_filename ;
extern void init_dg_filename PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_FILENAME_OPTION */
extern dg_filename_option yes_dg_filename_option PROTO_S ( ( dg_filename ) ) ;
extern dg_filename_option no_dg_filename_option ;
extern void init_dg_filename_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_IDNAME */
extern dg_idname f_dg_idname_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern dg_idname f_dg_anonymous_idname PROTO_S ( ( string_option ) ) ;
extern dg_idname f_dg_artificial_idname PROTO_S ( ( string_option ) ) ;
extern dg_idname f_dg_external_idname PROTO_S ( ( string ) ) ;
extern dg_idname f_dg_instance_idname PROTO_S ( ( dg_idname_option, dg_idname, dg_sourcepos, dg_name_list ) ) ;
extern dg_idname f_dg_sourcestring_idname PROTO_S ( ( string ) ) ;
extern dg_idname f_dummy_dg_idname ;
extern void init_dg_idname PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_IDNAME_LIST */
extern dg_idname_list new_dg_idname_list PROTO_S ( ( int ) ) ;
extern dg_idname_list add_dg_idname_list PROTO_S ( ( dg_idname_list, dg_idname, int ) ) ;
extern void init_dg_idname_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_IDNAME_OPTION */
extern dg_idname_option yes_dg_idname_option PROTO_S ( ( dg_idname ) ) ;
extern dg_idname_option no_dg_idname_option ;
extern void init_dg_idname_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_LIST */
extern dg_list new_dg_list PROTO_S ( ( int ) ) ;
extern dg_list add_dg_list PROTO_S ( ( dg_list, dg, int ) ) ;
extern void init_dg_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_MACRO */
extern dg_macro f_dg_function_macro PROTO_S ( ( dg_sourcepos, dg_idname, dg_idname_list, string ) ) ;
extern dg_macro f_dg_include_macro PROTO_S ( ( dg_sourcepos, dg_filename, dg_macro_list ) ) ;
extern dg_macro f_dg_object_macro PROTO_S ( ( dg_sourcepos, dg_idname, string ) ) ;
extern dg_macro f_dg_undef_macro PROTO_S ( ( dg_sourcepos, dg_idname ) ) ;
extern dg_macro f_dummy_dg_macro ;
extern void init_dg_macro PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_MACRO_LIST */
extern dg_macro_list new_dg_macro_list PROTO_S ( ( int ) ) ;
extern dg_macro_list add_dg_macro_list PROTO_S ( ( dg_macro_list, dg_macro, int ) ) ;
extern void init_dg_macro_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_NAME */
extern dg_name f_dg_name_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern dg_name f_dg_tag_name PROTO_S ( ( dg_tag, dg_name ) ) ;
extern dg_name f_dg_constant_name PROTO_S ( ( dg_name ) ) ;
extern dg_name f_dg_entry_family_name PROTO_S ( ( dg_name, dg_dim ) ) ;
extern dg_name f_dg_entry_name PROTO_S ( ( dg_idname, dg_sourcepos, dg_type, dg_accessibility_option, dg_dim_option ) ) ;
extern dg_name f_dg_inlined_name PROTO_S ( ( dg_name, dg_tag ) ) ;
extern dg_name f_dg_is_spec_name PROTO_S ( ( dg_name, bool_option ) ) ;
extern dg_name f_dg_module_name PROTO_S ( ( dg_idname, dg_sourcepos, dg_namelist, exp_option, dg_tag_option ) ) ;
extern dg_name f_dg_namespace_name PROTO_S ( ( dg_idname, dg_sourcepos, dg_namelist ) ) ;
extern dg_name f_dg_object_name PROTO_S ( ( dg_idname, dg_sourcepos, dg_type, exp_option, dg_accessibility_option ) ) ;
extern dg_name f_dg_proc_name PROTO_S ( ( dg_idname, dg_sourcepos, dg_type, exp_option, dg_accessibility_option, dg_virtuality_option, bool, dg_type_list_option, dg_tag_option ) ) ;
extern dg_name f_dg_program_name PROTO_S ( ( dg_idname, dg_sourcepos, exp ) ) ;
extern dg_name f_dg_rep_clause_name PROTO_S ( ( dg_name, exp ) ) ;
extern dg_name f_dg_spec_ref_name PROTO_S ( ( dg_tag, dg_name ) ) ;
extern dg_name f_dg_subunit_name PROTO_S ( ( dg_tag, dg_name, nat, dg_accessibility_option ) ) ;
extern dg_name f_dg_type_name PROTO_S ( ( dg_idname_option, dg_sourcepos, dg_accessibility_option, dg_type_option, bool, bool_option, dg_constraint_list_option ) ) ;
extern dg_name f_dg_visibility_name PROTO_S ( ( dg_tag, nat, dg_idname_option, dg_sourcepos_option, dg_accessibility_option, dg_type_option ) ) ;
extern dg_name f_dummy_dg_name ;
extern void init_dg_name PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_NAME_LIST */
extern dg_name_list new_dg_name_list PROTO_S ( ( int ) ) ;
extern dg_name_list add_dg_name_list PROTO_S ( ( dg_name_list, dg_name, int ) ) ;
extern void init_dg_name_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_NAME_OPTION */
extern dg_name_option yes_dg_name_option PROTO_S ( ( dg_name ) ) ;
extern dg_name_option no_dg_name_option ;
extern void init_dg_name_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_NAMELIST */
extern dg_namelist f_dg_tag_namelist PROTO_S ( ( dg_tag, dg_namelist ) ) ;
extern dg_namelist f_make_dg_namelist PROTO_S ( ( dg_name_list ) ) ;
extern dg_namelist f_dummy_dg_namelist ;
extern void init_dg_namelist PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_PARAM */
extern dg_param f_dg_object_param PROTO_S ( ( dg_idname_option, dg_sourcepos_option, dg_param_mode_option, dg_type, dg_default_option ) ) ;
extern dg_param f_dg_type_param PROTO_S ( ( dg_idname_option, dg_sourcepos_option, dg_param_list ) ) ;
extern dg_param f_dummy_dg_param ;
extern void init_dg_param PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_PARAM_LIST */
extern dg_param_list new_dg_param_list PROTO_S ( ( int ) ) ;
extern dg_param_list add_dg_param_list PROTO_S ( ( dg_param_list, dg_param, int ) ) ;
extern void init_dg_param_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_PARAM_MODE */
extern dg_param_mode f_dg_in_mode ;
extern dg_param_mode f_dg_inout_mode ;
extern dg_param_mode f_dg_out_mode ;
extern dg_param_mode f_dummy_dg_param_mode ;
extern void init_dg_param_mode PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_PARAM_MODE_OPTION */
extern dg_param_mode_option yes_dg_param_mode_option PROTO_S ( ( dg_param_mode ) ) ;
extern dg_param_mode_option no_dg_param_mode_option ;
extern void init_dg_param_mode_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_QUALIFIER */
extern dg_qualifier f_dg_aliased_qualifier ;
extern dg_qualifier f_dg_class_wide_qualifier ;
extern dg_qualifier f_dg_const_qualifier ;
extern dg_qualifier f_dg_limited_qualifier ;
extern dg_qualifier f_dg_volatile_qualifier ;
extern dg_qualifier f_dummy_dg_qualifier ;
extern void init_dg_qualifier PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_SOURCEPOS */
extern dg_sourcepos f_dg_file_sourcepos PROTO_S ( ( dg_filename ) ) ;
extern dg_sourcepos f_dg_global_sourcepos ;
extern dg_sourcepos f_dg_mark_sourcepos PROTO_S ( ( dg_filename, nat, nat ) ) ;
extern dg_sourcepos f_dg_null_sourcepos ;
extern dg_sourcepos f_dg_span_sourcepos PROTO_S ( ( dg_filename, nat, nat, dg_filename_option, nat, nat ) ) ;
extern dg_sourcepos f_dummy_dg_sourcepos ;
extern void init_dg_sourcepos PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_SOURCEPOS_OPTION */
extern dg_sourcepos_option yes_dg_sourcepos_option PROTO_S ( ( dg_sourcepos ) ) ;
extern dg_sourcepos_option no_dg_sourcepos_option ;
extern void init_dg_sourcepos_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_TAG */
extern dg_tag f_make_dg_tag PROTO_S ( ( tdfint ) ) ;
extern dg_tag f_dummy_dg_tag ;
extern void init_dg_tag PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_TAG_LIST */
extern dg_tag_list new_dg_tag_list PROTO_S ( ( int ) ) ;
extern dg_tag_list add_dg_tag_list PROTO_S ( ( dg_tag_list, dg_tag, int ) ) ;
extern void init_dg_tag_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_TAG_OPTION */
extern dg_tag_option yes_dg_tag_option PROTO_S ( ( dg_tag ) ) ;
extern dg_tag_option no_dg_tag_option ;
extern void init_dg_tag_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_TYPE */
extern dg_type f_dg_type_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern dg_type f_dg_tag_type PROTO_S ( ( dg_tag, dg_type ) ) ;
extern dg_type f_dg_address_type PROTO_S ( ( dg_idname, shape ) ) ;
extern dg_type f_dg_array_type PROTO_S ( ( dg_type, exp, bool_option, dg_dim_list ) ) ;
extern dg_type f_dg_bitfield_type PROTO_S ( ( dg_type, bitfield_variety, shape ) ) ;
extern dg_type f_dg_boolean_type PROTO_S ( ( dg_idname, variety ) ) ;
extern dg_type f_dg_char_type PROTO_S ( ( dg_idname, variety ) ) ;
extern dg_type f_dg_class_type PROTO_S ( ( dg_class_base_list, dg_classmem_list, dg_varpart_option, dg_tag_list, shape_option, dg_tag_option, dg_tag_option, dg_idname_option, dg_sourcepos_option, bool, dg_tag_option, dg_tag_option, bool, bool_option ) ) ;
extern dg_type f_dg_complex_float_type PROTO_S ( ( dg_idname, floating_variety ) ) ;
extern dg_type f_dg_enum_type PROTO_S ( ( dg_enum_list, dg_idname_option, dg_sourcepos_option, shape, bool ) ) ;
extern dg_type f_dg_file_type PROTO_S ( ( dg_type, shape ) ) ;
extern dg_type f_dg_fixed_point_type PROTO_S ( ( dg_type, exp, exp_option, exp_option ) ) ;
extern dg_type f_dg_float_type PROTO_S ( ( dg_idname, floating_variety ) ) ;
extern dg_type f_dg_floating_digits_type PROTO_S ( ( dg_type, exp ) ) ;
extern dg_type f_dg_inlined_type PROTO_S ( ( dg_type, dg_tag ) ) ;
extern dg_type f_dg_integer_type PROTO_S ( ( dg_idname, variety ) ) ;
extern dg_type f_dg_is_spec_type PROTO_S ( ( dg_type ) ) ;
extern dg_type f_dg_modular_type PROTO_S ( ( dg_type, exp ) ) ;
extern dg_type f_dg_named_type PROTO_S ( ( dg_tag ) ) ;
extern dg_type f_dg_packed_type PROTO_S ( ( dg_type, shape ) ) ;
extern dg_type f_dg_pointer_type PROTO_S ( ( dg_type, bool_option ) ) ;
extern dg_type f_dg_proc_type PROTO_S ( ( dg_param_list, dg_type, bool_option, nat_option, nat_option, procprops_option ) ) ;
extern dg_type f_dg_ptr_memdata_type PROTO_S ( ( dg_tag, dg_type, shape, dg_tag_option ) ) ;
extern dg_type f_dg_ptr_memfn_type PROTO_S ( ( dg_tag, dg_type, shape, dg_tag_option ) ) ;
extern dg_type f_dg_qualified_type PROTO_S ( ( dg_qualifier, dg_type ) ) ;
extern dg_type f_dg_reference_type PROTO_S ( ( dg_type ) ) ;
extern dg_type f_dg_set_type PROTO_S ( ( dg_type, shape ) ) ;
extern dg_type f_dg_spec_ref_type PROTO_S ( ( dg_tag, dg_type ) ) ;
extern dg_type f_dg_string_type PROTO_S ( ( dg_tag, exp, exp ) ) ;
extern dg_type f_dg_struct_type PROTO_S ( ( dg_classmem_list, shape_option, dg_idname_option, dg_sourcepos_option, dg_varpart_option, bool, bool ) ) ;
extern dg_type f_dg_subrange_type PROTO_S ( ( dg_type, dg_bound, dg_bound ) ) ;
extern dg_type f_dg_synchronous_type PROTO_S ( ( dg_idname, dg_sourcepos, dg_name_list, dg_tag, dg_classmem_list, dg_varpart_option, shape_option, bool, dg_tag_option ) ) ;
extern dg_type f_dg_task_type PROTO_S ( ( dg_idname, dg_sourcepos, dg_name_list, dg_tag, dg_tag, dg_classmem_list, dg_varpart_option, shape_option, bool, dg_tag_option ) ) ;
extern dg_type f_dg_unknown_type PROTO_S ( ( shape ) ) ;
extern dg_type f_dg_void_type ;
extern dg_type f_dummy_dg_type ;
extern void init_dg_type PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_TYPE_LIST */
extern dg_type_list new_dg_type_list PROTO_S ( ( int ) ) ;
extern dg_type_list add_dg_type_list PROTO_S ( ( dg_type_list, dg_type, int ) ) ;
extern void init_dg_type_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_TYPE_LIST_OPTION */
extern dg_type_list_option yes_dg_type_list_option PROTO_S ( ( dg_type_list ) ) ;
extern dg_type_list_option no_dg_type_list_option ;
extern void init_dg_type_list_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_TYPE_OPTION */
extern dg_type_option yes_dg_type_option PROTO_S ( ( dg_type ) ) ;
extern dg_type_option no_dg_type_option ;
extern void init_dg_type_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_VARIANT */
extern dg_variant f_make_dg_variant PROTO_S ( ( dg_discrim_list, dg_classmem_list ) ) ;
extern dg_variant f_dummy_dg_variant ;
extern void init_dg_variant PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_VARIANT_LIST */
extern dg_variant_list new_dg_variant_list PROTO_S ( ( int ) ) ;
extern dg_variant_list add_dg_variant_list PROTO_S ( ( dg_variant_list, dg_variant, int ) ) ;
extern void init_dg_variant_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_VARPART */
extern dg_varpart f_dg_discrim_varpart PROTO_S ( ( dg_classmem, dg_variant_list ) ) ;
extern dg_varpart f_dg_sibl_discrim_varpart PROTO_S ( ( dg_tag, dg_variant_list ) ) ;
extern dg_varpart f_dg_undiscrim_varpart PROTO_S ( ( dg_type, dg_variant_list ) ) ;
extern dg_varpart f_dummy_dg_varpart ;
extern void init_dg_varpart PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_VARPART_OPTION */
extern dg_varpart_option yes_dg_varpart_option PROTO_S ( ( dg_varpart ) ) ;
extern dg_varpart_option no_dg_varpart_option ;
extern void init_dg_varpart_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_VIRTUALITY */
extern dg_virtuality f_dg_abstract_virtuality ;
extern dg_virtuality f_dg_virtual_virtuality ;
extern dg_virtuality f_dummy_dg_virtuality ;
extern void init_dg_virtuality PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DG_VIRTUALITY_OPTION */
extern dg_virtuality_option yes_dg_virtuality_option PROTO_S ( ( dg_virtuality ) ) ;
extern dg_virtuality_option no_dg_virtuality_option ;
extern void init_dg_virtuality_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_DESCRIPTOR */
extern diag_descriptor f_diag_desc_id PROTO_S ( ( tdfstring, sourcemark, exp, diag_type ) ) ;
extern diag_descriptor f_diag_desc_struct PROTO_S ( ( tdfstring, sourcemark, diag_type ) ) ;
extern diag_descriptor f_diag_desc_typedef PROTO_S ( ( tdfstring, sourcemark, diag_type ) ) ;
extern diag_descriptor f_dummy_diag_descriptor ;
extern void init_diag_descriptor PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_DESCRIPTOR_LIST */
extern diag_descriptor_list new_diag_descriptor_list PROTO_S ( ( int ) ) ;
extern diag_descriptor_list add_diag_descriptor_list PROTO_S ( ( diag_descriptor_list, diag_descriptor, int ) ) ;
extern void init_diag_descriptor_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_FIELD */
extern diag_field f_make_diag_field PROTO_S ( ( tdfstring, exp, diag_type ) ) ;
extern diag_field f_dummy_diag_field ;
extern void init_diag_field PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_FIELD_LIST */
extern diag_field_list new_diag_field_list PROTO_S ( ( int ) ) ;
extern diag_field_list add_diag_field_list PROTO_S ( ( diag_field_list, diag_field, int ) ) ;
extern void init_diag_field_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_TAG */
extern diag_tag f_make_diag_tag PROTO_S ( ( tdfint ) ) ;
extern diag_tag f_dummy_diag_tag ;
extern void init_diag_tag PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_TAGDEF */
extern diag_tagdef f_make_diag_tagdef PROTO_S ( ( tdfint, diag_type ) ) ;
extern diag_tagdef f_dummy_diag_tagdef ;
extern void init_diag_tagdef PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_TAGDEF_LIST */
extern diag_tagdef_list new_diag_tagdef_list PROTO_S ( ( int ) ) ;
extern diag_tagdef_list add_diag_tagdef_list PROTO_S ( ( diag_tagdef_list, diag_tagdef, int ) ) ;
extern void init_diag_tagdef_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_TQ */
extern diag_tq f_add_diag_const PROTO_S ( ( diag_tq ) ) ;
extern diag_tq f_add_diag_volatile PROTO_S ( ( diag_tq ) ) ;
extern diag_tq f_diag_tq_null ;
extern diag_tq f_dummy_diag_tq ;
extern void init_diag_tq PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_TYPE */
extern diag_type f_diag_type_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern diag_type f_diag_array PROTO_S ( ( diag_type, exp, exp, exp, diag_type ) ) ;
extern diag_type f_diag_bitfield PROTO_S ( ( diag_type, nat ) ) ;
extern diag_type f_diag_enum PROTO_S ( ( diag_type, tdfstring, enum_values_list ) ) ;
extern diag_type f_diag_floating_variety PROTO_S ( ( floating_variety ) ) ;
extern diag_type f_diag_loc PROTO_S ( ( diag_type, diag_tq ) ) ;
extern diag_type f_diag_proc PROTO_S ( ( diag_type_list, bool, diag_type ) ) ;
extern diag_type f_diag_ptr PROTO_S ( ( diag_type, diag_tq ) ) ;
extern diag_type f_diag_struct PROTO_S ( ( shape, tdfstring, diag_field_list ) ) ;
extern diag_type f_diag_type_null ;
extern diag_type f_diag_union PROTO_S ( ( shape, tdfstring, diag_field_list ) ) ;
extern diag_type f_diag_variety PROTO_S ( ( variety ) ) ;
extern diag_type f_use_diag_tag PROTO_S ( ( diag_tag ) ) ;
extern diag_type f_dummy_diag_type ;
extern void init_diag_type PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_TYPE_LIST */
extern diag_type_list new_diag_type_list PROTO_S ( ( int ) ) ;
extern diag_type_list add_diag_type_list PROTO_S ( ( diag_type_list, diag_type, int ) ) ;
extern void init_diag_type_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_TYPE_UNIT */
extern diag_type_unit f_build_diagtype_unit PROTO_S ( ( tdfint, diag_tagdef_list ) ) ;
extern diag_type_unit f_dummy_diag_type_unit ;
extern void init_diag_type_unit PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR DIAG_UNIT */
extern diag_unit f_build_diag_unit PROTO_S ( ( tdfint, diag_descriptor_list ) ) ;
extern diag_unit f_dummy_diag_unit ;
extern void init_diag_unit PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR ENUM_VALUES */
extern enum_values f_make_enum_values PROTO_S ( ( exp, tdfstring ) ) ;
extern enum_values f_dummy_enum_values ;
extern void init_enum_values PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR ENUM_VALUES_LIST */
extern enum_values_list new_enum_values_list PROTO_S ( ( int ) ) ;
extern enum_values_list add_enum_values_list PROTO_S ( ( enum_values_list, enum_values, int ) ) ;
extern void init_enum_values_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR ERROR_CODE */
extern error_code f_nil_access ;
extern error_code f_overflow ;
extern error_code f_stack_overflow ;
extern error_code f_dummy_error_code ;
extern void init_error_code PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR ERROR_CODE_LIST */
extern error_code_list new_error_code_list PROTO_S ( ( int ) ) ;
extern error_code_list add_error_code_list PROTO_S ( ( error_code_list, error_code, int ) ) ;
extern void init_error_code_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR ERROR_TREATMENT */
extern error_treatment f_errt_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern error_treatment f_errt_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern error_treatment f_continue ;
extern error_treatment f_error_jump PROTO_S ( ( label ) ) ;
extern error_treatment f_trap PROTO_S ( ( error_code_list ) ) ;
extern error_treatment f_wrap ;
extern error_treatment f_impossible ;
extern error_treatment f_dummy_error_treatment ;
extern void init_error_treatment PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR EXP */
extern exp f_exp_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern exp f_exp_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern exp f_abs PROTO_S ( ( error_treatment, exp ) ) ;
extern exp f_add_to_ptr PROTO_S ( ( exp, exp ) ) ;
extern exp f_and PROTO_S ( ( exp, exp ) ) ;
extern exp f_apply_proc PROTO_S ( ( shape, exp, exp_list, exp_option ) ) ;
extern void start_apply_general_proc PROTO_S ( ( shape, procprops_option, exp, otagexp_list, callees ) ) ;
extern exp f_apply_general_proc PROTO_S ( ( shape, procprops_option, exp, otagexp_list, callees, exp ) ) ;
extern exp f_assign PROTO_S ( ( exp, exp ) ) ;
extern exp f_assign_with_mode PROTO_S ( ( transfer_mode, exp, exp ) ) ;
extern exp f_bitfield_assign PROTO_S ( ( exp, exp, exp ) ) ;
extern exp f_bitfield_assign_with_mode PROTO_S ( ( transfer_mode, exp, exp, exp ) ) ;
extern exp f_bitfield_contents PROTO_S ( ( bitfield_variety, exp, exp ) ) ;
extern exp f_bitfield_contents_with_mode PROTO_S ( ( transfer_mode, bitfield_variety, exp, exp ) ) ;
extern exp f_case PROTO_S ( ( bool, exp, caselim_list ) ) ;
extern exp f_change_bitfield_to_int PROTO_S ( ( variety, exp ) ) ;
extern exp f_change_floating_variety PROTO_S ( ( error_treatment, floating_variety, exp ) ) ;
extern exp f_change_variety PROTO_S ( ( error_treatment, variety, exp ) ) ;
extern exp f_change_int_to_bitfield PROTO_S ( ( bitfield_variety, exp ) ) ;
extern exp f_complex_conjugate PROTO_S ( ( exp ) ) ;
extern exp f_component PROTO_S ( ( shape, exp, exp ) ) ;
extern exp f_concat_nof PROTO_S ( ( exp, exp ) ) ;
extern void start_conditional PROTO_S ( ( label ) ) ;
extern exp f_conditional PROTO_S ( ( label, exp, exp ) ) ;
extern exp f_contents PROTO_S ( ( shape, exp ) ) ;
extern exp f_contents_with_mode PROTO_S ( ( transfer_mode, shape, exp ) ) ;
extern exp f_current_env PROTO_S ( ( void ) ) ;
extern exp f_div0 PROTO_S ( ( error_treatment, error_treatment, exp, exp ) ) ;
extern exp f_div1 PROTO_S ( ( error_treatment, error_treatment, exp, exp ) ) ;
extern exp f_div2 PROTO_S ( ( error_treatment, error_treatment, exp, exp ) ) ;
extern exp f_env_offset PROTO_S ( ( alignment, alignment, tag ) ) ;
extern exp f_env_size PROTO_S ( ( tag ) ) ;
extern exp f_fail_installer PROTO_S ( ( string ) ) ;
extern exp f_float_int PROTO_S ( ( error_treatment, floating_variety, exp ) ) ;
extern exp f_floating_abs PROTO_S ( ( error_treatment, exp ) ) ;
extern exp f_floating_div PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_floating_minus PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_floating_maximum PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_floating_minimum PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_floating_mult PROTO_S ( ( error_treatment, exp_list ) ) ;
extern exp f_floating_negate PROTO_S ( ( error_treatment, exp ) ) ;
extern exp f_floating_plus PROTO_S ( ( error_treatment, exp_list ) ) ;
extern exp f_floating_power PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_floating_test PROTO_S ( ( nat_option, error_treatment, ntest, label, exp, exp ) ) ;
extern exp f_goto PROTO_S ( ( label ) ) ;
extern exp f_goto_local_lv PROTO_S ( ( exp ) ) ;
extern void start_identify PROTO_S ( ( access_option, tag, exp ) ) ;
extern exp f_identify PROTO_S ( ( access_option, tag, exp, exp ) ) ;
extern exp f_ignorable PROTO_S ( ( exp ) ) ;
extern exp f_imaginary_part PROTO_S ( ( exp ) ) ;
extern void start_initial_value PROTO_S ( ( void ) ) ;
extern exp f_initial_value PROTO_S ( ( exp ) ) ;
extern exp f_integer_test PROTO_S ( ( nat_option, ntest, label, exp, exp ) ) ;
extern void start_labelled PROTO_S ( ( label_list ) ) ;
extern exp f_labelled PROTO_S ( ( label_list, exp, exp_list ) ) ;
extern exp f_last_local PROTO_S ( ( exp ) ) ;
extern exp f_local_alloc PROTO_S ( ( exp ) ) ;
extern exp f_local_alloc_check PROTO_S ( ( exp ) ) ;
extern exp f_local_free PROTO_S ( ( exp, exp ) ) ;
extern exp f_local_free_all PROTO_S ( ( void ) ) ;
extern exp f_long_jump PROTO_S ( ( exp, exp ) ) ;
extern exp f_make_complex PROTO_S ( ( floating_variety, exp, exp ) ) ;
extern exp f_make_compound PROTO_S ( ( exp, exp_list ) ) ;
extern exp f_make_floating PROTO_S ( ( floating_variety, rounding_mode, bool, string, nat, signed_nat ) ) ;
extern void start_make_general_proc PROTO_S ( ( shape, procprops_option, tagshacc_list, tagshacc_list ) ) ;
extern exp f_make_general_proc PROTO_S ( ( shape, procprops_option, tagshacc_list, tagshacc_list, exp ) ) ;
extern exp f_make_int PROTO_S ( ( variety, signed_nat ) ) ;
extern exp f_make_local_lv PROTO_S ( ( label ) ) ;
extern exp f_make_nof PROTO_S ( ( exp_list ) ) ;
extern exp f_make_nof_int PROTO_S ( ( variety, string ) ) ;
extern exp f_make_null_local_lv PROTO_S ( ( void ) ) ;
extern exp f_make_null_proc PROTO_S ( ( void ) ) ;
extern exp f_make_null_ptr PROTO_S ( ( alignment ) ) ;
extern void start_make_proc PROTO_S ( ( shape, tagshacc_list, tagacc_option ) ) ;
extern exp f_make_proc PROTO_S ( ( shape, tagshacc_list, tagacc_option, exp ) ) ;
extern exp f_make_stack_limit PROTO_S ( ( exp, exp, exp ) ) ;
extern exp f_make_top PROTO_S ( ( void ) ) ;
extern exp f_make_value PROTO_S ( ( shape ) ) ;
extern exp f_maximum PROTO_S ( ( exp, exp ) ) ;
extern exp f_minimum PROTO_S ( ( exp, exp ) ) ;
extern exp f_minus PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_move_some PROTO_S ( ( transfer_mode, exp, exp, exp ) ) ;
extern exp f_mult PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_n_copies PROTO_S ( ( nat, exp ) ) ;
extern exp f_negate PROTO_S ( ( error_treatment, exp ) ) ;
extern exp f_not PROTO_S ( ( exp ) ) ;
extern exp f_obtain_tag PROTO_S ( ( tag ) ) ;
extern exp f_offset_add PROTO_S ( ( exp, exp ) ) ;
extern exp f_offset_div PROTO_S ( ( variety, exp, exp ) ) ;
extern exp f_offset_div_by_int PROTO_S ( ( exp, exp ) ) ;
extern exp f_offset_max PROTO_S ( ( exp, exp ) ) ;
extern exp f_offset_mult PROTO_S ( ( exp, exp ) ) ;
extern exp f_offset_negate PROTO_S ( ( exp ) ) ;
extern exp f_offset_pad PROTO_S ( ( alignment, exp ) ) ;
extern exp f_offset_subtract PROTO_S ( ( exp, exp ) ) ;
extern exp f_offset_test PROTO_S ( ( nat_option, ntest, label, exp, exp ) ) ;
extern exp f_offset_zero PROTO_S ( ( alignment ) ) ;
extern exp f_or PROTO_S ( ( exp, exp ) ) ;
extern exp f_plus PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_pointer_test PROTO_S ( ( nat_option, ntest, label, exp, exp ) ) ;
extern exp f_power PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_proc_test PROTO_S ( ( nat_option, ntest, label, exp, exp ) ) ;
extern exp f_profile PROTO_S ( ( nat ) ) ;
extern exp f_real_part PROTO_S ( ( exp ) ) ;
extern exp f_rem0 PROTO_S ( ( error_treatment, error_treatment, exp, exp ) ) ;
extern exp f_rem1 PROTO_S ( ( error_treatment, error_treatment, exp, exp ) ) ;
extern exp f_rem2 PROTO_S ( ( error_treatment, error_treatment, exp, exp ) ) ;
extern void start_repeat PROTO_S ( ( label ) ) ;
extern exp f_repeat PROTO_S ( ( label, exp, exp ) ) ;
extern exp f_return PROTO_S ( ( exp ) ) ;
extern exp f_return_to_label PROTO_S ( ( exp ) ) ;
extern exp f_round_with_mode PROTO_S ( ( error_treatment, rounding_mode, variety, exp ) ) ;
extern exp f_rotate_left PROTO_S ( ( exp, exp ) ) ;
extern exp f_rotate_right PROTO_S ( ( exp, exp ) ) ;
extern exp f_sequence PROTO_S ( ( exp_list, exp ) ) ;
extern exp f_set_stack_limit PROTO_S ( ( exp ) ) ;
extern exp f_shape_offset PROTO_S ( ( shape ) ) ;
extern exp f_shift_left PROTO_S ( ( error_treatment, exp, exp ) ) ;
extern exp f_shift_right PROTO_S ( ( exp, exp ) ) ;
extern exp f_subtract_ptrs PROTO_S ( ( exp, exp ) ) ;
extern exp f_tail_call PROTO_S ( ( procprops_option, exp, callees ) ) ;
extern exp f_untidy_return PROTO_S ( ( exp ) ) ;
extern void start_variable PROTO_S ( ( access_option, tag, exp ) ) ;
extern exp f_variable PROTO_S ( ( access_option, tag, exp, exp ) ) ;
extern exp f_xor PROTO_S ( ( exp, exp ) ) ;
extern exp f_dummy_exp ;
extern void init_exp PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR EXP_LIST */
extern exp_list new_exp_list PROTO_S ( ( int ) ) ;
extern exp_list add_exp_list PROTO_S ( ( exp_list, exp, int ) ) ;
extern void init_exp_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR EXP_OPTION */
extern exp_option yes_exp_option PROTO_S ( ( exp ) ) ;
extern exp_option no_exp_option ;
extern void init_exp_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR EXTERN_LINK */
extern extern_link f_make_extern_link PROTO_S ( ( linkextern_list ) ) ;
extern extern_link f_dummy_extern_link ;
extern void init_extern_link PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR EXTERN_LINK_LIST */
extern extern_link_list new_extern_link_list PROTO_S ( ( int ) ) ;
extern extern_link_list add_extern_link_list PROTO_S ( ( extern_link_list, extern_link, int ) ) ;
extern void init_extern_link_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR EXTERNAL */
extern external f_string_extern PROTO_S ( ( tdfident ) ) ;
extern external f_unique_extern PROTO_S ( ( unique ) ) ;
extern external f_chain_extern PROTO_S ( ( tdfident, tdfint ) ) ;
extern external f_dummy_external ;
extern void init_external PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR FILENAME */
extern filename f_filename_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern filename f_make_filename PROTO_S ( ( nat, tdfstring, tdfstring ) ) ;
extern filename f_dummy_filename ;
extern void init_filename PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR FLOATING_VARIETY */
extern floating_variety f_flvar_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern floating_variety f_flvar_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern floating_variety f_flvar_parms PROTO_S ( ( nat, nat, nat, nat ) ) ;
extern floating_variety f_complex_parms PROTO_S ( ( nat, nat, nat, nat ) ) ;
extern floating_variety f_float_of_complex PROTO_S ( ( shape ) ) ;
extern floating_variety f_complex_of_float PROTO_S ( ( shape ) ) ;
extern floating_variety f_dummy_floating_variety ;
extern void init_floating_variety PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR GROUP */
extern group f_make_group PROTO_S ( ( unit_list ) ) ;
extern group f_dummy_group ;
extern void init_group PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR GROUP_LIST */
extern group_list new_group_list PROTO_S ( ( int ) ) ;
extern group_list add_group_list PROTO_S ( ( group_list, group, int ) ) ;
extern void init_group_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LABEL */
extern label f_label_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern label f_make_label PROTO_S ( ( tdfint ) ) ;
extern label f_dummy_label ;
extern void init_label PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LABEL_LIST */
extern label_list new_label_list PROTO_S ( ( int ) ) ;
extern label_list add_label_list PROTO_S ( ( label_list, label, int ) ) ;
extern void init_label_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINK */
extern link f_make_link PROTO_S ( ( tdfint, tdfint ) ) ;
extern link f_dummy_link ;
extern void init_link PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINK_LIST */
extern link_list new_link_list PROTO_S ( ( int ) ) ;
extern link_list add_link_list PROTO_S ( ( link_list, link, int ) ) ;
extern void init_link_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINKEXTERN */
extern linkextern f_make_linkextern PROTO_S ( ( tdfint, external ) ) ;
extern linkextern f_dummy_linkextern ;
extern void init_linkextern PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINKEXTERN_LIST */
extern linkextern_list new_linkextern_list PROTO_S ( ( int ) ) ;
extern linkextern_list add_linkextern_list PROTO_S ( ( linkextern_list, linkextern, int ) ) ;
extern void init_linkextern_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINKINFO */
extern linkinfo f_static_name_def PROTO_S ( ( exp, tdfstring ) ) ;
extern linkinfo f_make_comment PROTO_S ( ( tdfstring ) ) ;
extern linkinfo f_make_weak_defn PROTO_S ( ( exp, exp ) ) ;
extern linkinfo f_make_weak_symbol PROTO_S ( ( tdfstring, exp ) ) ;
extern linkinfo f_dummy_linkinfo ;
extern void init_linkinfo PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINKINFO_LIST */
extern linkinfo_list new_linkinfo_list PROTO_S ( ( int ) ) ;
extern linkinfo_list add_linkinfo_list PROTO_S ( ( linkinfo_list, linkinfo, int ) ) ;
extern void init_linkinfo_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINKINFO_PROPS */
extern linkinfo_props f_make_linkinfos PROTO_S ( ( tdfint, linkinfo_list ) ) ;
extern linkinfo_props f_dummy_linkinfo_props ;
extern void init_linkinfo_props PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINKS */
extern links f_make_links PROTO_S ( ( link_list ) ) ;
extern links f_dummy_links ;
extern void init_links PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR LINKS_LIST */
extern links_list new_links_list PROTO_S ( ( int ) ) ;
extern links_list add_links_list PROTO_S ( ( links_list, links, int ) ) ;
extern void init_links_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR NAT */
extern nat f_nat_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern nat f_nat_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern nat f_computed_nat PROTO_S ( ( exp ) ) ;
extern nat f_error_val PROTO_S ( ( error_code ) ) ;
extern nat f_make_nat PROTO_S ( ( tdfint ) ) ;
extern nat f_dummy_nat ;
extern void init_nat PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR NAT_OPTION */
extern nat_option yes_nat_option PROTO_S ( ( nat ) ) ;
extern nat_option no_nat_option ;
extern void init_nat_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR NTEST */
extern ntest f_ntest_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern ntest f_ntest_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern ntest f_equal ;
extern ntest f_greater_than ;
extern ntest f_greater_than_or_equal ;
extern ntest f_less_than ;
extern ntest f_less_than_or_equal ;
extern ntest f_not_equal ;
extern ntest f_not_greater_than ;
extern ntest f_not_greater_than_or_equal ;
extern ntest f_not_less_than ;
extern ntest f_not_less_than_or_equal ;
extern ntest f_less_than_or_greater_than ;
extern ntest f_not_less_than_and_not_greater_than ;
extern ntest f_comparable ;
extern ntest f_not_comparable ;
extern ntest f_dummy_ntest ;
extern void init_ntest PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR OTAGEXP */
extern otagexp f_make_otagexp PROTO_S ( ( tag_option, exp ) ) ;
extern otagexp f_dummy_otagexp ;
extern void init_otagexp PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR OTAGEXP_LIST */
extern otagexp_list new_otagexp_list PROTO_S ( ( int ) ) ;
extern otagexp_list add_otagexp_list PROTO_S ( ( otagexp_list, otagexp, int ) ) ;
extern void init_otagexp_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR PROCPROPS */
extern procprops f_procprops_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern procprops f_procprops_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern procprops f_add_procprops PROTO_S ( ( procprops, procprops ) ) ;
extern procprops f_check_stack ;
extern procprops f_inline ;
extern procprops f_no_long_jump_dest ;
extern procprops f_untidy ;
extern procprops f_var_callees ;
extern procprops f_var_callers ;
extern procprops f_dummy_procprops ;
extern void init_procprops PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR PROCPROPS_OPTION */
extern procprops_option yes_procprops_option PROTO_S ( ( procprops ) ) ;
extern procprops_option no_procprops_option ;
extern void init_procprops_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR ROUNDING_MODE */
extern rounding_mode f_rounding_mode_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern rounding_mode f_rounding_mode_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern rounding_mode f_round_as_state ;
extern rounding_mode f_to_nearest ;
extern rounding_mode f_toward_larger ;
extern rounding_mode f_toward_smaller ;
extern rounding_mode f_toward_zero ;
extern rounding_mode f_dummy_rounding_mode ;
extern void init_rounding_mode PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR SHAPE */
extern shape f_shape_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern shape f_shape_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern shape f_bitfield PROTO_S ( ( bitfield_variety ) ) ;
extern shape f_bottom ;
extern shape f_compound PROTO_S ( ( exp ) ) ;
extern shape f_floating PROTO_S ( ( floating_variety ) ) ;
extern shape f_integer PROTO_S ( ( variety ) ) ;
extern shape f_nof PROTO_S ( ( nat, shape ) ) ;
extern shape f_offset PROTO_S ( ( alignment, alignment ) ) ;
extern shape f_pointer PROTO_S ( ( alignment ) ) ;
extern shape f_proc ;
extern shape f_top ;
extern shape f_dummy_shape ;
extern void init_shape PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR SHAPE_OPTION */
extern shape_option yes_shape_option PROTO_S ( ( shape ) ) ;
extern shape_option no_shape_option ;
extern void init_shape_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR SIGNED_NAT */
extern signed_nat f_signed_nat_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern signed_nat f_signed_nat_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern signed_nat f_computed_signed_nat PROTO_S ( ( exp ) ) ;
extern signed_nat f_make_signed_nat PROTO_S ( ( tdfbool, tdfint ) ) ;
extern signed_nat f_snat_from_nat PROTO_S ( ( bool, nat ) ) ;
extern signed_nat f_dummy_signed_nat ;
extern void init_signed_nat PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR SORTNAME */
extern sortname f_access ;
extern sortname f_al_tag ;
extern sortname f_alignment_sort ;
extern sortname f_bitfield_variety ;
extern sortname f_bool ;
extern sortname f_error_treatment ;
extern sortname f_exp ;
extern sortname f_floating_variety ;
extern sortname f_foreign_sort PROTO_S ( ( string ) ) ;
extern sortname f_label ;
extern sortname f_nat ;
extern sortname f_ntest ;
extern sortname f_procprops ;
extern sortname f_rounding_mode ;
extern sortname f_shape ;
extern sortname f_signed_nat ;
extern sortname f_string ;
extern sortname f_tag ;
extern sortname f_transfer_mode ;
extern sortname f_token PROTO_S ( ( sortname, sortname_list ) ) ;
extern sortname f_variety ;
extern sortname f_dummy_sortname ;
extern void init_sortname PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR SORTNAME_LIST */
extern sortname_list new_sortname_list PROTO_S ( ( int ) ) ;
extern sortname_list add_sortname_list PROTO_S ( ( sortname_list, sortname, int ) ) ;
extern void init_sortname_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR SOURCEMARK */
extern sourcemark f_make_sourcemark PROTO_S ( ( filename, nat, nat ) ) ;
extern sourcemark f_dummy_sourcemark ;
extern void init_sourcemark PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR STRING */
extern string f_string_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern string f_string_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern string f_concat_string PROTO_S ( ( string, string ) ) ;
extern string f_make_string PROTO_S ( ( tdfstring ) ) ;
extern string f_dummy_string ;
extern void init_string PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR STRING_LIST */
extern string_list new_string_list PROTO_S ( ( int ) ) ;
extern string_list add_string_list PROTO_S ( ( string_list, string, int ) ) ;
extern void init_string_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR STRING_OPTION */
extern string_option yes_string_option PROTO_S ( ( string ) ) ;
extern string_option no_string_option ;
extern void init_string_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAG */
extern tag f_tag_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern tag f_make_tag PROTO_S ( ( tdfint ) ) ;
extern tag f_dummy_tag ;
extern void init_tag PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAG_OPTION */
extern tag_option yes_tag_option PROTO_S ( ( tag ) ) ;
extern tag_option no_tag_option ;
extern void init_tag_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGACC */
extern tagacc f_make_tagacc PROTO_S ( ( tag, access_option ) ) ;
extern tagacc f_dummy_tagacc ;
extern void init_tagacc PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGACC_OPTION */
extern tagacc_option yes_tagacc_option PROTO_S ( ( tagacc ) ) ;
extern tagacc_option no_tagacc_option ;
extern void init_tagacc_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGDEC */
extern tagdec f_make_id_tagdec PROTO_S ( ( tdfint, access_option, string_option, shape ) ) ;
extern tagdec f_make_var_tagdec PROTO_S ( ( tdfint, access_option, string_option, shape ) ) ;
extern tagdec f_common_tagdec PROTO_S ( ( tdfint, access_option, string_option, shape ) ) ;
extern tagdec f_dummy_tagdec ;
extern void init_tagdec PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGDEC_LIST */
extern tagdec_list new_tagdec_list PROTO_S ( ( int ) ) ;
extern tagdec_list add_tagdec_list PROTO_S ( ( tagdec_list, tagdec, int ) ) ;
extern void init_tagdec_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGDEC_PROPS */
extern tagdec_props f_make_tagdecs PROTO_S ( ( tdfint, tagdec_list ) ) ;
extern tagdec_props f_dummy_tagdec_props ;
extern void init_tagdec_props PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGDEF */
extern void start_make_id_tagdef PROTO_S ( ( tdfint ) ) ;
extern tagdef f_make_id_tagdef PROTO_S ( ( tdfint, string_option, exp ) ) ;
extern void start_make_var_tagdef PROTO_S ( ( tdfint ) ) ;
extern tagdef f_make_var_tagdef PROTO_S ( ( tdfint, access_option, string_option, exp ) ) ;
extern void start_common_tagdef PROTO_S ( ( tdfint ) ) ;
extern tagdef f_common_tagdef PROTO_S ( ( tdfint, access_option, string_option, exp ) ) ;
extern tagdef f_dummy_tagdef ;
extern void init_tagdef PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGDEF_LIST */
extern tagdef_list new_tagdef_list PROTO_S ( ( int ) ) ;
extern tagdef_list add_tagdef_list PROTO_S ( ( tagdef_list, tagdef, int ) ) ;
extern void init_tagdef_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGDEF_PROPS */
extern tagdef_props f_make_tagdefs PROTO_S ( ( tdfint, tagdef_list ) ) ;
extern tagdef_props f_dummy_tagdef_props ;
extern void init_tagdef_props PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGSHACC */
extern tagshacc f_make_tagshacc PROTO_S ( ( shape, access_option, tag ) ) ;
extern tagshacc f_dummy_tagshacc ;
extern void init_tagshacc PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TAGSHACC_LIST */
extern tagshacc_list new_tagshacc_list PROTO_S ( ( int ) ) ;
extern tagshacc_list add_tagshacc_list PROTO_S ( ( tagshacc_list, tagshacc, int ) ) ;
extern void init_tagshacc_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TDFIDENT_LIST */
extern tdfident_list new_tdfident_list PROTO_S ( ( int ) ) ;
extern tdfident_list add_tdfident_list PROTO_S ( ( tdfident_list, tdfident, int ) ) ;
extern void init_tdfident_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TDFINT_LIST */
extern tdfint_list new_tdfint_list PROTO_S ( ( int ) ) ;
extern tdfint_list add_tdfint_list PROTO_S ( ( tdfint_list, tdfint, int ) ) ;
extern void init_tdfint_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKDEC */
extern tokdec f_make_tokdec PROTO_S ( ( tdfint, string_option, sortname ) ) ;
extern tokdec f_dummy_tokdec ;
extern void init_tokdec PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKDEC_LIST */
extern tokdec_list new_tokdec_list PROTO_S ( ( int ) ) ;
extern tokdec_list add_tokdec_list PROTO_S ( ( tokdec_list, tokdec, int ) ) ;
extern void init_tokdec_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKDEC_PROPS */
extern tokdec_props f_make_tokdecs PROTO_S ( ( tokdec_list ) ) ;
extern tokdec_props f_dummy_tokdec_props ;
extern void init_tokdec_props PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKDEF */
extern tokdef f_make_tokdef PROTO_S ( ( tdfint, string_option, bitstream ) ) ;
extern tokdef f_dummy_tokdef ;
extern void init_tokdef PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKDEF_LIST */
extern tokdef_list new_tokdef_list PROTO_S ( ( int ) ) ;
extern tokdef_list add_tokdef_list PROTO_S ( ( tokdef_list, tokdef, int ) ) ;
extern void init_tokdef_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKDEF_PROPS */
extern tokdef_props f_make_tokdefs PROTO_S ( ( tdfint, tokdef_list ) ) ;
extern tokdef_props f_dummy_tokdef_props ;
extern void init_tokdef_props PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKEN */
extern token f_token_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern token f_make_tok PROTO_S ( ( tdfint ) ) ;
extern token f_use_tokdef PROTO_S ( ( bitstream ) ) ;
extern token f_dummy_token ;
extern void init_token PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKEN_DEFN */
extern token_defn f_token_definition PROTO_S ( ( sortname, tokformals_list ) ) ;
extern token_defn f_dummy_token_defn ;
extern void init_token_defn PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKEN_OPTION */
extern token_option yes_token_option PROTO_S ( ( token ) ) ;
extern token_option no_token_option ;
extern void init_token_option PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKFORMALS */
extern tokformals f_make_tokformals PROTO_S ( ( sortname, tdfint ) ) ;
extern tokformals f_dummy_tokformals ;
extern void init_tokformals PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TOKFORMALS_LIST */
extern tokformals_list new_tokformals_list PROTO_S ( ( int ) ) ;
extern tokformals_list add_tokformals_list PROTO_S ( ( tokformals_list, tokformals, int ) ) ;
extern void init_tokformals_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR TRANSFER_MODE */
extern transfer_mode f_transfer_mode_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern transfer_mode f_transfer_mode_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern transfer_mode f_add_modes PROTO_S ( ( transfer_mode, transfer_mode ) ) ;
extern transfer_mode f_overlap ;
extern transfer_mode f_standard_transfer_mode ;
extern transfer_mode f_trap_on_nil ;
extern transfer_mode f_volatile ;
extern transfer_mode f_complete ;
extern transfer_mode f_dummy_transfer_mode ;
extern void init_transfer_mode PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR UNIQUE */
extern unique f_make_unique PROTO_S ( ( tdfident_list ) ) ;
extern unique f_dummy_unique ;
extern void init_unique PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR UNIT */
extern void start_make_unit PROTO_S ( ( tdfint_list ) ) ;
extern unit f_make_unit PROTO_S ( ( tdfint_list, links_list, bytestream ) ) ;
extern unit f_dummy_unit ;
extern void init_unit PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR UNIT_LIST */
extern unit_list new_unit_list PROTO_S ( ( int ) ) ;
extern unit_list add_unit_list PROTO_S ( ( unit_list, unit, int ) ) ;
extern void init_unit_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR VARIETY */
extern variety f_var_apply_token PROTO_S ( ( token, bitstream ) ) ;
extern variety f_var_cond PROTO_S ( ( exp, bitstream, bitstream ) ) ;
extern variety f_var_limits PROTO_S ( ( signed_nat, signed_nat ) ) ;
extern variety f_var_width PROTO_S ( ( bool, nat ) ) ;
extern variety f_dummy_variety ;
extern void init_variety PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR VERSION */
extern version f_make_version PROTO_S ( ( tdfint, tdfint ) ) ;
extern version f_user_info PROTO_S ( ( string ) ) ;
extern version f_dummy_version ;
extern void init_version PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR VERSION_LIST */
extern version_list new_version_list PROTO_S ( ( int ) ) ;
extern version_list add_version_list PROTO_S ( ( version_list, version, int ) ) ;
extern void init_version_list PROTO_S ( ( void ) ) ;

/* CONSTRUCTS FOR VERSION_PROPS */
extern version_props f_make_versions PROTO_S ( ( version_list ) ) ;
extern version_props f_dummy_version_props ;
extern void init_version_props PROTO_S ( ( void ) ) ;


#endif
