/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#include "Image.hpp"

#include "ImageManipulation.hpp"

#include "boost/numeric/ublas/matrix_proxy.hpp"

indii::Image::Image(const int width, const int height) :
    r(height, width), g(height, width), b(height, width) {
  //
}

indii::Image::Image(const Image& img, const float scale) {
  const int width = std::floor(img.getWidth()/scale);
  const int height = std::floor(img.getHeight()/scale);
     
  r.resize(width, height, false);
  g.resize(width, height, false);
  b.resize(width, height, false);
 
  for (int x = 0; x < width; ++x) {
    for (int y = 0; y < height; ++y) {
      int y1 = std::floor(y*scale);
      int x1 = std::floor(x*scale);
      r(y,x) = img.r(y1, x1);
      g(y,x) = img.g(y1, x1);
      b(y,x) = img.b(y1, x1);
    }
  }
}
