/*
 *  Guided Tour System
 *  author: Anthony Dillon
 */

function GuidedTourSystem($parent){
	var _parent = $parent;
	var _this = this;
	
	var arrowClicked = false;
	
	var theElement;
	var tempElement;
	var timer;
	
	var guides;
	var currentIndex = -1;
	var currentStep = 0;
	var guideCount = 0;
	
	this.init = function(){
		var applicationsGuide = {system:'applications',icon:'img/tourguide/mail-small.png', guide:[
						[_tour_applications_title_, _tour_applications_1_,'#menu .writer','right'],
						[_tour_applications_title_, _tour_applications_2_,'#menu .writer .open-arrow','right','next']
						], hash: 'applications', complete: false};
						
		var sendEmailGuide = {system:'sending-email',icon:'img/tourguide/mail-small.png', guide:[
						[_tour_email_title_, _tour_email_1_,'#menu .email','right'],
						[_tour_email_title_, _tour_email_2_,'#email-window .buttons .email-write','below'],
						[_tour_email_title_, _tour_email_3_,'#email-write #write-to input','above','next'],
						[_tour_email_title_, _tour_email_4_,'#email-write #write-subject input','above','next'],
						[_tour_email_title_, _tour_email_5_,'#email-write #write-body textarea','above','next'],
						[_tour_email_title_, _tour_email_6_,'#email-write .buttons #write-send','below']
						], hash: 'sending-email', complete: false};
						
		var watchVideoGuide = {system:'watching-video',icon:'img/tourguide/video-small.png', guide:[
						[_tour_video_title_, _tour_video_1_,'#menu .dash','right'],
						[_tour_video_title_, _tour_video_2_,'#systemOverlay #dash-bottom-bar .bottom-wrapper .files-icon','above'],
						[_tour_video_title_, _tour_video_3_,'#display-find-files .folders .app-list div[data-id="3"]','below'],
						[_tour_video_title_, _tour_video_4_,'#folder-window .folder-contents .contents .file','below','dblclick']
						//[_tour_video_title_, _tour_video_5_,'#movieplayer','above', 'next']
						], hash: 'watching-video', complete: false};
						
		var browseWebGuide = {system:'surf-the-web',icon:'img/tourguide/firefox-small.png', guide:[
						[_tour_internet_title_, _tour_internet_1_,'#menu .firefox','right'],
						[_tour_internet_title_, _tour_internet_2_,'#firefox-window .firefox-url input','above','next'],
						[_tour_internet_title_, _tour_internet_3_,'#firefox-window','top','next']
						], hash: 'surf-the-web', complete: false};
						
		var newAppsGuide = {system:'find-apps',icon:'img/tourguide/apps-small.png', guide:[
						[_tour_apps_title_1_, _tour_apps_1_,'#menu .software','right'],
						[_tour_apps_title_1_, _tour_apps_2_,'#software-centre .app-container .chromium','above'],
						[_tour_apps_title_2_, _tour_apps_3_,'#software-centre .detailed .price .button','below'],
						[_tour_apps_title_3_, _tour_apps_4_,'#software-centre .detailed .price','top','next']
						], hash: 'find-apps', complete: false};
						
		var listenMusicGuide = {system:'listen-music',icon:'img/tourguide/listen-to-music.png', guide:[
						[_tour_music_title_, _tour_music_1_,'#menu .dash','right'],
						[_tour_music_title_, _tour_music_2_,'#systemOverlay #dash-bottom-bar .bottom-wrapper .music-icon','above'],
						[_tour_music_title_, _tour_music_3_,'#display-find-music .songs .app-list div','below']
						], hash: 'listen-music', complete: false};
						
		var photosGuide = {system:'photos',icon:'img/tourguide/shotwell-small.png', guide:[
						[_tour_photos_title_, _tour_photos_1_,'#menu .dash','right'],
						[_tour_photos_title_, _tour_photos_2_,'#display-home .recent-files .app-list div[data-id="12"]','above'],
						[_tour_photos_title_, _tour_photos_3_,'#shotwell','right','next']
						], hash: 'photos', complete: false};
						
		var filesAndFoldersGuide = {system:'files-and-folders',icon:'img/tourguide/file-small.png', guide:[
						[_tour_files_title_, _tour_files_1_,'#menu .home','right'],
						[_tour_files_title_, _tour_files_2_,'#folder-window .folder-contents .contents .file-folder[data-id="1"]','below','dblclick'],
						[_tour_files_title_, _tour_files_3_,'#folder-window .buttons .folder-back','below'],
						[_tour_files_title_, _tour_files_4_,'#folder-window','above','next']
						], hash: 'files-and-folders', complete: false};
						
		var createDocumentsGuide = {system:'create-documents',icon:'img/tourguide/document-small.png', guide:[
						[_tour_documents_title_, _tour_documents_1_,'#menu .writer','right'],
						[_tour_documents_title_, _tour_documents_2_,'#libreoffice-writer-window','below','next']
						], hash: 'create-documents', complete: false};
						
		var createSpreadsheetsGuide = {system:'create-spreadsheets',icon:'img/tourguide/calc-small.png', guide:[
						[_tour_spreadsheet_title_, _tour_spreadsheet_1_,'#menu .calc','right'],
						[_tour_spreadsheet_title_, _tour_spreadsheet_2_,'#libreoffice-calc-window','below','next']
						], hash: 'create-spreadsheets', complete: false};
						
		var createPresentationsGuide = {system:'create-presentations',icon:'img/tourguide/impress-small.png', guide:[
						[_tour_presentation_title_, _tour_presentation_1_,'#menu .impress','right'],
						[_tour_presentation_title_, _tour_presentation_2_,'#libreoffice-impress-window','below','next']
						], hash: 'create-presentations', complete: false};
						
		var systemIndicatorsGuide = {system:'system-indicators',icon:'img/tourguide/impress-small.png', guide:[
						[_tour_indicators_title_1_, _tour_indicators_1_,'#speakers','below'],
						[_tour_indicators_title_1_, _tour_indicators_2_,'#speakers .system-volume','left','next'],
						[_tour_indicators_title_1_, _tour_indicators_3_,'#speakers .banshee','left','next'],
						[_tour_indicators_title_1_, _tour_indicators_4_,'#speakers','below'],
						[_tour_indicators_title_2_, _tour_indicators_5_,'#bluetooth','below'],
						[_tour_indicators_title_2_, _tour_indicators_6_,'#bluetooth .drop-down','left'],
						[_tour_indicators_title_2_, _tour_indicators_7_,'#bluetooth','below'],
						[_tour_indicators_title_3_, _tour_indicators_8_,'#time','below'],
						[_tour_indicators_title_3_, _tour_indicators_9_,'#time .drop-down','below','next']
						], hash: 'system-indicators', complete: false};
						
		var ubuntuOneGuide = {system:'ubuntu-one',icon:'img/tourguide/ubuntuone-small.png', guide:[
						[_tour_u1_title_, _tour_u1_1_,'#message','below'],
						[_tour_u1_title_, _tour_u1_2_,'#message .drop-down .ubuntuone','left'],
						[_tour_u1_title_, _tour_u1_3_,'#ubuntuone-window','below', 'next']
						], hash: 'system-indicators', complete: false};
		
		guides = new Array(sendEmailGuide,watchVideoGuide,browseWebGuide,newAppsGuide,listenMusicGuide,photosGuide,filesAndFoldersGuide,createDocumentsGuide,createSpreadsheetsGuide,createPresentationsGuide,systemIndicatorsGuide,ubuntuOneGuide,applicationsGuide);
		guideCount = guides.length;
		
		$('#OT').bind('click',function(e){
			e.stopPropagation();
		});
		$('#OR').bind('click',function(e){
			e.stopPropagation();
		});
		$('#OB').bind('click',function(e){
			e.stopPropagation();
		});
		$('#OL').bind('click',function(e){
			e.stopPropagation();
		});
	}
	
	this.close = function(){
		_parent.closeAllWindows(closeAllWindows);
	}
	
	this.setSystem = function($system){
		if(!arrowClicked){
			var found = false;
			for(i = 0; i < guides.length; i++){
				if(guides[i].system == $system){
					this.setCurrentIndex(i);
					found = true;
					break;
				}
			}
			if(!found){ this.setCurrentIndex(-1); }
		}
		
	}
	
	this.setIndex = function($index){
		currentIndex = $index;
	}
	
	this.setCurrentIndex = function($currentIndex, $update){
		currentIndex = $currentIndex;
		this.update();
	}
	
	this.reset = function(){
		this.showTourOverlay(false);
		currentIndex = -1;
		currentStep = 0;
		_parent.closeAllWindows(currentIndex)
	}
	
	this.next = function(){
		arrowClicked = true;
		_parent.closeAllWindows(currentIndex);
		if (currentIndex == guideCount -1) {
			currentIndex = 0;
		} else {
			currentIndex++;
		}
		this.update();
		this.updateHash();
		_parent.systemMenu.handleMenuClick(guides[currentIndex].system);
		arrowClicked = false;
	}
	
	this.prev = function(){
		arrowClicked = true;
		_parent.closeAllWindows(currentIndex);
		if (currentIndex == 0) {
			currentIndex = guideCount -1;
		} else {
			currentIndex--;
		}
		this.update();
		this.updateHash();
		_parent.systemMenu.handleMenuClick(guides[currentIndex].system);
		arrowClicked = false;
	}
	
	this.getStep = function(){
		return currentStep;
	}
	
	this.update = function(){
		if(currentIndex != -1){
			if(!$('#tour-guide .guide-container .guide-logo').is(':visible')){
				$('#tour-guide .guide-container .guide-logo').show();
				$('#tour-guide .guide-container h3').show();
			}
			this.showTourOverlay(true);
			$('#tour-guide .guide-container .guide-logo').css('background','url(../'+guides[currentIndex].icon+')');
			$('#tour-guide .guide-container h3').text(guides[currentIndex].guide[currentStep][0]);
			$('#tour-guide .guide-container p').text(guides[currentIndex].guide[currentStep][1]);
			if(guides[currentIndex].guide[currentStep][4] == 'next'){
				$('#tour-guide .guide-container p').append(' '+_tour_click_+'<a href="#">'+_tour_next_+'</a>');
			}
			var arrowdir = 'below';
			if(guides[currentIndex].guide[currentStep][3] != undefined){ arrowdir = guides[currentIndex].guide[currentStep][3] }
			this.pullElementOut(guides[currentIndex].guide[currentStep][2],arrowdir);
		}
	}
	
	this.showTourOverlay = function($show){
		if($show){
			$('#OT').show();
			$('#OB').show();
			$('#OL').show();
			$('#OR').show();
		}else{
			$('#OT').hide();
			$('#OB').hide();
			$('#OL').hide();
			$('#OR').hide();
		}
	}
	
	this.pullElementOut = function($element,$arrow){
		if(theElement != undefined){
			theElement.unbind('click',this.newnext);
			theElement.unbind('dbclick',this.newnext);
			theElement.unbind('keypress');
			$('.guide-container p a').unbind('click',this.newnext);
		}
		theElement = $($element);
		var ORWidth = $(document).width() - (theElement.offset().left + theElement.outerWidth());
		var OTWidth = theElement.offset().left;
		$('#OT').css('height', theElement.offset().top+'px').css('left', theElement.offset().left).css('width',theElement.outerWidth()+'px');
		$('#OL').css('width', theElement.offset().left+'px');
		$('#OB').css('height', $(document).height() - (theElement.offset().top + theElement.outerHeight())+'px').css('top', theElement.offset().top + theElement.outerHeight()).css('left', theElement.offset().left).css('width',theElement.outerWidth()+'px');
		$('#OR').css('width', $(document).width() - (theElement.offset().left + theElement.outerWidth())+'px' ).css('left', theElement.offset().left + theElement.outerWidth());
		if(guides[currentIndex].guide[currentStep][4]){
			if(guides[currentIndex].guide[currentStep][4] == 'next'){
				$('.guide-container p a').bind('click',this.newnext);
				theElement.focus();
				theElement.bind('keypress',function(e){
					console.log(e.keyCode);
					if(e.keyCode == 9){
						_this.newnext();
						e.preventDefault();
					}
				});
			}else{
				theElement.bind('dblclick',this.newnext);
			}
		}else{
			theElement.bind('click',this.newnext);
		}
		this.addArrow($arrow);
	}
	
	this.newnext = function(){
		currentStep++;
		if(guides[currentIndex].guide[currentStep]){
			_this.update();
		}else{
			_this.completeGuide();
		}
	}
	
	this.completeGuide = function(){
		this.removeArrow();
		guides[currentIndex].complete = true;
		currentStep = 0;
		$('#tour-guide .guide-container .guide-logo').css('background','url(../img/welcome/completed.png) no-repeat center center');
		$('#tour-guide .guide-container p').text(_tour_congratulations_+' '+guides[currentIndex].guide[0][0]);
		this.showTourOverlay(false);
		_parent.welcomeSystem.open();
		_parent.closeTopRightDropDowns();
		_parent.closeAllWindows();
	}

	this.updateHash = function() {
		window.location.hash = guides[currentIndex].hash;
	}
	
	this.addArrow = function($position){
		this.removeArrow();
		$('#OT').css('z-index','20');
		$('#OR').css('z-index','20');
		$('#OB').css('z-index','20');
		$('#OL').css('z-index','20');
		var $top = 0;
		switch($position){
			case 'above':
				$('#OT').css('z-index','21');
				$('#OT').append('<span class="OGarrow-above"></span>');
				$('#OT').find('.OGarrow-above').css('left',(theElement.outerWidth() / 2) - 20+ 'px');
				this.arrowBounce($('#OT').find('.OGarrow-above'));
			break;
			case 'right':
				$top = theElement.offset().top + (theElement.height() / 2) - 20;
				console.log($top);
				$('#OR').append('<span class="OGarrow-right"></span>');
				$('#OR').find('.OGarrow-right').css('top',$top + 'px');
				this.arrowBounce($('#OR').find('.OGarrow-right'));
			break;
			case 'below':
				$('#OB').css('z-index','21');
				$('#OB').append('<span class="OGarrow-below"></span>');
				$('#OB').find('.OGarrow-below').css('left',(theElement.outerWidth() / 2) - 20+ 'px');
				this.arrowBounce($('#OB').find('.OGarrow-below'));
			break;
			case 'left':
				$top = theElement.offset().top + (theElement.height() / 2) - 20;
				$('#OL').css('z-index','21');
				$('#OL').append('<span class="OGarrow-left"></span>');
				$('#OL').find('.OGarrow-left').css('top',$top + 'px');
				this.arrowBounce($('#OL').find('.OGarrow-left'));
			break;
		}
	}
	
	this.removeArrow = function($position){
		timer = clearInterval();
		timer = null;
		$('#OT span').remove();
		$('#OR span').remove();
		$('#OB span').remove();
		$('#OL span').remove();
	}
	
	this.arrowBounce = function($arrow, $direction) {
		var flag = 1;
		if($arrow.attr('class').split('-')[1] == 'below' || $arrow.attr('class').split('-')[1] == 'above'){
	        timer = setInterval(function() {
	           if(flag == 1) { flag = -1 } else { flag = 1 }
	            $arrow.animate({ top: "+="+(flag*10)}, 500)
	        },300);
        }else if($arrow.attr('class').split('-')[1] == 'left'){
        	timer = setInterval(function() {
	           if(flag == 1) { flag = -1 } else { flag = 1 }
	            $arrow.animate({ right: "+="+(flag*10)}, 500)
	        },300);
        }else{
        	timer = setInterval(function() {
	           if(flag == 1) { flag = -1 } else { flag = 1 }
	            $arrow.animate({ left: "+="+(flag*10)}, 500)
	        },300);
        }
    }
    
    this.getGuides = function(){
    	return guides;
    }        
}
